/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-01-21 07:38:17 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=188 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=893 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=336 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=174 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_logs` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `types` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `create_at` datetime NOT NULL,
  `form_id` bigint DEFAULT NULL,
  `entry_id` bigint DEFAULT NULL,
  `user_id` bigint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_payment_meta` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `payment_id` bigint NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `payment_id` (`payment_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `meta_value` (`meta_value`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `form_id` bigint NOT NULL,
  `status` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `subtotal_amount` decimal(26,8) NOT NULL DEFAULT '0.00000000',
  `discount_amount` decimal(26,8) NOT NULL DEFAULT '0.00000000',
  `total_amount` decimal(26,8) NOT NULL DEFAULT '0.00000000',
  `currency` varchar(3) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `entry_id` bigint NOT NULL DEFAULT '0',
  `gateway` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `type` varchar(12) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `mode` varchar(4) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `transaction_id` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `customer_id` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `subscription_id` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `subscription_status` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `date_created_gmt` datetime NOT NULL,
  `date_updated_gmt` datetime NOT NULL,
  `is_published` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `status` (`status`(8)),
  KEY `total_amount` (`total_amount`),
  KEY `type` (`type`(8)),
  KEY `transaction_id` (`transaction_id`(32)),
  KEY `customer_id` (`customer_id`(32)),
  KEY `subscription_id` (`subscription_id`(32)),
  KEY `subscription_status` (`subscription_status`(8)),
  KEY `title` (`title`(64))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_tasks_meta` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `action` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpmailsmtp_debug_events` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `content` text COLLATE utf8mb4_unicode_520_ci,
  `initiator` text COLLATE utf8mb4_unicode_520_ci,
  `event_type` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpmailsmtp_tasks_meta` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `action` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("175", "action_scheduler/migration_hook", "complete", "2025-01-20 09:49:19", "2025-01-20 10:49:19", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1737366559;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1737366559;}", "1", "1", "2025-01-20 09:54:54", "2025-01-20 10:54:54", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("176", "wp_mail_smtp_summary_report_email", "pending", "2025-01-27 13:00:00", "2025-01-27 14:00:00", "10", "[null]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1737982800;s:18:\"\0*\0first_timestamp\";i:1737982800;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1737982800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("177", "wp_mail_smtp_admin_notifications_update", "complete", "2025-01-20 09:56:50", "2025-01-20 10:56:50", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1737367010;s:18:\"\0*\0first_timestamp\";i:1737367010;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1737367010;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-01-20 09:57:20", "2025-01-20 10:57:20", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("178", "wp_mail_smtp_admin_notifications_update", "pending", "2025-01-21 09:57:20", "2025-01-21 10:57:20", "10", "[1]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1737453440;s:18:\"\0*\0first_timestamp\";i:1737367010;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1737453440;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("179", "wpforms_process_forms_locator_scan", "complete", "2025-01-20 09:59:18", "2025-01-20 10:59:18", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1737367158;s:18:\"\0*\0first_timestamp\";i:1737367158;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1737367158;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-01-20 09:59:20", "2025-01-20 10:59:20", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("180", "wpforms_process_purge_spam", "complete", "2025-01-20 09:59:18", "2025-01-20 10:59:18", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1737367158;s:18:\"\0*\0first_timestamp\";i:1737367158;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1737367158;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-01-20 09:59:20", "2025-01-20 10:59:20", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("181", "wpforms_email_summaries_fetch_info_blocks", "complete", "2025-01-17 06:51:45", "2025-01-17 07:51:45", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1737096705;s:18:\"\0*\0first_timestamp\";i:1737096705;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1737096705;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "3", "1", "2025-01-20 09:59:20", "2025-01-20 10:59:20", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("185", "wpforms_admin_notifications_update", "complete", "2025-01-20 09:59:49", "2025-01-20 09:59:49", "10", "{\"tasks_meta_id\":3}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2025-01-20 10:00:37", "2025-01-20 11:00:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("187", "action_scheduler/migration_hook", "complete", "2025-01-20 10:03:00", "2025-01-20 11:03:00", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1737367380;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1737367380;}", "1", "1", "2025-01-20 10:03:26", "2025-01-20 11:03:26", "0", NULL);

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "wp_mail_smtp");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "wpforms");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("1", "175", "action created", "2025-01-20 09:48:19", "2025-01-20 10:48:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("2", "175", "action started via WP Cron", "2025-01-20 09:54:54", "2025-01-20 10:54:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("3", "175", "action complete via WP Cron", "2025-01-20 09:54:54", "2025-01-20 10:54:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4", "176", "action created", "2025-01-20 09:55:50", "2025-01-20 10:55:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("5", "177", "action created", "2025-01-20 09:55:50", "2025-01-20 10:55:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("6", "177", "action started via WP Cron", "2025-01-20 09:57:19", "2025-01-20 10:57:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("7", "177", "action complete via WP Cron", "2025-01-20 09:57:20", "2025-01-20 10:57:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("8", "178", "action created", "2025-01-20 09:57:20", "2025-01-20 10:57:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("9", "179", "action created", "2025-01-20 09:59:18", "2025-01-20 10:59:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("10", "180", "action created", "2025-01-20 09:59:18", "2025-01-20 10:59:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("11", "181", "action created", "2025-01-20 09:59:18", "2025-01-20 10:59:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("12", "181", "action started via WP Cron", "2025-01-20 09:59:20", "2025-01-20 10:59:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("13", "181", "action complete via WP Cron", "2025-01-20 09:59:20", "2025-01-20 10:59:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("15", "179", "action started via WP Cron", "2025-01-20 09:59:20", "2025-01-20 10:59:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("16", "179", "action complete via WP Cron", "2025-01-20 09:59:20", "2025-01-20 10:59:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("18", "180", "action started via WP Cron", "2025-01-20 09:59:20", "2025-01-20 10:59:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("19", "180", "action complete via WP Cron", "2025-01-20 09:59:20", "2025-01-20 10:59:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("21", "185", "action created", "2025-01-20 09:59:49", "2025-01-20 10:59:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("22", "185", "action started via WP Cron", "2025-01-20 10:00:37", "2025-01-20 11:00:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("23", "185", "action complete via WP Cron", "2025-01-20 10:00:37", "2025-01-20 11:00:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("29", "187", "action created", "2025-01-20 10:02:00", "2025-01-20 11:02:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("30", "187", "action started via WP Cron", "2025-01-20 10:03:26", "2025-01-20 11:03:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("31", "187", "action complete via WP Cron", "2025-01-20 10:03:26", "2025-01-20 11:03:26");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "Un commentateur ou commentatrice WordPress", "wapuu@wordpress.example", "https://fr.wordpress.org/", "", "2024-10-08 08:28:49", "2024-10-08 06:28:49", "Bonjour, ceci est un commentaire.\nPour débuter avec la modération, la modification et la suppression de commentaires, veuillez visiter l’écran des Commentaires dans le Tableau de bord.\nLes avatars des personnes qui commentent arrivent depuis <a href=\"https://fr.gravatar.com/\">Gravatar</a>.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20250121_theovaladouxportfolio", "fb4815b39912856a7753_20250121073755", "23", "2025-01-21 07:38:16", "root", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-01-21 07:37:55\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.6.1\";s:9:\"VersionDB\";s:6:\"8.0.30\";s:10:\"VersionPHP\";s:6:\"8.1.10\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";i:1;s:4:\"Name\";s:30:\"20250121_theovaladouxportfolio\";s:4:\"Hash\";s:35:\"fb4815b39912856a7753_20250121073755\";s:8:\"NameHash\";s:66:\"20250121_theovaladouxportfolio_fb4815b39912856a7753_20250121073755\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:76:\"20250121_theovaladouxportfolio_fb4815b39912856a7753_20250121073755_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"22.6\";s:6:\"WPUser\";s:4:\"root\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:78:\"20250121_theovaladouxportfolio_fb4815b39912856a7753_20250121073755_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:38:\"C:/laragon/www/Portfolio-Theo-Valadoux\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1714;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:14755;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-01-21 07:37:55\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.6.1\";s:9:\"VersionDB\";s:6:\"8.0.30\";s:10:\"VersionPHP\";s:6:\"8.1.10\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:30:\"20250121_theovaladouxportfolio\";s:4:\"Hash\";s:35:\"fb4815b39912856a7753_20250121073755\";s:8:\"NameHash\";s:66:\"20250121_theovaladouxportfolio_fb4815b39912856a7753_20250121073755\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:84:\"20250121_theovaladouxportfolio_fb4815b39912856a7753_20250121073755_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:52:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:79:\"20250121_theovaladouxportfolio_fb4815b39912856a7753_20250121073755_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:150:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content/backups-dup-lite/tmp/20250121_theovaladouxportfolio_fb4815b39912856a7753_20250121073755_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:47:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-admin\";i:1;s:50:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-includes\";i:2;s:59:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:38:\"C:/laragon/www/Portfolio-Theo-Valadoux\";i:1;s:38:\"C:/laragon/www/Portfolio-Theo-Valadoux\";i:2;s:49:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content\";i:3;s:57:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content/uploads\";i:4;s:57:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content/plugins\";i:5;s:60:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content/mu-plugins\";i:6;s:56:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:70:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "cron", "a:16:{i:1737445098;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1737446328;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1737447598;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1737448128;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1737448130;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1737449558;a:1:{s:32:\"Kubio\\NotificationsManager::init\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1737484148;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1737487728;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1737527329;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1737527330;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1737527348;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1737527352;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1737982800;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1737988121;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1738045840;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "auto");
INSERT INTO `wp_options` VALUES("2", "siteurl", "http://portfolio-theo-valadoux.test", "on");
INSERT INTO `wp_options` VALUES("3", "home", "http://portfolio-theo-valadoux.test", "on");
INSERT INTO `wp_options` VALUES("4", "blogname", "Théo Valadoux portfolio", "on");
INSERT INTO `wp_options` VALUES("5", "blogdescription", "", "on");
INSERT INTO `wp_options` VALUES("6", "users_can_register", "0", "on");
INSERT INTO `wp_options` VALUES("7", "admin_email", "theo.valadoux@gmail.com", "on");
INSERT INTO `wp_options` VALUES("8", "start_of_week", "1", "on");
INSERT INTO `wp_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `wp_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `wp_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `wp_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `wp_options` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `wp_options` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `wp_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `wp_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `wp_options` VALUES("17", "mailserver_pass", "password", "on");
INSERT INTO `wp_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `wp_options` VALUES("19", "default_category", "1", "on");
INSERT INTO `wp_options` VALUES("20", "default_comment_status", "open", "on");
INSERT INTO `wp_options` VALUES("21", "default_ping_status", "open", "on");
INSERT INTO `wp_options` VALUES("22", "default_pingback_flag", "1", "on");
INSERT INTO `wp_options` VALUES("23", "posts_per_page", "10", "on");
INSERT INTO `wp_options` VALUES("24", "date_format", "j F Y", "on");
INSERT INTO `wp_options` VALUES("25", "time_format", "G\\hi", "on");
INSERT INTO `wp_options` VALUES("26", "links_updated_date_format", "d F Y G\\hi", "on");
INSERT INTO `wp_options` VALUES("27", "comment_moderation", "0", "on");
INSERT INTO `wp_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `wp_options` VALUES("29", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "on");
INSERT INTO `wp_options` VALUES("30", "rewrite_rules", "a:118:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:57:\"portfolio-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?rara_portfolio_categories=$matches[1]&feed=$matches[2]\";s:52:\"portfolio-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?rara_portfolio_categories=$matches[1]&feed=$matches[2]\";s:33:\"portfolio-category/(.+?)/embed/?$\";s:58:\"index.php?rara_portfolio_categories=$matches[1]&embed=true\";s:45:\"portfolio-category/(.+?)/page/?([0-9]{1,})/?$\";s:65:\"index.php?rara_portfolio_categories=$matches[1]&paged=$matches[2]\";s:27:\"portfolio-category/(.+?)/?$\";s:47:\"index.php?rara_portfolio_categories=$matches[1]\";s:37:\"portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"portfolio/([^/]+)/embed/?$\";s:47:\"index.php?rara-portfolio=$matches[1]&embed=true\";s:30:\"portfolio/([^/]+)/trackback/?$\";s:41:\"index.php?rara-portfolio=$matches[1]&tb=1\";s:38:\"portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?rara-portfolio=$matches[1]&paged=$matches[2]\";s:45:\"portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?rara-portfolio=$matches[1]&cpage=$matches[2]\";s:34:\"portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?rara-portfolio=$matches[1]&page=$matches[2]\";s:26:\"portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "on");
INSERT INTO `wp_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `wp_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `wp_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `wp_options` VALUES("34", "active_plugins", "a:5:{i:0;s:36:\"contact-form-7/wp-contact-form-7.php\";i:1;s:25:\"duplicator/duplicator.php\";i:2;s:16:\"kubio/plugin.php\";i:3;s:43:\"raratheme-companion/raratheme-companion.php\";i:4;s:29:\"wp-mail-smtp/wp_mail_smtp.php\";}", "on");
INSERT INTO `wp_options` VALUES("35", "category_base", "", "on");
INSERT INTO `wp_options` VALUES("36", "ping_sites", "http://rpc.pingomatic.com/", "on");
INSERT INTO `wp_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `wp_options` VALUES("38", "gmt_offset", "0", "on");
INSERT INTO `wp_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `wp_options` VALUES("40", "recently_edited", "a:2:{i:0;s:74:\"C:\\laragon\\www\\Portfolio-Theo-Valadoux/wp-content/themes/inspiro/style.css\";i:2;s:0:\"\";}", "off");
INSERT INTO `wp_options` VALUES("41", "template", "vireo", "on");
INSERT INTO `wp_options` VALUES("42", "stylesheet", "vireo", "on");
INSERT INTO `wp_options` VALUES("43", "comment_registration", "0", "on");
INSERT INTO `wp_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `wp_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `wp_options` VALUES("46", "default_role", "subscriber", "on");
INSERT INTO `wp_options` VALUES("47", "db_version", "57155", "on");
INSERT INTO `wp_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `wp_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `wp_options` VALUES("50", "blog_public", "1", "on");
INSERT INTO `wp_options` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `wp_options` VALUES("52", "show_on_front", "page", "on");
INSERT INTO `wp_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `wp_options` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `wp_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `wp_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `wp_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `wp_options` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `wp_options` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `wp_options` VALUES("62", "avatar_default", "mystery", "on");
INSERT INTO `wp_options` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `wp_options` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `wp_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `wp_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `wp_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `wp_options` VALUES("68", "close_comments_for_old_posts", "0", "on");
INSERT INTO `wp_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `wp_options` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `wp_options` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `wp_options` VALUES("72", "page_comments", "0", "on");
INSERT INTO `wp_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `wp_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `wp_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `wp_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("77", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("78", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("79", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("80", "uninstall_plugins", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("81", "timezone_string", "Europe/Paris", "on");
INSERT INTO `wp_options` VALUES("82", "page_for_posts", "66", "on");
INSERT INTO `wp_options` VALUES("83", "page_on_front", "65", "on");
INSERT INTO `wp_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `wp_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `wp_options` VALUES("87", "site_icon", "0", "on");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `wp_options` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `wp_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `wp_options` VALUES("92", "admin_email_lifespan", "1743920928", "on");
INSERT INTO `wp_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `wp_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `wp_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `wp_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `wp_options` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("101", "initial_db_version", "57155", "on");
INSERT INTO `wp_options` VALUES("102", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_kubio-globals\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "auto");
INSERT INTO `wp_options` VALUES("103", "fresh_site", "0", "auto");
INSERT INTO `wp_options` VALUES("104", "WPLANG", "fr_FR", "auto");
INSERT INTO `wp_options` VALUES("105", "user_count", "1", "off");
INSERT INTO `wp_options` VALUES("106", "widget_block", "a:7:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Articles récents</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:233:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Commentaires récents</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:151:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Catégories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;i:7;a:1:{s:7:\"content\";s:232:\"<!-- wp:separator {\"color\":\"kubio-color-1\",\"className\":\"is-style-wide\"} --><hr class=\"wp-block-separator has-text-color has-background has-kubio-color-1-background-color has-kubio-color-1-color is-style-wide\"/><!-- /wp:separator -->\";}}", "auto");
INSERT INTO `wp_options` VALUES("107", "sidebars_widgets", "a:3:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"array_version\";i:3;s:17:\"kubio-woocommerce\";a:6:{i:0;s:25:\"woocommerce_widget_cart-2\";i:1;s:7:\"block-7\";i:2;s:26:\"woocommerce_price_filter-2\";i:3;s:38:\"woocommerce_recently_viewed_products-2\";i:4;s:32:\"woocommerce_top_rated_products-2\";i:5;s:33:\"woocommerce_layered_nav_filters-2\";}}", "auto");
INSERT INTO `wp_options` VALUES("108", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("109", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("110", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("111", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("112", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("113", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("114", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("115", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("116", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("117", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("118", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("119", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("120", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("121", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("122", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:5:\"6.6.1\";s:5:\"files\";a:496:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:21:\"button/editor-rtl.css\";i:29;s:25:\"button/editor-rtl.min.css\";i:30;s:17:\"button/editor.css\";i:31;s:21:\"button/editor.min.css\";i:32;s:20:\"button/style-rtl.css\";i:33;s:24:\"button/style-rtl.min.css\";i:34;s:16:\"button/style.css\";i:35;s:20:\"button/style.min.css\";i:36;s:22:\"buttons/editor-rtl.css\";i:37;s:26:\"buttons/editor-rtl.min.css\";i:38;s:18:\"buttons/editor.css\";i:39;s:22:\"buttons/editor.min.css\";i:40;s:21:\"buttons/style-rtl.css\";i:41;s:25:\"buttons/style-rtl.min.css\";i:42;s:17:\"buttons/style.css\";i:43;s:21:\"buttons/style.min.css\";i:44;s:22:\"calendar/style-rtl.css\";i:45;s:26:\"calendar/style-rtl.min.css\";i:46;s:18:\"calendar/style.css\";i:47;s:22:\"calendar/style.min.css\";i:48;s:25:\"categories/editor-rtl.css\";i:49;s:29:\"categories/editor-rtl.min.css\";i:50;s:21:\"categories/editor.css\";i:51;s:25:\"categories/editor.min.css\";i:52;s:24:\"categories/style-rtl.css\";i:53;s:28:\"categories/style-rtl.min.css\";i:54;s:20:\"categories/style.css\";i:55;s:24:\"categories/style.min.css\";i:56;s:19:\"code/editor-rtl.css\";i:57;s:23:\"code/editor-rtl.min.css\";i:58;s:15:\"code/editor.css\";i:59;s:19:\"code/editor.min.css\";i:60;s:18:\"code/style-rtl.css\";i:61;s:22:\"code/style-rtl.min.css\";i:62;s:14:\"code/style.css\";i:63;s:18:\"code/style.min.css\";i:64;s:18:\"code/theme-rtl.css\";i:65;s:22:\"code/theme-rtl.min.css\";i:66;s:14:\"code/theme.css\";i:67;s:18:\"code/theme.min.css\";i:68;s:22:\"columns/editor-rtl.css\";i:69;s:26:\"columns/editor-rtl.min.css\";i:70;s:18:\"columns/editor.css\";i:71;s:22:\"columns/editor.min.css\";i:72;s:21:\"columns/style-rtl.css\";i:73;s:25:\"columns/style-rtl.min.css\";i:74;s:17:\"columns/style.css\";i:75;s:21:\"columns/style.min.css\";i:76;s:29:\"comment-content/style-rtl.css\";i:77;s:33:\"comment-content/style-rtl.min.css\";i:78;s:25:\"comment-content/style.css\";i:79;s:29:\"comment-content/style.min.css\";i:80;s:30:\"comment-template/style-rtl.css\";i:81;s:34:\"comment-template/style-rtl.min.css\";i:82;s:26:\"comment-template/style.css\";i:83;s:30:\"comment-template/style.min.css\";i:84;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:85;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:86;s:38:\"comments-pagination-numbers/editor.css\";i:87;s:42:\"comments-pagination-numbers/editor.min.css\";i:88;s:34:\"comments-pagination/editor-rtl.css\";i:89;s:38:\"comments-pagination/editor-rtl.min.css\";i:90;s:30:\"comments-pagination/editor.css\";i:91;s:34:\"comments-pagination/editor.min.css\";i:92;s:33:\"comments-pagination/style-rtl.css\";i:93;s:37:\"comments-pagination/style-rtl.min.css\";i:94;s:29:\"comments-pagination/style.css\";i:95;s:33:\"comments-pagination/style.min.css\";i:96;s:29:\"comments-title/editor-rtl.css\";i:97;s:33:\"comments-title/editor-rtl.min.css\";i:98;s:25:\"comments-title/editor.css\";i:99;s:29:\"comments-title/editor.min.css\";i:100;s:23:\"comments/editor-rtl.css\";i:101;s:27:\"comments/editor-rtl.min.css\";i:102;s:19:\"comments/editor.css\";i:103;s:23:\"comments/editor.min.css\";i:104;s:22:\"comments/style-rtl.css\";i:105;s:26:\"comments/style-rtl.min.css\";i:106;s:18:\"comments/style.css\";i:107;s:22:\"comments/style.min.css\";i:108;s:20:\"cover/editor-rtl.css\";i:109;s:24:\"cover/editor-rtl.min.css\";i:110;s:16:\"cover/editor.css\";i:111;s:20:\"cover/editor.min.css\";i:112;s:19:\"cover/style-rtl.css\";i:113;s:23:\"cover/style-rtl.min.css\";i:114;s:15:\"cover/style.css\";i:115;s:19:\"cover/style.min.css\";i:116;s:22:\"details/editor-rtl.css\";i:117;s:26:\"details/editor-rtl.min.css\";i:118;s:18:\"details/editor.css\";i:119;s:22:\"details/editor.min.css\";i:120;s:21:\"details/style-rtl.css\";i:121;s:25:\"details/style-rtl.min.css\";i:122;s:17:\"details/style.css\";i:123;s:21:\"details/style.min.css\";i:124;s:20:\"embed/editor-rtl.css\";i:125;s:24:\"embed/editor-rtl.min.css\";i:126;s:16:\"embed/editor.css\";i:127;s:20:\"embed/editor.min.css\";i:128;s:19:\"embed/style-rtl.css\";i:129;s:23:\"embed/style-rtl.min.css\";i:130;s:15:\"embed/style.css\";i:131;s:19:\"embed/style.min.css\";i:132;s:19:\"embed/theme-rtl.css\";i:133;s:23:\"embed/theme-rtl.min.css\";i:134;s:15:\"embed/theme.css\";i:135;s:19:\"embed/theme.min.css\";i:136;s:19:\"file/editor-rtl.css\";i:137;s:23:\"file/editor-rtl.min.css\";i:138;s:15:\"file/editor.css\";i:139;s:19:\"file/editor.min.css\";i:140;s:18:\"file/style-rtl.css\";i:141;s:22:\"file/style-rtl.min.css\";i:142;s:14:\"file/style.css\";i:143;s:18:\"file/style.min.css\";i:144;s:23:\"footnotes/style-rtl.css\";i:145;s:27:\"footnotes/style-rtl.min.css\";i:146;s:19:\"footnotes/style.css\";i:147;s:23:\"footnotes/style.min.css\";i:148;s:23:\"freeform/editor-rtl.css\";i:149;s:27:\"freeform/editor-rtl.min.css\";i:150;s:19:\"freeform/editor.css\";i:151;s:23:\"freeform/editor.min.css\";i:152;s:22:\"gallery/editor-rtl.css\";i:153;s:26:\"gallery/editor-rtl.min.css\";i:154;s:18:\"gallery/editor.css\";i:155;s:22:\"gallery/editor.min.css\";i:156;s:21:\"gallery/style-rtl.css\";i:157;s:25:\"gallery/style-rtl.min.css\";i:158;s:17:\"gallery/style.css\";i:159;s:21:\"gallery/style.min.css\";i:160;s:21:\"gallery/theme-rtl.css\";i:161;s:25:\"gallery/theme-rtl.min.css\";i:162;s:17:\"gallery/theme.css\";i:163;s:21:\"gallery/theme.min.css\";i:164;s:20:\"group/editor-rtl.css\";i:165;s:24:\"group/editor-rtl.min.css\";i:166;s:16:\"group/editor.css\";i:167;s:20:\"group/editor.min.css\";i:168;s:19:\"group/style-rtl.css\";i:169;s:23:\"group/style-rtl.min.css\";i:170;s:15:\"group/style.css\";i:171;s:19:\"group/style.min.css\";i:172;s:19:\"group/theme-rtl.css\";i:173;s:23:\"group/theme-rtl.min.css\";i:174;s:15:\"group/theme.css\";i:175;s:19:\"group/theme.min.css\";i:176;s:21:\"heading/style-rtl.css\";i:177;s:25:\"heading/style-rtl.min.css\";i:178;s:17:\"heading/style.css\";i:179;s:21:\"heading/style.min.css\";i:180;s:19:\"html/editor-rtl.css\";i:181;s:23:\"html/editor-rtl.min.css\";i:182;s:15:\"html/editor.css\";i:183;s:19:\"html/editor.min.css\";i:184;s:20:\"image/editor-rtl.css\";i:185;s:24:\"image/editor-rtl.min.css\";i:186;s:16:\"image/editor.css\";i:187;s:20:\"image/editor.min.css\";i:188;s:19:\"image/style-rtl.css\";i:189;s:23:\"image/style-rtl.min.css\";i:190;s:15:\"image/style.css\";i:191;s:19:\"image/style.min.css\";i:192;s:19:\"image/theme-rtl.css\";i:193;s:23:\"image/theme-rtl.min.css\";i:194;s:15:\"image/theme.css\";i:195;s:19:\"image/theme.min.css\";i:196;s:29:\"latest-comments/style-rtl.css\";i:197;s:33:\"latest-comments/style-rtl.min.css\";i:198;s:25:\"latest-comments/style.css\";i:199;s:29:\"latest-comments/style.min.css\";i:200;s:27:\"latest-posts/editor-rtl.css\";i:201;s:31:\"latest-posts/editor-rtl.min.css\";i:202;s:23:\"latest-posts/editor.css\";i:203;s:27:\"latest-posts/editor.min.css\";i:204;s:26:\"latest-posts/style-rtl.css\";i:205;s:30:\"latest-posts/style-rtl.min.css\";i:206;s:22:\"latest-posts/style.css\";i:207;s:26:\"latest-posts/style.min.css\";i:208;s:18:\"list/style-rtl.css\";i:209;s:22:\"list/style-rtl.min.css\";i:210;s:14:\"list/style.css\";i:211;s:18:\"list/style.min.css\";i:212;s:25:\"media-text/editor-rtl.css\";i:213;s:29:\"media-text/editor-rtl.min.css\";i:214;s:21:\"media-text/editor.css\";i:215;s:25:\"media-text/editor.min.css\";i:216;s:24:\"media-text/style-rtl.css\";i:217;s:28:\"media-text/style-rtl.min.css\";i:218;s:20:\"media-text/style.css\";i:219;s:24:\"media-text/style.min.css\";i:220;s:19:\"more/editor-rtl.css\";i:221;s:23:\"more/editor-rtl.min.css\";i:222;s:15:\"more/editor.css\";i:223;s:19:\"more/editor.min.css\";i:224;s:30:\"navigation-link/editor-rtl.css\";i:225;s:34:\"navigation-link/editor-rtl.min.css\";i:226;s:26:\"navigation-link/editor.css\";i:227;s:30:\"navigation-link/editor.min.css\";i:228;s:29:\"navigation-link/style-rtl.css\";i:229;s:33:\"navigation-link/style-rtl.min.css\";i:230;s:25:\"navigation-link/style.css\";i:231;s:29:\"navigation-link/style.min.css\";i:232;s:33:\"navigation-submenu/editor-rtl.css\";i:233;s:37:\"navigation-submenu/editor-rtl.min.css\";i:234;s:29:\"navigation-submenu/editor.css\";i:235;s:33:\"navigation-submenu/editor.min.css\";i:236;s:25:\"navigation/editor-rtl.css\";i:237;s:29:\"navigation/editor-rtl.min.css\";i:238;s:21:\"navigation/editor.css\";i:239;s:25:\"navigation/editor.min.css\";i:240;s:24:\"navigation/style-rtl.css\";i:241;s:28:\"navigation/style-rtl.min.css\";i:242;s:20:\"navigation/style.css\";i:243;s:24:\"navigation/style.min.css\";i:244;s:23:\"nextpage/editor-rtl.css\";i:245;s:27:\"nextpage/editor-rtl.min.css\";i:246;s:19:\"nextpage/editor.css\";i:247;s:23:\"nextpage/editor.min.css\";i:248;s:24:\"page-list/editor-rtl.css\";i:249;s:28:\"page-list/editor-rtl.min.css\";i:250;s:20:\"page-list/editor.css\";i:251;s:24:\"page-list/editor.min.css\";i:252;s:23:\"page-list/style-rtl.css\";i:253;s:27:\"page-list/style-rtl.min.css\";i:254;s:19:\"page-list/style.css\";i:255;s:23:\"page-list/style.min.css\";i:256;s:24:\"paragraph/editor-rtl.css\";i:257;s:28:\"paragraph/editor-rtl.min.css\";i:258;s:20:\"paragraph/editor.css\";i:259;s:24:\"paragraph/editor.min.css\";i:260;s:23:\"paragraph/style-rtl.css\";i:261;s:27:\"paragraph/style-rtl.min.css\";i:262;s:19:\"paragraph/style.css\";i:263;s:23:\"paragraph/style.min.css\";i:264;s:25:\"post-author/style-rtl.css\";i:265;s:29:\"post-author/style-rtl.min.css\";i:266;s:21:\"post-author/style.css\";i:267;s:25:\"post-author/style.min.css\";i:268;s:33:\"post-comments-form/editor-rtl.css\";i:269;s:37:\"post-comments-form/editor-rtl.min.css\";i:270;s:29:\"post-comments-form/editor.css\";i:271;s:33:\"post-comments-form/editor.min.css\";i:272;s:32:\"post-comments-form/style-rtl.css\";i:273;s:36:\"post-comments-form/style-rtl.min.css\";i:274;s:28:\"post-comments-form/style.css\";i:275;s:32:\"post-comments-form/style.min.css\";i:276;s:27:\"post-content/editor-rtl.css\";i:277;s:31:\"post-content/editor-rtl.min.css\";i:278;s:23:\"post-content/editor.css\";i:279;s:27:\"post-content/editor.min.css\";i:280;s:23:\"post-date/style-rtl.css\";i:281;s:27:\"post-date/style-rtl.min.css\";i:282;s:19:\"post-date/style.css\";i:283;s:23:\"post-date/style.min.css\";i:284;s:27:\"post-excerpt/editor-rtl.css\";i:285;s:31:\"post-excerpt/editor-rtl.min.css\";i:286;s:23:\"post-excerpt/editor.css\";i:287;s:27:\"post-excerpt/editor.min.css\";i:288;s:26:\"post-excerpt/style-rtl.css\";i:289;s:30:\"post-excerpt/style-rtl.min.css\";i:290;s:22:\"post-excerpt/style.css\";i:291;s:26:\"post-excerpt/style.min.css\";i:292;s:34:\"post-featured-image/editor-rtl.css\";i:293;s:38:\"post-featured-image/editor-rtl.min.css\";i:294;s:30:\"post-featured-image/editor.css\";i:295;s:34:\"post-featured-image/editor.min.css\";i:296;s:33:\"post-featured-image/style-rtl.css\";i:297;s:37:\"post-featured-image/style-rtl.min.css\";i:298;s:29:\"post-featured-image/style.css\";i:299;s:33:\"post-featured-image/style.min.css\";i:300;s:34:\"post-navigation-link/style-rtl.css\";i:301;s:38:\"post-navigation-link/style-rtl.min.css\";i:302;s:30:\"post-navigation-link/style.css\";i:303;s:34:\"post-navigation-link/style.min.css\";i:304;s:28:\"post-template/editor-rtl.css\";i:305;s:32:\"post-template/editor-rtl.min.css\";i:306;s:24:\"post-template/editor.css\";i:307;s:28:\"post-template/editor.min.css\";i:308;s:27:\"post-template/style-rtl.css\";i:309;s:31:\"post-template/style-rtl.min.css\";i:310;s:23:\"post-template/style.css\";i:311;s:27:\"post-template/style.min.css\";i:312;s:24:\"post-terms/style-rtl.css\";i:313;s:28:\"post-terms/style-rtl.min.css\";i:314;s:20:\"post-terms/style.css\";i:315;s:24:\"post-terms/style.min.css\";i:316;s:24:\"post-title/style-rtl.css\";i:317;s:28:\"post-title/style-rtl.min.css\";i:318;s:20:\"post-title/style.css\";i:319;s:24:\"post-title/style.min.css\";i:320;s:26:\"preformatted/style-rtl.css\";i:321;s:30:\"preformatted/style-rtl.min.css\";i:322;s:22:\"preformatted/style.css\";i:323;s:26:\"preformatted/style.min.css\";i:324;s:24:\"pullquote/editor-rtl.css\";i:325;s:28:\"pullquote/editor-rtl.min.css\";i:326;s:20:\"pullquote/editor.css\";i:327;s:24:\"pullquote/editor.min.css\";i:328;s:23:\"pullquote/style-rtl.css\";i:329;s:27:\"pullquote/style-rtl.min.css\";i:330;s:19:\"pullquote/style.css\";i:331;s:23:\"pullquote/style.min.css\";i:332;s:23:\"pullquote/theme-rtl.css\";i:333;s:27:\"pullquote/theme-rtl.min.css\";i:334;s:19:\"pullquote/theme.css\";i:335;s:23:\"pullquote/theme.min.css\";i:336;s:39:\"query-pagination-numbers/editor-rtl.css\";i:337;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:338;s:35:\"query-pagination-numbers/editor.css\";i:339;s:39:\"query-pagination-numbers/editor.min.css\";i:340;s:31:\"query-pagination/editor-rtl.css\";i:341;s:35:\"query-pagination/editor-rtl.min.css\";i:342;s:27:\"query-pagination/editor.css\";i:343;s:31:\"query-pagination/editor.min.css\";i:344;s:30:\"query-pagination/style-rtl.css\";i:345;s:34:\"query-pagination/style-rtl.min.css\";i:346;s:26:\"query-pagination/style.css\";i:347;s:30:\"query-pagination/style.min.css\";i:348;s:25:\"query-title/style-rtl.css\";i:349;s:29:\"query-title/style-rtl.min.css\";i:350;s:21:\"query-title/style.css\";i:351;s:25:\"query-title/style.min.css\";i:352;s:20:\"query/editor-rtl.css\";i:353;s:24:\"query/editor-rtl.min.css\";i:354;s:16:\"query/editor.css\";i:355;s:20:\"query/editor.min.css\";i:356;s:19:\"quote/style-rtl.css\";i:357;s:23:\"quote/style-rtl.min.css\";i:358;s:15:\"quote/style.css\";i:359;s:19:\"quote/style.min.css\";i:360;s:19:\"quote/theme-rtl.css\";i:361;s:23:\"quote/theme-rtl.min.css\";i:362;s:15:\"quote/theme.css\";i:363;s:19:\"quote/theme.min.css\";i:364;s:23:\"read-more/style-rtl.css\";i:365;s:27:\"read-more/style-rtl.min.css\";i:366;s:19:\"read-more/style.css\";i:367;s:23:\"read-more/style.min.css\";i:368;s:18:\"rss/editor-rtl.css\";i:369;s:22:\"rss/editor-rtl.min.css\";i:370;s:14:\"rss/editor.css\";i:371;s:18:\"rss/editor.min.css\";i:372;s:17:\"rss/style-rtl.css\";i:373;s:21:\"rss/style-rtl.min.css\";i:374;s:13:\"rss/style.css\";i:375;s:17:\"rss/style.min.css\";i:376;s:21:\"search/editor-rtl.css\";i:377;s:25:\"search/editor-rtl.min.css\";i:378;s:17:\"search/editor.css\";i:379;s:21:\"search/editor.min.css\";i:380;s:20:\"search/style-rtl.css\";i:381;s:24:\"search/style-rtl.min.css\";i:382;s:16:\"search/style.css\";i:383;s:20:\"search/style.min.css\";i:384;s:20:\"search/theme-rtl.css\";i:385;s:24:\"search/theme-rtl.min.css\";i:386;s:16:\"search/theme.css\";i:387;s:20:\"search/theme.min.css\";i:388;s:24:\"separator/editor-rtl.css\";i:389;s:28:\"separator/editor-rtl.min.css\";i:390;s:20:\"separator/editor.css\";i:391;s:24:\"separator/editor.min.css\";i:392;s:23:\"separator/style-rtl.css\";i:393;s:27:\"separator/style-rtl.min.css\";i:394;s:19:\"separator/style.css\";i:395;s:23:\"separator/style.min.css\";i:396;s:23:\"separator/theme-rtl.css\";i:397;s:27:\"separator/theme-rtl.min.css\";i:398;s:19:\"separator/theme.css\";i:399;s:23:\"separator/theme.min.css\";i:400;s:24:\"shortcode/editor-rtl.css\";i:401;s:28:\"shortcode/editor-rtl.min.css\";i:402;s:20:\"shortcode/editor.css\";i:403;s:24:\"shortcode/editor.min.css\";i:404;s:24:\"site-logo/editor-rtl.css\";i:405;s:28:\"site-logo/editor-rtl.min.css\";i:406;s:20:\"site-logo/editor.css\";i:407;s:24:\"site-logo/editor.min.css\";i:408;s:23:\"site-logo/style-rtl.css\";i:409;s:27:\"site-logo/style-rtl.min.css\";i:410;s:19:\"site-logo/style.css\";i:411;s:23:\"site-logo/style.min.css\";i:412;s:27:\"site-tagline/editor-rtl.css\";i:413;s:31:\"site-tagline/editor-rtl.min.css\";i:414;s:23:\"site-tagline/editor.css\";i:415;s:27:\"site-tagline/editor.min.css\";i:416;s:25:\"site-title/editor-rtl.css\";i:417;s:29:\"site-title/editor-rtl.min.css\";i:418;s:21:\"site-title/editor.css\";i:419;s:25:\"site-title/editor.min.css\";i:420;s:24:\"site-title/style-rtl.css\";i:421;s:28:\"site-title/style-rtl.min.css\";i:422;s:20:\"site-title/style.css\";i:423;s:24:\"site-title/style.min.css\";i:424;s:26:\"social-link/editor-rtl.css\";i:425;s:30:\"social-link/editor-rtl.min.css\";i:426;s:22:\"social-link/editor.css\";i:427;s:26:\"social-link/editor.min.css\";i:428;s:27:\"social-links/editor-rtl.css\";i:429;s:31:\"social-links/editor-rtl.min.css\";i:430;s:23:\"social-links/editor.css\";i:431;s:27:\"social-links/editor.min.css\";i:432;s:26:\"social-links/style-rtl.css\";i:433;s:30:\"social-links/style-rtl.min.css\";i:434;s:22:\"social-links/style.css\";i:435;s:26:\"social-links/style.min.css\";i:436;s:21:\"spacer/editor-rtl.css\";i:437;s:25:\"spacer/editor-rtl.min.css\";i:438;s:17:\"spacer/editor.css\";i:439;s:21:\"spacer/editor.min.css\";i:440;s:20:\"spacer/style-rtl.css\";i:441;s:24:\"spacer/style-rtl.min.css\";i:442;s:16:\"spacer/style.css\";i:443;s:20:\"spacer/style.min.css\";i:444;s:20:\"table/editor-rtl.css\";i:445;s:24:\"table/editor-rtl.min.css\";i:446;s:16:\"table/editor.css\";i:447;s:20:\"table/editor.min.css\";i:448;s:19:\"table/style-rtl.css\";i:449;s:23:\"table/style-rtl.min.css\";i:450;s:15:\"table/style.css\";i:451;s:19:\"table/style.min.css\";i:452;s:19:\"table/theme-rtl.css\";i:453;s:23:\"table/theme-rtl.min.css\";i:454;s:15:\"table/theme.css\";i:455;s:19:\"table/theme.min.css\";i:456;s:23:\"tag-cloud/style-rtl.css\";i:457;s:27:\"tag-cloud/style-rtl.min.css\";i:458;s:19:\"tag-cloud/style.css\";i:459;s:23:\"tag-cloud/style.min.css\";i:460;s:28:\"template-part/editor-rtl.css\";i:461;s:32:\"template-part/editor-rtl.min.css\";i:462;s:24:\"template-part/editor.css\";i:463;s:28:\"template-part/editor.min.css\";i:464;s:27:\"template-part/theme-rtl.css\";i:465;s:31:\"template-part/theme-rtl.min.css\";i:466;s:23:\"template-part/theme.css\";i:467;s:27:\"template-part/theme.min.css\";i:468;s:30:\"term-description/style-rtl.css\";i:469;s:34:\"term-description/style-rtl.min.css\";i:470;s:26:\"term-description/style.css\";i:471;s:30:\"term-description/style.min.css\";i:472;s:27:\"text-columns/editor-rtl.css\";i:473;s:31:\"text-columns/editor-rtl.min.css\";i:474;s:23:\"text-columns/editor.css\";i:475;s:27:\"text-columns/editor.min.css\";i:476;s:26:\"text-columns/style-rtl.css\";i:477;s:30:\"text-columns/style-rtl.min.css\";i:478;s:22:\"text-columns/style.css\";i:479;s:26:\"text-columns/style.min.css\";i:480;s:19:\"verse/style-rtl.css\";i:481;s:23:\"verse/style-rtl.min.css\";i:482;s:15:\"verse/style.css\";i:483;s:19:\"verse/style.min.css\";i:484;s:20:\"video/editor-rtl.css\";i:485;s:24:\"video/editor-rtl.min.css\";i:486;s:16:\"video/editor.css\";i:487;s:20:\"video/editor.min.css\";i:488;s:19:\"video/style-rtl.css\";i:489;s:23:\"video/style-rtl.min.css\";i:490;s:15:\"video/style.css\";i:491;s:19:\"video/style.min.css\";i:492;s:19:\"video/theme-rtl.css\";i:493;s:23:\"video/theme-rtl.min.css\";i:494;s:15:\"video/theme.css\";i:495;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `wp_options` VALUES("126", "recovery_keys", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("127", "theme_mods_twentytwentyfour", "a:4:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1728371114;s:4:\"data\";a:11:{s:19:\"wp_inactive_widgets\";a:0:{}s:7:\"sidebar\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:12:\"blog-sidebar\";a:0:{}s:8:\"footer_1\";a:0:{}s:8:\"footer_2\";a:0:{}s:8:\"footer_3\";a:0:{}s:8:\"footer_4\";a:0:{}s:13:\"header_social\";a:0:{}s:24:\"footer_instagram_section\";a:0:{}s:9:\"sidebar-1\";a:0:{}s:9:\"sidebar-2\";a:0:{}}}s:19:\"wp_classic_sidebars\";a:8:{s:7:\"sidebar\";a:11:{s:4:\"name\";s:7:\"Sidebar\";s:2:\"id\";s:7:\"sidebar\";s:11:\"description\";s:92:\"Main sidebar that is displayed on the right and can be toggled by clicking on the menu icon.\";s:5:\"class\";s:0:\"\";s:13:\"before_widget\";s:35:\"<div id=\"%1$s\" class=\"widget %2$s\">\";s:12:\"after_widget\";s:31:\"<div class=\"clear\"></div></div>\";s:12:\"before_title\";s:18:\"<h3 class=\"title\">\";s:11:\"after_title\";s:5:\"</h3>\";s:14:\"before_sidebar\";s:0:\"\";s:13:\"after_sidebar\";s:0:\"\";s:12:\"show_in_rest\";b:0;}s:12:\"blog-sidebar\";a:11:{s:4:\"name\";s:12:\"Blog Sidebar\";s:2:\"id\";s:12:\"blog-sidebar\";s:11:\"description\";s:75:\"Add widgets here to appear in your sidebar on blog posts and archive pages.\";s:5:\"class\";s:0:\"\";s:13:\"before_widget\";s:39:\"<section id=\"%1$s\" class=\"widget %2$s\">\";s:12:\"after_widget\";s:10:\"</section>\";s:12:\"before_title\";s:18:\"<h2 class=\"title\">\";s:11:\"after_title\";s:5:\"</h2>\";s:14:\"before_sidebar\";s:0:\"\";s:13:\"after_sidebar\";s:0:\"\";s:12:\"show_in_rest\";b:0;}s:8:\"footer_1\";a:11:{s:4:\"name\";s:8:\"Footer 1\";s:2:\"id\";s:8:\"footer_1\";s:11:\"description\";s:42:\"Add widgets here to appear in your footer.\";s:5:\"class\";s:0:\"\";s:13:\"before_widget\";s:39:\"<section id=\"%1$s\" class=\"widget %2$s\">\";s:12:\"after_widget\";s:10:\"</section>\";s:12:\"before_title\";s:18:\"<h2 class=\"title\">\";s:11:\"after_title\";s:5:\"</h2>\";s:14:\"before_sidebar\";s:0:\"\";s:13:\"after_sidebar\";s:0:\"\";s:12:\"show_in_rest\";b:0;}s:8:\"footer_2\";a:11:{s:4:\"name\";s:8:\"Footer 2\";s:2:\"id\";s:8:\"footer_2\";s:11:\"description\";s:42:\"Add widgets here to appear in your footer.\";s:5:\"class\";s:0:\"\";s:13:\"before_widget\";s:39:\"<section id=\"%1$s\" class=\"widget %2$s\">\";s:12:\"after_widget\";s:10:\"</section>\";s:12:\"before_title\";s:18:\"<h2 class=\"title\">\";s:11:\"after_title\";s:5:\"</h2>\";s:14:\"before_sidebar\";s:0:\"\";s:13:\"after_sidebar\";s:0:\"\";s:12:\"show_in_rest\";b:0;}s:8:\"footer_3\";a:11:{s:4:\"name\";s:8:\"Footer 3\";s:2:\"id\";s:8:\"footer_3\";s:11:\"description\";s:42:\"Add widgets here to appear in your footer.\";s:5:\"class\";s:0:\"\";s:13:\"before_widget\";s:39:\"<section id=\"%1$s\" class=\"widget %2$s\">\";s:12:\"after_widget\";s:10:\"</section>\";s:12:\"before_title\";s:18:\"<h2 class=\"title\">\";s:11:\"after_title\";s:5:\"</h2>\";s:14:\"before_sidebar\";s:0:\"\";s:13:\"after_sidebar\";s:0:\"\";s:12:\"show_in_rest\";b:0;}s:8:\"footer_4\";a:11:{s:4:\"name\";s:8:\"Footer 4\";s:2:\"id\";s:8:\"footer_4\";s:11:\"description\";s:42:\"Add widgets here to appear in your footer.\";s:5:\"class\";s:0:\"\";s:13:\"before_widget\";s:39:\"<section id=\"%1$s\" class=\"widget %2$s\">\";s:12:\"after_widget\";s:10:\"</section>\";s:12:\"before_title\";s:18:\"<h2 class=\"title\">\";s:11:\"after_title\";s:5:\"</h2>\";s:14:\"before_sidebar\";s:0:\"\";s:13:\"after_sidebar\";s:0:\"\";s:12:\"show_in_rest\";b:0;}s:13:\"header_social\";a:11:{s:4:\"name\";s:19:\"Header Social Icons\";s:2:\"id\";s:13:\"header_social\";s:11:\"description\";s:102:\"Widget area in the header. Install the \"Social Icons Widget by WPZOOM\" plugin and add the widget here.\";s:5:\"class\";s:0:\"\";s:13:\"before_widget\";s:35:\"<div id=\"%1$s\" class=\"widget %2$s\">\";s:12:\"after_widget\";s:6:\"</div>\";s:12:\"before_title\";s:24:\"<h3 class=\"title\"><span>\";s:11:\"after_title\";s:12:\"</span></h3>\";s:14:\"before_sidebar\";s:0:\"\";s:13:\"after_sidebar\";s:0:\"\";s:12:\"show_in_rest\";b:0;}s:24:\"footer_instagram_section\";a:11:{s:4:\"name\";s:20:\"Footer Instagram Bar\";s:2:\"id\";s:24:\"footer_instagram_section\";s:11:\"description\";s:45:\"Widget area for \"Instagram widget by WPZOOM\".\";s:5:\"class\";s:0:\"\";s:13:\"before_widget\";s:39:\"<section class=\"widget %2$s\" id=\"%1$s\">\";s:12:\"after_widget\";s:35:\"<div class=\"clear\"></div></section>\";s:12:\"before_title\";s:18:\"<h3 class=\"title\">\";s:11:\"after_title\";s:5:\"</h3>\";s:14:\"before_sidebar\";s:0:\"\";s:13:\"after_sidebar\";s:0:\"\";s:12:\"show_in_rest\";b:0;}}s:18:\"nav_menu_locations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("142", "can_compress_scripts", "1", "on");
INSERT INTO `wp_options` VALUES("155", "finished_updating_comment_type", "1", "auto");
INSERT INTO `wp_options` VALUES("169", "current_theme", "Vireo", "auto");
INSERT INTO `wp_options` VALUES("170", "theme_mods_perfect-portfolio", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1728371269;s:4:\"data\";a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:7:\"sidebar\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:5:\"about\";a:0:{}s:3:\"cta\";a:0:{}s:8:\"services\";a:0:{}s:10:\"cta-footer\";a:0:{}s:10:\"footer-one\";a:0:{}s:10:\"footer-two\";a:0:{}s:12:\"footer-three\";a:0:{}}}}", "off");
INSERT INTO `wp_options` VALUES("171", "theme_switched", "", "auto");
INSERT INTO `wp_options` VALUES("179", "wp_calendar_block_has_published_posts", "1", "auto");
INSERT INTO `wp_options` VALUES("190", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("191", "rtc_queue_flush_rewrite_rules", "no", "auto");
INSERT INTO `wp_options` VALUES("192", "recently_activated", "a:1:{s:24:\"wpforms-lite/wpforms.php\";i:1737367320;}", "auto");
INSERT INTO `wp_options` VALUES("193", "widget_raratheme_companion_cta_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("194", "widget_rtc_contact_social_links", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("195", "widget_raratheme_featured_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("196", "widget_rrtc_icon_text_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("197", "widget_raratheme_image_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("198", "widget_raratheme_companion_stat_counter_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("199", "widget_raratheme_popular_post", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("200", "widget_raratheme_recent_post", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("201", "widget_rtc_social_links", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("202", "widget_rrtc_testimonial_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("203", "widget_rrtc_description_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("204", "widget_raratheme_client_logo_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("205", "widget_raratheme_companion_faqs_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("206", "widget_raratheme_featured_page_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("207", "widget_rtc_pro_twitter_feeds_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("208", "widget_rara_posts_category_slider_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("209", "widget_raratheme_advertisement_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("210", "widget_raratheme_author_bio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("211", "widget_raratheme_custom_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("212", "widget_raratheme_facebook_page_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("213", "widget_raratheme_snapcode_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("214", "widget_raratheme_pinterest_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("215", "widget_raratheme_image_text_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("223", "theme_mods_inspiro", "a:124:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1728377532;s:4:\"data\";a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:7:\"sidebar\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:12:\"blog-sidebar\";a:0:{}s:8:\"footer_1\";a:0:{}s:8:\"footer_2\";a:0:{}s:8:\"footer_3\";a:0:{}s:8:\"footer_4\";a:0:{}s:13:\"header_social\";a:0:{}s:24:\"footer_instagram_section\";a:0:{}}}s:18:\"color-slider-title\";s:0:\"\";s:24:\"color-slider-description\";s:0:\"\";s:15:\"display_content\";s:7:\"excerpt\";s:22:\"display_featured_image\";b:1;s:20:\"blog_options_upgrade\";s:0:\"\";s:20:\"color_general_h_tags\";s:0:\"\";s:20:\"color_general_h1_tag\";s:0:\"\";s:20:\"color_general_h2_tag\";s:0:\"\";s:20:\"color_general_h3_tag\";s:0:\"\";s:20:\"color_general_h4_tag\";s:0:\"\";s:20:\"color_general_h5_tag\";s:0:\"\";s:20:\"color_general_h6_tag\";s:0:\"\";s:24:\"color_general_page_title\";s:0:\"\";s:18:\"color-single-title\";s:0:\"\";s:24:\"color_general_post_title\";s:0:\"\";s:16:\"color-post-title\";s:0:\"\";s:32:\"color_general_entry_excerpt_text\";s:0:\"\";s:32:\"color_general_entry_content_text\";s:0:\"\";s:20:\"color-single-content\";s:0:\"\";s:26:\"color_general_link_content\";s:0:\"\";s:18:\"control-color-link\";s:0:\"\";s:32:\"color_general_link_hover_content\";s:0:\"\";s:16:\"color-link-hover\";s:0:\"\";s:11:\"colorscheme\";s:5:\"light\";s:16:\"color-background\";s:7:\"#ffffff\";s:15:\"color-body-text\";s:7:\"#444444\";s:15:\"colorscheme_hex\";s:7:\"#0bb4aa\";s:29:\"color_header_custom_logo_text\";s:7:\"#ffffff\";s:10:\"color-logo\";s:7:\"#ffffff\";s:35:\"color_header_custom_logo_hover_text\";s:7:\"#ffffff\";s:16:\"color-logo-hover\";s:7:\"#ffffff\";s:21:\"color_menu_background\";s:7:\"#101010\";s:21:\"color-menu-background\";s:7:\"#101010\";s:28:\"color-menu-background-scroll\";s:15:\"rgba(0,0,0,0.9)\";s:26:\"color_menu_search_icon_btn\";s:7:\"#ffffff\";s:24:\"color_menu_hamburger_btn\";s:7:\"#ffffff\";s:20:\"color-menu-hamburger\";s:7:\"#ffffff\";s:21:\"color_only_hero_title\";s:0:\"\";s:23:\"header_button_textcolor\";s:7:\"#ffffff\";s:24:\"color-slider-button-text\";s:7:\"#ffffff\";s:26:\"color-slider-button-border\";s:7:\"#ffffff\";s:29:\"header_button_textcolor_hover\";s:7:\"#ffffff\";s:30:\"color-slider-button-text-hover\";s:7:\"#ffffff\";s:27:\"header_button_bgcolor_hover\";s:7:\"#0bb4aa\";s:36:\"color-slider-button-background-hover\";s:7:\"#0bb4aa\";s:32:\"color-slider-button-border-hover\";s:7:\"#0bb4aa\";s:29:\"color_scroll_to_content_arrow\";s:0:\"\";s:19:\"color-slider-arrows\";s:0:\"\";s:29:\"hero_gradient_opacity_control\";s:3:\"0.3\";s:23:\"color_footer_background\";s:7:\"#101010\";s:23:\"footer-background-color\";s:7:\"#101010\";s:17:\"color_footer_text\";s:7:\"#78787f\";s:17:\"footer-text-color\";s:7:\"#78787f\";s:27:\"color_footer_copyright_text\";s:7:\"#ffffff\";s:14:\"colors_premium\";s:0:\"\";s:32:\"color_sidebar_widgets_background\";s:7:\"#101010\";s:24:\"color-sidebar-background\";s:7:\"#101010\";s:27:\"color_sidebar_widgets_title\";s:7:\"#ffffff\";s:26:\"color_sidebar_widgets_text\";s:7:\"#78787f\";s:18:\"color-sidebar-text\";s:7:\"#78787f\";s:26:\"color_sidebar_widgets_link\";s:7:\"#0bb4aa\";s:18:\"color-sidebar-link\";s:7:\"#0bb4aa\";s:33:\"external_header_video_full_height\";b:1;s:11:\"hero_enable\";b:1;s:12:\"overlay_show\";b:1;s:17:\"header_site_title\";s:24:\"Théo Valadoux portfolio\";s:23:\"header_site_description\";s:0:\"\";s:19:\"header_button_title\";s:0:\"\";s:17:\"header_button_url\";s:0:\"\";s:23:\"header_button_link_open\";b:1;s:16:\"custom_logo_text\";s:24:\"Théo Valadoux portfolio\";s:16:\"layout_blog_page\";s:4:\"full\";s:18:\"layout_single_post\";s:4:\"full\";s:16:\"body-font-family\";s:5:\"Inter\";s:17:\"body-font-variant\";s:3:\"400\";s:14:\"body-font-size\";i:16;s:16:\"body-font-weight\";s:6:\"normal\";s:19:\"body-text-transform\";s:0:\"\";s:16:\"body-line-height\";d:1.8;s:17:\"title-font-family\";s:10:\"Montserrat\";s:18:\"title-font-variant\";s:3:\"700\";s:15:\"title-font-size\";i:26;s:17:\"title-font-weight\";s:3:\"700\";s:20:\"title-text-transform\";s:9:\"uppercase\";s:17:\"title-line-height\";d:1.8;s:20:\"headings-font-family\";s:7:\"inherit\";s:21:\"headings-font-variant\";s:3:\"700\";s:20:\"headings-font-weight\";s:3:\"700\";s:23:\"headings-text-transform\";s:7:\"inherit\";s:20:\"headings-line-height\";d:1.4;s:20:\"mainmenu-font-family\";s:10:\"Montserrat\";s:21:\"mainmenu-font-variant\";s:3:\"500\";s:18:\"mainmenu-font-size\";i:16;s:20:\"mainmenu-font-weight\";s:3:\"500\";s:23:\"mainmenu-text-transform\";s:0:\"\";s:20:\"mainmenu-line-height\";d:1.8;s:22:\"mobilemenu-font-family\";s:10:\"Montserrat\";s:23:\"mobilemenu-font-variant\";s:3:\"600\";s:20:\"mobilemenu-font-size\";i:16;s:22:\"mobilemenu-font-weight\";s:3:\"600\";s:25:\"mobilemenu-text-transform\";s:9:\"uppercase\";s:22:\"mobilemenu-line-height\";d:1.8;s:24:\"slider-title-font-family\";s:5:\"Inter\";s:25:\"slider-title-font-variant\";s:3:\"700\";s:22:\"slider-title-font-size\";i:80;s:24:\"slider-title-font-weight\";s:3:\"700\";s:27:\"slider-title-text-transform\";s:0:\"\";s:24:\"slider-title-line-height\";d:1.25;s:23:\"slider-text-font-family\";s:5:\"Inter\";s:24:\"slider-text-font-variant\";s:0:\"\";s:21:\"slider-text-font-size\";i:20;s:23:\"slider-text-font-weight\";s:7:\"inherit\";s:26:\"slider-text-text-transform\";s:0:\"\";s:23:\"slider-text-line-height\";d:1.8;s:25:\"slider-button-font-family\";s:5:\"Inter\";s:26:\"slider-button-font-variant\";s:0:\"\";s:23:\"slider-button-font-size\";i:16;s:25:\"slider-button-font-weight\";s:7:\"inherit\";s:28:\"slider-button-text-transform\";s:0:\"\";s:25:\"slider-button-line-height\";d:1.8;}", "off");
INSERT INTO `wp_options` VALUES("226", "inspiro_theme_installed_time", "1728370401", "auto");
INSERT INTO `wp_options` VALUES("228", "downloaded_font_files", "a:32:{s:83:\"https://fonts.gstatic.com/s/inter/v18/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa2JL7SUc.woff2\";s:108:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa2JL7SUc.woff2\";s:83:\"https://fonts.gstatic.com/s/inter/v18/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa0ZL7SUc.woff2\";s:108:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa0ZL7SUc.woff2\";s:83:\"https://fonts.gstatic.com/s/inter/v18/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa2ZL7SUc.woff2\";s:108:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa2ZL7SUc.woff2\";s:83:\"https://fonts.gstatic.com/s/inter/v18/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa1pL7SUc.woff2\";s:108:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa1pL7SUc.woff2\";s:83:\"https://fonts.gstatic.com/s/inter/v18/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa2pL7SUc.woff2\";s:108:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa2pL7SUc.woff2\";s:83:\"https://fonts.gstatic.com/s/inter/v18/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa25L7SUc.woff2\";s:108:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa25L7SUc.woff2\";s:80:\"https://fonts.gstatic.com/s/inter/v18/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa1ZL7.woff2\";s:105:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa1ZL7.woff2\";s:77:\"https://fonts.gstatic.com/s/montserrat/v26/JTUSjIg1_i6t8kCHKm459WRhyzbi.woff2\";s:102:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/montserrat/JTUSjIg1_i6t8kCHKm459WRhyzbi.woff2\";s:77:\"https://fonts.gstatic.com/s/montserrat/v26/JTUSjIg1_i6t8kCHKm459W1hyzbi.woff2\";s:102:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/montserrat/JTUSjIg1_i6t8kCHKm459W1hyzbi.woff2\";s:77:\"https://fonts.gstatic.com/s/montserrat/v26/JTUSjIg1_i6t8kCHKm459WZhyzbi.woff2\";s:102:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/montserrat/JTUSjIg1_i6t8kCHKm459WZhyzbi.woff2\";s:77:\"https://fonts.gstatic.com/s/montserrat/v26/JTUSjIg1_i6t8kCHKm459Wdhyzbi.woff2\";s:102:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/montserrat/JTUSjIg1_i6t8kCHKm459Wdhyzbi.woff2\";s:75:\"https://fonts.gstatic.com/s/montserrat/v26/JTUSjIg1_i6t8kCHKm459Wlhyw.woff2\";s:100:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/montserrat/JTUSjIg1_i6t8kCHKm459Wlhyw.woff2\";s:66:\"https://fonts.gstatic.com/s/lato/v24/S6u8w4BMUTPHjxsAUi-qJCY.woff2\";s:91:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/lato/S6u8w4BMUTPHjxsAUi-qJCY.woff2\";s:63:\"https://fonts.gstatic.com/s/lato/v24/S6u8w4BMUTPHjxsAXC-q.woff2\";s:88:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/lato/S6u8w4BMUTPHjxsAXC-q.woff2\";s:70:\"https://fonts.gstatic.com/s/lato/v24/S6u_w4BMUTPHjxsI5wq_FQft1dw.woff2\";s:95:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/lato/S6u_w4BMUTPHjxsI5wq_FQft1dw.woff2\";s:67:\"https://fonts.gstatic.com/s/lato/v24/S6u_w4BMUTPHjxsI5wq_Gwft.woff2\";s:92:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/lato/S6u_w4BMUTPHjxsI5wq_Gwft.woff2\";s:70:\"https://fonts.gstatic.com/s/lato/v24/S6u_w4BMUTPHjxsI3wi_FQft1dw.woff2\";s:95:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/lato/S6u_w4BMUTPHjxsI3wi_FQft1dw.woff2\";s:67:\"https://fonts.gstatic.com/s/lato/v24/S6u_w4BMUTPHjxsI3wi_Gwft.woff2\";s:92:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/lato/S6u_w4BMUTPHjxsI3wi_Gwft.woff2\";s:63:\"https://fonts.gstatic.com/s/lato/v24/S6uyw4BMUTPHjxAwXjeu.woff2\";s:88:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/lato/S6uyw4BMUTPHjxAwXjeu.woff2\";s:61:\"https://fonts.gstatic.com/s/lato/v24/S6uyw4BMUTPHjx4wXg.woff2\";s:86:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/lato/S6uyw4BMUTPHjx4wXg.woff2\";s:67:\"https://fonts.gstatic.com/s/lato/v24/S6u9w4BMUTPHh6UVSwaPGR_p.woff2\";s:92:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/lato/S6u9w4BMUTPHh6UVSwaPGR_p.woff2\";s:65:\"https://fonts.gstatic.com/s/lato/v24/S6u9w4BMUTPHh6UVSwiPGQ.woff2\";s:90:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/lato/S6u9w4BMUTPHh6UVSwiPGQ.woff2\";s:67:\"https://fonts.gstatic.com/s/lato/v24/S6u9w4BMUTPHh50XSwaPGR_p.woff2\";s:92:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/lato/S6u9w4BMUTPHh50XSwaPGR_p.woff2\";s:65:\"https://fonts.gstatic.com/s/lato/v24/S6u9w4BMUTPHh50XSwiPGQ.woff2\";s:90:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/lato/S6u9w4BMUTPHh50XSwiPGQ.woff2\";s:93:\"https://fonts.gstatic.com/s/playfairdisplay/v37/nuFkD-vYSZviVYUb_rj3ij__anPXDTnohkk72xU.woff2\";s:119:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/playfair-display/nuFkD-vYSZviVYUb_rj3ij__anPXDTnohkk72xU.woff2\";s:93:\"https://fonts.gstatic.com/s/playfairdisplay/v37/nuFkD-vYSZviVYUb_rj3ij__anPXDTnojUk72xU.woff2\";s:119:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/playfair-display/nuFkD-vYSZviVYUb_rj3ij__anPXDTnojUk72xU.woff2\";s:93:\"https://fonts.gstatic.com/s/playfairdisplay/v37/nuFkD-vYSZviVYUb_rj3ij__anPXDTnojEk72xU.woff2\";s:119:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/playfair-display/nuFkD-vYSZviVYUb_rj3ij__anPXDTnojEk72xU.woff2\";s:90:\"https://fonts.gstatic.com/s/playfairdisplay/v37/nuFkD-vYSZviVYUb_rj3ij__anPXDTnogkk7.woff2\";s:116:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/playfair-display/nuFkD-vYSZviVYUb_rj3ij__anPXDTnogkk7.woff2\";s:90:\"https://fonts.gstatic.com/s/playfairdisplay/v37/nuFiD-vYSZviVYUb_rj3ij__anPXDTjYgFE_.woff2\";s:116:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/playfair-display/nuFiD-vYSZviVYUb_rj3ij__anPXDTjYgFE_.woff2\";s:90:\"https://fonts.gstatic.com/s/playfairdisplay/v37/nuFiD-vYSZviVYUb_rj3ij__anPXDTPYgFE_.woff2\";s:116:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/playfair-display/nuFiD-vYSZviVYUb_rj3ij__anPXDTPYgFE_.woff2\";s:90:\"https://fonts.gstatic.com/s/playfairdisplay/v37/nuFiD-vYSZviVYUb_rj3ij__anPXDTLYgFE_.woff2\";s:116:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/playfair-display/nuFiD-vYSZviVYUb_rj3ij__anPXDTLYgFE_.woff2\";s:88:\"https://fonts.gstatic.com/s/playfairdisplay/v37/nuFiD-vYSZviVYUb_rj3ij__anPXDTzYgA.woff2\";s:114:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content//fonts/playfair-display/nuFiD-vYSZviVYUb_rj3ij__anPXDTzYgA.woff2\";}", "off");
INSERT INTO `wp_options` VALUES("243", "theme_mods_cleanportfolio", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1728371175;s:4:\"data\";a:5:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}}}}", "off");
INSERT INTO `wp_options` VALUES("247", "_transient_cleanportfolio_categories", "1", "on");
INSERT INTO `wp_options` VALUES("252", "auto_update_themes", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("273", "category_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("283", "wpzoom_inspiro_upgrader_from_free", "1", "auto");
INSERT INTO `wp_options` VALUES("301", "_transient_inspiro_categories", "1", "on");
INSERT INTO `wp_options` VALUES("311", "theme_mods_vireo", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:11:\"header-menu\";i:5;}s:18:\"custom_css_post_id\";i:-1;}", "on");
INSERT INTO `wp_options` VALUES("315", "__kubio_instance_flags", "a:11:{s:13:\"import_design\";b:1;s:19:\"import_design_index\";i:1;s:12:\"start_source\";s:15:\"notice-homepage\";s:9:\"_settings\";a:6:{s:11:\"googleFonts\";a:1:{s:12:\"serveLocally\";b:0;}s:15:\"editorUIVersion\";i:2;s:10:\"editorMode\";s:4:\"full\";s:17:\"activatedOnStage2\";b:1;s:8:\"aiStage2\";b:0;s:9:\"site_uuid\";s:36:\"0e565c73-8092-48bb-9c4e-eef769d79ef0\";}s:7:\"kubio_f\";s:1:\"1\";s:21:\"kubio_activation_time\";i:1728377558;s:10:\"stylesheet\";s:5:\"vireo\";s:24:\"kubio_templates_imported\";i:1728377559;s:29:\"kubio_template_parts_imported\";i:1728377559;s:20:\"wc_sidebar_populated\";b:1;s:10:\"aiSettings\";a:14:{s:13:\"business_name\";s:24:\"Théo Valadoux portfolio\";s:10:\"otherPages\";a:0:{}s:11:\"isMultiPage\";b:1;s:13:\"business_type\";s:22:\"Art / Design Portfolio\";s:10:\"short_desc\";s:200:\"fais moi un portfolio sachant que je fais du handball mon ecole est un bts sio donc de l\'informatique ensuite je veux plusieurs pages qui sont page d\'acceuil, projets, compétences, a propos, contact \";s:12:\"sections_tag\";s:4:\"flat\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"contact\";a:1:{s:7:\"socials\";a:4:{i:0;a:2:{s:4:\"type\";s:8:\"facebook\";s:3:\"url\";s:0:\"\";}i:1;a:2:{s:4:\"type\";s:9:\"instagram\";s:3:\"url\";s:0:\"\";}i:2;a:2:{s:4:\"type\";s:7:\"youtube\";s:3:\"url\";s:0:\"\";}i:3;a:2:{s:4:\"type\";s:8:\"linkedin\";s:3:\"url\";s:0:\"\";}}}s:8:\"siteMood\";s:12:\"professional\";s:10:\"clientType\";s:4:\"both\";s:3:\"cta\";a:2:{s:7:\"pattern\";a:10:{s:13:\"cloudPresetId\";i:108;s:8:\"category\";s:3:\"cta\";s:8:\"template\";a:1:{i:0;a:3:{i:0;s:13:\"kubio/section\";i:1;a:4:{s:5:\"kubio\";a:4:{s:8:\"styleRef\";s:11:\"SgAeDE6hbOD\";s:5:\"props\";a:6:{s:5:\"width\";s:5:\"boxed\";s:13:\"verticalAlign\";s:6:\"center\";s:10:\"showHeader\";b:0;s:14:\"overlapSection\";b:0;s:5:\"attrs\";a:2:{s:4:\"name\";s:5:\"blank\";s:2:\"id\";s:5:\"blank\";}s:13:\"kubioMetadata\";a:2:{s:8:\"category\";s:3:\"cta\";s:13:\"cloudPresetId\";i:108;}}s:5:\"style\";a:1:{s:11:\"descendants\";a:1:{s:5:\"outer\";a:4:{s:12:\"customHeight\";a:2:{s:4:\"type\";s:14:\"fit-to-content\";s:10:\"min-height\";a:2:{s:5:\"value\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}}s:10:\"background\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-1),1)\";}s:10:\"separators\";a:2:{s:6:\"bottom\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-1),1)\";}s:3:\"top\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-1),1)\";}}s:10:\"typography\";a:1:{s:7:\"holders\";a:7:{s:1:\"p\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-5),1)\";}s:2:\"h1\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-5),1)\";}s:2:\"h2\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-5),1)\";}s:2:\"h3\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-5),1)\";}s:2:\"h4\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-5),1)\";}s:2:\"h5\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-5),1)\";}s:2:\"h6\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-5),1)\";}}}}}}s:4:\"hash\";s:11:\"faD7AZAHdAK\";}s:5:\"attrs\";a:1:{s:4:\"name\";s:14:\"Call To Action\";}s:6:\"anchor\";s:14:\"call-to-action\";s:7:\"kubioAI\";a:1:{s:4:\"meta\";a:3:{s:8:\"category\";s:3:\"cta\";s:13:\"cloudPresetId\";i:108;s:7:\"summary\";s:90:\"Envie d\'un design unique et créatif pour votre entreprise? Contactez-moi dès maintenant!\";}}}i:2;a:1:{i:0;a:3:{i:0;s:9:\"kubio/row\";i:1;a:2:{s:5:\"kubio\";a:3:{s:8:\"styleRef\";s:11:\"kyFvl2dnvOl\";s:5:\"props\";a:3:{s:14:\"fullBackground\";b:0;s:6:\"layout\";a:10:{s:10:\"equalWidth\";b:0;s:11:\"equalHeight\";b:1;s:11:\"itemsPerRow\";i:2;s:13:\"verticalAlign\";s:6:\"center\";s:15:\"horizontalAlign\";s:6:\"center\";s:13:\"horizontalGap\";i:2;s:11:\"verticalGap\";i:2;s:18:\"horizontalInnerGap\";i:2;s:16:\"verticalInnerGap\";i:2;s:6:\"custom\";a:4:{s:13:\"horizontalGap\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";s:0:\"\";}s:11:\"verticalGap\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";s:0:\"\";}s:18:\"horizontalInnerGap\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";s:0:\"\";}s:16:\"verticalInnerGap\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";s:0:\"\";}}}s:5:\"media\";a:1:{s:6:\"mobile\";a:1:{s:6:\"layout\";a:3:{s:11:\"itemsPerRow\";i:1;s:13:\"horizontalGap\";i:0;s:14:\"outerGapLinked\";b:0;}}}}s:4:\"hash\";s:11:\"C78voNJYnx_\";}s:7:\"kubioAI\";a:0:{}}i:2;a:1:{i:0;a:3:{i:0;s:12:\"kubio/column\";i:1;a:2:{s:5:\"kubio\";a:5:{s:8:\"styleRef\";s:11:\"IN4qKg542cn\";s:5:\"props\";a:2:{s:6:\"layout\";a:4:{s:6:\"custom\";a:4:{s:13:\"horizontalGap\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";s:0:\"\";}s:11:\"verticalGap\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";s:0:\"\";}s:18:\"horizontalInnerGap\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";s:0:\"\";}s:16:\"verticalInnerGap\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";s:0:\"\";}}s:13:\"verticalAlign\";s:5:\"start\";s:16:\"verticalInnerGap\";s:7:\"inherit\";s:18:\"horizontalInnerGap\";s:7:\"inherit\";}s:8:\"internal\";a:1:{s:11:\"heroSection\";a:1:{s:4:\"type\";N;}}}s:5:\"style\";a:1:{s:11:\"descendants\";a:1:{s:5:\"inner\";a:2:{s:9:\"textAlign\";s:6:\"center\";s:12:\"customHeight\";a:2:{s:4:\"type\";s:14:\"fit-to-content\";s:10:\"min-height\";a:2:{s:5:\"value\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}}}}}s:6:\"_style\";a:1:{s:11:\"descendants\";a:1:{s:9:\"container\";a:2:{s:5:\"media\";a:1:{s:6:\"mobile\";a:1:{s:11:\"columnWidth\";a:2:{s:4:\"type\";s:6:\"custom\";s:6:\"custom\";a:2:{s:5:\"value\";i:100;s:4:\"unit\";s:1:\"%\";}}}}s:11:\"columnWidth\";a:2:{s:4:\"type\";s:6:\"custom\";s:6:\"custom\";a:2:{s:4:\"unit\";s:1:\"%\";s:5:\"value\";i:100;}}}}}s:4:\"hash\";s:11:\"tsKKFPsr0GH\";}s:7:\"kubioAI\";a:0:{}}i:2;a:2:{i:0;a:3:{i:0;s:13:\"kubio/heading\";i:1;a:4:{s:5:\"kubio\";a:3:{s:8:\"styleRef\";s:11:\"lzzZKCibo2x\";s:5:\"props\";a:2:{s:5:\"level\";i:2;s:5:\"fancy\";a:1:{s:18:\"fancyRotatingWords\";s:26:\"awesome\namazing\nimpressive\";}}s:4:\"hash\";s:11:\"sEtd3_4_wCg\";}s:4:\"link\";a:1:{s:12:\"typeOpenLink\";s:10:\"sameWindow\";}s:7:\"content\";s:59:\"Envie d\'un design unique et créatif pour votre entreprise?\";s:7:\"kubioAI\";a:1:{s:4:\"meta\";a:1:{s:13:\"initialValues\";a:2:{s:5:\"words\";i:8;s:5:\"chars\";i:27;}}}}i:2;a:0:{}}i:1;a:3:{i:0;s:17:\"kubio/buttongroup\";i:1;a:2:{s:5:\"kubio\";a:2:{s:8:\"styleRef\";s:11:\"rwMTSjdyD_Y\";s:4:\"hash\";s:11:\"n1QMMjcGyr6\";}s:7:\"kubioAI\";a:0:{}}i:2;a:2:{i:0;a:3:{i:0;s:12:\"kubio/button\";i:1;a:6:{s:5:\"kubio\";a:4:{s:8:\"styleRef\";s:11:\"lFBQYE3SpVD\";s:5:\"props\";a:5:{s:11:\"buttonWidth\";s:12:\"fitToContent\";s:12:\"iconPosition\";s:6:\"before\";s:8:\"showIcon\";b:0;s:10:\"buttonSize\";s:5:\"large\";s:15:\"horizontalAlign\";s:6:\"center\";}s:5:\"style\";a:1:{s:11:\"descendants\";a:2:{s:4:\"link\";a:6:{s:7:\"padding\";a:4:{s:3:\"top\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";s:2:\"15\";}s:6:\"bottom\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";s:2:\"15\";}s:4:\"left\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";s:2:\"30\";}s:5:\"right\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";s:2:\"30\";}}s:10:\"typography\";a:7:{s:4:\"size\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";s:2:\"14\";}s:6:\"weight\";s:3:\"600\";s:9:\"transform\";s:9:\"uppercase\";s:10:\"lineHeight\";a:2:{s:5:\"value\";s:1:\"1\";s:4:\"unit\";s:0:\"\";}s:13:\"letterSpacing\";a:2:{s:5:\"value\";s:1:\"1\";s:4:\"unit\";s:2:\"px\";}s:5:\"color\";s:28:\"rgba(var(--kubio-color-6),1)\";s:6:\"margin\";a:2:{s:3:\"top\";s:0:\"\";s:6:\"bottom\";s:4:\"2rem\";}}s:6:\"border\";a:4:{s:3:\"top\";a:4:{s:6:\"radius\";a:2:{s:5:\"right\";a:2:{s:5:\"value\";i:6;s:4:\"unit\";s:2:\"px\";}s:4:\"left\";a:2:{s:5:\"value\";i:6;s:4:\"unit\";s:2:\"px\";}}s:5:\"color\";s:28:\"rgba(var(--kubio-color-5),1)\";s:5:\"style\";s:5:\"solid\";s:5:\"width\";a:2:{s:5:\"value\";s:1:\"2\";s:4:\"unit\";s:2:\"px\";}}s:6:\"bottom\";a:4:{s:6:\"radius\";a:2:{s:5:\"right\";a:2:{s:5:\"value\";i:6;s:4:\"unit\";s:2:\"px\";}s:4:\"left\";a:2:{s:5:\"value\";i:6;s:4:\"unit\";s:2:\"px\";}}s:5:\"color\";s:28:\"rgba(var(--kubio-color-5),1)\";s:5:\"style\";s:5:\"solid\";s:5:\"width\";a:2:{s:5:\"value\";s:1:\"2\";s:4:\"unit\";s:2:\"px\";}}s:4:\"left\";a:3:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-5),1)\";s:5:\"style\";s:5:\"solid\";s:5:\"width\";a:2:{s:5:\"value\";s:1:\"2\";s:4:\"unit\";s:2:\"px\";}}s:5:\"right\";a:3:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-5),1)\";s:5:\"style\";s:5:\"solid\";s:5:\"width\";a:2:{s:5:\"value\";s:1:\"2\";s:4:\"unit\";s:2:\"px\";}}}s:10:\"background\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-5),1)\";}s:9:\"textAlign\";s:6:\"center\";s:6:\"states\";a:1:{s:5:\"hover\";a:3:{s:10:\"background\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-2),1)\";}s:6:\"border\";a:4:{s:3:\"top\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-2),1)\";}s:4:\"left\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-2),1)\";}s:5:\"right\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-2),1)\";}s:6:\"bottom\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-2),1)\";}}s:10:\"typography\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-5),1)\";}}}}s:4:\"icon\";a:2:{s:4:\"size\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";s:2:\"14\";}s:6:\"margin\";a:2:{s:4:\"left\";a:2:{s:5:\"value\";s:1:\"0\";s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";s:2:\"10\";s:4:\"unit\";s:2:\"px\";}}}}}s:4:\"hash\";s:11:\"auWoDBrNTEO\";}s:4:\"text\";s:30:\"Contactez-moi dès maintenant!\";s:4:\"link\";a:4:{s:5:\"value\";s:0:\"\";s:12:\"typeOpenLink\";s:10:\"sameWindow\";s:8:\"noFollow\";b:0;s:13:\"lightboxMedia\";s:0:\"\";}s:13:\"preserveSpace\";a:1:{s:4:\"text\";b:0;}s:4:\"icon\";a:1:{s:4:\"name\";s:17:\"font-awesome/star\";}s:7:\"kubioAI\";a:0:{}}i:2;a:0:{}}i:1;a:3:{i:0;s:12:\"kubio/button\";i:1;a:6:{s:5:\"kubio\";a:4:{s:8:\"styleRef\";s:11:\"tnS1KmBabA3\";s:5:\"props\";a:5:{s:11:\"buttonWidth\";s:12:\"fitToContent\";s:12:\"iconPosition\";s:6:\"before\";s:8:\"showIcon\";b:0;s:10:\"buttonSize\";s:5:\"large\";s:15:\"horizontalAlign\";s:6:\"center\";}s:5:\"style\";a:1:{s:11:\"descendants\";a:2:{s:4:\"link\";a:6:{s:7:\"padding\";a:4:{s:3:\"top\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";s:2:\"15\";}s:6:\"bottom\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";s:2:\"15\";}s:4:\"left\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";s:2:\"30\";}s:5:\"right\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";s:2:\"30\";}}s:10:\"typography\";a:7:{s:4:\"size\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";s:2:\"14\";}s:6:\"weight\";s:3:\"600\";s:9:\"transform\";s:9:\"uppercase\";s:10:\"lineHeight\";a:2:{s:5:\"value\";s:1:\"1\";s:4:\"unit\";s:0:\"\";}s:13:\"letterSpacing\";a:2:{s:5:\"value\";s:1:\"1\";s:4:\"unit\";s:2:\"px\";}s:5:\"color\";s:4:\"#fff\";s:6:\"margin\";a:2:{s:3:\"top\";s:0:\"\";s:6:\"bottom\";s:4:\"2rem\";}}s:10:\"background\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-6),1)\";}s:6:\"border\";a:4:{s:3:\"top\";a:4:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-6),1)\";s:6:\"radius\";a:2:{s:5:\"right\";a:2:{s:5:\"value\";i:6;s:4:\"unit\";s:2:\"px\";}s:4:\"left\";a:2:{s:5:\"value\";i:6;s:4:\"unit\";s:2:\"px\";}}s:5:\"style\";s:5:\"solid\";s:5:\"width\";a:2:{s:5:\"value\";s:1:\"2\";s:4:\"unit\";s:2:\"px\";}}s:4:\"left\";a:3:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-6),1)\";s:5:\"style\";s:5:\"solid\";s:5:\"width\";a:2:{s:5:\"value\";s:1:\"2\";s:4:\"unit\";s:2:\"px\";}}s:5:\"right\";a:3:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-6),1)\";s:5:\"style\";s:5:\"solid\";s:5:\"width\";a:2:{s:5:\"value\";s:1:\"2\";s:4:\"unit\";s:2:\"px\";}}s:6:\"bottom\";a:4:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-6),1)\";s:6:\"radius\";a:2:{s:5:\"right\";a:2:{s:5:\"value\";i:6;s:4:\"unit\";s:2:\"px\";}s:4:\"left\";a:2:{s:5:\"value\";i:6;s:4:\"unit\";s:2:\"px\";}}s:5:\"style\";s:5:\"solid\";s:5:\"width\";a:2:{s:5:\"value\";s:1:\"2\";s:4:\"unit\";s:2:\"px\";}}}s:9:\"textAlign\";s:6:\"center\";s:6:\"states\";a:1:{s:5:\"hover\";a:2:{s:10:\"background\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-2),1)\";}s:6:\"border\";a:4:{s:3:\"top\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-2),1)\";}s:4:\"left\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-2),1)\";}s:5:\"right\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-2),1)\";}s:6:\"bottom\";a:1:{s:5:\"color\";s:28:\"rgba(var(--kubio-color-2),1)\";}}}}}s:4:\"icon\";a:2:{s:4:\"size\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";s:2:\"14\";}s:6:\"margin\";a:2:{s:4:\"left\";a:2:{s:5:\"value\";s:1:\"0\";s:4:\"unit\";s:2:\"px\";}s:5:\"right\";a:2:{s:5:\"value\";s:2:\"10\";s:4:\"unit\";s:2:\"px\";}}}}}s:4:\"hash\";s:11:\"7FCq1kiewqD\";}s:4:\"text\";s:30:\"Contactez-moi dès maintenant!\";s:4:\"link\";a:4:{s:5:\"value\";s:0:\"\";s:12:\"typeOpenLink\";s:10:\"sameWindow\";s:8:\"noFollow\";b:0;s:13:\"lightboxMedia\";s:0:\"\";}s:13:\"preserveSpace\";a:1:{s:4:\"text\";b:0;}s:4:\"icon\";a:1:{s:4:\"name\";s:17:\"font-awesome/star\";}s:7:\"kubioAI\";a:0:{}}i:2;a:0:{}}}}}}}}}}}s:5:\"title\";s:15:\"flat-free-cta-5\";s:4:\"slug\";s:4:\"cta8\";s:17:\"pairCloudPresetId\";N;s:4:\"name\";s:26:\"kubio-content/cta/cta8/108\";s:12:\"internalTags\";a:1:{i:0;s:8:\"ai-ready\";}s:10:\"publicTags\";a:1:{i:0;s:4:\"flat\";}s:7:\"summary\";s:90:\"Envie d\'un design unique et créatif pour votre entreprise? Contactez-moi dès maintenant!\";}s:4:\"text\";s:7:\"contact\";}s:9:\"ownerType\";s:10:\"individual\";s:14:\"websiteSubject\";s:22:\"Art / Design Portfolio\";s:12:\"coreBusiness\";s:6:\"design\";}}", "off");
INSERT INTO `wp_options` VALUES("317", "kubio_instance_data", "a:4:{s:23:\"license_active_endpoint\";s:51:\"https://cloud.kubiobuilder.com/api/license/activate\";s:22:\"license_check_endpoint\";s:48:\"https://cloud.kubiobuilder.com/api/license/check\";s:23:\"product_update_endpoint\";s:49:\"https://cloud.kubiobuilder.com/api/product/update\";s:13:\"dashboard_url\";s:31:\"https://cloud.kubiobuilder.com/\";}", "auto");
INSERT INTO `wp_options` VALUES("318", "_kubio_backup_unique_key_id", "6704f2d6c79ac", "off");
INSERT INTO `wp_options` VALUES("319", "kubio_is_fresh_site", "0", "auto");
INSERT INTO `wp_options` VALUES("322", "widget_woocommerce_widget_cart", "a:1:{i:2;a:2:{s:5:\"title\";s:4:\"Cart\";s:13:\"hide_if_empty\";i:1;}}", "auto");
INSERT INTO `wp_options` VALUES("323", "widget_woocommerce_price_filter", "a:1:{i:2;a:1:{s:5:\"title\";s:15:\"Filter by price\";}}", "auto");
INSERT INTO `wp_options` VALUES("324", "widget_woocommerce_recently_viewed_products", "a:1:{i:2;a:2:{s:5:\"title\";s:24:\"Recently Viewed Products\";s:6:\"number\";i:10;}}", "auto");
INSERT INTO `wp_options` VALUES("325", "widget_woocommerce_top_rated_products", "a:1:{i:2;a:2:{s:5:\"title\";s:18:\"Top rated products\";s:6:\"number\";i:5;}}", "auto");
INSERT INTO `wp_options` VALUES("326", "widget_woocommerce_layered_nav_filters", "a:1:{i:2;a:1:{s:5:\"title\";s:14:\"Active filters\";}}", "auto");
INSERT INTO `wp_options` VALUES("339", "kubio_ai_key", "5D23885A-5C55456F-588CD89B-F59AC9F1", "auto");
INSERT INTO `wp_options` VALUES("341", "wpcf7", "a:2:{s:7:\"version\";s:5:\"6.0.1\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1728378493;s:7:\"version\";s:5:\"5.9.8\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "auto");
INSERT INTO `wp_options` VALUES("379", "https_detection_errors", "a:1:{s:20:\"https_request_failed\";a:1:{i:0;s:28:\"La demande HTTPS a échoué.\";}}", "auto");
INSERT INTO `wp_options` VALUES("380", "_transient_health-check-site-status-result", "{\"good\":16,\"recommended\":6,\"critical\":1}", "on");
INSERT INTO `wp_options` VALUES("417", "secret_key", "ERP%Iw3Q`APRp}tnaeR<1UwYdzoF0j@GJ$M(I9DjU(?Zqh%/6hr{N^C$we~f ok ", "off");
INSERT INTO `wp_options` VALUES("487", "_kubio_dismissable_notices", "a:3:{s:25:\"kubio-remote-notice-11691\";a:1:{s:12:\"dismiss_time\";i:0;}s:24:\"kubio-remote-notice-6841\";a:1:{s:12:\"dismiss_time\";i:0;}s:25:\"kubio-remote-notice-12052\";a:1:{s:12:\"dismiss_time\";i:0;}}", "auto");
INSERT INTO `wp_options` VALUES("704", "core_updater.lock", "1734603998", "off");
INSERT INTO `wp_options` VALUES("727", "_site_transient_timeout_php_check_7ec5f04fef1dc985019fbdb14afad4b2", "1737971159", "off");
INSERT INTO `wp_options` VALUES("728", "_site_transient_php_check_7ec5f04fef1dc985019fbdb14afad4b2", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("733", "_site_transient_timeout_browser_a69b52f9d7f760edf3fd052bcda2542f", "1737971241", "off");
INSERT INTO `wp_options` VALUES("734", "_site_transient_browser_a69b52f9d7f760edf3fd052bcda2542f", "a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:5:\"133.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:32:\"https://www.mozilla.org/firefox/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("735", "_transient_timeout_kubio-demo-sites-repository", "1737452844", "off");
INSERT INTO `wp_options` VALUES("736", "_transient_kubio-demo-sites-repository", "a:2:{s:7:\"version\";s:5:\"2.4.3\";s:5:\"demos\";a:61:{s:15:\"business-free-1\";a:11:{s:4:\"name\";s:8:\"Business\";s:4:\"slug\";s:15:\"business-free-1\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:7:\"kds_url\";s:115:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/business-free-1/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-67/screenshot.jpg\";s:7:\"preview\";s:46:\"https://support-work.kubiobuilder.com/business\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-09-08 14:31:18.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";s:14:\"business-pro-1\";s:6:\"is_pro\";i:0;s:10:\"is_testing\";b:0;}s:20:\"creative-agency-free\";a:11:{s:4:\"name\";s:20:\"Creative Agency Free\";s:4:\"slug\";s:20:\"creative-agency-free\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:7:\"kds_url\";s:120:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/creative-agency-free/content.kds\";s:5:\"thumb\";s:81:\"https://static.kubiobuilder.com/templates-screenshots/template-75/screenshot.webp\";s:7:\"preview\";s:58:\"https://support-work.kubiobuilder.com/creative-agency-free\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-11-17 08:22:06.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:0;s:10:\"is_testing\";b:0;}s:17:\"multipurpose-free\";a:11:{s:4:\"name\";s:17:\"Multipurpose Free\";s:4:\"slug\";s:17:\"multipurpose-free\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:7:\"kds_url\";s:117:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/multipurpose-free/content.kds\";s:5:\"thumb\";s:86:\"https://static.kubiobuilder.com/templates-screenshots/multipurpose-free/screenshot.jpg\";s:7:\"preview\";s:55:\"https://support-work.kubiobuilder.com/multipurpose-free\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-10-11 08:52:26.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";s:16:\"multipurpose-pro\";s:6:\"is_pro\";i:0;s:10:\"is_testing\";b:0;}s:17:\"accountant-free-1\";a:11:{s:4:\"name\";s:10:\"Accountant\";s:4:\"slug\";s:17:\"accountant-free-1\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:7:\"kds_url\";s:117:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/accountant-free-1/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-69/screenshot.jpg\";s:7:\"preview\";s:48:\"https://support-work.kubiobuilder.com/accountant\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-09-08 14:29:48.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";s:14:\"accountant-pro\";s:6:\"is_pro\";i:0;s:10:\"is_testing\";b:0;}s:11:\"lawyer-free\";a:11:{s:4:\"name\";s:11:\"Lawyer Free\";s:4:\"slug\";s:11:\"lawyer-free\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:7:\"kds_url\";s:111:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/lawyer-free/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-79/screenshot.jpg\";s:7:\"preview\";s:49:\"https://support-work.kubiobuilder.com/lawyer-free\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-10-11 08:52:24.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";s:12:\"lawyer-pro-1\";s:6:\"is_pro\";i:0;s:10:\"is_testing\";b:0;}s:11:\"writer-free\";a:11:{s:4:\"name\";s:11:\"Writer Free\";s:4:\"slug\";s:11:\"writer-free\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:7:\"kds_url\";s:111:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/writer-free/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-73/screenshot.jpg\";s:7:\"preview\";s:49:\"https://support-work.kubiobuilder.com/writer-free\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-10-04 08:51:53.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:0;s:10:\"is_testing\";b:0;}s:14:\"nutrition-free\";a:11:{s:4:\"name\";s:9:\"Nutrition\";s:4:\"slug\";s:14:\"nutrition-free\";s:10:\"categories\";a:1:{i:0;s:10:\"food-drink\";}s:7:\"kds_url\";s:114:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/nutrition-free/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-20/screenshot.jpg\";s:7:\"preview\";s:47:\"https://support-work.kubiobuilder.com/nutrition\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-02-09 07:07:45.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:0;s:10:\"is_testing\";b:0;}s:11:\"church-free\";a:11:{s:4:\"name\";s:11:\"Church Free\";s:4:\"slug\";s:11:\"church-free\";s:10:\"categories\";a:1:{i:0;s:9:\"community\";}s:7:\"kds_url\";s:111:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/church-free/content.kds\";s:5:\"thumb\";s:81:\"https://static.kubiobuilder.com/templates-screenshots/template-78/screenshot.webp\";s:7:\"preview\";s:49:\"https://support-work.kubiobuilder.com/church-free\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-10-11 08:52:21.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";s:9:\"cathedral\";s:6:\"is_pro\";i:0;s:10:\"is_testing\";b:0;}s:18:\"real-estate-free-1\";a:11:{s:4:\"name\";s:16:\"Real Estate Free\";s:4:\"slug\";s:18:\"real-estate-free-1\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:7:\"kds_url\";s:118:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/real-estate-free-1/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-19/screenshot.jpg\";s:7:\"preview\";s:56:\"https://support-work.kubiobuilder.com/real-estate-free-1\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-02-09 07:07:44.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:0;s:10:\"is_testing\";b:0;}s:17:\"photographer-free\";a:11:{s:4:\"name\";s:12:\"Photographer\";s:4:\"slug\";s:17:\"photographer-free\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:7:\"kds_url\";s:117:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/photographer-free/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-27/screenshot.jpg\";s:7:\"preview\";s:50:\"https://support-work.kubiobuilder.com/photographer\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-02-09 07:07:56.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:0;s:10:\"is_testing\";b:0;}s:11:\"gadget-free\";a:11:{s:4:\"name\";s:6:\"Gadget\";s:4:\"slug\";s:11:\"gadget-free\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:7:\"kds_url\";s:111:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/gadget-free/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-21/screenshot.jpg\";s:7:\"preview\";s:44:\"https://support-work.kubiobuilder.com/gadget\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-02-09 07:07:47.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:0;s:10:\"is_testing\";b:0;}s:13:\"resume-free-1\";a:11:{s:4:\"name\";s:11:\"Resume Free\";s:4:\"slug\";s:13:\"resume-free-1\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:7:\"kds_url\";s:113:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/resume-free-1/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-71/screenshot.jpg\";s:7:\"preview\";s:49:\"https://support-work.kubiobuilder.com/resume-free\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-09-07 13:35:46.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:0;s:10:\"is_testing\";b:0;}s:12:\"finance-free\";a:11:{s:4:\"name\";s:12:\"Finance Free\";s:4:\"slug\";s:12:\"finance-free\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:7:\"kds_url\";s:112:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/finance-free/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-18/screenshot.jpg\";s:7:\"preview\";s:50:\"https://support-work.kubiobuilder.com/finance-free\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-02-09 07:07:41.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:0;s:10:\"is_testing\";b:0;}s:14:\"insurance-free\";a:11:{s:4:\"name\";s:14:\"Insurance Free\";s:4:\"slug\";s:14:\"insurance-free\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:7:\"kds_url\";s:114:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/insurance-free/content.kds\";s:5:\"thumb\";s:84:\"https://static.kubiobuilder.com/templates-screenshots/insurance-free/screenshot.webp\";s:7:\"preview\";s:52:\"https://support-work.kubiobuilder.com/insurance-free\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-10-28 10:12:28.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:0;s:10:\"is_testing\";b:0;}s:15:\"life-coach-free\";a:11:{s:4:\"name\";s:15:\"Life Coach Free\";s:4:\"slug\";s:15:\"life-coach-free\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:7:\"kds_url\";s:115:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/life-coach-free/content.kds\";s:5:\"thumb\";s:85:\"https://static.kubiobuilder.com/templates-screenshots/life-coach-free/screenshot.webp\";s:7:\"preview\";s:53:\"https://support-work.kubiobuilder.com/life-coach-free\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-11-07 09:45:05.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:0;s:10:\"is_testing\";b:0;}s:15:\"copywriter-free\";a:11:{s:4:\"name\";s:10:\"Copywriter\";s:4:\"slug\";s:15:\"copywriter-free\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:7:\"kds_url\";s:115:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/copywriter-free/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-24/screenshot.jpg\";s:7:\"preview\";s:48:\"https://support-work.kubiobuilder.com/copywriter\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-02-09 07:07:52.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:0;s:10:\"is_testing\";b:0;}s:13:\"travel-free-1\";a:11:{s:4:\"name\";s:6:\"Travel\";s:4:\"slug\";s:13:\"travel-free-1\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:7:\"kds_url\";s:113:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/travel-free-1/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-65/screenshot.jpg\";s:7:\"preview\";s:44:\"https://support-work.kubiobuilder.com/travel\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-08-08 10:42:39.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:0;s:10:\"is_testing\";b:0;}s:15:\"babysitter-free\";a:11:{s:4:\"name\";s:10:\"Babysitter\";s:4:\"slug\";s:15:\"babysitter-free\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:7:\"kds_url\";s:115:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/babysitter-free/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-23/screenshot.jpg\";s:7:\"preview\";s:48:\"https://support-work.kubiobuilder.com/babysitter\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-02-09 07:07:50.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";s:15:\"babysitting-pro\";s:6:\"is_pro\";i:0;s:10:\"is_testing\";b:0;}s:13:\"pharmago-free\";a:11:{s:4:\"name\";s:13:\"PharmaGo Free\";s:4:\"slug\";s:13:\"pharmago-free\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:7:\"kds_url\";s:113:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/pharmago-free/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-62/screenshot.jpg\";s:7:\"preview\";s:51:\"https://support-work.kubiobuilder.com/pharmago-free\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-07-08 07:41:02.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";s:10:\"pharma-pro\";s:6:\"is_pro\";i:0;s:10:\"is_testing\";b:0;}s:21:\"car-presentation-free\";a:11:{s:4:\"name\";s:21:\"Car presentation Free\";s:4:\"slug\";s:21:\"car-presentation-free\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:7:\"kds_url\";s:121:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/car-presentation-free/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-43/screenshot.jpg\";s:7:\"preview\";s:59:\"https://support-work.kubiobuilder.com/car-presentation-free\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-06-03 13:48:12.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:0;s:10:\"is_testing\";b:0;}s:20:\"coworking-space-free\";a:11:{s:4:\"name\";s:20:\"Coworking Space Free\";s:4:\"slug\";s:20:\"coworking-space-free\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:7:\"kds_url\";s:120:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/coworking-space-free/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-25/screenshot.jpg\";s:7:\"preview\";s:58:\"https://support-work.kubiobuilder.com/coworking-space-free\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-02-09 07:07:53.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";s:14:\"co-working-pro\";s:6:\"is_pro\";i:0;s:10:\"is_testing\";b:0;}s:17:\"fashion-blog-free\";a:11:{s:4:\"name\";s:17:\"Fashion Blog Free\";s:4:\"slug\";s:17:\"fashion-blog-free\";s:10:\"categories\";a:1:{i:0;s:9:\"community\";}s:7:\"kds_url\";s:117:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/fashion-blog-free/content.kds\";s:5:\"thumb\";s:81:\"https://static.kubiobuilder.com/templates-screenshots/template-77/screenshot.webp\";s:7:\"preview\";s:55:\"https://support-work.kubiobuilder.com/fashion-blog-free\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-10-11 08:52:17.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:0;s:10:\"is_testing\";b:0;}s:25:\"alternative-medicine-free\";a:11:{s:4:\"name\";s:20:\"Alternative Medicine\";s:4:\"slug\";s:25:\"alternative-medicine-free\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:7:\"kds_url\";s:125:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/alternative-medicine-free/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-22/screenshot.jpg\";s:7:\"preview\";s:58:\"https://support-work.kubiobuilder.com/alternative-medicine\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-02-09 07:07:48.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:0;s:10:\"is_testing\";b:0;}s:15:\"craft-beer-free\";a:11:{s:4:\"name\";s:15:\"Craft Beer Free\";s:4:\"slug\";s:15:\"craft-beer-free\";s:10:\"categories\";a:1:{i:0;s:10:\"food-drink\";}s:7:\"kds_url\";s:115:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/craft-beer-free/content.kds\";s:5:\"thumb\";s:85:\"https://static.kubiobuilder.com/templates-screenshots/craft-beer-free/screenshot.webp\";s:7:\"preview\";s:53:\"https://support-work.kubiobuilder.com/craft-beer-free\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-10-11 08:52:50.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:0;s:10:\"is_testing\";b:0;}s:15:\"accounting-free\";a:11:{s:4:\"name\";s:10:\"Accounting\";s:4:\"slug\";s:15:\"accounting-free\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:7:\"kds_url\";s:115:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/accounting-free/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-26/screenshot.jpg\";s:7:\"preview\";s:48:\"https://support-work.kubiobuilder.com/accounting\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-02-09 07:07:54.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:0;s:10:\"is_testing\";b:0;}s:14:\"business-pro-1\";a:11:{s:4:\"name\";s:12:\"Business PRO\";s:4:\"slug\";s:14:\"business-pro-1\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:7:\"kds_url\";s:114:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/business-pro-1/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-68/screenshot.jpg\";s:7:\"preview\";s:50:\"https://support-work.kubiobuilder.com/business-pro\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-09-28 09:27:19.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:16:\"multipurpose-pro\";a:11:{s:4:\"name\";s:16:\"Multipurpose PRO\";s:4:\"slug\";s:16:\"multipurpose-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:7:\"kds_url\";s:116:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/multipurpose-pro/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-63/screenshot.jpg\";s:7:\"preview\";s:54:\"https://support-work.kubiobuilder.com/multipurpose-pro\";s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}i:1;a:2:{s:4:\"slug\";s:16:\"mailchimp-for-wp\";s:5:\"label\";s:30:\"MC4WP: Mailchimp for WordPress\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-09-07 14:13:03.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:14:\"accountant-pro\";a:11:{s:4:\"name\";s:14:\"Accountant PRO\";s:4:\"slug\";s:14:\"accountant-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:7:\"kds_url\";s:114:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/accountant-pro/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-45/screenshot.jpg\";s:7:\"preview\";s:52:\"https://support-work.kubiobuilder.com/accountant-pro\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-06-09 07:46:01.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:12:\"lawyer-pro-1\";a:11:{s:4:\"name\";s:10:\"Lawyer PRO\";s:4:\"slug\";s:12:\"lawyer-pro-1\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:7:\"kds_url\";s:112:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/lawyer-pro-1/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-66/screenshot.jpg\";s:7:\"preview\";s:48:\"https://support-work.kubiobuilder.com/lawyer-pro\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-08-16 08:09:59.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:16:\"optical-care-pro\";a:11:{s:4:\"name\";s:16:\"Optical care PRO\";s:4:\"slug\";s:16:\"optical-care-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:7:\"kds_url\";s:116:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/optical-care-pro/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-28/screenshot.jpg\";s:7:\"preview\";s:54:\"https://support-work.kubiobuilder.com/optical-care-pro\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-02-15 08:50:56.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:19:\"creative-agency-pro\";a:11:{s:4:\"name\";s:19:\"Branding Agency PRO\";s:4:\"slug\";s:19:\"creative-agency-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:7:\"kds_url\";s:119:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/creative-agency-pro/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-29/screenshot.jpg\";s:7:\"preview\";s:57:\"https://support-work.kubiobuilder.com/creative-agency-pro\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-02-11 10:01:49.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:19:\"floral-designer-pro\";a:11:{s:4:\"name\";s:19:\"Floral designer PRO\";s:4:\"slug\";s:19:\"floral-designer-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:7:\"kds_url\";s:119:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/floral-designer-pro/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-30/screenshot.jpg\";s:7:\"preview\";s:57:\"https://support-work.kubiobuilder.com/floral-designer-pro\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-02-11 10:01:50.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:14:\"music-band-pro\";a:11:{s:4:\"name\";s:14:\"Music band PRO\";s:4:\"slug\";s:14:\"music-band-pro\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:7:\"kds_url\";s:114:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/music-band-pro/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-33/screenshot.jpg\";s:7:\"preview\";s:52:\"https://support-work.kubiobuilder.com/music-band-pro\";s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}i:1;a:2:{s:4:\"slug\";s:16:\"mailchimp-for-wp\";s:5:\"label\";s:30:\"MC4WP: Mailchimp for WordPress\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-02-11 10:01:54.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:21:\"veterinary-clinic-pro\";a:11:{s:4:\"name\";s:21:\"Veterinary clinic PRO\";s:4:\"slug\";s:21:\"veterinary-clinic-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:7:\"kds_url\";s:121:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/veterinary-clinic-pro/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-31/screenshot.jpg\";s:7:\"preview\";s:59:\"https://support-work.kubiobuilder.com/veterinary-clinic-pro\";s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}i:1;a:2:{s:4:\"slug\";s:16:\"mailchimp-for-wp\";s:5:\"label\";s:30:\"MC4WP: Mailchimp for WordPress\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-02-11 10:01:51.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:10:\"events-pro\";a:11:{s:4:\"name\";s:10:\"Events PRO\";s:4:\"slug\";s:10:\"events-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:7:\"kds_url\";s:110:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/events-pro/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-35/screenshot.jpg\";s:7:\"preview\";s:48:\"https://support-work.kubiobuilder.com/events-pro\";s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}i:1;a:2:{s:4:\"slug\";s:16:\"mailchimp-for-wp\";s:5:\"label\";s:30:\"MC4WP: Mailchimp for WordPress\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-06-07 07:54:41.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:16:\"spa-wellness-pro\";a:11:{s:4:\"name\";s:16:\"Spa wellness PRO\";s:4:\"slug\";s:16:\"spa-wellness-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:7:\"kds_url\";s:116:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/spa-wellness-pro/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-32/screenshot.jpg\";s:7:\"preview\";s:54:\"https://support-work.kubiobuilder.com/spa-wellness-pro\";s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}i:1;a:2:{s:4:\"slug\";s:16:\"mailchimp-for-wp\";s:5:\"label\";s:30:\"MC4WP: Mailchimp for WordPress\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-02-11 10:01:53.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:7:\"gym-pro\";a:11:{s:4:\"name\";s:7:\"Gym PRO\";s:4:\"slug\";s:7:\"gym-pro\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:7:\"kds_url\";s:107:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/gym-pro/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-37/screenshot.jpg\";s:7:\"preview\";s:45:\"https://support-work.kubiobuilder.com/gym-pro\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-02-24 08:54:34.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:20:\"fashion-designer-pro\";a:11:{s:4:\"name\";s:20:\"Fashion Designer PRO\";s:4:\"slug\";s:20:\"fashion-designer-pro\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:7:\"kds_url\";s:120:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/fashion-designer-pro/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-34/screenshot.jpg\";s:7:\"preview\";s:58:\"https://support-work.kubiobuilder.com/fashion-designer-pro\";s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}i:1;a:2:{s:4:\"slug\";s:16:\"mailchimp-for-wp\";s:5:\"label\";s:30:\"MC4WP: Mailchimp for WordPress\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-02-11 10:01:56.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:9:\"hotel-pro\";a:11:{s:4:\"name\";s:9:\"Hotel PRO\";s:4:\"slug\";s:9:\"hotel-pro\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:7:\"kds_url\";s:109:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/hotel-pro/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-38/screenshot.jpg\";s:7:\"preview\";s:47:\"https://support-work.kubiobuilder.com/hotel-pro\";s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}i:1;a:2:{s:4:\"slug\";s:16:\"mailchimp-for-wp\";s:5:\"label\";s:30:\"MC4WP: Mailchimp for WordPress\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-06-07 07:52:57.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:13:\"developer-pro\";a:11:{s:4:\"name\";s:13:\"Developer PRO\";s:4:\"slug\";s:13:\"developer-pro\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:7:\"kds_url\";s:113:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/developer-pro/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-46/screenshot.jpg\";s:7:\"preview\";s:51:\"https://support-work.kubiobuilder.com/developer-pro\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-06-09 07:45:51.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:12:\"cleaning-pro\";a:11:{s:4:\"name\";s:12:\"Cleaning PRO\";s:4:\"slug\";s:12:\"cleaning-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:7:\"kds_url\";s:112:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/cleaning-pro/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-41/screenshot.jpg\";s:7:\"preview\";s:50:\"https://support-work.kubiobuilder.com/cleaning-pro\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-06-09 07:46:58.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:9:\"sushi-pro\";a:11:{s:4:\"name\";s:9:\"Sushi PRO\";s:4:\"slug\";s:9:\"sushi-pro\";s:10:\"categories\";a:1:{i:0;s:10:\"food-drink\";}s:7:\"kds_url\";s:109:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/sushi-pro/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-42/screenshot.jpg\";s:7:\"preview\";s:47:\"https://support-work.kubiobuilder.com/sushi-pro\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-06-10 09:19:32.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:14:\"restaurant-pro\";a:11:{s:4:\"name\";s:14:\"Restaurant PRO\";s:4:\"slug\";s:14:\"restaurant-pro\";s:10:\"categories\";a:1:{i:0;s:10:\"food-drink\";}s:7:\"kds_url\";s:114:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/restaurant-pro/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-44/screenshot.jpg\";s:7:\"preview\";s:52:\"https://support-work.kubiobuilder.com/restaurant-pro\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-06-03 13:48:25.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:12:\"handyman-pro\";a:11:{s:4:\"name\";s:12:\"Handyman PRO\";s:4:\"slug\";s:12:\"handyman-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:7:\"kds_url\";s:112:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/handyman-pro/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-40/screenshot.jpg\";s:7:\"preview\";s:50:\"https://support-work.kubiobuilder.com/handyman-pro\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-06-03 13:48:35.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:13:\"insurance-pro\";a:11:{s:4:\"name\";s:13:\"Insurance PRO\";s:4:\"slug\";s:13:\"insurance-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:7:\"kds_url\";s:113:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/insurance-pro/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-47/screenshot.jpg\";s:7:\"preview\";s:51:\"https://support-work.kubiobuilder.com/insurance-pro\";s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}i:1;a:2:{s:4:\"slug\";s:16:\"mailchimp-for-wp\";s:5:\"label\";s:30:\"MC4WP: Mailchimp for WordPress\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-06-03 14:57:11.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:8:\"pest-pro\";a:11:{s:4:\"name\";s:8:\"Pest PRO\";s:4:\"slug\";s:8:\"pest-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:7:\"kds_url\";s:108:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/pest-pro/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-49/screenshot.jpg\";s:7:\"preview\";s:46:\"https://support-work.kubiobuilder.com/pest-pro\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-06-03 13:48:49.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:15:\"babysitting-pro\";a:11:{s:4:\"name\";s:15:\"Babysitting PRO\";s:4:\"slug\";s:15:\"babysitting-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:7:\"kds_url\";s:115:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/babysitting-pro/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-51/screenshot.jpg\";s:7:\"preview\";s:53:\"https://support-work.kubiobuilder.com/babysitting-pro\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2023-05-10 07:37:02.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:14:\"co-working-pro\";a:11:{s:4:\"name\";s:14:\"Co-working PRO\";s:4:\"slug\";s:14:\"co-working-pro\";s:10:\"categories\";a:1:{i:0;s:9:\"community\";}s:7:\"kds_url\";s:114:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/co-working-pro/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-50/screenshot.jpg\";s:7:\"preview\";s:52:\"https://support-work.kubiobuilder.com/co-working-pro\";s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}i:1;a:2:{s:4:\"slug\";s:16:\"mailchimp-for-wp\";s:5:\"label\";s:30:\"MC4WP: Mailchimp for WordPress\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-06-09 07:45:32.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:13:\"elearning-pro\";a:11:{s:4:\"name\";s:13:\"eLearning PRO\";s:4:\"slug\";s:13:\"elearning-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:7:\"kds_url\";s:113:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/elearning-pro/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-57/screenshot.jpg\";s:7:\"preview\";s:51:\"https://support-work.kubiobuilder.com/elearning-pro\";s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}i:1;a:2:{s:4:\"slug\";s:16:\"mailchimp-for-wp\";s:5:\"label\";s:30:\"MC4WP: Mailchimp for WordPress\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-06-03 14:57:19.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:15:\"car-service-pro\";a:11:{s:4:\"name\";s:15:\"Car service PRO\";s:4:\"slug\";s:15:\"car-service-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:7:\"kds_url\";s:115:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/car-service-pro/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-52/screenshot.jpg\";s:7:\"preview\";s:53:\"https://support-work.kubiobuilder.com/car-service-pro\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2023-05-05 11:39:57.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:12:\"handmade-pro\";a:11:{s:4:\"name\";s:12:\"Handmade PRO\";s:4:\"slug\";s:12:\"handmade-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:7:\"kds_url\";s:112:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/handmade-pro/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-48/screenshot.jpg\";s:7:\"preview\";s:50:\"https://support-work.kubiobuilder.com/handmade-pro\";s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}i:1;a:2:{s:4:\"slug\";s:16:\"mailchimp-for-wp\";s:5:\"label\";s:30:\"MC4WP: Mailchimp for WordPress\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-06-09 07:45:42.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:13:\"once-club-pro\";a:11:{s:4:\"name\";s:13:\"Once Club PRO\";s:4:\"slug\";s:13:\"once-club-pro\";s:10:\"categories\";a:1:{i:0;s:10:\"food-drink\";}s:7:\"kds_url\";s:113:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/once-club-pro/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-56/screenshot.jpg\";s:7:\"preview\";s:51:\"https://support-work.kubiobuilder.com/once-club-pro\";s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}i:1;a:2:{s:4:\"slug\";s:16:\"mailchimp-for-wp\";s:5:\"label\";s:30:\"MC4WP: Mailchimp for WordPress\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-06-10 07:46:10.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:12:\"vineyard-pro\";a:11:{s:4:\"name\";s:12:\"Vineyard PRO\";s:4:\"slug\";s:12:\"vineyard-pro\";s:10:\"categories\";a:1:{i:0;s:10:\"food-drink\";}s:7:\"kds_url\";s:112:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/vineyard-pro/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-54/screenshot.jpg\";s:7:\"preview\";s:50:\"https://support-work.kubiobuilder.com/vineyard-pro\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2023-05-10 07:37:31.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:12:\"holistic-pro\";a:11:{s:4:\"name\";s:12:\"Holistic PRO\";s:4:\"slug\";s:12:\"holistic-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:7:\"kds_url\";s:112:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/holistic-pro/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-53/screenshot.jpg\";s:7:\"preview\";s:50:\"https://support-work.kubiobuilder.com/holistic-pro\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2023-05-10 07:37:53.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:23:\"interior-designer-pro-1\";a:11:{s:4:\"name\";s:21:\"Interior Designer PRO\";s:4:\"slug\";s:23:\"interior-designer-pro-1\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:7:\"kds_url\";s:123:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/interior-designer-pro-1/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-64/screenshot.jpg\";s:7:\"preview\";s:59:\"https://support-work.kubiobuilder.com/interior-designer-pro\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-08-05 07:04:10.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:12:\"gaming-pro-1\";a:11:{s:4:\"name\";s:10:\"Gaming PRO\";s:4:\"slug\";s:12:\"gaming-pro-1\";s:10:\"categories\";a:1:{i:0;s:9:\"community\";}s:7:\"kds_url\";s:112:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/gaming-pro-1/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-58/screenshot.jpg\";s:7:\"preview\";s:48:\"https://support-work.kubiobuilder.com/gaming-pro\";s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}i:1;a:2:{s:4:\"slug\";s:16:\"mailchimp-for-wp\";s:5:\"label\";s:30:\"MC4WP: Mailchimp for WordPress\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-09-07 12:03:25.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:16:\"accounting-pro-1\";a:11:{s:4:\"name\";s:27:\"Professional Accounting PRO\";s:4:\"slug\";s:16:\"accounting-pro-1\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:7:\"kds_url\";s:116:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/accounting-pro-1/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-55/screenshot.jpg\";s:7:\"preview\";s:52:\"https://support-work.kubiobuilder.com/accounting-pro\";s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}i:1;a:2:{s:4:\"slug\";s:16:\"mailchimp-for-wp\";s:5:\"label\";s:30:\"MC4WP: Mailchimp for WordPress\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-06-09 07:45:23.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:15:\"constructor-pro\";a:11:{s:4:\"name\";s:15:\"Constructor PRO\";s:4:\"slug\";s:15:\"constructor-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:7:\"kds_url\";s:115:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/constructor-pro/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-72/screenshot.jpg\";s:7:\"preview\";s:53:\"https://support-work.kubiobuilder.com/constructor-pro\";s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}i:1;a:2:{s:4:\"slug\";s:16:\"mailchimp-for-wp\";s:5:\"label\";s:30:\"MC4WP: Mailchimp for WordPress\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-10-04 09:18:24.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:9:\"cathedral\";a:11:{s:4:\"name\";s:13:\"Cathedral PRO\";s:4:\"slug\";s:9:\"cathedral\";s:10:\"categories\";a:1:{i:0;s:9:\"community\";}s:7:\"kds_url\";s:109:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/cathedral/content.kds\";s:5:\"thumb\";s:80:\"https://static.kubiobuilder.com/templates-screenshots/template-61/screenshot.jpg\";s:7:\"preview\";s:51:\"https://support-work.kubiobuilder.com/cathedral-pro\";s:7:\"plugins\";a:2:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}i:1;a:2:{s:4:\"slug\";s:16:\"mailchimp-for-wp\";s:5:\"label\";s:30:\"MC4WP: Mailchimp for WordPress\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-09-28 08:51:46.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:10:\"pharma-pro\";a:11:{s:4:\"name\";s:10:\"Pharma PRO\";s:4:\"slug\";s:10:\"pharma-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:7:\"kds_url\";s:110:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/pharma-pro/content.kds\";s:5:\"thumb\";s:81:\"https://static.kubiobuilder.com/templates-screenshots/template-70/screenshot.webp\";s:7:\"preview\";s:48:\"https://support-work.kubiobuilder.com/pharma-pro\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2022-10-11 09:41:54.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:1;s:10:\"is_testing\";b:0;}s:6:\"global\";a:11:{s:4:\"name\";s:11:\"Global Free\";s:4:\"slug\";s:6:\"global\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:7:\"kds_url\";s:106:\"https://s3.us-west-2.amazonaws.com/static-assets.kubiobuilder.com/demo-sites/production/global/content.kds\";s:5:\"thumb\";s:76:\"https://static.kubiobuilder.com/templates-screenshots/global/screenshot.webp\";s:7:\"preview\";s:49:\"https://support-work.kubiobuilder.com/global-free\";s:7:\"plugins\";a:1:{i:0;a:2:{s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"label\";s:14:\"Contact Form 7\";}}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2024-02-29 14:40:49.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:17:\"pro_template_slug\";N;s:6:\"is_pro\";i:0;s:10:\"is_testing\";b:0;}}}", "off");
INSERT INTO `wp_options` VALUES("737", "_transient_timeout_kubio_remote_notifications", "1737452844", "off");
INSERT INTO `wp_options` VALUES("738", "_transient_kubio_remote_notifications", "a:2:{i:12052;a:2:{s:2:\"id\";i:12052;s:3:\"acf\";a:10:{s:7:\"message\";s:107:\"<strong>Kubio PRO</strong> starts at <strong>just $7/month</strong>🚀 so you can design like a pro today!\";s:4:\"type\";s:4:\"info\";s:12:\"license_type\";s:4:\"free\";s:3:\"dev\";b:0;s:17:\"has_time_boundary\";b:0;s:5:\"after\";i:2;s:10:\"start_date\";N;s:8:\"date_end\";N;s:12:\"primary_link\";a:3:{s:5:\"title\";s:13:\"Get the offer\";s:3:\"url\";s:90:\"https://kubiobuilder.com/pricing/?coupon=SPECIALOFFER&utm_campaign=wp-notice&utm_medium=wp\";s:6:\"target\";s:0:\"\";}s:14:\"secondary_link\";s:0:\"\";}}i:6841;a:2:{s:2:\"id\";i:6841;s:3:\"acf\";a:10:{s:7:\"message\";s:922:\"<script id=\"kubio-review-script-initializer\" src=\"https://kubiobuilder.com/user-interviews-popup/script.js?v=15\"></script>\r\n<div class=\"kubio-review\">\r\n  <h3>How do you like Kubio so far?</h3>\r\n  <div class=\"kubio-review-question\" style=\"display: none\">\r\n    <p>On a scale from 1 to 5, how would you rate your experience with Kubio builder?</p>\r\n    <div class=\"kubio-recommendation-buttons\">\r\n      <button class=\"button\" data-value=\"1\">1<span class=\"kubio-review-item-face\"></span></button>\r\n      <button class=\"button\" data-value=\"2\">2<span class=\"kubio-review-item-face\"></span></button>\r\n      <button class=\"button\" data-value=\"3\">3<span class=\"kubio-review-item-face\"></span></button>\r\n      <button class=\"button\" data-value=\"4\">4<span class=\"kubio-review-item-face\"></span></button>\r\n      <button class=\"button\" data-value=\"5\">5<span class=\"kubio-review-item-face\"></span></button>\r\n    </div>\r\n  </div>\r\n</div>\";s:4:\"type\";s:4:\"info\";s:12:\"license_type\";s:4:\"free\";s:3:\"dev\";b:0;s:17:\"has_time_boundary\";b:0;s:5:\"after\";i:7;s:10:\"start_date\";N;s:8:\"date_end\";N;s:12:\"primary_link\";s:0:\"\";s:14:\"secondary_link\";s:0:\"\";}}}", "off");
INSERT INTO `wp_options` VALUES("755", "action_scheduler_hybrid_store_demarkation", "174", "auto");
INSERT INTO `wp_options` VALUES("756", "schema-ActionScheduler_StoreSchema", "7.0.1737366498", "auto");
INSERT INTO `wp_options` VALUES("757", "schema-ActionScheduler_LoggerSchema", "3.0.1737366498", "auto");
INSERT INTO `wp_options` VALUES("758", "wp_mail_smtp_initial_version", "4.3.0", "off");
INSERT INTO `wp_options` VALUES("759", "wp_mail_smtp_version", "4.3.0", "off");
INSERT INTO `wp_options` VALUES("760", "wp_mail_smtp", "a:20:{s:4:\"mail\";a:6:{s:10:\"from_email\";s:24:\"theo.valadoux8@gmail.com\";s:9:\"from_name\";s:24:\"Théo Valadoux portfolio\";s:6:\"mailer\";s:5:\"gmail\";s:11:\"return_path\";b:0;s:16:\"from_email_force\";b:1;s:15:\"from_name_force\";b:0;}s:4:\"smtp\";a:7:{s:7:\"autotls\";b:1;s:4:\"auth\";b:1;s:4:\"host\";s:0:\"\";s:4:\"port\";s:3:\"587\";s:10:\"encryption\";s:3:\"tls\";s:4:\"user\";s:0:\"\";s:4:\"pass\";s:0:\"\";}s:7:\"general\";a:1:{s:29:\"summary_report_email_disabled\";b:0;}s:5:\"gmail\";a:10:{s:9:\"client_id\";s:72:\"342307675344-aufab18vcuh8ovkon5djhl15scvblfg0.apps.googleusercontent.com\";s:13:\"client_secret\";s:35:\"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\";s:12:\"access_token\";a:6:{s:12:\"access_token\";s:224:\"ya29.a0ARW5m75XqaOY91oNEv-_P592bupsnOmmb4rVevdVUhX-aYxJgjCOXKbY5JShZgeKQsO4fx0QVke2ZOcBFtFpOhGuA_culRsGU8h3zv6j57YA9mhabG8L_lfQLZ9s0_u3bo_mwggvAy9cMqKmGePpPeA0M9GvkUwrFN_D6-ba8AaCgYKAdoSARISFQHGX2MiV78wFICRApu0rCvYhLeFSA0177\";s:10:\"expires_in\";i:3599;s:5:\"scope\";s:24:\"https://mail.google.com/\";s:10:\"token_type\";s:6:\"Bearer\";s:7:\"created\";i:1737444045;s:13:\"refresh_token\";s:103:\"1//03iOWmRfhbvEKCgYIARAAGAMSNwF-L9IrlSIGkh4wQd5U57Ahj_QBtguBnlVYcSQyFvKMChKUb9fqPtzw67llQHO9I9q2pFAl134\";}s:13:\"refresh_token\";s:103:\"1//03iOWmRfhbvEKCgYIARAAGAMSNwF-L9IrlSIGkh4wQd5U57Ahj_QBtguBnlVYcSQyFvKMChKUb9fqPtzw67llQHO9I9q2pFAl134\";s:12:\"user_details\";a:1:{s:5:\"email\";s:0:\"\";}s:23:\"one_click_setup_enabled\";b:0;s:27:\"one_click_setup_credentials\";a:2:{s:3:\"key\";s:0:\"\";s:5:\"token\";s:0:\"\";}s:28:\"one_click_setup_user_details\";a:1:{s:5:\"email\";s:0:\"\";}s:20:\"is_setup_wizard_auth\";b:0;s:9:\"auth_code\";s:73:\"4/0AanRRrsHNcz7Ln8ZC4HIYa3SiUlJatHu94rRiSP2DksS5uZDdQhSehY-1XMo6KS2RCpPiQ\";}s:9:\"sendlayer\";a:1:{s:7:\"api_key\";s:0:\"\";}s:7:\"smtpcom\";a:2:{s:7:\"api_key\";s:0:\"\";s:7:\"channel\";s:0:\"\";}s:10:\"sendinblue\";a:2:{s:7:\"api_key\";s:0:\"\";s:6:\"domain\";s:0:\"\";}s:7:\"mailgun\";a:3:{s:7:\"api_key\";s:0:\"\";s:6:\"domain\";s:0:\"\";s:6:\"region\";s:2:\"US\";}s:7:\"mailjet\";a:2:{s:7:\"api_key\";s:0:\"\";s:10:\"secret_key\";s:0:\"\";}s:8:\"sendgrid\";a:2:{s:7:\"api_key\";s:0:\"\";s:6:\"domain\";s:0:\"\";}s:7:\"smtp2go\";a:1:{s:7:\"api_key\";s:0:\"\";}s:9:\"sparkpost\";a:2:{s:7:\"api_key\";s:0:\"\";s:6:\"region\";s:2:\"US\";}s:8:\"postmark\";a:2:{s:16:\"server_api_token\";s:0:\"\";s:14:\"message_stream\";s:0:\"\";}s:9:\"amazonses\";a:3:{s:9:\"client_id\";s:0:\"\";s:13:\"client_secret\";s:0:\"\";s:6:\"region\";s:9:\"us-east-1\";}s:12:\"elasticemail\";a:1:{s:7:\"api_key\";s:0:\"\";}s:7:\"outlook\";a:8:{s:9:\"client_id\";s:0:\"\";s:13:\"client_secret\";s:0:\"\";s:12:\"access_token\";a:0:{}s:13:\"refresh_token\";s:0:\"\";s:12:\"user_details\";a:1:{s:5:\"email\";s:0:\"\";}s:23:\"one_click_setup_enabled\";b:0;s:27:\"one_click_setup_credentials\";a:3:{s:12:\"access_token\";s:0:\"\";s:13:\"refresh_token\";s:0:\"\";s:7:\"expires\";s:0:\"\";}s:28:\"one_click_setup_user_details\";a:1:{s:5:\"email\";s:0:\"\";}}s:4:\"zoho\";a:6:{s:9:\"client_id\";s:0:\"\";s:13:\"client_secret\";s:0:\"\";s:6:\"domain\";s:3:\"com\";s:12:\"access_token\";a:0:{}s:13:\"refresh_token\";s:0:\"\";s:12:\"user_details\";a:1:{s:5:\"email\";s:0:\"\";}}s:4:\"logs\";a:5:{s:7:\"enabled\";b:0;s:17:\"log_email_content\";b:0;s:16:\"save_attachments\";b:0;s:19:\"open_email_tracking\";b:0;s:19:\"click_link_tracking\";b:0;}s:11:\"alert_email\";a:2:{s:7:\"enabled\";b:0;s:11:\"connections\";a:0:{}}s:7:\"license\";a:4:{s:3:\"key\";s:0:\"\";s:10:\"is_expired\";b:0;s:11:\"is_disabled\";b:0;s:10:\"is_invalid\";b:0;}}", "off");
INSERT INTO `wp_options` VALUES("761", "wp_mail_smtp_activated_time", "1737366498", "off");
INSERT INTO `wp_options` VALUES("762", "wp_mail_smtp_activated", "a:1:{s:4:\"lite\";i:1737366498;}", "auto");
INSERT INTO `wp_options` VALUES("767", "action_scheduler_lock_async-request-runner", "678f4ec9b58334.13624382|1737445125", "no");
INSERT INTO `wp_options` VALUES("768", "_transient_timeout_as-post-store-dependencies-met", "1737452899", "off");
INSERT INTO `wp_options` VALUES("769", "_transient_as-post-store-dependencies-met", "yes", "off");
INSERT INTO `wp_options` VALUES("771", "wp_mail_smtp_migration_version", "5", "on");
INSERT INTO `wp_options` VALUES("772", "wp_mail_smtp_debug_events_db_version", "1", "on");
INSERT INTO `wp_options` VALUES("773", "wp_mail_smtp_activation_prevent_redirect", "1", "auto");
INSERT INTO `wp_options` VALUES("774", "wp_mail_smtp_setup_wizard_stats", "a:3:{s:13:\"launched_time\";i:1737366506;s:14:\"completed_time\";i:1737367178;s:14:\"was_successful\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("780", "wp_mail_smtp_notifications", "a:4:{s:6:\"update\";i:1737367040;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "auto");
INSERT INTO `wp_options` VALUES("781", "wp_mail_smtp_debug", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("784", "wpforms_activation_redirect", "1", "auto");
INSERT INTO `wp_options` VALUES("785", "wpforms_installation_source", "wp-mail-smtp-setup-wizard", "auto");
INSERT INTO `wp_options` VALUES("786", "wpforms_version", "1.9.3.1", "auto");
INSERT INTO `wp_options` VALUES("787", "wpforms_version_lite", "1.9.3.1", "auto");
INSERT INTO `wp_options` VALUES("788", "wpforms_activated", "a:1:{s:4:\"lite\";i:1737367142;}", "auto");
INSERT INTO `wp_options` VALUES("793", "wpforms_versions_lite", "a:14:{s:5:\"1.5.9\";i:0;s:7:\"1.6.7.2\";i:0;s:5:\"1.6.8\";i:0;s:5:\"1.7.5\";i:0;s:7:\"1.7.5.1\";i:0;s:5:\"1.7.7\";i:0;s:5:\"1.8.2\";i:0;s:5:\"1.8.3\";i:0;s:5:\"1.8.4\";i:0;s:5:\"1.8.6\";i:0;s:5:\"1.8.7\";i:0;s:5:\"1.9.1\";i:0;s:5:\"1.9.2\";i:0;s:7:\"1.9.3.1\";i:1737367158;}", "auto");
INSERT INTO `wp_options` VALUES("794", "wpforms_constant_contact_version", "3", "auto");
INSERT INTO `wp_options` VALUES("795", "widget_wpforms-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("796", "wpforms_settings", "a:3:{s:13:\"modern-markup\";s:1:\"1\";s:20:\"modern-markup-is-set\";b:1;s:26:\"modern-markup-hide-setting\";b:1;}", "auto");
INSERT INTO `wp_options` VALUES("798", "wpforms_admin_notices", "a:1:{s:14:\"review_request\";a:2:{s:4:\"time\";i:1737367160;s:9:\"dismissed\";b:0;}}", "auto");
INSERT INTO `wp_options` VALUES("799", "_wpforms_transient_wpforms_htaccess_file", "a:3:{s:4:\"size\";i:737;s:5:\"mtime\";i:1737367160;s:5:\"ctime\";i:1737367160;}", "on");
INSERT INTO `wp_options` VALUES("800", "wpforms_email_summaries_fetch_info_blocks_last_run", "1737367160", "auto");
INSERT INTO `wp_options` VALUES("801", "wpforms_process_forms_locator_status", "completed", "auto");
INSERT INTO `wp_options` VALUES("802", "wp_mail_smtp_lite_sent_email_counter", "5", "on");
INSERT INTO `wp_options` VALUES("803", "wp_mail_smtp_lite_weekly_sent_email_counter", "a:1:{s:2:\"04\";i:5;}", "on");
INSERT INTO `wp_options` VALUES("805", "wpforms_splash_version", "1.8.6", "auto");
INSERT INTO `wp_options` VALUES("808", "wp_mail_smtp_review_notice", "a:2:{s:4:\"time\";i:1737367189;s:9:\"dismissed\";b:0;}", "auto");
INSERT INTO `wp_options` VALUES("816", "_wpforms_transient_timeout_addons.json", "1737972111", "off");
INSERT INTO `wp_options` VALUES("817", "_wpforms_transient_addons.json", "1737367311", "off");
INSERT INTO `wp_options` VALUES("818", "_wpforms_transient_wpforms_C:/laragon/www/Portfolio-Theo-Valadoux/wp-content/uploads/wpforms/cache/.htaccess_file", "a:3:{s:4:\"size\";i:484;s:5:\"mtime\";i:1737367313;s:5:\"ctime\";i:1737367313;}", "on");
INSERT INTO `wp_options` VALUES("821", "action_scheduler_migration_status", "complete", "auto");
INSERT INTO `wp_options` VALUES("837", "_site_transient_timeout_theme_roots", "1737445802", "off");
INSERT INTO `wp_options` VALUES("838", "_site_transient_theme_roots", "a:7:{s:14:\"cleanportfolio\";s:7:\"/themes\";s:7:\"inspiro\";s:7:\"/themes\";s:17:\"perfect-portfolio\";s:7:\"/themes\";s:16:\"twentytwentyfour\";s:7:\"/themes\";s:17:\"twentytwentythree\";s:7:\"/themes\";s:15:\"twentytwentytwo\";s:7:\"/themes\";s:5:\"vireo\";s:7:\"/themes\";}", "off");
INSERT INTO `wp_options` VALUES("848", "_site_transient_timeout_available_translations", "1737455686", "off");
INSERT INTO `wp_options` VALUES("849", "_site_transient_available_translations", "a:131:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:5:\"6.0.9\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.9/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:8:\"6.2-beta\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.2-beta/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2024-02-13 12:49:38\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.5/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"متابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.25/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-07-22 13:29:21\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.6.1/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2024-01-19 08:58:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.5/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.26\";s:7:\"updated\";s:19:\"2024-12-26 00:37:42\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.26/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-07-16 06:53:48\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-09-22 18:57:51\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.5/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:28:\"চালিয়ে যান\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-02-22 20:45:53\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-09-02 08:55:22\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.6.1/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-07-23 09:49:04\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-14 17:44:28\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.6.1/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-18 01:45:49\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-07-29 10:55:35\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/6.6.1/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-09-05 00:52:59\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.6.1/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-09-05 00:53:45\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-07-29 10:55:14\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-16 07:47:37\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.6/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-02 13:40:02\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.6.1/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-07-11 10:54:13\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-23 06:54:09\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-07-11 10:55:12\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-07-13 10:48:39\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-13 21:41:14\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-09-09 15:14:59\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.6.1/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-14 13:29:14\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-26 09:32:30\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-28 23:24:21\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-09-02 20:41:52\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-10-17 19:22:50\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.5/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2023-11-08 20:42:04\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.5/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2023-10-16 16:00:04\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.5/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-04-21 13:32:10\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:6:\"5.8.10\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.8.10/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.16\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.16/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.21\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.21/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-16 19:05:01\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-06 09:50:37\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.5/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-10-10 00:21:17\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.5/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-06-20 17:15:28\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-31 22:44:39\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-20 07:24:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.6.1/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-17 06:59:43\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-31 21:15:41\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-02-01 23:56:53\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.5/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2023-04-30 13:56:46\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.25/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"fy\";a:8:{s:8:\"language\";s:2:\"fy\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2022-12-25 12:53:23\";s:12:\"english_name\";s:7:\"Frisian\";s:11:\"native_name\";s:5:\"Frysk\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.6/fy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fy\";i:2;s:3:\"fry\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Trochgean\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-09-06 15:34:06\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2025-01-03 07:11:25\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.5/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ચાલુ રાખો\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.33\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.33/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2024-05-04 18:39:24\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2024-02-25 08:05:38\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.5/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-24 18:18:49\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.6.1/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-02-22 17:37:32\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.6/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-07-18 16:12:48\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-09-05 14:23:57\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.26\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.26/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-16 11:59:33\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-15 07:15:06\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.6.1/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.26\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.26/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-07-12 07:15:01\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-07-05 11:40:39\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.6/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-07-18 02:49:24\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.6.1/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.21\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.21/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-01 17:47:37\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.6.1/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-09-06 05:36:46\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-24 01:25:58\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.6.1/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:3:\"kir\";a:8:{s:8:\"language\";s:3:\"kir\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-06-29 07:13:57\";s:12:\"english_name\";s:6:\"Kyrgyz\";s:11:\"native_name\";s:16:\"Кыргызча\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.6.1/kir.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ky\";i:2;s:3:\"kir\";i:3;s:3:\"kir\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Улантуу\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-13 13:11:03\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.5/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-06-20 17:21:01\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.6.1/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:5:\"6.0.9\";s:7:\"updated\";s:19:\"2022-10-01 09:23:52\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.9/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-13 20:34:23\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.5/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-20 17:22:06\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.5/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-09-05 17:32:20\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.6.1/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.15\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.15/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.38\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.38/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-07-21 18:30:52\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-30 11:32:23\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-27 08:08:42\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-09-08 20:16:39\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-09-10 15:50:44\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.6.1/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.25/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-22 04:34:25\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.34\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.34/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-14 07:51:40\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-09-08 22:00:15\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2023-08-21 12:15:00\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.5/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-14 07:51:49\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.6.1/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-09-09 21:42:05\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-09-01 23:45:25\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.16\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.16/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-09-09 04:32:14\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-28 16:16:47\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.6.1/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-30 07:14:35\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-09-02 11:01:55\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.6.1/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-09-10 07:58:11\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-20 14:19:52\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-06-20 17:29:45\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.6.1/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.38\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.38/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:6:\"5.8.10\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.8.10/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2017-09-30 09:04:29\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.8.25/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-14 17:49:29\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-10 11:39:01\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2024-03-06 18:52:07\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.5/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.16\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.16/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-09-10 13:46:40\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.6.1/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-02 11:13:39\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2022-07-15 15:25:03\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"6.6.1\";s:7:\"updated\";s:19:\"2024-08-21 10:37:10\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.1/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}}", "off");
INSERT INTO `wp_options` VALUES("853", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:4:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-6.7.1.zip\";s:6:\"locale\";s:5:\"fr_FR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-6.7.1.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.7.1\";s:7:\"version\";s:5:\"6.7.1\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}i:1;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.7.1.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.7.1.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-6.7.1-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-6.7.1-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.7.1\";s:7:\"version\";s:5:\"6.7.1\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}i:2;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-6.7.1.zip\";s:6:\"locale\";s:5:\"fr_FR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-6.7.1.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.7.1\";s:7:\"version\";s:5:\"6.7.1\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:3;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-6.6.2.zip\";s:6:\"locale\";s:5:\"fr_FR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-6.6.2.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.6.2\";s:7:\"version\";s:5:\"6.6.2\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}}s:12:\"last_checked\";i:1737444967;s:15:\"version_checked\";s:5:\"6.6.1\";s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("854", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1737444968;s:7:\"checked\";a:7:{s:14:\"cleanportfolio\";s:5:\"1.3.0\";s:7:\"inspiro\";s:5:\"1.9.4\";s:17:\"perfect-portfolio\";s:5:\"1.2.4\";s:16:\"twentytwentyfour\";s:3:\"1.2\";s:17:\"twentytwentythree\";s:3:\"1.5\";s:15:\"twentytwentytwo\";s:3:\"1.8\";s:5:\"vireo\";s:6:\"1.0.16\";}s:8:\"response\";a:5:{s:7:\"inspiro\";a:6:{s:5:\"theme\";s:7:\"inspiro\";s:11:\"new_version\";s:5:\"1.9.7\";s:3:\"url\";s:37:\"https://wordpress.org/themes/inspiro/\";s:7:\"package\";s:55:\"https://downloads.wordpress.org/theme/inspiro.1.9.7.zip\";s:8:\"requires\";s:3:\"6.0\";s:12:\"requires_php\";s:3:\"7.4\";}s:16:\"twentytwentyfour\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfour\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfour/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfour.1.3.zip\";s:8:\"requires\";s:3:\"6.4\";s:12:\"requires_php\";s:3:\"7.0\";}s:17:\"twentytwentythree\";a:6:{s:5:\"theme\";s:17:\"twentytwentythree\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:47:\"https://wordpress.org/themes/twentytwentythree/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/twentytwentythree.1.6.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}s:15:\"twentytwentytwo\";a:6:{s:5:\"theme\";s:15:\"twentytwentytwo\";s:11:\"new_version\";s:3:\"1.9\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentytwo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentytwo.1.9.zip\";s:8:\"requires\";s:3:\"5.9\";s:12:\"requires_php\";s:3:\"5.6\";}s:5:\"vireo\";a:6:{s:5:\"theme\";s:5:\"vireo\";s:11:\"new_version\";s:6:\"1.0.19\";s:3:\"url\";s:35:\"https://wordpress.org/themes/vireo/\";s:7:\"package\";s:54:\"https://downloads.wordpress.org/theme/vireo.1.0.19.zip\";s:8:\"requires\";s:3:\"5.8\";s:12:\"requires_php\";s:3:\"7.1\";}}s:9:\"no_update\";a:2:{s:14:\"cleanportfolio\";a:6:{s:5:\"theme\";s:14:\"cleanportfolio\";s:11:\"new_version\";s:5:\"1.3.0\";s:3:\"url\";s:44:\"https://wordpress.org/themes/cleanportfolio/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/cleanportfolio.1.3.0.zip\";s:8:\"requires\";s:3:\"5.6\";s:12:\"requires_php\";s:3:\"5.6\";}s:17:\"perfect-portfolio\";a:6:{s:5:\"theme\";s:17:\"perfect-portfolio\";s:11:\"new_version\";s:5:\"1.2.4\";s:3:\"url\";s:47:\"https://wordpress.org/themes/perfect-portfolio/\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/theme/perfect-portfolio.1.2.4.zip\";s:8:\"requires\";s:3:\"6.2\";s:12:\"requires_php\";s:3:\"7.3\";}}s:12:\"translations\";a:3:{i:0;a:7:{s:4:\"type\";s:5:\"theme\";s:4:\"slug\";s:7:\"inspiro\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.9.4\";s:7:\"updated\";s:19:\"2021-12-30 11:46:43\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/theme/inspiro/1.9.4/fr_FR.zip\";s:10:\"autoupdate\";b:1;}i:1;a:7:{s:4:\"type\";s:5:\"theme\";s:4:\"slug\";s:17:\"perfect-portfolio\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.2.4\";s:7:\"updated\";s:19:\"2020-02-14 07:57:12\";s:7:\"package\";s:83:\"https://downloads.wordpress.org/translation/theme/perfect-portfolio/1.2.4/fr_FR.zip\";s:10:\"autoupdate\";b:1;}i:2;a:7:{s:4:\"type\";s:5:\"theme\";s:4:\"slug\";s:5:\"vireo\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:6:\"1.0.16\";s:7:\"updated\";s:19:\"2024-09-16 12:42:42\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/vireo/1.0.16/fr_FR.zip\";s:10:\"autoupdate\";b:1;}}}", "off");
INSERT INTO `wp_options` VALUES("856", "_site_transient_timeout_wp_theme_files_patterns-d2f3da05b31470e9fe4d2fef95fabac5", "1737446691", "off");
INSERT INTO `wp_options` VALUES("857", "_site_transient_wp_theme_files_patterns-d2f3da05b31470e9fe4d2fef95fabac5", "a:2:{s:7:\"version\";s:6:\"1.0.16\";s:8:\"patterns\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("858", "_site_transient_timeout_browser_11868452804c8a2bb86650b580125ff5", "1738049698", "off");
INSERT INTO `wp_options` VALUES("859", "_site_transient_browser_11868452804c8a2bb86650b580125ff5", "a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:5:\"134.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:32:\"https://www.mozilla.org/firefox/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("860", "_transient_timeout_action_scheduler_last_pastdue_actions_check", "1737466499", "off");
INSERT INTO `wp_options` VALUES("861", "_transient_action_scheduler_last_pastdue_actions_check", "1737444899", "off");
INSERT INTO `wp_options` VALUES("862", "_transient_timeout_wp_mail_smtp_error_debug_events_transient_30-days", "1737448499", "off");
INSERT INTO `wp_options` VALUES("863", "_transient_wp_mail_smtp_error_debug_events_transient_30-days", "3", "off");
INSERT INTO `wp_options` VALUES("864", "_site_transient_timeout_community-events-1aecf33ab8525ff212ebdffbb438372e", "1737488104", "off");
INSERT INTO `wp_options` VALUES("865", "_site_transient_community-events-1aecf33ab8525ff212ebdffbb438372e", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:9:\"127.0.0.0\";}s:6:\"events\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("866", "_transient_timeout_feed_0d2db5fea5a8633b56992c916819b198", "1737488105", "off");
INSERT INTO `wp_options` VALUES("867", "_transient_feed_0d2db5fea5a8633b56992c916819b198", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Actualités – WordPress.org Français\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://fr.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Dec 2024 16:47:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fr-FR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.8-alpha-59668\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Actualités – WordPress.org Français\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://fr.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"WordPress 6.7 « Rollins »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://fr.wordpress.org/2024/11/12/wordpress-6-7-rollins/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 12 Nov 2024 23:14:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3255\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:385:\"Chaque version de WordPress célèbre un ou une artiste ayant posé son empreinte sur le monde la musique. WordPress 6.7 «&#160;Rollins&#160;» rend hommage au saxophoniste de jazz Sonny Rollins. Connu comme l’un des plus grands improvisateurs du jazz, Rollins a influencé des générations de musiciens avec sa technique, son esprit d&#8217;innovation et son approche de [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:69268:\"\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/11/Release-Edition-Featured-Image-1024x535.png\" alt=\"\" class=\"wp-image-18085\" /></figure>\n\n\n\n<p>Chaque version de WordPress célèbre un ou une artiste ayant posé son empreinte sur le monde la musique. WordPress 6.7 «&nbsp;Rollins&nbsp;» rend hommage au saxophoniste de jazz Sonny Rollins. Connu comme l’un des plus grands improvisateurs du jazz, Rollins a influencé des générations de musiciens avec sa technique, son esprit d&rsquo;innovation et son approche de l&rsquo;expression musicale.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Bienvenue sur WordPress&nbsp;6.7&nbsp;!</h2>\n\n\n\n<p>WordPress 6.7 introduit le nouveau thème <bdo lang=\"en\" dir=\"ltr\"><em>Twenty Twenty-Five</em></bdo>, qui offre une flexibilité de conception ultime pour tous les sites et blogs. Vous pourrez gérer la typographie de votre site comme jamais auparavant. Les nouvelles fonctionnalités de zoom arrière vous permettront de concevoir votre site avec une vue macroscopique pour prendre du recul sur les détails de votre projet.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://fr.wordpress.org/latest-fr_FR.zip\" target=\"_blank\" rel=\"noreferrer noopener\">Télécharger WordPress 6.7 «&nbsp;Rollins&nbsp;» en français (ZIP – 19,1 Mo)</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Présentation du nouveau thème <bdo lang=\"en\" dir=\"ltr\">Twenty Twenty-Five</bdo></h2>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Une infinité de possibilités sans complexité</p>\n</blockquote>\n\n\n\n<p><bdo lang=\"en\" dir=\"ltr\">Twenty Twenty-Five</bdo> est un thème polyvalent, axé sur le design, qui vous permet de créer des sites époustouflants en toute simplicité. Personnalisez votre esthétisme grâce à un éventail d‘options de style, de compositions de blocs et de palettes de couleurs. Réduit à l‘essentiel, c‘est un thème qui peut vraiment évoluer avec vous.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-tt5-2.webp\" alt=\"\" style=\"object-fit:cover\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Obtenez une vue d’ensemble en dézoomant</h3>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Explorez votre contenu sous un nouvel angle</p>\n</blockquote>\n\n\n\n<p>Modifiez et organisez des sections entières de votre contenu comme jamais auparavant. Une vue plus large de votre site vous permet d‘ajouter, de modifier, de mélanger ou de supprimer des compositions à votre guise. Laissez s‘exprimer l‘architecte qui est en vous.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-zoom-2.webp\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Connectez des blocs et des champs personnalisés sans souci (et sans coder)</h3>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Une manière simplifiée de créer du contenu dynamique</p>\n</blockquote>\n\n\n\n<p>Cette fonctionnalité introduit une nouvelle interface pour connecter des blocs à des champs personnalisés. Cela vous donne le contrôle d’éléments dynamiques directement dans l’éditeur. Vous pouvez relier des blocs à des champs en quelques clics, ce qui améliore la flexibilité et l’efficacité de ces actions. Vos clients vont adorer ça.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-block-bindings-2.webp\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Laissez s’exprimer votre passion pour la typographie</h3>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Nouvelle section de styles, nouvelles possibilités</p>\n</blockquote>\n\n\n\n<p>Créez, modifiez, retirez et appliquez des préréglages de taille de police avec le dernier apport à l’interface des Styles. Surchargez le thème par défaut ou créez votre propre taille de police personnalisée, avec une typographie dynamique pour un redimensionnement responsive des polices. Prenez soin des détails&nbsp;!</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-font-presets-2.png\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations des performances</h3>\n\n\n\n<p>WordPress 6.7 propose d’importantes mises à jour en matière de performances, notamment un chargement plus rapide des compositions, des aperçus optimisés pour le composant des vues de données, une meilleure prise en charge de PHP 8 et plus, la suppression du code obsolète, des tailles automatiques pour les images en chargement différé, ainsi qu’un traitement plus efficace des balises dans l’API HTML.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations de l’accessibilité</h3>\n\n\n\n<p>Plus de 65 correctifs et améliorations d’accessibilité focalisées sur les aspects fondamentaux de l’expérience de WordPress, de l’amélioration des composants d’interface d’administration à la navigation clavier dans l’éditeur, en passant par des niveaux de titres plus accessibles dans les écrans de connexion et de meilleurs libellés.</p>\n\n\n\n<h2 class=\"wp-block-heading\">En savoir plus sur WordPress 6.7</h2>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\"><em>Learn WordPress</em></a>&nbsp;est une ressource gratuite pour les personnes qui utilisent WordPress, qu’elles soient débutantes ou expérimentées.&nbsp;<em>Learn</em>&nbsp;contient des vidéos pratiques sur l’utilisation de diverses fonctionnalités de WordPress, des&nbsp;<a href=\"https://learn.wordpress.org/online-workshops/\">évènements interactifs</a>&nbsp;pour explorer des sujets en profondeur, et des plans de cours pour approfondir des domaines spécifiques de WordPress.</p>\n\n\n\n<p>Lisez les <a href=\"https://wordpress.org/support/wordpress-version/version-6-7/\">notes de version de WordPress 6.7</a> pour obtenir des informations sur l’installation, les améliorations, les problèmes corrigés, les contributeurs et contributrices de la version, les ressources d’apprentissage et la liste des modifications apportées aux fichiers.</p>\n\n\n\n<p>Explorez le <a href=\"https://fr.wordpress.org/2024/10/28/guide-des-changements-techniques-de-wordpress-6-7/\">guide des changements techniques de WordPress 6.7</a>. Découvrez les changements de cette version avec les notes détaillées des développeurs et développeuses qui vous permettent de construire votre site avec WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">L’équipe de direction de WordPress&nbsp;6.7</h2>\n\n\n\n<p>Voici l’équipe qui a coordonné le développement et la sortie de cette nouvelle version de WordPress&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Direction générale&nbsp;: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Coordination de la version&nbsp;: <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a></li>\n\n\n\n<li>Direction technique&nbsp;cœur&nbsp;: <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a></li>\n\n\n\n<li>Direction technique côté Gutenberg&nbsp;: <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a>,&nbsp;<a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a>,&nbsp;<a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a></li>\n\n\n\n<li>Gestion de projet côté cœur&nbsp;: <a href=\"https://profiles.wordpress.org/stoyangeorgiev/\">Stoyan Georgiev</a>, <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a></li>\n\n\n\n<li>Gestion de projet côté Gutenberg&nbsp;: <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a>,&nbsp;<a href=\"https://wordpress.org/support/users/colorful-tones/\">Damon Cook</a></li>\n\n\n\n<li>Direction de la documentation&nbsp;: <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a></li>\n\n\n\n<li>Direction des tests&nbsp;: <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K. Gupta</a></li>\n\n\n\n<li>Direction artistique&nbsp;: <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a></li>\n\n\n\n<li>Direction des performances&nbsp;: <a href=\"https://profiles.wordpress.org/adamsilverstein/\"></a><a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a></li>\n\n\n\n<li>Direction du design du nouveau thème&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a></li>\n\n\n\n<li>Direction du développement du nouveau thème&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a>,&nbsp;<a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux contributeurs et contributrices</h2>\n\n\n\n<p>WordPress 6.7 n’aurait pas pu sortir sans la contribution passionnée de plus de&nbsp;<strong>780 personnes provenant de tous les pays du monde</strong>.</p>\n\n\n\n<p>Un remerciement tout spécial pour les plus de 230 personnes qui ont contribué au cœur de WordPress pour la première fois avec WP&nbsp;6.7 <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p class=\"is-style-wporg-props-long alignfull is-style-short-text has-lemon-3-background-color has-background\" style=\"font-size:12px\"><a href=\"https://profiles.wordpress.org/benniledl/\">!Benni</a> · <a href=\"https://profiles.wordpress.org/75thtrombone/\">75thtrombone</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/aware/\">Aaron Ware</a> · <a href=\"https://profiles.wordpress.org/aatanasov/\">aatanasov</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/abhi3315/\">abhi3315</a> · <a href=\"https://profiles.wordpress.org/fitehal/\">Abhishek Deshpande</a> · <a href=\"https://profiles.wordpress.org/ababir/\">Abir</a> · <a href=\"https://profiles.wordpress.org/acafourek/\">acafourek</a> · <a href=\"https://profiles.wordpress.org/adamkheckler/\">Adam Heckler</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/adamwood/\">Adam Wood</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zieliński</a> · <a href=\"https://profiles.wordpress.org/adarshposimyth/\">Adarsh Akshat</a> · <a href=\"https://profiles.wordpress.org/adrian2k7/\">Adrian</a> · <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a> · <a href=\"https://profiles.wordpress.org/ah72king/\">ah72king</a> · <a href=\"https://profiles.wordpress.org/ahmarzaidi/\">Ahmar Zaidi</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/ajitbohra/\">Ajit Bohra</a> · <a href=\"https://profiles.wordpress.org/akashdhawade/\">Akash Dhawade</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/akshat2802/\">Akshat Kakkad</a> · <a href=\"https://profiles.wordpress.org/alaminfirdows/\">Al-Amin Firdows</a> · <a href=\"https://profiles.wordpress.org/alanfuller/\">Alan Fuller</a> · <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juhé Lluveras</a> · <a href=\"https://profiles.wordpress.org/alessandrotesoro/\">Alessandro Tesoro</a> · <a href=\"https://profiles.wordpress.org/ralessio/\">Alessio</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alex27/\">alex27</a> · <a href=\"https://profiles.wordpress.org/digitalex11/\">Alexander Frank</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/harlet7/\">Alexandru Horeanu</a> · <a href=\"https://profiles.wordpress.org/alexcu21/\">alexcu21</a> · <a href=\"https://profiles.wordpress.org/ali7ali/\">Ali Ali</a> · <a href=\"https://profiles.wordpress.org/aliaghdam/\">aliaghdam</a> · <a href=\"https://profiles.wordpress.org/firewatch/\">allilevine</a> · <a href=\"https://profiles.wordpress.org/mrfoxtalbot/\">Alvaro Gómez</a> · <a href=\"https://profiles.wordpress.org/alvitazwar052/\">Alvi Tazwar</a> · <a href=\"https://profiles.wordpress.org/amincharoliya/\">Amin Charoliya</a> · <a href=\"https://profiles.wordpress.org/amirthepiper/\">Amir Abbas</a> · <a href=\"https://profiles.wordpress.org/amitraj2203/\">Amit Raj</a> · <a href=\"https://profiles.wordpress.org/amjadr360/\">Amjad Ali</a> · <a href=\"https://profiles.wordpress.org/anthakkar08/\">Anand Thakkar</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/awetz583/\">Andrea Roenning</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/andreiglingeanu/\">andreiglingeanu</a> · <a href=\"https://profiles.wordpress.org/andrewhayward/\">Andrew Hayward</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/rarst/\">Andrey “Rarst” Savchenko</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/la-geek/\">Angelika Reisiger</a> · <a href=\"https://profiles.wordpress.org/aniketpatel/\">Aniket Patel</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankit k gupta/\">Ankit K. Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitkumarshah/\">Ankit Kumar Shah</a> · <a href=\"https://profiles.wordpress.org/the-ank/\">Ankur Vishwakarma</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ahortin/\">Anthony Hortin</a> · <a href=\"https://profiles.wordpress.org/ant1busted/\">Antoine</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/antoniosejas/\">Antonio Sejas</a> · <a href=\"https://profiles.wordpress.org/apmeyer/\">apmeyer</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/perezcarreno/\">Armando J. Perez Carreno</a> · <a href=\"https://profiles.wordpress.org/armandsdz/\">Armands</a> · <a href=\"https://profiles.wordpress.org/arnaudbroes/\">arnaudbroes</a> · <a href=\"https://profiles.wordpress.org/ambrosiawt/\">Art Smith</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/arypneta/\">arypneta</a> · <a href=\"https://profiles.wordpress.org/asafm7/\">asafm7</a> · <a href=\"https://profiles.wordpress.org/aslamdoctor/\">Aslam Doctor</a> · <a href=\"https://profiles.wordpress.org/nmutua/\">Autumn</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/bjerke-johannessen/\">Bård Bjerke Johannessen</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/barryceelen/\">Barry Ceelen</a> · <a href=\"https://profiles.wordpress.org/bartkalisz/\">Bart Kalisz</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/rainbowgeek/\">Benjamin Denis</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/kau-boy/\">Bernhard Kau</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/neoxx/\">Bernhard Riedl</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/berubenic/\">berubenic</a> · <a href=\"https://profiles.wordpress.org/bhaveshdesai13/\">Bhavesh</a> · <a href=\"https://profiles.wordpress.org/bijit027/\">bijit027</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/blindmikey/\">blindmikey</a> · <a href=\"https://profiles.wordpress.org/bobbyleenoblestudios/\">bobbyleenoblestudios</a> · <a href=\"https://profiles.wordpress.org/bogdannikolic/\">Bogdan Nikolic</a> · <a href=\"https://profiles.wordpress.org/veryard/\">Brad</a> · <a href=\"https://profiles.wordpress.org/bradley2083/\">brad hogan</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/brentjettgmailcom/\">Brent Jett</a> · <a href=\"https://profiles.wordpress.org/brettshumaker/\">Brett Shumaker</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/bgosnell/\">Brian Gosnell</a> · <a href=\"https://profiles.wordpress.org/brianhenryie/\">Brian Henry</a> · <a href=\"https://profiles.wordpress.org/bridgetwes/\">bridgetwes</a> · <a href=\"https://profiles.wordpress.org/brobken/\">brobken</a> · <a href=\"https://profiles.wordpress.org/freibergergarcia/\">Bruno Freiberger Garcia</a> · <a href=\"https://profiles.wordpress.org/cambabutonono/\">Cambabutonono</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/carstenbach/\">Carsten Bach</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/mchirag2002/\">Chirag Mathur</a> · <a href=\"https://profiles.wordpress.org/chrico/\">ChriCo</a> · <a href=\"https://profiles.wordpress.org/jazzs3quence/\">Chris Reynolds</a> · <a href=\"https://profiles.wordpress.org/eclare/\">Chris Trynkiewicz (Sukces Strony)</a> · <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a> · <a href=\"https://profiles.wordpress.org/cfinke/\">Christopher Finke</a> · <a href=\"https://profiles.wordpress.org/ckanitz/\">Christopher Kanitz</a> · <a href=\"https://profiles.wordpress.org/nyiriland/\">Christy Nyiri</a> · <a href=\"https://profiles.wordpress.org/butterflymedia/\">Ciprian</a> · <a href=\"https://profiles.wordpress.org/codersantosh/\">codersantosh</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/craynor/\">craynor</a> · <a href=\"https://profiles.wordpress.org/creativethemeshq/\">creativethemeshq</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/cweiske/\">cweiske</a> · <a href=\"https://profiles.wordpress.org/coquardcyr/\">Cyrille</a> · <a href=\"https://profiles.wordpress.org/da5f656f/\">da5f656f</a> · <a href=\"https://profiles.wordpress.org/xendo/\">Dademaru</a> · <a href=\"https://profiles.wordpress.org/daleharrison/\">daleharrison</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/colorful tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/daniguardiola/\">Dani Guardiola</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/itsdanny/\">Danny</a> · <a href=\"https://profiles.wordpress.org/dannyreaktiv/\">dannyreaktiv</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/d-signed/\">Dareth NHANG</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/daveagp/\">daveagp</a> · <a href=\"https://profiles.wordpress.org/fac3less/\">David</a> · <a href=\"https://profiles.wordpress.org/dballari/\">David Ballarin Prunera</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/davidabowman/\">David Bowman</a> · <a href=\"https://profiles.wordpress.org/davidhbrown/\">David Brown</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/davidgodleman10up/\">David Godleman</a> · <a href=\"https://profiles.wordpress.org/dhenriet/\">David Henriet</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/daviedr/\">David Rozando</a> · <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/ddewan/\">ddewan</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/debarghyabanerjee/\">DEBARGHYA BANERJEE</a> · <a href=\"https://profiles.wordpress.org/deepakrohilla/\">Deepak Rohilla</a> · <a href=\"https://profiles.wordpress.org/deepakvijayan/\">Deepak Vijayan</a> · <a href=\"https://profiles.wordpress.org/dekadinious/\">Dekadinious</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dsmart/\">Derek Smart</a> · <a href=\"https://profiles.wordpress.org/deryck/\">Deryck</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/devansh2002/\">Devansh Chaudhary</a> · <a href=\"https://profiles.wordpress.org/devspace/\">devspace</a> · <a href=\"https://profiles.wordpress.org/dhananjaykuber/\">Dhananjay Kuber</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruval04/\">Dhruval Shah</a> · <a href=\"https://profiles.wordpress.org/dhruvang21/\">Dhruvang21</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dilip2615/\">Dilip Modhavadiya</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/divibanks/\">Divi Banks</a> · <a href=\"https://profiles.wordpress.org/djcowan/\">dj.cowan</a> · <a href=\"https://profiles.wordpress.org/djennez/\">djennez</a> · <a href=\"https://profiles.wordpress.org/cyberorca/\">Doni Kuntoro</a> · <a href=\"https://profiles.wordpress.org/dorzki/\">Dor Zuberi</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/drivingralle/\">Drivingralle</a> · <a href=\"https://profiles.wordpress.org/drzraf/\">drzraf</a> · <a href=\"https://profiles.wordpress.org/elrae/\">Earle Davies</a> · <a href=\"https://profiles.wordpress.org/eballeste/\">eballeste</a> · <a href=\"https://profiles.wordpress.org/eclev91/\">eclev91</a> · <a href=\"https://profiles.wordpress.org/beckej/\">Ed Beck</a> · <a href=\"https://profiles.wordpress.org/ejnwebmaster/\">ejnwebmaster</a> · <a href=\"https://profiles.wordpress.org/elfu98/\">elfu98</a> · <a href=\"https://profiles.wordpress.org/eliorivero/\">Elio Rivero</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a> · <a href=\"https://profiles.wordpress.org/erichmond/\">Elliott Richmond</a> · <a href=\"https://profiles.wordpress.org/eatse/\">Emmanue ATSÉ</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/emmanuel78/\">emmanuel78</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/nrqsnchz/\">Enrique Sánchez</a> · <a href=\"https://profiles.wordpress.org/ericdye/\">Eric Dye</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/erikiva/\">erikiva</a> · <a href=\"https://profiles.wordpress.org/erikyo/\">erikyo</a> · <a href=\"https://profiles.wordpress.org/eherman24/\">Evan Herman</a> · <a href=\"https://profiles.wordpress.org/circlecube/\">Evan Mullins</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/fabiorubioglio/\">Fabio Rubioglio</a> · <a href=\"https://profiles.wordpress.org/fahimmurshed/\">FahimMurshed</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fazyshah/\">Faizan Nabi</a> · <a href=\"https://profiles.wordpress.org/iamfarhan09/\">Farhan Ahmed</a> · <a href=\"https://profiles.wordpress.org/fayyazfayzi/\">Fayyaz</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/ffffelix/\">Felix Renicks</a> · <a href=\"https://profiles.wordpress.org/fjorgemota/\">Fernando Jorge Mota (a11n)</a> · <a href=\"https://profiles.wordpress.org/firoz2456/\">Firoz Sabaliya</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco</a> · <a href=\"https://profiles.wordpress.org/franz00/\">Fransisca H</a> · <a href=\"https://profiles.wordpress.org/fullworks/\">fullworks</a> · <a href=\"https://profiles.wordpress.org/gwallace87/\">Gale Wallace</a> · <a href=\"https://profiles.wordpress.org/gansbrest/\">gansbrest</a> · <a href=\"https://profiles.wordpress.org/garethelwell/\">Gareth Elwell</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/gauravtiwari/\">Gaurav Tiwari</a> · <a href=\"https://profiles.wordpress.org/gauravsingh7/\">gauravsingh7</a> · <a href=\"https://profiles.wordpress.org/georgwordpress/\">Georg</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/germanfrelo/\">Germán Freixinós</a> · <a href=\"https://profiles.wordpress.org/gmariani405/\">gmariani405</a> · <a href=\"https://profiles.wordpress.org/graemef/\">GraemeF</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/greentreefrog/\">greentreefrog</a> · <a href=\"https://profiles.wordpress.org/greenworld/\">GreenWorld</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/gyurmey/\">Gyurmey</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/halilesen/\">Halil ESEN</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hage/\">Hans-Gerd Gerhards</a> · <a href=\"https://profiles.wordpress.org/hardipparmar/\">Hardip Parmar</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/plaidharper/\">Harper Holsinger</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harshvaishnav/\">harshvaishnav</a> · <a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a> · <a href=\"https://profiles.wordpress.org/hectorjarquin/\">hectorjarquin</a> · <a href=\"https://profiles.wordpress.org/hedgefield/\">hedgefield</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/iamarinoh/\">Henrique Iamarino</a> · <a href=\"https://profiles.wordpress.org/abcd95/\">Himanshu Pathak</a> · <a href=\"https://profiles.wordpress.org/hirschferkel/\">hirschferkel</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/h71/\">Hossein</a> · <a href=\"https://profiles.wordpress.org/htmgarcia/\">htmgarcia</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/kardi420/\">Ibrahim</a> · <a href=\"https://profiles.wordpress.org/ibrahimriaz/\">Ibrahim Riaz</a> · <a href=\"https://profiles.wordpress.org/imranh920/\">Imran Hossain (a11n)</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/itpathsolutions/\">IT Path Solutions</a> · <a href=\"https://profiles.wordpress.org/itapress/\">itapress</a> · <a href=\"https://profiles.wordpress.org/ivanottinger/\">Ivan Ottinger</a> · <a href=\"https://profiles.wordpress.org/jpstevens/\">Jack Stevens</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/smithjw1/\">Jacob Smith</a> · <a href=\"https://profiles.wordpress.org/jagirbahesh/\">jagirbahesh</a> · <a href=\"https://profiles.wordpress.org/jainil07/\">Jainil Shah</a> · <a href=\"https://profiles.wordpress.org/jtgreyd/\">Jakob Trost</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/jamesosborne/\">James Osborne</a> · <a href=\"https://profiles.wordpress.org/jamesros161/\">James Rosado</a> · <a href=\"https://profiles.wordpress.org/jwgoedert/\">James Wesley Goedert</a> · <a href=\"https://profiles.wordpress.org/janpfeil/\">Jan Pfeil</a> · <a href=\"https://profiles.wordpress.org/janak007/\">janak Kaneriya</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarekmorawski/\">jarekmorawski</a> · <a href=\"https://profiles.wordpress.org/ipajen/\">Jarko Piironen</a> · <a href=\"https://profiles.wordpress.org/jasonbahl/\">Jason Bahl</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/javad2000/\">javad2000</a> · <a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a> · <a href=\"https://profiles.wordpress.org/jawadwp/\">Jawad Malik</a> · <a href=\"https://profiles.wordpress.org/topdownjimmy/\">Jay</a> · <a href=\"https://profiles.wordpress.org/jayadevankbh/\">Jayadevan k</a> · <a href=\"https://profiles.wordpress.org/drjosh07/\">jbrya029</a> · <a href=\"https://profiles.wordpress.org/jdahir0789/\">JD Ahir</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/krokodok/\">Jeff Chi</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> · <a href=\"https://profiles.wordpress.org/jenilk/\">Jenil Kanani</a> · <a href=\"https://profiles.wordpress.org/jennifarhat/\">Jennifer Farhat</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">Jerry Jones</a> · <a href=\"https://profiles.wordpress.org/skobe/\">Jesko Bendmann</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jetaldobariya1/\">jetaldobariya1</a> · <a href=\"https://profiles.wordpress.org/jigar9998/\">Jigar Panchal</a> · <a href=\"https://profiles.wordpress.org/jimmyh61/\">jimmyh61</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnillo/\">John Espiritu</a> · <a href=\"https://profiles.wordpress.org/johnny5/\">John Godley</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnregan3/\">John Regan</a> · <a href=\"https://profiles.wordpress.org/lwangaman/\">JohnRDOrazio</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/elbsegler/\">Jonas</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jonnywatersbb/\">Jonny Waters</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/josklever/\">Jos Klever</a> · <a href=\"https://profiles.wordpress.org/josevarghese/\">Jose Varghese</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a> · <a href=\"https://profiles.wordpress.org/verygoode/\">Joshua Goode</a> · <a href=\"https://profiles.wordpress.org/jossnaz/\">Jossnaz</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/julianoe/\">julianoe</a> · <a href=\"https://profiles.wordpress.org/juliemoynat/\">Julie Moynat</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/junedsabaliya/\">Juned Sabaliya</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kaavyaiyer/\">Kaavya Iyer (woo-hc)</a> · <a href=\"https://profiles.wordpress.org/arkenon/\">Kadim Gültekin</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/kajalgohel/\">Kajal Gohel</a> · <a href=\"https://profiles.wordpress.org/ikamal/\">Kamal Hosen</a> · <a href=\"https://profiles.wordpress.org/kamran8176/\">Kamran Hussen</a> · <a href=\"https://profiles.wordpress.org/karan4word/\">Karan Gupta</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/kartikmehta/\">Kartik Mehta</a> · <a href=\"https://profiles.wordpress.org/kartik-suthar/\">Kartik Suthar</a> · <a href=\"https://profiles.wordpress.org/kbrownkd/\">kbrownkd (a11n)</a> · <a href=\"https://profiles.wordpress.org/keffr3n/\">Keffr3n</a> · <a href=\"https://profiles.wordpress.org/kel-dc/\">Kel Santiago-Pilarski</a> · <a href=\"https://profiles.wordpress.org/kellenmace/\">Kellen Mace</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/keoshi/\">keoshi</a> · <a href=\"https://profiles.wordpress.org/kevinb/\">Kevin Behrens</a> · <a href=\"https://profiles.wordpress.org/ktaron/\">Kevin Taron</a> · <a href=\"https://profiles.wordpress.org/kevinswalsh/\">kevinswalsh</a> · <a href=\"https://profiles.wordpress.org/khokansardar/\">Khokan Sardar</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kisquian/\">kisquian</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/kowsar89/\">Kowsar Hossain</a> · <a href=\"https://profiles.wordpress.org/kracked888/\">kracked888</a> · <a href=\"https://profiles.wordpress.org/krishneup/\">Krishna Neupane</a> · <a href=\"https://profiles.wordpress.org/kristastevens/\">kristastevens</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/kmadhak/\">Kunal Madhak</a> · <a href=\"https://profiles.wordpress.org/gohelkunjan/\">Kunjan Gohel</a> · <a href=\"https://profiles.wordpress.org/kurtpayne/\">Kurt Payne</a> · <a href=\"https://profiles.wordpress.org/kushang78/\">Kushang Tailor</a> · <a href=\"https://profiles.wordpress.org/mlaetitia/\">Lae</a> · <a href=\"https://profiles.wordpress.org/notlaura/\">Lara Schenck</a> · <a href=\"https://profiles.wordpress.org/lastsplash/\">lastsplash (a11n)</a> · <a href=\"https://profiles.wordpress.org/newyorkerlaura/\">Laura Byrne</a> · <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a> · <a href=\"https://profiles.wordpress.org/oncecoupled/\">Lauren</a> · <a href=\"https://profiles.wordpress.org/laranz/\">Lawrence Joe</a> · <a href=\"https://profiles.wordpress.org/leemon/\">leemon</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/lifelightweb/\">lifelightweb</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/linsoftware/\">Linnea Huxford</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/louiswol94/\">Louis Wolmarans</a> · <a href=\"https://profiles.wordpress.org/louwie17/\">Lourens</a> · <a href=\"https://profiles.wordpress.org/lovesoni1999/\">Love Soni</a> · <a href=\"https://profiles.wordpress.org/crixu/\">Lucas</a> · <a href=\"https://profiles.wordpress.org/gigitux/\">Luigi Teschio</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/lukasbesch/\">lukasbesch</a> · <a href=\"https://profiles.wordpress.org/lukecarbis/\">Luke Carbis</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madpeter/\">madpeter</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/nadimcse/\">Mahmudul Haque Nadim</a> · <a href=\"https://profiles.wordpress.org/mai21/\">Mai</a> · <a href=\"https://profiles.wordpress.org/mkrndmane/\">Makarand G. Mane</a> · <a href=\"https://profiles.wordpress.org/manbo/\">manbo</a> · <a href=\"https://profiles.wordpress.org/maneshtimilsina/\">Manesh Timilsina</a> · <a href=\"https://profiles.wordpress.org/targz-1/\">Manuel Schmalstieg</a> · <a href=\"https://profiles.wordpress.org/manzoorwanijk/\">Manzoor Wani (a11n)</a> · <a href=\"https://profiles.wordpress.org/marianguas/\">María Anguas</a> · <a href=\"https://profiles.wordpress.org/mdxfr/\">Marc</a> · <a href=\"https://profiles.wordpress.org/marc4/\">Marc Armengou</a> · <a href=\"https://profiles.wordpress.org/mardroid/\">Marcel Tannich</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/iworks/\">Marcin Pietrzak</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/pereirinha/\">Marco Pereirinha</a> · <a href=\"https://profiles.wordpress.org/marcwieland95/\">marcwieland95</a> · <a href=\"https://profiles.wordpress.org/igreenie/\">Marek Železný</a> · <a href=\"https://profiles.wordpress.org/margolisj/\">margolisj</a> · <a href=\"https://profiles.wordpress.org/mariayohana/\">Maria Yohana</a> · <a href=\"https://profiles.wordpress.org/plari/\">Marie</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/marius84/\">mariushosting</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/markparnell/\">Mark Parnell</a> · <a href=\"https://profiles.wordpress.org/mark-k/\">Mark-k</a> · <a href=\"https://profiles.wordpress.org/mhkuu/\">Martijn van der Klis</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">marybaum</a> · <a href=\"https://profiles.wordpress.org/mat_/\">mat_</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/mattyrob/\">Matt Robinson</a> · <a href=\"https://profiles.wordpress.org/mattormeeple/\">Matt Sherman</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/mboynes/\">Matthew Boynes</a> · <a href=\"https://profiles.wordpress.org/lonelyvegan/\">Matthew Riley MacPherson</a> · <a href=\"https://profiles.wordpress.org/kittmedia/\">Matthias Kittsteiner</a> · <a href=\"https://profiles.wordpress.org/mattraines/\">mattraines</a> · <a href=\"https://profiles.wordpress.org/maurodf/\">maurodf</a> · <a href=\"https://profiles.wordpress.org/mayanktripathi32/\">Mayank Tripathi</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/mcrisp1972/\">mcrisp1972</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/mhshohel/\">Md Hossain Shohel</a> · <a href=\"https://profiles.wordpress.org/istiaqhossain/\">Md. Istiaq Hossain</a> · <a href=\"https://profiles.wordpress.org/mdviralsampat/\">mdviralsampat</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/iammehedi1/\">Mehedi Hassan</a> · <a href=\"https://profiles.wordpress.org/mehulkaklotar/\">Mehul Kaklotar</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/meteorlxy/\">meteorlxy</a> · <a href=\"https://profiles.wordpress.org/mfgmicha/\">Micha Krapp</a> · <a href=\"https://profiles.wordpress.org/tw2113/\">Michael Beckwith</a> · <a href=\"https://profiles.wordpress.org/michaelbourne/\">Michael Bourne</a> · <a href=\"https://profiles.wordpress.org/hrkhal/\">Michael James Ilett</a> · <a href=\"https://profiles.wordpress.org/michaelpick/\">michaelpick</a> · <a href=\"https://profiles.wordpress.org/michaelwp85/\">michaelwp85</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/mielbu/\">Michelle Bulloch</a> · <a href=\"https://profiles.wordpress.org/miguelaxcar/\">Miguel Axcar</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/migueluy/\">Miguel Lezama</a> · <a href=\"https://profiles.wordpress.org/simison/\">Mikael Korpela</a> · <a href=\"https://profiles.wordpress.org/mmcalister/\">Mike McAlister</a> · <a href=\"https://profiles.wordpress.org/ritterml/\">Mike Ritter</a> · <a href=\"https://profiles.wordpress.org/mikeb8s/\">mikeb8s</a> · <a href=\"https://profiles.wordpress.org/mikeybinns/\">Mikey Binns</a> · <a href=\"https://profiles.wordpress.org/milamj/\">milamj</a> · <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">Mitchell Austin</a> · <a href=\"https://profiles.wordpress.org/mklusak/\">mklusak</a> · <a href=\"https://profiles.wordpress.org/mleathem/\">mleathem</a> · <a href=\"https://profiles.wordpress.org/mlf20/\">mlf20</a> · <a href=\"https://profiles.wordpress.org/mobarak/\">Mobarak Ali</a> · <a href=\"https://profiles.wordpress.org/mohitdadhich10/\">Mohit Dadhich</a> · <a href=\"https://profiles.wordpress.org/morganestes/\">Morgan Estes</a> · <a href=\"https://profiles.wordpress.org/mosne/\">Mosne / Paolo Tesei</a> · <a href=\"https://profiles.wordpress.org/mossy2100/\">mossy2100</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/assassinateur/\">Nadir Seghir a11n</a> · <a href=\"https://profiles.wordpress.org/naeemhaque/\">Naeem Haque</a> · <a href=\"https://profiles.wordpress.org/nagpai/\">Nagesh Pai</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/n8finch/\">Nate Finch</a> · <a href=\"https://profiles.wordpress.org/nateinaction/\">Nate Gay</a> · <a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a> · <a href=\"https://profiles.wordpress.org/nebojsajurcic/\">Nebojša Jurčić</a> · <a href=\"https://profiles.wordpress.org/nek285/\">nek285</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/neo2k23/\">neo2k23</a> · <a href=\"https://profiles.wordpress.org/neotrope/\">neotrope</a> · <a href=\"https://profiles.wordpress.org/eidolonnight/\">Nicholas Garofalo</a> · <a href=\"https://profiles.wordpress.org/nickbohle/\">Nick Bohle</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/nick_thegeek/\">Nick the Geek</a> · <a href=\"https://profiles.wordpress.org/nicolefurlan/\">Nicole Furlan</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nihar007/\">Nihar Ranjan Das</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/nikitasolanki1812/\">Nikita Solanki</a> · <a href=\"https://profiles.wordpress.org/nirajgirixd/\">Niraj Giri</a> · <a href=\"https://profiles.wordpress.org/niravsherasiya7707/\">Nirav Sherasiya</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/noruzzaman/\">Noruzzaman</a> · <a href=\"https://profiles.wordpress.org/nurielmeni/\">nurielmeni</a> · <a href=\"https://profiles.wordpress.org/obliviousharmony/\">obliviousharmony</a> · <a href=\"https://profiles.wordpress.org/finalwebsites/\">Olaf Lederer</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a> · <a href=\"https://profiles.wordpress.org/olivierlafleur/\">Olivier Lafleur</a> · <a href=\"https://profiles.wordpress.org/alshakero/\">Omar Alshaker</a> · <a href=\"https://profiles.wordpress.org/oscarhugopaz/\">Oscar Hugo Paz</a> · <a href=\"https://profiles.wordpress.org/prestonwordsworth/\">p15h</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/otakupahp/\">Pablo Hernández</a> · <a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a> · <a href=\"https://profiles.wordpress.org/pamprn/\">Pamela Ribeiro</a> · <a href=\"https://profiles.wordpress.org/pander/\">pander</a> · <a href=\"https://profiles.wordpress.org/pls78/\">Paolo L. Scala</a> · <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Paragon Initiative Enterprises</a> · <a href=\"https://profiles.wordpress.org/parinpanjari/\">Parin Panjari</a> · <a href=\"https://profiles.wordpress.org/parthvataliya/\">Parth vataliya</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/obrienlabs/\">Pat O’Brien</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/paulschreiber/\">Paul Schreiber</a> · <a href=\"https://profiles.wordpress.org/paulwilde/\">Paul Wilde</a> · <a href=\"https://profiles.wordpress.org/paulcline/\">paulcline</a> · <a href=\"https://profiles.wordpress.org/paulopmt1/\">Paulo Trentin</a> · <a href=\"https://profiles.wordpress.org/pavanpatil1/\">Pavan Patil</a> · <a href=\"https://profiles.wordpress.org/pcarvalho/\">pcarvalho</a> · <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendonça</a> · <a href=\"https://profiles.wordpress.org/perryrylance/\">perryrylance</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/pevogam/\">pevogam</a> · <a href=\"https://profiles.wordpress.org/mr2p/\">Phi Phan</a> · <a href=\"https://profiles.wordpress.org/johnstonphilip/\">Phil Johnston</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/philwebs/\">philwebs</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/boniu91/\">Piotrek Boniu</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pgeorgiev/\">Plamen Georgiev</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/porg/\">porg</a> · <a href=\"https://profiles.wordpress.org/ppolo99/\">ppolo99</a> · <a href=\"https://profiles.wordpress.org/praful2111/\">Praful Patel</a> · <a href=\"https://profiles.wordpress.org/pranitdugad/\">Pranit Dugad</a> · <a href=\"https://profiles.wordpress.org/pratikkry/\">Pratik Kumar</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/prettyboymp/\">prettyboymp</a> · <a href=\"https://profiles.wordpress.org/prionkor/\">prionkor</a> · <a href=\"https://profiles.wordpress.org/pwtyler/\">pwtyler</a> · <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a> · <a href=\"https://profiles.wordpress.org/spanglishwebs/\">Rachel Winspear</a> · <a href=\"https://profiles.wordpress.org/rfischmann/\">Rafael Fischmann</a> · <a href=\"https://profiles.wordpress.org/rafaelgalani/\">Rafael Gallani</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiqul Islam</a> · <a href=\"https://profiles.wordpress.org/rahmatgumilar/\">Rahmat Gumilar</a> · <a href=\"https://profiles.wordpress.org/rahulharpal/\">rahulharpal</a> · <a href=\"https://profiles.wordpress.org/imrraaj/\">Raj Patel</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/shashwatahalder01/\">rajkumar shashwata halder</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramon-fincken/\">ramon fincken</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/ramswarup/\">Ramswarup Rathod</a> · <a href=\"https://profiles.wordpress.org/xyulex/\">Raul Martinez</a> · <a href=\"https://profiles.wordpress.org/rcneil/\">rcneil</a> · <a href=\"https://profiles.wordpress.org/realthemes/\">realthemes</a> · <a href=\"https://profiles.wordpress.org/rejaulalomkhan/\">Rejaul Alom Khan</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho (a11n)</a> · <a href=\"https://profiles.wordpress.org/reputeinfosystems/\">reputeinfosystems</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rhellewellgmailcom/\">Rick Hellewell</a> · <a href=\"https://profiles.wordpress.org/riddhipatel/\">Riddhi Patel</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/rishit30g/\">Rishit Gupta</a> · <a href=\"https://profiles.wordpress.org/rithik56/\">rithik56</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/robert-biswas/\">Robert Biswas</a> · <a href=\"https://profiles.wordpress.org/robertghetau/\">Robert Ghetau</a> · <a href=\"https://profiles.wordpress.org/rocketworks/\">rocket.works – Dominik Friedrich</a> · <a href=\"https://profiles.wordpress.org/rodelgc/\">Rodel Calasagsag a11n</a> · <a href=\"https://profiles.wordpress.org/rghedin/\">Rodrigo</a> · <a href=\"https://profiles.wordpress.org/rodrigosprimo/\">Rodrigo Primo</a> · <a href=\"https://profiles.wordpress.org/geekofshire/\">Rohan Jha</a> · <a href=\"https://profiles.wordpress.org/rohitmathur7/\">rohitmathur7</a> · <a href=\"https://profiles.wordpress.org/costasovo/\">Rostislav Wolný</a> · <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a> · <a href=\"https://profiles.wordpress.org/roygbyte/\">roygbyte</a> · <a href=\"https://profiles.wordpress.org/royho/\">royho</a> · <a href=\"https://profiles.wordpress.org/rpf5573/\">rpf5573</a> · <a href=\"https://profiles.wordpress.org/rslee/\">rslee</a> · <a href=\"https://profiles.wordpress.org/ruchirj/\">Ruchir Goswami</a> · <a href=\"https://profiles.wordpress.org/rayhatron/\">Rufaro Madamombe</a> · <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a> · <a href=\"https://profiles.wordpress.org/rleeson/\">Ryan Leeson</a> · <a href=\"https://profiles.wordpress.org/ryancurban/\">Ryan Urban</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/sppramodh/\">S P Pramodh</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a> · <a href=\"https://profiles.wordpress.org/sergiomdgomes/\">Sérgio Gomes</a> · <a href=\"https://profiles.wordpress.org/soean/\">Sören Wünsch</a> · <a href=\"https://profiles.wordpress.org/sadmansh/\">sadmansh</a> · <a href=\"https://profiles.wordpress.org/isaeedam/\">Saeed Piri</a> · <a href=\"https://profiles.wordpress.org/mi5t4n/\">Sagar Tamang</a> · <a href=\"https://profiles.wordpress.org/sahiladit/\">sahiladit</a> · <a href=\"https://profiles.wordpress.org/sainathpoojary/\">Sainath Poojary</a> · <a href=\"https://profiles.wordpress.org/sakibmd/\">Sakib Mohammed</a> · <a href=\"https://profiles.wordpress.org/samtoohey93/\">Sam Toohey</a> · <a href=\"https://profiles.wordpress.org/samiamnot/\">samiamnot</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/samuelsidler/\">Samuel Sidler</a> · <a href=\"https://profiles.wordpress.org/samuelsilvapt/\">Samuel Silva</a> · <a href=\"https://profiles.wordpress.org/sannevndrmeulen/\">Sanne van der Meulen</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarahricker/\">sarahricker</a> · <a href=\"https://profiles.wordpress.org/sarthaknagoshe2002/\">Sarthak Nagoshe</a> · <a href=\"https://profiles.wordpress.org/sathyapulse/\">Sathiya Venkatesan</a> · <a href=\"https://profiles.wordpress.org/satishprajapati/\">Satish Prajapati</a> · <a href=\"https://profiles.wordpress.org/sfougnier/\">Saul Fougnier</a> · <a href=\"https://profiles.wordpress.org/sauliusv/\">Saulius Vikerta</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/sayedulsayem/\">Sayedul Sayem</a> · <a href=\"https://profiles.wordpress.org/scholdstrom/\">scholdstrom</a> · <a href=\"https://profiles.wordpress.org/swb1192/\">Scott Buscemi</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scottculverhouse/\">scottculverhouse</a> · <a href=\"https://profiles.wordpress.org/seanavers/\">seanavers</a> · <a href=\"https://profiles.wordpress.org/seifradwane/\">Seif Radwane</a> · <a href=\"https://profiles.wordpress.org/kuuuzya/\">Sergey</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/zahardoc/\">Serhiy Zakharchenko</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/sh4lin/\">Shalin Shah</a> · <a href=\"https://profiles.wordpress.org/sharonaustin/\">Sharon Austin</a> · <a href=\"https://profiles.wordpress.org/sheulyshila/\">sheulyshila</a> · <a href=\"https://profiles.wordpress.org/spdft/\">Shoe</a> · <a href=\"https://profiles.wordpress.org/showravhasan/\">Showrav Hasan</a> · <a href=\"https://profiles.wordpress.org/shreya0204/\">Shreya Agarwal</a> · <a href=\"https://profiles.wordpress.org/silaskoehler/\">Silas Köhler</a> · <a href=\"https://profiles.wordpress.org/siliconforks/\">siliconforks</a> · <a href=\"https://profiles.wordpress.org/simo_m/\">Simone Maranzana</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/smerriman/\">smerriman</a> · <a href=\"https://profiles.wordpress.org/snehapatil02/\">Sneha Patil</a> · <a href=\"https://profiles.wordpress.org/sophiegy/\">Sophie – a11n</a> · <a href=\"https://profiles.wordpress.org/souptik/\">Souptik Datta</a> · <a href=\"https://profiles.wordpress.org/sourabhjain/\">Sourabh Jain</a> · <a href=\"https://profiles.wordpress.org/sourav08/\">Sourav Pahwa</a> · <a href=\"https://profiles.wordpress.org/staurand/\">staurand</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/stein2nd/\">stein2nd</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a> · <a href=\"https://profiles.wordpress.org/thompsonsj/\">Steven Thompson</a> · <a href=\"https://profiles.wordpress.org/stoyangeorgiev/\">Stoyan Georgiev</a> · <a href=\"https://profiles.wordpress.org/styleshit/\">styleshit</a> · <a href=\"https://profiles.wordpress.org/sudipatel007/\">Sudip Dadhaniya</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">Sunil Prajapati</a> · <a href=\"https://profiles.wordpress.org/quadthemes/\">Sunny</a> · <a href=\"https://profiles.wordpress.org/superchlorine/\">superchlorine</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/jannathsyeda/\">Syeda Fahima Jannath</a> · <a href=\"https://profiles.wordpress.org/takahashi_fumiki/\">Takahashi Fumiki</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/devtanbir/\">Tanbir Ahmod</a> · <a href=\"https://profiles.wordpress.org/tanvirul/\">Tanvirul Haque</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/taylorgorman/\">Taylor Gorman</a> · <a href=\"https://profiles.wordpress.org/tdrayson/\">tdrayson</a> · <a href=\"https://profiles.wordpress.org/iamjaydip/\">thejaydip</a> · <a href=\"https://profiles.wordpress.org/thelmachido/\">thelmachido a11n</a> · <a href=\"https://profiles.wordpress.org/themes-1/\">them.es</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kräftner</a> · <a href=\"https://profiles.wordpress.org/thrijith/\">Thrijith Thankachan</a> · <a href=\"https://profiles.wordpress.org/sippis/\">Timi Wahalahti</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tirth03/\">Tirth Doshi</a> · <a href=\"https://profiles.wordpress.org/tmanoilov/\">tmanoilov</a> · <a href=\"https://profiles.wordpress.org/toastercookie/\">toastercookie</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn “Tobi” Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomjcafferkey/\">Tom Cafferkey</a> · <a href=\"https://profiles.wordpress.org/thomasdevisser/\">Tom de Visser</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/tomhine/\">tomhine</a> · <a href=\"https://profiles.wordpress.org/tomllobet/\">tomllobet</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/areziaal/\">Troy Chaplin</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/tunetheweb/\">tunetheweb</a> · <a href=\"https://profiles.wordpress.org/twstokes/\">twstokes</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/umesh84/\">Umesh Gupta</a> · <a href=\"https://profiles.wordpress.org/umeshsinghin/\">Umesh Singh</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">up1512001</a> · <a href=\"https://profiles.wordpress.org/ukdrahul/\">Uttam Kumar Dash</a> · <a href=\"https://profiles.wordpress.org/valer1e/\">valer1e</a> · <a href=\"https://profiles.wordpress.org/vertisoft/\">vertisoft</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/vijaysinh9094/\">Vijaysinh Zala</a> · <a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Szépe</a> · <a href=\"https://profiles.wordpress.org/vineet2003/\">Vinit</a> · <a href=\"https://profiles.wordpress.org/ghorivipul97/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vipulgupta003/\">Vipul Gupta</a> · <a href=\"https://profiles.wordpress.org/vipulpatil/\">vipulpatil</a> · <a href=\"https://profiles.wordpress.org/vrajadas/\">Vraja Das</a> · <a href=\"https://profiles.wordpress.org/vrishabhsk/\">vrishabhsk</a> · <a href=\"https://profiles.wordpress.org/wbdv/\">wbdv</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design | Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/webwurm/\">webwurm</a> · <a href=\"https://profiles.wordpress.org/wesrapyd/\">wesrapyd</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/skorasaurus/\">Will Skora</a> · <a href=\"https://profiles.wordpress.org/williamalexander/\">William Alexander</a> · <a href=\"https://profiles.wordpress.org/williampatton/\">williampatton</a> · <a href=\"https://profiles.wordpress.org/wongjn/\">wongjn</a> · <a href=\"https://profiles.wordpress.org/wpeople/\">WPeople</a> · <a href=\"https://profiles.wordpress.org/wpsoul/\">wpsoul</a> · <a href=\"https://profiles.wordpress.org/wzieba/\">wzieba</a> · <a href=\"https://profiles.wordpress.org/xipasduarte/\">xipasduarte</a> · <a href=\"https://profiles.wordpress.org/yaniiliev/\">Yani</a> · <a href=\"https://profiles.wordpress.org/collet/\">Yann</a> · <a href=\"https://profiles.wordpress.org/yguyon/\">Yannis Guyon</a> · <a href=\"https://profiles.wordpress.org/yogeshbhutkar/\">Yogesh Bhutkar</a> · <a href=\"https://profiles.wordpress.org/ytfeldrawkcab/\">ytfeLdrawkcaB</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yukinobu/\">Yukinobu Asakawa</a> · <a href=\"https://profiles.wordpress.org/yuvrajsinh2211/\">Yuvrajsinh Sisodiya</a> · <a href=\"https://profiles.wordpress.org/zackkrida/\">Zack Krida</a> · <a href=\"https://profiles.wordpress.org/zeelthakkar/\">zeelthakkar</a> · <a href=\"https://profiles.wordpress.org/zitaruksergij/\">zitaruksergij</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux personnes ayant contribué à traduire WordPress&nbsp;6.7 en français</h2>\n\n\n\n<p>WordPress est un projet international et la version 6.7 est déjà complètement disponible dans plus de 40 langues différentes.</p>\n\n\n\n<p>Nous souhaitons remercier ici les personnes ayant participé à la traduction de WordPress&nbsp;6.7 en français&nbsp;:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/fxbenard\">fxbenard</a>, <a href=\"https://profiles.wordpress.org/xibe\">Xavier Borderie</a>, <a href=\"https://profiles.wordpress.org/amebref\">amebref</a>, <a href=\"https://profiles.wordpress.org/beryldlg\">Béryl de La Grandière</a>, <a href=\"https://profiles.wordpress.org/chris-kns\">chris-kns</a>, <a href=\"https://profiles.wordpress.org/clementpolito\">Clément Polito</a>, <a href=\"https://profiles.wordpress.org/dfi42\">dfi42</a>, <a href=\"https://profiles.wordpress.org/eddystile\">Eddy</a>, <a href=\"https://profiles.wordpress.org/emlebrun\">Emilie LEBRUN</a>, <a href=\"https://profiles.wordpress.org/florientinneo\">Florient DELAFOY</a>, <a href=\"https://profiles.wordpress.org/karine-wendling\">karine wendling</a>, <a href=\"https://profiles.wordpress.org/laeti972\">Laetitia de Perthuis</a>, <a href=\"https://profiles.wordpress.org/wplmillet\">Laurent MILLET</a>, <a href=\"https://profiles.wordpress.org/marineevain\">Marine EVAIN</a>, <a href=\"https://profiles.wordpress.org/lymx\">Maxime LEROY</a>, <a href=\"https://profiles.wordpress.org/firestar300\">Milan Ricoul</a>, <a href=\"https://profiles.wordpress.org/momo-fr\">momo-fr</a>, <a href=\"https://profiles.wordpress.org/pasglop\">pasglop</a>, <a href=\"https://profiles.wordpress.org/phoenix13\">phoenix13</a>, <a href=\"https://profiles.wordpress.org/pierrelannoy\">Pierre Lannoy</a>, <a href=\"https://profiles.wordpress.org/sebastienserre\">Sébastien SERRE</a>, et <a href=\"https://profiles.wordpress.org/spaceshipone\">Timothée Brosille</a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-small-font-size\">Article traduit par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>. Merci à <a href=\"https://profiles.wordpress.org/laboiteare/\">Renaud Pacouil</a> pour sa relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3255\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Guide des changements techniques de WordPress 6.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://fr.wordpress.org/2024/10/28/guide-des-changements-techniques-de-wordpress-6-7/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 28 Oct 2024 10:49:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:5:\"Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3243\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:436:\"WordPress 6.7 comprend la résolution de plus de&#160;300 tickets sur Trac, dont&#160;87 améliorations et nouvelles fonctionnalités, plus de 200 corrections de bogues. cette version comprend&#160;23 tickets focalisés sur les performances,&#160;21 sur l’accessibilité et&#160;12 sur la modernisation du code et la conformité aux standards de code. Les modifications de 6.7 s’étalent sur&#160;38 composants du cœur du [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:28124:\"\n<figure class=\"wp-block-image alignfull size-large is-style-serif wp-elements-f590cfee42cfa860d05ec74ddea8b4ef\" style=\"background:linear-gradient(135deg,rgb(7,125,194) 0%,rgb(134,54,209) 100%)\"><a href=\"https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques.png\"><img fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"515\" src=\"https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-1024x515.png\" alt=\"\" class=\"wp-image-3244\" srcset=\"https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-1024x515.png 1024w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-300x151.png 300w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-768x386.png 768w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-1536x772.png 1536w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-2048x1029.png 2048w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>WordPress 6.7 comprend la résolution de plus de&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=status&amp;col=owner&amp;col=type&amp;col=priority&amp;col=milestone&amp;order=priority\">300 tickets sur Trac</a>, dont&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">87 améliorations et nouvelles fonctionnalités</a>, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">plus de 200 corrections de bogues</a>. cette version comprend&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~performance&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">23 tickets focalisés sur les performances</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~accessibility&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">21 sur l’accessibilité</a> et&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~coding-standards&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">12 sur la modernisation du code et la conformité aux standards de code</a>. Les modifications de 6.7 s’étalent sur&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.7&amp;group=component&amp;max=9999&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">38 composants du cœur du CMS</a>.</p>\n\n\n\n<p>Cette version comprend aussi <a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.6%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.7%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.8%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.9%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.0%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.1%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.2%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.3%22%20\">445 améliorations</a>,&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.6%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.7%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.8%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.9%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.0%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.1%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.2%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.3%22%20\">464 corrections de bogues</a> et&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.6%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.7%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.8%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.9%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.0%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.1%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.2%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.3%22%20\">55 améliorations d’accessibilité</a>&nbsp;sur l’éditeur (projet Gutenberg).</p>\n\n\n\n<p class=\"is-style-serif has-white-color has-text-color has-background has-link-color wp-elements-ca39a6cbb68f24eb2fca5cc30331b23f\" style=\"background:linear-gradient(135deg,rgb(7,125,194) 0%,rgb(134,54,209) 100%)\">Ce guide décrit les principaux changements techniques que vous trouverez sur WordPress&nbsp;6.7, dont la sortie est prévue le 12 novembre 2024.</p>\n\n\n\n<p>Tous les liens de cet article pointent vers des notes de développement rédigées en anglais. L’objectif est de fournir un panorama général des changements techniques apportés par cette version, en français, puis de diriger les personnes qui souhaitent en savoir plus vers les notes de développement en anglais.</p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/6-7/\">Pour en savoir plus sur la feuille de route et le calendrier de sortie de WP&nbsp;6.7, consultez cette page.</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"Block-Editor\">Changements concernant l’éditeur et le projet Gutenberg</h2>\n\n\n\n<p>WordPress 6.7 implémente 8 versions de Gutenberg &#8211; <a href=\"https://make.wordpress.org/core/2024/06/20/whats-new-in-gutenberg-18-6/\">18.6</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/07/04/whats-new-in-gutenberg-18-7-03-july/\">18.7</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/07/17/whats-new-in-gutenberg-18-8-17-july/\">18.8</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/07/31/whats-new-in-gutenberg-18-9-31-july/#:~:text=In%20a%20recurring%20effort%20to,Links%2C%20and%20Term%20Description%20blocks.\">18.9</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/08/14/whats-new-in-gutenberg-19-0-14-august/\">19.0</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/08/28/whats-new-in-gutenberg-19-1-28-august/\">19.1</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/09/12/what-is-new-in-gutenberg-19-2-11-september/\">19.2</a> et&nbsp;<a href=\"https://make.wordpress.org/core/2024/09/25/whats-new-in-gutenberg-19-3-25-september/\">19.3</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Changements techniques</h3>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"uMdKNlBoCL\"><a href=\"https://make.wordpress.org/core/2024/10/18/post-editor-iframing-with-meta-boxes-in-wordpress-6-7/\">Post Editor iframing with meta boxes in WordPress 6.7</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Post Editor iframing with meta boxes in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/post-editor-iframing-with-meta-boxes-in-wordpress-6-7/embed/#?secret=qmaY5pXzTl#?secret=uMdKNlBoCL\" data-secret=\"uMdKNlBoCL\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"WgyaZOCHrA\"><a href=\"https://make.wordpress.org/core/2024/10/21/block-bindings-improvements-to-the-editor-experience-in-6-7/\">Block Bindings: Improvements to the Editor Experience in 6.7</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Block Bindings: Improvements to the Editor Experience in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/21/block-bindings-improvements-to-the-editor-experience-in-6-7/embed/#?secret=vZmeFCPHik#?secret=WgyaZOCHrA\" data-secret=\"WgyaZOCHrA\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"eMYoPzBbo4\"><a href=\"https://make.wordpress.org/core/2024/10/21/updates-to-block-hooks-in-wordpress-6-7/\">Updates to Block Hooks in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to Block Hooks in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/21/updates-to-block-hooks-in-wordpress-6-7/embed/#?secret=GWcYXO1duD#?secret=eMYoPzBbo4\" data-secret=\"eMYoPzBbo4\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"NPZA5TJPdn\"><a href=\"https://make.wordpress.org/core/2024/10/18/editor-components-updates-in-wordpress-6-7/\">Updates to user-interface components in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to user-interface components in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/editor-components-updates-in-wordpress-6-7/embed/#?secret=7xhnb18OOq#?secret=NPZA5TJPdn\" data-secret=\"NPZA5TJPdn\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"react\">Changements concernant les outils de design dans l’éditeur</h3>\n\n\n\n<p>Nous avons poursuivi l’effort de consolidation des outils de design et plusieurs blocs prennent désormais en charge davantage de fonctionnalités de mise en page et de mise en forme.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"KJzsYABs6e\"><a href=\"https://make.wordpress.org/core/2024/10/17/roster-of-design-tools-per-block-wordpress-6-6-edition-2/\">Roster of design tools per block (WordPress 6.7 edition)</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Roster of design tools per block (WordPress 6.7 edition)&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/17/roster-of-design-tools-per-block-wordpress-6-6-edition-2/embed/#?secret=bU509N5zTq#?secret=KJzsYABs6e\" data-secret=\"KJzsYABs6e\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"miscellaneous-block-editor-changes\">Autres modifications concernant l’éditeur</h3>\n\n\n\n<p>D&rsquo;autres modifications diverses ont été listées dans des notes de développement dédiées&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"cgYDsB9BeF\"><a href=\"https://make.wordpress.org/core/2024/10/18/extending-the-preview-dropdown-menu-in-wordpress-6-7/\">Extending the Preview Dropdown Menu in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Extending the Preview Dropdown Menu in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/extending-the-preview-dropdown-menu-in-wordpress-6-7/embed/#?secret=ahd0C4rIgD#?secret=cgYDsB9BeF\" data-secret=\"cgYDsB9BeF\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"7mDUijDFk2\"><a href=\"https://make.wordpress.org/core/2024/10/20/miscellaneous-block-editor-changes-in-wordpress-6-7/\">Miscellaneous Block Editor Changes in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous Block Editor Changes in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/20/miscellaneous-block-editor-changes-in-wordpress-6-7/embed/#?secret=AVDYRuiEbq#?secret=7mDUijDFk2\" data-secret=\"7mDUijDFk2\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">API de gestion des interactions et modules de script</h2>\n\n\n\n<p>WordPress 6.7 comprend des mises à jour de l’API <code>Interactivity</code>, comme par exemple une nouvelle façon d’interagir avec les changements d’état côté serveur dans la navigation côté client. Les mises à jour des modules <code>Script</code>s comprennent des améliorations du chargement des scripts existants en tant que dépendances.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"mwSy0wULCz\"><a href=\"https://make.wordpress.org/core/2024/10/15/subscribe-to-changes-in-the-interactivity-api-state-and-context-on-client-side-navigation-in-6-7/\">Subscribe to changes in the Interactivity API state and context on client-side navigation in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Subscribe to changes in the Interactivity API state and context on client-side navigation in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/15/subscribe-to-changes-in-the-interactivity-api-state-and-context-on-client-side-navigation-in-6-7/embed/#?secret=3hQMOVXqfJ#?secret=mwSy0wULCz\" data-secret=\"mwSy0wULCz\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"5G0bvIkW0h\"><a href=\"https://make.wordpress.org/core/2024/10/14/updates-to-script-modules-in-6-7/\">Updates to Script Modules in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to Script Modules in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/14/updates-to-script-modules-in-6-7/embed/#?secret=1xRq1veJ2v#?secret=5G0bvIkW0h\" data-secret=\"5G0bvIkW0h\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"html-api\">API HTML</h2>\n\n\n\n<p>WordPress 6.7 comprend plusieurs mises à jour de l&rsquo;API <code>HTML</code>. Plusieurs fonctionnalités majeures sont sorties ainsi qu&rsquo;un amélioration conséquente de l&rsquo;utilisabilité du processeur HTML.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"NYzaXUkHI3\"><a href=\"https://make.wordpress.org/core/2024/10/17/updates-to-the-html-api-in-6-7/\">Updates to the HTML API in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to the HTML API in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/17/updates-to-the-html-api-in-6-7/embed/#?secret=iEwkK7OKSw#?secret=NYzaXUkHI3\" data-secret=\"NYzaXUkHI3\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"i18n\">Internationalisation</h2>\n\n\n\n<p><a href=\"https://core.trac.wordpress.org/query?component=I18N&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">Diverses améliorations de l&rsquo;internationalisation</a> sont disponibles avec WordPress 6.7&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"DP8l0CiCdI\"><a href=\"https://make.wordpress.org/core/2024/10/21/i18n-improvements-6-7/\">Internationalization improvements in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Internationalization improvements in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/21/i18n-improvements-6-7/embed/#?secret=MCSsLcKVNl#?secret=DP8l0CiCdI\" data-secret=\"DP8l0CiCdI\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"performance\">Performances</h2>\n\n\n\n<p>WordPress 6.7 apporte aussi plusieurs améliorations focalisées sur les performances, telles qu&rsquo;une nouvelle façon de déclarer les blocs utilisant des fichiers PHP générés pour contrecarrer les goulots d&rsquo;étranglement liés au chargement et au parcours des fichiers JSON.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"LiMcRNquOr\"><a href=\"https://make.wordpress.org/core/2024/10/17/new-block-type-registration-apis-to-improve-performance-in-wordpress-6-7/\">New block type registration APIs to improve performance in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New block type registration APIs to improve performance in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/17/new-block-type-registration-apis-to-improve-performance-in-wordpress-6-7/embed/#?secret=2au4COS7ru#?secret=LiMcRNquOr\" data-secret=\"LiMcRNquOr\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"741P7G7pRI\"><a href=\"https://make.wordpress.org/core/2024/10/18/auto-sizes-for-lazy-loaded-images-in-wordpress-6-7/\">Auto Sizes for Lazy Loaded Images in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Auto Sizes for Lazy Loaded Images in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/auto-sizes-for-lazy-loaded-images-in-wordpress-6-7/embed/#?secret=jrG82zsmtK#?secret=741P7G7pRI\" data-secret=\"741P7G7pRI\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"miscellaneous-developer-changes\">Autres changements techniques</h2>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"jPhUPBY0Od\"><a href=\"https://make.wordpress.org/core/2024/10/20/new-plugin-template-registration-api-in-wordpress-6-7/\">New Plugin Template Registration API in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New Plugin Template Registration API in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/20/new-plugin-template-registration-api-in-wordpress-6-7/embed/#?secret=yPPthJgGpb#?secret=jPhUPBY0Od\" data-secret=\"jPhUPBY0Od\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"IH9C1mVH4S\"><a href=\"https://make.wordpress.org/core/2024/08/15/automatic-conversion-of-heic-images-to-jpeg-in-wordpress-6-7/\">Automatic conversion of HEIC images to JPEG in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Automatic conversion of HEIC images to JPEG in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/08/15/automatic-conversion-of-heic-images-to-jpeg-in-wordpress-6-7/embed/#?secret=EpH55CK7AE#?secret=IH9C1mVH4S\" data-secret=\"IH9C1mVH4S\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"other-updates\">Nouvelles fonctions, crochets, filtres, classes et méthodes</h2>\n\n\n\n<p>Pour obtenir la liste de toutes les nouvelles fonctions, crochets, filtres, classes et méthodes, vous pourrez vous rendre – une fois que WP 6.7 sera sortie – sur cette page&nbsp;: <a href=\"https://developer.wordpress.org/reference/since/6.7.0/\">https://developer.wordpress.org/reference/since/6.7.0/</a>.</p>\n\n\n\n<div class=\"wp-block-group alignfull is-layout-flow wp-block-group-is-layout-flow\">\n<p class=\"is-style-serif has-white-color has-text-color has-background has-link-color wp-elements-87f312e26bd4a386f9cdeec66ae58d52\" style=\"background:linear-gradient(135deg,rgb(7,125,194) 0%,rgb(134,54,209) 100%)\">Que vous développiez des thèmes ou des extensions, pensez à tester et retester votre code pour vous assurer de sa compatibilité avec ces changements.<br><br>Vous pouvez utiliser <a href=\"https://fr.wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\" rel=\"noreferrer noopener\">l’extension « <em><bdo lang=\"en\" dir=\"ltr\">Beta Tester</bdo></em> »</a> sur un site de test pour vérifier la compatibilité de vos développements avec la <a href=\"https://wordpress.org/news/2024/10/wordpress-6-7-release-candidate-1/\">version <em><bdo lang=\"en\" dir=\"ltr\">release candidate</bdo></em> de WordPress 6.7</a>. <br>Vous pouvez aussi tester cette nouvelle version directement dans votre navigateur en utilisant <em><a href=\"https://playground.wordpress.net/#%7B%20%22preferredVersions%22:%20%7B%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20%7D,%20%22features%22:%20%7B%20%22networking%22:%20true%20%7D,%20%22steps%22:%20[%20%7B%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20%7D,%20%22options%22:%20%7B%20%22activate%22:%20false%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D%20]%20%7D\"><bdo lang=\"en\" dir=\"ltr\">WordPress Playground</bdo></a></em>.<br><br>Nous comptons sur vous pour vérifier que votre code fonctionne correctement avec le cœur du CMS, pour le bien des millions d’utilisateurs et utilisatrices de WordPress <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n</div>\n\n\n\n<p class=\"has-small-font-size\">Ce guide a été traduit et réadapté à partir du <a href=\"https://make.wordpress.org/core/2024/10/23/wordpress-6-7-field-guide/\">Field Guide de WP 6.7 (en anglais)</a> par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>.<br>Merci à <a href=\"https://profiles.wordpress.org/fxbenard/\">FX Benard</a> et <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> pour leur relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3243\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:66:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"Nouveau programme de mentorat pour la contribution à WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"https://fr.wordpress.org/2024/08/21/nouveau-programme-de-mentorat-pour-la-contribution-a-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Aug 2024 09:34:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:10:\"Contribuer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:13:\"Documentation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:10:\"Traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:18:\"mentorship program\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3204\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:389:\"Le 7 octobre 2024, un nouveau programme de mentorat pour la contribution à WordPress ou « WordPress Contributor Mentorship » va débuter pour une durée de 6 semaines, il s’achèvera donc avec la sortie de la version 6.7 mi-novembre. Mais c’est quoi exactement ce programme&#160;? Il s’agit du troisième programme organisé par l’équipe Community afin de faciliter [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jenny Dupuy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6506:\"\n<p>Le 7 octobre 2024, un nouveau programme de mentorat pour la contribution à WordPress ou « WordPress Contributor Mentorship » va débuter pour une durée de 6 semaines, il s’achèvera donc avec la sortie de la version 6.7 mi-novembre.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Mais c’est quoi exactement ce programme&nbsp;?</h2>\n\n\n\n<p>Il s’agit du troisième programme organisé par l’équipe <a href=\"https://make.wordpress.org/community/\">Community</a> afin de faciliter l’intégration de nouvelles personnes aux <a href=\"https://make.wordpress.org/\">diverses équipe de contribution</a>.</p>\n\n\n\n<p>Ce programme met en place de petites équipes avec un mentor et des mentoré·e·s qui travaillent ensemble sur un projet proposé par le mentor lors de sa candidature.</p>\n\n\n\n<p>Les organisateurs répartissent donc les contributeurs/contributrices selon les souhaits qu&rsquo;ils/elles ont définis lors de leur candidature.</p>\n\n\n\n<p>Tout au long du programme, le/la mentor prend en charge l&rsquo;équipe de mentoré·e·s pour avancer le projet qu&rsquo;il/elle a proposé, et quelques réunions en visio sont proposées par les organisateurs.</p>\n\n\n\n<p>Si vous souhaitez débuter la contribution à WordPress mais ne savez pas comment, ni par où commencer, alors ce programme est parfait pour vous en tant que mentoré·e.&nbsp; Vous serez guidé·e tout au long du programme par des mentors et pourrez ainsi obtenir toutes les informations nécessaires à une contribution efficace.<br>Et si vous contribuez déjà et souhaitez transmettre vos connaissances à d’autres personnes alors participez au programme en tant que mentor ! Ce sera l’occasion d’accueillir de nouvelles personnes dans vos équipes respectives.</p>\n\n\n\n<p>Cette cohorte est synchronisée avec la sortie de la version 6.7 afin de permettre aux participants, qui rejoignent l’équipe Core ou celle du développement du thème Twenty Twenty-Five, de contribuer spécifiquement à cette version de WordPress. Mais, la contribution à WordPress ne se résumant pas à son code, vous avez aussi l’opportunité de rejoindre des équipes de contribution non liées au code telles que Communauté (organisation d’évènements et encadrement des équipes), Design, Documentation, Formation, etc.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Qui peut candidater ?</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Pour les mentoré·e·s : toute personne souhaitant débuter la contribution à WordPress, ou encore contribuer à d’autres équipes que celle(s) où il/elle contribue déjà.</li>\n\n\n\n<li>Pour les mentors : toute personne ayant déjà un peu d’expérience dans la contribution WordPress.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Comment rejoindre le programme ?</h2>\n\n\n\n<p>Pour rejoindre le programme, il faut remplir un petit formulaire :</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://docs.google.com/forms/d/e/1FAIpQLSd6faivlMZzyiq1sx_78fvnw7-JOshZMZcIO6BTp-B7TuM2ww/viewform\" target=\"_blank\" rel=\"noreferrer noopener\">Candidater en tant que mentoré·e</a></div>\n\n\n\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://docs.google.com/forms/d/e/1FAIpQLSfDzRRrIDJcQcVF0m3I16-RfwrjmXBHboxCC5Rx0OHatK_EBQ/viewform\" target=\"_blank\" rel=\"noreferrer noopener\">Candidater en tant que mentor</a></div>\n</div>\n\n\n\n<p>Mais <strong>attention date limite des candidatures</strong> : </p>\n\n\n\n<p class=\"has-text-align-center has-light-grey-2-color has-vivid-red-background-color has-text-color has-background has-link-color wp-elements-18846e5805f4ed69ba3dc19961036bd1\" style=\"margin-top:var(--wp--preset--spacing--10);margin-right:var(--wp--preset--spacing--10);margin-bottom:var(--wp--preset--spacing--10);margin-left:var(--wp--preset--spacing--10);padding-top:var(--wp--preset--spacing--10);padding-right:var(--wp--preset--spacing--10);padding-bottom:var(--wp--preset--spacing--10);padding-left:var(--wp--preset--spacing--10)\">le 26 août 2024</p>\n\n\n\n<p>Vous serez ensuite recontacté·e.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Contribuer dans votre langue</h2>\n\n\n\n<p>Ce 3<sup>e</sup> programme propose une nouveauté : selon le projet auquel vous participerez, vous aurez peut être l’opportunité de contribuer en français, puisque des équipes par locale vont être constituées.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Plus d&rsquo;informations</h2>\n\n\n\n<p>Retrouvez plus d&rsquo;informations sur le programme dans cet article (en anglais) :</p>\n\n\n\n<figure class=\"wp-block-embed aligncenter is-type-wp-embed is-provider-wordpress-org-project wp-block-embed-wordpress-org-project\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"TOusFk6YKX\"><a href=\"https://make.wordpress.org/project/2024/08/16/wordpress-contributor-mentorship-program-cohort-3-2024-q4-call-for-mentees-mentors/\">WordPress Contributor Mentorship Program Cohort #3 (2024 Q4): Call for Mentees &amp; Mentors</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;WordPress Contributor Mentorship Program Cohort #3 (2024 Q4): Call for Mentees &amp; Mentors&#8221; &#8212; WordPress.org Project\" src=\"https://make.wordpress.org/project/2024/08/16/wordpress-contributor-mentorship-program-cohort-3-2024-q4-call-for-mentees-mentors/embed/#?secret=93CdKWMRfW#?secret=TOusFk6YKX\" data-secret=\"TOusFk6YKX\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p class=\"has-text-align-center has-light-grey-2-color has-purple-2-background-color has-text-color has-background has-link-color has-extra-large-font-size wp-elements-ce3e97f8976a3a3f44d47b605fc66a4f\" style=\"margin-top:var(--wp--preset--spacing--30);margin-right:var(--wp--preset--spacing--30);margin-bottom:var(--wp--preset--spacing--30);margin-left:var(--wp--preset--spacing--30);padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)\">On compte sur vous pour vous inscrire nombreux et nombreuses à ce programme !<br>Si vous n’avez jamais contribué c’est l’occasion rêvée de commencer, si vous contribuez déjà et souhaitez rejoindre de nouvelles équipes ce programme est fait pour vous !</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3204\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"WordPress 6.6 « Dorsey »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://fr.wordpress.org/2024/07/16/wordpress-6-6-dorsey/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 16 Jul 2024 17:40:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3181\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:408:\"Nous avons le plaisir de vous présenter WordPress&#160;6.6 «&#160;Dorsey&#160;», version nommée en l&#8217;honneur du légendaire leader de big band américain Tommy Dorsey. Reconnu pour son timbre de trombone et pour ses compositions, la musique de Dorsey envoûte son audience grâce à sa profondeur émotionnelle et son énergie. Écoutez la musique du Dorsey’s Big Band tandis que vous [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:68929:\"\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2024/07/dorsey.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"680\" src=\"https://fr.wordpress.org/files/2024/07/dorsey-1024x680.png\" alt=\"\" class=\"wp-image-3199\" srcset=\"https://fr.wordpress.org/files/2024/07/dorsey-1024x680.png 1024w, https://fr.wordpress.org/files/2024/07/dorsey-300x199.png 300w, https://fr.wordpress.org/files/2024/07/dorsey-768x510.png 768w, https://fr.wordpress.org/files/2024/07/dorsey-1536x1021.png 1536w, https://fr.wordpress.org/files/2024/07/dorsey-2048x1361.png 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>Nous avons le plaisir de vous présenter WordPress&nbsp;6.6 «&nbsp;Dorsey&nbsp;», version nommée en l&rsquo;honneur du légendaire <bdo lang=\"en\" dir=\"ltr\">leader</bdo> de <bdo lang=\"en\" dir=\"ltr\">big band</bdo> américain Tommy Dorsey. Reconnu pour son timbre de trombone et pour ses compositions, la musique de Dorsey envoûte son audience grâce à sa profondeur émotionnelle et son énergie.</p>\n\n\n\n<p>Écoutez la musique du <a href=\"https://open.spotify.com/playlist/37i9dQZF1DZ06evO2TT3Ge?si=d9872e46371c4ed7\" target=\"_blank\" rel=\"noreferrer noopener\"><bdo lang=\"en\" dir=\"ltr\">Dorsey’s Big Band</bdo></a> tandis que vous découvrirez les nouvelles fonctionnalités et les améliorations de WordPress 6.6.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Bienvenue à 6.6&nbsp;!</h2>\n\n\n\n<p>WordPress 6.6 répond à la promesse d’un web meilleur en ajoutant de nouveaux outils pour améliorer le quotidien des créateurs de contenus, des sites les plus complexes aux sites «&nbsp;<bdo lang=\"en\" dir=\"ltr\">one page</bdo>&nbsp;». Sans jamais mettre de côté la sécurité, la stabilité ou les performances, WordPress 6.6 apporte de nouveaux outils et améliore les flux de rédaction déjà en place.</p>\n\n\n\n<p>Une nouvelle fonctionnalité de restauration pour les mises à jour automatiques des extensions vous offre quant à elle sécurité, flexibilité et sérénité.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://fr.wordpress.org/download/\">Téléchargez WordPress 6.6 «&nbsp;Dorsey&nbsp;»</a></div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Palettes de couleurs et ensembles de polices</h3>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-1 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:33.33%\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.6/color-palettes.webp\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:66.66%\">\n<p><strong>Ajout de davantage d’options de conception aux thèmes basés sur des blocs.</strong>&nbsp;Les auteur·ices de thèmes basés sur les blocs peuvent créer un nombre illimité de palettes de couleurs ou de polices personnalisées pour offrir des options graphiques plus spécifiques au sein du même thème. Ces palettes offrent des possibilités graphiques plus harmonisées, permettant une personnalisation sans modifier le style global du site, au-delà des paramètres de couleur ou de typographie.</p>\n</div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Aperçu rapide des pages</h3>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-2 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:33.33%\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.6/page-previews.webp\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:66.66%\">\n<p><strong>Simplifiez votre flux de travail avec une nouvelle mise en page conçue pour les pages.</strong>&nbsp;Découvrez toutes vos pages et un aperçu de n’importe quelle page sélectionnée avant de la modifier via une nouvelle mise en page dans l’éditeur de site.</p>\n</div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Retour en arrière pour les mises à jour automatiques d’extensions</h3>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-3 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:33.33%\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.6/feature-rollbacks.webp\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:66.66%\">\n<p><strong>Mettez à jour vos extensions en toute tranquillité.</strong>&nbsp;Bénéficiez de la facilité des mises à jour automatiques des extensions avec la possibilité de restauration en cas de problème, améliorant ainsi la sécurité de votre site tout en minimisant les risques d’indisponibilité potentielle de celui-ci.</p>\n</div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Surcharges</h3>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-4 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:33.33%\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.6/overrides.webp\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:66.66%\">\n<p><strong>Ajout de la possibilité de personnaliser les contenus dans les compositions synchronisées.</strong>&nbsp;Autoriser la personnalisation des éléments de contenu spécifiques dans chaque apparition d’une composition synchronisée tout en conservant un style uniformisé pour toutes les apparitions, simplifiant ainsi les futures mises à jour. Actuellement, vous pouvez définir des surcharges pour les blocs Titre, Paragraphe, Bouton et Image.</p>\n</div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations des performances</h3>\n\n\n\n<p>WordPress 6.6 comprend des mises à jour importantes comme le retrait d&rsquo;appels redondants vers <code>WP_Theme_JSON</code>, la désactivation du chargement automatique pour les options les plus volumétriques, la suppression de dépendances inutiles, le chargement différé des contenus embarqués, la nouvelle directive <code>data-wp-on-async</code> et une réduction de 33 % du chargement des modèles dans l&rsquo;éditeur.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations de l’accessibilité</h3>\n\n\n\n<p>Plus de 55 correctifs d’accessibilité et améliorations se concentrent sur des aspects fondamentaux de l’expérience WordPress, en particulier le composant de vue de données qui alimente la nouvelle expérience de modification de site et des domaines comme l’outil d’insertion qui fournit un moyen-clé d’interagir avec les blocs et les compositions.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Et bien plus encore</h3>\n\n\n\n<p>Pour une vision complète de toutes les nouvelles fonctionnalités et améliorations de WordPress 6.6, vous pouvez consulter le site de démonstration des fonctionnalités.</p>\n\n\n\n<p><a href=\"https://fr.wordpress.org/download/releases/6-6/\">Découvrez toutes les nouveautés</a></p>\n\n\n\n<h3 class=\"wp-block-heading\">En savoir plus sur WordPress 6.6</h3>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\"><em>Learn WordPress</em></a>&nbsp;est une ressource gratuite pour les personnes qui utilisent WordPress, qu’elles soient débutantes ou expérimentées.&nbsp;<em>Learn</em>&nbsp;contient des vidéos pratiques sur l’utilisation de diverses fonctionnalités de WordPress, des&nbsp;<a href=\"https://learn.wordpress.org/online-workshops/\">évènements interactifs</a>&nbsp;pour explorer des sujets en profondeur, et des plans de cours pour approfondir des domaines spécifiques de WordPress.</p>\n\n\n\n<p>Explorez le&nbsp;<a href=\"https://fr.wordpress.org/2024/06/27/guide-des-changements-techniques-de-wordpress-6-6/\">Guide des changements techniques de WordPress 6.6</a>. Découvrez les changements de cette version avec les notes détaillées des développeurs et développeuses qui vous aident à construire avec WordPress.</p>\n\n\n\n<p><a href=\"https://wordpress.org/support/wordpress-version/version-6-6/\">Lisez les notes de version de WordPress 6.6</a>&nbsp;pour obtenir des informations sur l’installation, les améliorations, les problèmes corrigés, les contributeurs et contributrices de la version, les ressources d’apprentissage et la liste des modifications apportées aux fichiers.</p>\n\n\n\n<h2 class=\"wp-block-heading\">L’équipe de direction de WordPress&nbsp;6.6</h2>\n\n\n\n<p>Voici l’équipe qui a coordonné le développement et la sortie de cette nouvelle version de WordPress&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Direction générale&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Coordination générale&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a></li>\n\n\n\n<li>Direction technique côté Cœur&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a></li>\n\n\n\n<li>Direction technique côté Gutenberg&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a>,&nbsp;<a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a></li>\n\n\n\n<li>Gestion de projet technique côté Cœur&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a>,&nbsp;<a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a></li>\n\n\n\n<li>Gestion de projet technique côté Gutenberg&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a>&nbsp;</li>\n\n\n\n<li>Responsables de la documentation&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/josepmoran/\">Josep Morán</a></li>\n\n\n\n<li>Direction marketing et communication&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a></li>\n\n\n\n<li>Direction artistique : <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a></li>\n\n\n\n<li>Responsable des performances&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a></li>\n\n\n\n<li>Responsables des tests&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a>,&nbsp;<a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a>&nbsp;et&nbsp;<a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a></li>\n\n\n\n<li>Responsable des thèmes natifs&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux contributeurs et contributrices</h2>\n\n\n\n<p>WordPress 6.6 n’aurait pas pu sortir sans la contribution passionnée de plus de&nbsp;<strong>630 personnes provenant d’au moins 50 pays différents</strong>.</p>\n\n\n\n<p>Un remerciement tout spécial pour les plus de 150 personnes qui ont contribué au cœur de WordPress pour la première fois avec WP&nbsp;6.6 <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p style=\"font-size:10px\"><a href=\"https://profiles.wordpress.org/benniledl/\">!Benni</a> · <a href=\"https://profiles.wordpress.org/_ck_/\">_ck_</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/abmamun007/\">Abdullah Mamun</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/fitehal/\">Abhishek Deshpande</a> · <a href=\"https://profiles.wordpress.org/abletec/\">abletec</a> · <a href=\"https://profiles.wordpress.org/acosmin/\">acosmin</a> · <a href=\"https://profiles.wordpress.org/adampickering/\">Adam Pickering</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/adarshposimyth/\">Adarsh Akshat</a> · <a href=\"https://profiles.wordpress.org/ajmcfadyen/\">admcfajn</a> · <a href=\"https://profiles.wordpress.org/adrianduffell/\">adrianduffell</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/ajithrn/\">Ajith R N</a> · <a href=\"https://profiles.wordpress.org/skyakash12/\">Akash Muchandikar</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/akmelias/\">akmelias</a> · <a href=\"https://profiles.wordpress.org/wpfy/\">Akramul Hasan</a> · <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a> · <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a> · <a href=\"https://profiles.wordpress.org/alanfuller/\">Alan Fuller</a> · <a href=\"https://profiles.wordpress.org/ahoereth/\">Alex</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/alexkingorg/\">Alex King</a> · <a href=\"https://profiles.wordpress.org/akirk/\">Alex Kirk</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/viper007bond/\">Alex Mills</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/alexanderkoledov/\">AlexKole</a> · <a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a> · <a href=\"https://profiles.wordpress.org/sabreuse/\">Amy Hendrix (sabreuse)</a> · <a href=\"https://profiles.wordpress.org/amykamala/\">Amy Kamala</a> · <a href=\"https://profiles.wordpress.org/anandau14/\">Anand Upadhyay</a> · <a href=\"https://profiles.wordpress.org/anlino/\">Anders Norén</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/andrewhayward/\">Andrew Hayward</a> · <a href=\"https://profiles.wordpress.org/l1nuxjedi/\">Andrew Hutchings</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/norcross/\">Andrew Norcross</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/andrewleap/\">andrewleap</a> · <a href=\"https://profiles.wordpress.org/andbalashov/\">Andrii Balashov</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/apeatling/\">Andy Peatling</a> · <a href=\"https://profiles.wordpress.org/aneeshd16/\">Aneesh Devasthale</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ant1busted/\">Antoine</a> · <a href=\"https://profiles.wordpress.org/antonlukin/\">Anton Lukin</a> · <a href=\"https://profiles.wordpress.org/atimmer/\">Anton Timmermans</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/lighthouse79/\">Antonella</a> · <a href=\"https://profiles.wordpress.org/colomet/\">Antonio D.</a> · <a href=\"https://profiles.wordpress.org/antonisme/\">Antonis Lilis</a> · <a href=\"https://profiles.wordpress.org/arena94/\">arena94</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/passoniate/\">Arslan Kalwar</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/iamarunchaitanyajami/\">Arun Chaitanya Jami</a> · <a href=\"https://profiles.wordpress.org/dextorlobo/\">Arun Sharma</a> · <a href=\"https://profiles.wordpress.org/ideag/\">Arunas Liuiza</a> · <a href=\"https://profiles.wordpress.org/iamasadpolash/\">Asad Polash</a> · <a href=\"https://profiles.wordpress.org/ashfame/\">Ashish Kumar (Ashfame)</a> · <a href=\"https://profiles.wordpress.org/mohonchandra/\">Asish Chandra Mohon</a> · <a href=\"https://profiles.wordpress.org/aslamdoctor/\">Aslam Doctor</a> · <a href=\"https://profiles.wordpress.org/audunmb/\">audunmb</a> · <a href=\"https://profiles.wordpress.org/aurooba/\">Aurooba Ahmed</a> · <a href=\"https://profiles.wordpress.org/filosofo/\">Austin Matzko</a> · <a href=\"https://profiles.wordpress.org/axwax/\">axwax</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> · <a href=\"https://profiles.wordpress.org/bahia0019/\">bahia0019</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/bangank36/\">bangank36</a> · <a href=\"https://profiles.wordpress.org/barry/\">Barry</a> · <a href=\"https://profiles.wordpress.org/barryhughes-1/\">Barry</a> · <a href=\"https://profiles.wordpress.org/bartkalisz/\">Bart Kalisz</a> · <a href=\"https://profiles.wordpress.org/bartkleinreesink/\">bartkleinreesink</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/beaulebens/\">Beau Lebens</a> · <a href=\"https://profiles.wordpress.org/bedas/\">Beda</a> · <a href=\"https://profiles.wordpress.org/benharri/\">ben</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/ubernaut/\">Ben Hansen</a> · <a href=\"https://profiles.wordpress.org/husobj/\">Ben Huson</a> · <a href=\"https://profiles.wordpress.org/benlk/\">Ben Keith</a> · <a href=\"https://profiles.wordpress.org/blobaugh/\">Ben Lobaugh (blobaugh)</a> · <a href=\"https://profiles.wordpress.org/britner/\">Ben Ritner – Kadence WP</a> · <a href=\"https://profiles.wordpress.org/retlehs/\">Ben Word</a> · <a href=\"https://profiles.wordpress.org/benjamingosset/\">Benjamin Gosset</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benjaminknox/\">benjaminknox</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/benoitfouc/\">benoitfouc</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/billseymour/\">billseymour</a> · <a href=\"https://profiles.wordpress.org/bplv/\">Biplav</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/bobbingwide/\">bobbingwide</a> · <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a> · <a href=\"https://profiles.wordpress.org/born2webdesign/\">born2webdesign</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradparbs/\">Brad Parbs</a> · <a href=\"https://profiles.wordpress.org/williamsba1/\">Brad Williams</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/drrobotnik/\">Brandon Lavigne</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/fischfood/\">Brian Fischer</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a> · <a href=\"https://profiles.wordpress.org/brianhenryie/\">Brian Henry</a> · <a href=\"https://profiles.wordpress.org/brookemk/\">Brooke</a> · <a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a> · <a href=\"https://profiles.wordpress.org/icaleb/\">Caleb Burks</a> · <a href=\"https://profiles.wordpress.org/ecc/\">camya</a> · <a href=\"https://profiles.wordpress.org/karl94/\">Carlo Cannas</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/cenkdemir/\">cenkdemir</a> · <a href=\"https://profiles.wordpress.org/cfinnberg/\">cfinnberg</a> · <a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a> · <a href=\"https://profiles.wordpress.org/chasedsiedu/\">chased@si.edu</a> · <a href=\"https://profiles.wordpress.org/mel_cha/\">chiilog (Chiaki Okamoto)</a> · <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a> · <a href=\"https://profiles.wordpress.org/chrisdavidmiles/\">Chris David Miles</a> · <a href=\"https://profiles.wordpress.org/jazzs3quence/\">Chris Reynolds</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/itschristiandale/\">christian-dale</a> · <a href=\"https://profiles.wordpress.org/christopherplus/\">Christopher</a> · <a href=\"https://profiles.wordpress.org/chrystl/\">Chrystl</a> · <a href=\"https://profiles.wordpress.org/codepo8/\">codepo8</a> · <a href=\"https://profiles.wordpress.org/cdevroe/\">Colin Devroe</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/colind/\">ColinD</a> · <a href=\"https://profiles.wordpress.org/cookiesfordevo/\">CookiesForDevo</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/creativeslice/\">Creative Slice</a> · <a href=\"https://profiles.wordpress.org/crstauf/\">crstauf</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/cvorko/\">cvorko</a> · <a href=\"https://profiles.wordpress.org/didierjm/\">cybeardjm</a> · <a href=\"https://profiles.wordpress.org/cyberchicken/\">Cyberchicken</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/mzaweb/\">Daniel Dvorkin</a> · <a href=\"https://profiles.wordpress.org/mapumba/\">Daniel Käfer</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/schutzsmith/\">Daniel Schutzsmith</a> · <a href=\"https://profiles.wordpress.org/danieldudzic/\">danieldudzic</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/danieltj/\">danieltj</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/darssen/\">darssen</a> · <a href=\"https://profiles.wordpress.org/davecpage/\">Dave Page</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">David Arenas</a> · <a href=\"https://profiles.wordpress.org/dartiss/\">David Artiss</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/dglingren/\">David Lingren</a> · <a href=\"https://profiles.wordpress.org/davidperez/\">David Perez</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/denis-de-bernardy/\">Denis de Bernardy</a> · <a href=\"https://profiles.wordpress.org/dingo_d/\">Denis Žoljom</a> · <a href=\"https://profiles.wordpress.org/dionysous/\">Dennis Hipp</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dennysdionigi/\">Dennys Dionigi</a> · <a href=\"https://profiles.wordpress.org/derekblank/\">Derek Blank</a> · <a href=\"https://profiles.wordpress.org/valendesigns/\">Derek Herman</a> · <a href=\"https://profiles.wordpress.org/derekspringer/\">Derek Springer</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/desrosjbot/\">Desrosj Bot</a> · <a href=\"https://profiles.wordpress.org/dernin/\">Devin Curtis</a> · <a href=\"https://profiles.wordpress.org/dlocc/\">Devin Walker</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruvishah2203/\">Dhruvi Shah</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/dougal/\">Dougal Campbell</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/lots0logs/\">Dustin Falgout</a> · <a href=\"https://profiles.wordpress.org/elrae/\">Earle Davies</a> · <a href=\"https://profiles.wordpress.org/ehtis/\">Ehtisham Siddiqui</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a> · <a href=\"https://profiles.wordpress.org/codex-m/\">Emerson Maningo</a> · <a href=\"https://profiles.wordpress.org/emirpprime/\">emirpprime</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/endymion00/\">Endymion00</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/enwikuna/\">Enwikuna</a> · <a href=\"https://profiles.wordpress.org/ericlewis/\">Eric Andrew Lewis</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a> · <a href=\"https://profiles.wordpress.org/evanltd/\">evanltd</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a> · <a href=\"https://profiles.wordpress.org/fabiorubioglio/\">Fabio Rubioglio</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisalahmed29/\">Faisal Ahmed</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fanly/\">Fanly</a> · <a href=\"https://profiles.wordpress.org/feastdesignco/\">Feast Design Co.</a> · <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/flhz/\">Florent Hernandez</a> · <a href=\"https://profiles.wordpress.org/fgiannar/\">Foteini Giannaropoulou (a11n)</a> · <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a> · <a href=\"https://profiles.wordpress.org/francescocarlucci/\">FrancescoCarlucci</a> · <a href=\"https://profiles.wordpress.org/fotodrachen/\">Frank Jäger</a> · <a href=\"https://profiles.wordpress.org/nexflaszlo/\">Frank Laszlo</a> · <a href=\"https://profiles.wordpress.org/wazeter/\">Frank Wazeter</a> · <a href=\"https://profiles.wordpress.org/fushar/\">fushar</a> · <a href=\"https://profiles.wordpress.org/gajendrasingh/\">Gajendra Singh</a> · <a href=\"https://profiles.wordpress.org/ecgan/\">Gan Eng Chin</a> · <a href=\"https://profiles.wordpress.org/garibiza/\">Garbiñe</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/gavande1/\">gavande1</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a> · <a href=\"https://profiles.wordpress.org/gerardreches/\">Gerard Reches</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/girishpanchal/\">Girish Panchal</a> · <a href=\"https://profiles.wordpress.org/giuseppemazzapica-1/\">Giuseppe Mazzapica</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/goldenapples/\">goldenapples</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/gregbenz/\">gregbenz</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/poran766/\">H.M. Mushfiqur Rahman</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hztyfoon/\">Hanzala Taifun</a> · <a href=\"https://profiles.wordpress.org/hardik2221/\">Hardik Raval</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harsh175/\">Harsh Patel</a> · <a href=\"https://profiles.wordpress.org/hasanuzzamanshamim/\">Hasanuzzaman Shamim</a> · <a href=\"https://profiles.wordpress.org/halounsbury/\">Heather Wilkins</a> · <a href=\"https://profiles.wordpress.org/muhme/\">Heiko Lübbe</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/helgatheviking/\">HelgaTheViking</a> · <a href=\"https://profiles.wordpress.org/tejwanihemant/\">Hemant Tejwani</a> · <a href=\"https://profiles.wordpress.org/kurudrive/\">Hidekazu Ishikawa</a> · <a href=\"https://profiles.wordpress.org/panchalhimani711/\">Himani Panchal</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/hiteshtalpada/\">Hitesh Talpada</a> · <a href=\"https://profiles.wordpress.org/h71/\">Hossein</a> · <a href=\"https://profiles.wordpress.org/howdy_mcgee/\">Howdy_McGee</a> · <a href=\"https://profiles.wordpress.org/hrrarya/\">Hridoy Mozumder</a> · <a href=\"https://profiles.wordpress.org/hrithikd/\">Hrithik Dalal</a> · <a href=\"https://profiles.wordpress.org/hlashbrooke/\">Hugh Lashbrooke</a> · <a href=\"https://profiles.wordpress.org/ganon/\">Hugo Chinchilla</a> · <a href=\"https://profiles.wordpress.org/hugod/\">hugod</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/ianbelanger/\">Ian Belanger</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/idad5/\">idad5</a> · <a href=\"https://profiles.wordpress.org/igmoweb/\">Ignacio Cruz Moreno</a> · <a href=\"https://profiles.wordpress.org/ignatiusjeroe/\">ignatiusjeroe</a> · <a href=\"https://profiles.wordpress.org/shaampk1/\">Ihtisham Zahoor</a> · <a href=\"https://profiles.wordpress.org/fnpen/\">Ilya Zolotov</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/iseulde/\">iseulde</a> · <a href=\"https://profiles.wordpress.org/itpathsolutions/\">IT Path Solutions</a> · <a href=\"https://profiles.wordpress.org/itecrs/\">itecrs</a> · <a href=\"https://profiles.wordpress.org/ivanzhuck/\">Ivan Zhuck</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/jadpm/\">jadpm</a> · <a href=\"https://profiles.wordpress.org/jamescollins/\">James Collins</a> · <a href=\"https://profiles.wordpress.org/macmanx/\">James Huff</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/james roberts/\">James Roberts</a> · <a href=\"https://profiles.wordpress.org/jamieblomerus/\">Jamie Blomerus</a> · <a href=\"https://profiles.wordpress.org/perrelet/\">Jamie Perrelet</a> · <a href=\"https://profiles.wordpress.org/jane/\">jane</a> · <a href=\"https://profiles.wordpress.org/whiteshadow/\">Janis Elsts</a> · <a href=\"https://profiles.wordpress.org/jsandtro/\">jansan</a> · <a href=\"https://profiles.wordpress.org/janthiel/\">janthiel</a> · <a href=\"https://profiles.wordpress.org/japh/\">Japh</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarednova/\">jarednova</a> · <a href=\"https://profiles.wordpress.org/jason_the_adams/\">Jason Adams</a> · <a href=\"https://profiles.wordpress.org/boogah/\">Jason Cosper</a> · <a href=\"https://profiles.wordpress.org/pbking/\">Jason Crist</a> · <a href=\"https://profiles.wordpress.org/coolmann/\">Jason Crouse</a> · <a href=\"https://profiles.wordpress.org/jsnjohnston/\">Jason Johnston</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/jayadevankbh/\">Jayadevan k</a> · <a href=\"https://profiles.wordpress.org/jbobich/\">jbobich</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/amieiro/\">Jesús Amieiro</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jghazally/\">jghazally</a> · <a href=\"https://profiles.wordpress.org/jipmoors/\">Jip Moors</a> · <a href=\"https://profiles.wordpress.org/jivygraphics/\">jivygraphics</a> · <a href=\"https://profiles.wordpress.org/jltallon/\">jltallon</a> · <a href=\"https://profiles.wordpress.org/joanrodas/\">Joan</a> · <a href=\"https://profiles.wordpress.org/morehawes/\">Joe</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joelcj91/\">Joel James</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnciacia/\">johnciacia</a> · <a href=\"https://profiles.wordpress.org/jb510/\">Jon Brown</a> · <a href=\"https://profiles.wordpress.org/duck_/\">Jon Cave</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/jbrinley/\">Jonathan Brinley</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/joppuyo/\">joppuyo</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/jorgevilchez/\">Jorge Vilchez</a> · <a href=\"https://profiles.wordpress.org/jornp/\">jornp</a> · <a href=\"https://profiles.wordpress.org/joefusco/\">Joseph Fusco</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a> · <a href=\"https://profiles.wordpress.org/joshcanhelp/\">joshcanhelp</a> · <a href=\"https://profiles.wordpress.org/verygoode/\">Joshua Goode</a> · <a href=\"https://profiles.wordpress.org/joshuatf/\">joshuatf</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/jrtashjian/\">JR Tashjian</a> · <a href=\"https://profiles.wordpress.org/jsmoriss/\">JS Morisset</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juhise/\">Juhi Saxena</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/ashikur698/\">K M Ashikur Rahman</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/bosskhj/\">Kamrul Hasan</a> · <a href=\"https://profiles.wordpress.org/karinclimber/\">Kari Anderson</a> · <a href=\"https://profiles.wordpress.org/karlijnbk/\">Karlijn Bok</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/tadamarketing/\">Katka</a> · <a href=\"https://profiles.wordpress.org/kawsaralameven/\">kawsaralameven</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/kbat82/\">Kevin Batdorf</a> · <a href=\"https://profiles.wordpress.org/kevincoleman/\">Kevin Coleman</a> · <a href=\"https://profiles.wordpress.org/kevinwhoffman/\">Kevin Hoffman</a> · <a href=\"https://profiles.wordpress.org/ktaron/\">Kevin Taron</a> · <a href=\"https://profiles.wordpress.org/kharisblank/\">Kharis Sulistiyono</a> · <a href=\"https://profiles.wordpress.org/khokansardar/\">Khokan Sardar</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kitchin/\">kitchin</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/koen12344/\">Koen Reus</a> · <a href=\"https://profiles.wordpress.org/koesper/\">Koesper</a> · <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/kurtpayne/\">Kurt Payne</a> · <a href=\"https://profiles.wordpress.org/kushang78/\">Kushang Tailor</a> · <a href=\"https://profiles.wordpress.org/kdowns/\">Kylen Downs</a> · <a href=\"https://profiles.wordpress.org/laumindproductscomau/\">lau@mindproducts.com.au</a> · <a href=\"https://profiles.wordpress.org/lada7042/\">Laura Adamonis</a> · <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a> · <a href=\"https://profiles.wordpress.org/wplmillet/\">Laurent MILLET</a> · <a href=\"https://profiles.wordpress.org/lakshmananphp/\">Lax Mariappan</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/munizleo/\">Leo Muniz</a> · <a href=\"https://profiles.wordpress.org/leonnugraha/\">Leonardus Nugraha</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/liammcarthur/\">LiamMcArthur</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/lkraav/\">lkraav</a> · <a href=\"https://profiles.wordpress.org/logikal16/\">logikal16</a> · <a href=\"https://profiles.wordpress.org/louiswol94/\">Louis Wolmarans</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/luboslives/\">luboslives</a> · <a href=\"https://profiles.wordpress.org/lucasbustamante/\">lucasbustamante</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">Luis Herranz</a> · <a href=\"https://profiles.wordpress.org/lpawlik/\">Lukas Pawlik</a> · <a href=\"https://profiles.wordpress.org/wpfed/\">Lukasz</a> · <a href=\"https://profiles.wordpress.org/lukefiretoss/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/maartenbelmans/\">Maarten</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/mrdollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/mhimon/\">Mahbub Hasan Imon</a> · <a href=\"https://profiles.wordpress.org/mahnewr/\">mahnewr</a> · <a href=\"https://profiles.wordpress.org/maahrokh/\">Mahrokh</a> · <a href=\"https://profiles.wordpress.org/malae/\">Malae</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manyourisms/\">manyourisms</a> · <a href=\"https://profiles.wordpress.org/marc_j/\">Marc_J</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/marcoevich/\">Marcoevich</a> · <a href=\"https://profiles.wordpress.org/margolisj/\">margolisj</a> · <a href=\"https://profiles.wordpress.org/chaton666/\">Marie Comet</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/markjaquith/\">Mark Jaquith</a> · <a href=\"https://profiles.wordpress.org/markoheijnen/\">Marko Heijnen</a> · <a href=\"https://profiles.wordpress.org/markoserb/\">Marko Ivanovic</a> · <a href=\"https://profiles.wordpress.org/flootr/\">Markus</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/mathewemoore/\">mathewemoore</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matiasrecondo77/\">matiasrecondo77</a> · <a href=\"https://profiles.wordpress.org/webdevmattcrom/\">Matt Cromwell</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/cadic/\">Max Lyuchin</a> · <a href=\"https://profiles.wordpress.org/maxpertici/\">Maxime Pertici</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/mhshohel/\">Md Hossain Shohel</a> · <a href=\"https://profiles.wordpress.org/hrshahin/\">Md HR Shahin</a> · <a href=\"https://profiles.wordpress.org/devsahadat/\">Md Sahadat Husain</a> · <a href=\"https://profiles.wordpress.org/megphillips91/\">Meg Phillips</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/melcarthus/\">melcarthus</a> · <a href=\"https://profiles.wordpress.org/meta4/\">meta4</a> · <a href=\"https://profiles.wordpress.org/metropolis_john/\">metropolis_john</a> · <a href=\"https://profiles.wordpress.org/254volkan/\">mevolkan</a> · <a href=\"https://profiles.wordpress.org/wpscholar/\">Micah Wood</a> · <a href=\"https://profiles.wordpress.org/mshowes/\">Michael Showes</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/michalooki/\">Michalooki</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/miguelsansegundo/\">miguelsansegundo</a> · <a href=\"https://profiles.wordpress.org/miikkamakela/\">Miikka</a> · <a href=\"https://profiles.wordpress.org/mbijon/\">Mike Bijon</a> · <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley (a11n)</a> · <a href=\"https://profiles.wordpress.org/mikeschinkel/\">Mike Schinkel</a> · <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a> · <a href=\"https://profiles.wordpress.org/mikinc860/\">Mikin Chauhan</a> · <a href=\"https://profiles.wordpress.org/gonzomir/\">Milen Petrinski – Gonzo</a> · <a href=\"https://profiles.wordpress.org/mimitips/\">mimi</a> · <a href=\"https://profiles.wordpress.org/illuminea/\">Miriam Schwab</a> · <a href=\"https://profiles.wordpress.org/mkismy/\">mkismy</a> · <a href=\"https://profiles.wordpress.org/mnydigital/\">mnydigital</a> · <a href=\"https://profiles.wordpress.org/batmoo/\">Mohammad Jangda</a> · <a href=\"https://profiles.wordpress.org/boemedia/\">Monique Dubbelman</a> · <a href=\"https://profiles.wordpress.org/monzuralam/\">Monzur Alam</a> · <a href=\"https://profiles.wordpress.org/man4toman/\">Morteza Geransayeh</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/seusmaniqbal/\">Muhammad Usman Iqbal</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/tanjimtc71/\">Musarrat Anjum Chowdhury</a> · <a href=\"https://profiles.wordpress.org/nahidkhanseo/\">Nahid Khan</a> · <a href=\"https://profiles.wordpress.org/naoki0h/\">Naoki Ohashi</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/nateallen/\">Nate Allen</a> · <a href=\"https://profiles.wordpress.org/navjotjsingh/\">Navjot Singh</a> · <a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a> · <a href=\"https://profiles.wordpress.org/neffff/\">neffff</a> · <a href=\"https://profiles.wordpress.org/neilorangepeel/\">Neil Hainsworth</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/nerdpressteam/\">NerdPress</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/sessioncookiemonster/\">Nick Martianov</a> · <a href=\"https://profiles.wordpress.org/nickpagz/\">nickpagz</a> · <a href=\"https://profiles.wordpress.org/nico23/\">Nico</a> · <a href=\"https://profiles.wordpress.org/nicolefurlan/\">Nicole Furlan</a> · <a href=\"https://profiles.wordpress.org/bgnicolepaschen/\">Nicole Paschen Caylor</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nielslange/\">Niels Lange</a> · <a href=\"https://profiles.wordpress.org/nihar007/\">Nihar Ranjan Das</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/nko/\">Nikita</a> · <a href=\"https://profiles.wordpress.org/nikmeyer/\">nikmeyer</a> · <a href=\"https://profiles.wordpress.org/rabmalin/\">Nilambar Sharma</a> · <a href=\"https://profiles.wordpress.org/nilovelez/\">Nilo Velez</a> · <a href=\"https://profiles.wordpress.org/dhrupo/\">Niluthpal Purkayastha</a> · <a href=\"https://profiles.wordpress.org/niravsherasiya7707/\">Nirav Sherasiya</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a> · <a href=\"https://profiles.wordpress.org/nvwd/\">Nowell VanHoesen</a> · <a href=\"https://profiles.wordpress.org/nudge/\">Nudge Themes</a> · <a href=\"https://profiles.wordpress.org/nwjames/\">nwjames</a> · <a href=\"https://profiles.wordpress.org/obliviousharmony/\">obliviousharmony</a> · <a href=\"https://profiles.wordpress.org/ockham/\">ockham</a> · <a href=\"https://profiles.wordpress.org/oguzkocer/\">oguzkocer</a> · <a href=\"https://profiles.wordpress.org/okat/\">okat</a> · <a href=\"https://profiles.wordpress.org/dargus/\">Old account</a> · <a href=\"https://profiles.wordpress.org/olegfuture/\">olegfuture</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a> · <a href=\"https://profiles.wordpress.org/pacicio/\">Pacicio</a> · <a href=\"https://profiles.wordpress.org/pannelars/\">pannelars</a> · <a href=\"https://profiles.wordpress.org/partyfrikadelle/\">partyfrikadelle</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/pauldewouters/\">Paul de Wouters</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/djpaul/\">Paul Wong-Gibbs</a> · <a href=\"https://profiles.wordpress.org/pavelevap/\">pavelevap</a> · <a href=\"https://profiles.wordpress.org/pbaylies/\">Peter Baylies</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/philipp15b/\">Philipp15b</a> · <a href=\"https://profiles.wordpress.org/phillsav/\">Phill</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/mordauk/\">Pippin Williamson</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pmeenan/\">pmeenan</a> · <a href=\"https://profiles.wordpress.org/webtechpooja/\">Pooja Derashri</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/pouicpouic/\">pouicpouic</a> · <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a> · <a href=\"https://profiles.wordpress.org/pratikthink/\">Pratik Kumar</a> · <a href=\"https://profiles.wordpress.org/pratiklondhe/\">Pratik Londhe</a> · <a href=\"https://profiles.wordpress.org/freewebmentor/\">Prem Tiwari</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">presstoke</a> · <a href=\"https://profiles.wordpress.org/prionkor/\">prionkor</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiq</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/rashiguptaa/\">Rashi Gupta</a> · <a href=\"https://profiles.wordpress.org/ratneshsonar/\">Ratnesh Sonar</a> · <a href=\"https://profiles.wordpress.org/rawrly/\">rawrly</a> · <a href=\"https://profiles.wordpress.org/rcain/\">rcain</a> · <a href=\"https://profiles.wordpress.org/rebasaurus/\">rebasaurus</a> · <a href=\"https://profiles.wordpress.org/tabrisrp/\">Remy Perona</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho (a11n)</a> · <a href=\"https://profiles.wordpress.org/renehermi/\">Rene Hermenau</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/rdcoll/\">Rich Collier</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/ravanh/\">Rolf Allard van Hagen</a> · <a href=\"https://profiles.wordpress.org/room34/\">room34</a> · <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a> · <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/pogidude/\">Ryann Micua</a> · <a href=\"https://profiles.wordpress.org/looswebstudio/\">Ryo</a> · <a href=\"https://profiles.wordpress.org/sereedmedia/\">Sé Reed</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a> · <a href=\"https://profiles.wordpress.org/soean/\">Sören Wünsch</a> · <a href=\"https://profiles.wordpress.org/sabbirshouvo/\">Sabbir Hasan</a> · <a href=\"https://profiles.wordpress.org/sachyya-sachet/\">Sachyya</a> · <a href=\"https://profiles.wordpress.org/sadizaman/\">Sadi Mohammad Zaman</a> · <a href=\"https://profiles.wordpress.org/sadpencil/\">sadpencil</a> · <a href=\"https://profiles.wordpress.org/introvertedbot/\">Sahil</a> · <a href=\"https://profiles.wordpress.org/tohincoderex/\">Saiduzzaman Tohin</a> · <a href=\"https://profiles.wordpress.org/sakibsnaz/\">Sakib MD Nazmush</a> · <a href=\"https://profiles.wordpress.org/salcode/\">Sal Ferrarello</a> · <a href=\"https://profiles.wordpress.org/xronn/\">Sam Berry</a> · <a href=\"https://profiles.wordpress.org/samba45/\">samba45</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/kim88/\">Samuel Rüegger</a> · <a href=\"https://profiles.wordpress.org/samuelsidler/\">Samuel Sidler</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/sacerro/\">Santiago Cerro López</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarathar/\">Sarath AR</a> · <a href=\"https://profiles.wordpress.org/satishprajapati/\">Satish Prajapati</a> · <a href=\"https://profiles.wordpress.org/hellosatya/\">Satyam Vishwakarma (Satya)</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/saxonfletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/sayful/\">Sayful Islam</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sean212/\">Sean Fisher</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/sgr33n/\">Sergio De Falco</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shahariaazam/\">Shaharia Azam</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/shanef/\">ShaneF</a> · <a href=\"https://profiles.wordpress.org/cafenoirdesign/\">Shannon Smith</a> · <a href=\"https://profiles.wordpress.org/shaunandrews/\">shaunandrews</a> · <a href=\"https://profiles.wordpress.org/shooper/\">Shawn Hooper</a> · <a href=\"https://profiles.wordpress.org/shidouhikari/\">shidouhikari</a> · <a href=\"https://profiles.wordpress.org/shiponkarmakar/\">Shipon Karmakar</a> · <a href=\"https://profiles.wordpress.org/shreyash3087/\">Shreyash Srivastava</a> · <a href=\"https://profiles.wordpress.org/shubhamsedani/\">Shubham Sedani</a> · <a href=\"https://profiles.wordpress.org/rsiddharth/\">siddharth ravikumar</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/sirajummahdi/\">Sirajum Mahdi</a> · <a href=\"https://profiles.wordpress.org/sjregan/\">sjregan</a> · <a href=\"https://profiles.wordpress.org/virtality-marketing-solutions/\">SourceView</a> · <a href=\"https://profiles.wordpress.org/sruthi89/\">sruthi89</a> · <a href=\"https://profiles.wordpress.org/stacimc/\">stacimc</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stephencronin/\">Stephen Cronin</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/stephenh1988/\">Stephen Harris</a> · <a href=\"https://profiles.wordpress.org/stevejonesdev/\">Steve Jones</a> · <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a> · <a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sumisubedi/\">Sumi Subedi</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/svitlana41319/\">Svitlana Sukhoveiko</a> · <a href=\"https://profiles.wordpress.org/syamraj24/\">syamraj24</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/smub/\">Syed Balkhi</a> · <a href=\"https://profiles.wordpress.org/nuhel/\">Syed Nuhel</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/sparklingrobots/\">Tara King</a> · <a href=\"https://profiles.wordpress.org/buley/\">Taylor</a> · <a href=\"https://profiles.wordpress.org/taylorde/\">Taylor Dewey</a> · <a href=\"https://profiles.wordpress.org/taylorgorman/\">Taylor Gorman</a> · <a href=\"https://profiles.wordpress.org/tazotodua/\">tazotodua</a> · <a href=\"https://profiles.wordpress.org/tykoted/\">Teddy Patriarca</a> · <a href=\"https://profiles.wordpress.org/tellyworth/\">Tellyworth</a> · <a href=\"https://profiles.wordpress.org/thakordarshil/\">Thakor Darshil</a> · <a href=\"https://profiles.wordpress.org/themes-1/\">them.es</a> · <a href=\"https://profiles.wordpress.org/thinkluke/\">thinkluke</a> · <a href=\"https://profiles.wordpress.org/griffinjt/\">Thomas Griffin</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kräftner</a> · <a href=\"https://profiles.wordpress.org/threadi/\">threadi</a> · <a href=\"https://profiles.wordpress.org/tnolte/\">Tim Nolte</a> · <a href=\"https://profiles.wordpress.org/timbroddin/\">timbroddin</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timothée Brosille</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tmatsuur/\">tmatsuur</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomybyte/\">Tom</a> · <a href=\"https://profiles.wordpress.org/tomjcafferkey/\">Tom Cafferkey</a> · <a href=\"https://profiles.wordpress.org/hifidesign/\">Tom Finley</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/tomluckies/\">tomluckies</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/tomsommer/\">tomsommer</a> · <a href=\"https://profiles.wordpress.org/tomxygen/\">tomxygen</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemerö</a> · <a href=\"https://profiles.wordpress.org/starbuck/\">Tony G</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/torres126/\">torres126</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/toru/\">Toru Miki</a> · <a href=\"https://profiles.wordpress.org/toscho/\">toscho</a> · <a href=\"https://profiles.wordpress.org/wpsmith/\">Travis Smith</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">up1512001</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/utsav72640/\">Utsav tilava</a> · <a href=\"https://profiles.wordpress.org/ukdrahul/\">Uttam Kumar Dash</a> · <a href=\"https://profiles.wordpress.org/eboxnet/\">Vagelis</a> · <a href=\"https://profiles.wordpress.org/valerogarte/\">valerogarte</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">Vijayan</a> · <a href=\"https://profiles.wordpress.org/vikram6/\">vikram6</a> · <a href=\"https://profiles.wordpress.org/viliamkopecky/\">viliamkopecky</a> · <a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vivekawsm/\">vivekawsm</a> · <a href=\"https://profiles.wordpress.org/vladimiraus/\">vladimiraus</a> · <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a> · <a href=\"https://profiles.wordpress.org/vrajadas/\">Vraja Das</a> · <a href=\"https://profiles.wordpress.org/wasiur195/\">Wasiur Rahman</a> · <a href=\"https://profiles.wordpress.org/welaunchio/\">welaunchio</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whsajid/\">WHSajid</a> · <a href=\"https://profiles.wordpress.org/nestea29950/\">WilliamG</a> · <a href=\"https://profiles.wordpress.org/wpcorner/\">WP Corner</a> · <a href=\"https://profiles.wordpress.org/xlthlx/\">xlthlx</a> · <a href=\"https://profiles.wordpress.org/yansern/\">Yan Sern</a> · <a href=\"https://profiles.wordpress.org/yguyon/\">Yannis Guyon</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yuliyan/\">Yuliyan Slavchev</a> · <a href=\"https://profiles.wordpress.org/yuvrajsinh2211/\">Yuvrajsinh Sisodiya</a> · <a href=\"https://profiles.wordpress.org/tollmanz/\">Zack Tollman</a> · <a href=\"https://profiles.wordpress.org/zanematthew/\">Zane Matthew</a> · <a href=\"https://profiles.wordpress.org/zebaafiashama/\">Zeba Afia Shama</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">zieladam</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a> · <a href=\"https://profiles.wordpress.org/chesio/\">Česlav Przywara</a></p>\n\n\n\n<h1 class=\"wp-block-heading\">Merci aux personnes ayant contribué à traduire WordPress 6.6 en français</h1>\n\n\n\n<p>WordPress est un projet international et la version 6.6 est déjà complètement disponible dans plus de 70 langues différentes.</p>\n\n\n\n<p>Nous souhaitons remercier ici les personnes ayant participé à la traduction de WordPress 6.6 en français :</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/wolforg\">Didier Demory</a>, <a href=\"https://profiles.wordpress.org/fxbenard\">fxbenard</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/amebref\">amebref</a>, <a href=\"https://profiles.wordpress.org/beryldlg\">Béryl de La Grandière</a>, <a href=\"https://profiles.wordpress.org/bonaldi\">Bonaldi</a>, <a href=\"https://profiles.wordpress.org/chris-kns\">chris-kns</a>, <a href=\"https://profiles.wordpress.org/clementpolito\">Clément Polito</a>, <a href=\"https://profiles.wordpress.org/coralietixeront\">coralietixeront</a>, <a href=\"https://profiles.wordpress.org/eddystile\">Eddy</a>, <a href=\"https://profiles.wordpress.org/emlebrun\">Emilie LEBRUN</a>, <a href=\"https://profiles.wordpress.org/scoco\">Emilien M.</a>, <a href=\"https://profiles.wordpress.org/florientinneo\">Florient DELAFOY</a>, <a href=\"https://profiles.wordpress.org/gaeldenysiak\">Gael Denysiak</a>, <a href=\"https://profiles.wordpress.org/gaellebesson\">gaellebesson</a>, <a href=\"https://profiles.wordpress.org/karine-wendling\">karine wendling</a>, <a href=\"https://profiles.wordpress.org/laeti972\">laeti972</a>, <a href=\"https://profiles.wordpress.org/wplmillet\">Laurent MILLET</a>, <a href=\"https://profiles.wordpress.org/nuryko\">Marianna</a>, <a href=\"https://profiles.wordpress.org/marineevain\">Marine EVAIN</a>, <a href=\"https://profiles.wordpress.org/lymx\">Maxime LEROY</a>, <a href=\"https://profiles.wordpress.org/momo-fr\">momo-fr</a>, <a href=\"https://profiles.wordpress.org/nlangle\">Nicolas Langle</a>, <a href=\"https://profiles.wordpress.org/mrbalou06\">Pascal T</a>, <a href=\"https://profiles.wordpress.org/pierrelannoy\">Pierre Lannoy</a>, <a href=\"https://profiles.wordpress.org/nekojonez\">Pieterjan Deneys</a>, <a href=\"https://profiles.wordpress.org/larrach\">Rachel Peter</a>, <a href=\"https://profiles.wordpress.org/sebastienserre\">Sébastien SERRE</a>, <a href=\"https://profiles.wordpress.org/spaceshipone\">Timothée Brosille</a>, <a href=\"https://profiles.wordpress.org/valer1e\">Valérie Galassi</a>, <a href=\"https://profiles.wordpress.org/virgar\">Virginie Garnier</a>, et <a href=\"https://profiles.wordpress.org/whaze\">whaze</a>.</p>\n\n\n\n<p></p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3181\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"Comment contribuer aux « release parties » des nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"https://fr.wordpress.org/2024/07/15/comment-contribuer-aux-release-parties-des-nouvelles-versions-de-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 15 Jul 2024 13:28:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Contribuer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3159\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:383:\"Lors des phases de développement d’une nouvelle version de WordPress, il est possible d’aider à la livraison des versions bêta et release candidate de WP en participant aux « release parties », qui sont des événements planifiés à l’avance pour procéder à la construction d’une version bêta ou release candidate, ou d&#8217;une version finale, et à sa [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7155:\"\n<p>Lors des phases de développement d’une nouvelle version de WordPress, il est possible d’aider à la livraison des versions bêta et <em><bdo lang=\"en\" dir=\"ltr\">release candidate</bdo></em> de WP en participant aux <em><bdo lang=\"en\" dir=\"ltr\">« release parties »</bdo></em>, qui sont des événements planifiés à l’avance pour procéder à la construction d’une version bêta ou release candidate, ou d&rsquo;une version finale, et à sa livraison au public.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Prérequis</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Aucun niveau technique particulier n’est nécessaire à part savoir utiliser WordPress</li>\n\n\n\n<li>Avoir un site de test installé en local ou en ligne</li>\n\n\n\n<li>Installer l’extension <em><bdo lang=\"en\" dir=\"ltr\"><a href=\"https://fr.wordpress.org/plugins/wordpress-beta-tester/\">Beta Tester</a></bdo></em> et la paramétrer (dans <code>Outils &gt; Test Bêta</code>) de la façon suivante (ici nous sommes sur une installation en anglais, si vous êtes sur une installation en français, faites la correspondance des options)&nbsp;:</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2024/07/reglages-beta-tester.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"427\" src=\"https://fr.wordpress.org/files/2024/07/reglages-beta-tester-1024x427.png\" alt=\"\" class=\"wp-image-3160\" srcset=\"https://fr.wordpress.org/files/2024/07/reglages-beta-tester-1024x427.png 1024w, https://fr.wordpress.org/files/2024/07/reglages-beta-tester-300x125.png 300w, https://fr.wordpress.org/files/2024/07/reglages-beta-tester-768x320.png 768w, https://fr.wordpress.org/files/2024/07/reglages-beta-tester-1536x641.png 1536w, https://fr.wordpress.org/files/2024/07/reglages-beta-tester-2048x854.png 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p><em><bdo lang=\"en\" dir=\"ltr\">Bleeding edge</bdo></em> : version en cours de développement. Cette version utilise le code en cours de développement (<em><bdo lang=\"en\" dir=\"ltr\">Bleeding edge nightlies</bdo></em>) qui peut parfois être instable. <em>Ne l’utilisez en production que si vous savez vraiment ce que vous faites</em>.</p>\n\n\n\n<p><em><bdo lang=\"en\" dir=\"ltr\">Bêta/RC only </bdo></em>: ceci concerne uniquement les versions bêta/RC du canal sélectionné.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Déroulement de la <em><bdo lang=\"en\" dir=\"ltr\">release party</bdo></em></h2>\n\n\n\n<p>Les <em><bdo lang=\"en\" dir=\"ltr\">release parties</bdo></em> se déroulent entièrement sur le Slack <a href=\"http://Make.WordPress.org\">Make.WordPress.org</a>, sur le canal #core. Pour le rejoindre utilisez votre nom de compte WordPress.org, ici : <a href=\"https://make.wordpress.org/chat/\">https://make.wordpress.org/chat/</a>.</p>\n\n\n\n<p>Généralement, il y en a pour 30-40 minutes si c’est une version beta/RC.</p>\n\n\n\n<p>Normalement les <em><bdo lang=\"en\" dir=\"ltr\">release parties</bdo></em> commencent à peu près à l’heure, souvent en fin d’après midi. Voici le déroulement :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Message d’accueil de la personne qui dirige la <bdo lang=\"en\" dir=\"ltr\"><em>release party</em></bdo>, tout le monde fait coucou et ça permet de consigner le nombre de contributrices et contributeurs qui participent à la <em><bdo lang=\"en\" dir=\"ltr\">release</bdo></em></li>\n\n\n\n<li>Quelques<bdo lang=\"en\" dir=\"ltr\"> vérificatio</bdo>ns techniques entre le ou la <em><bdo lang=\"en\" dir=\"ltr\">lead</bdo></em>, la personne faisant office de <em><bdo lang=\"en\" dir=\"ltr\">committer</bdo></em> (qui va créer la version de WordPress concernée) et le contrôle de mission (<em><bdo lang=\"en\" dir=\"ltr\">mission control</bdo></em>, qui est chargé de construire le paquet ZIP de la version), ça peut prendre 10-15 minutes mais c’est souvent moins.</li>\n\n\n\n<li>Les checks de sécurité et les tests unitaires sont lancés par la personne chargée des <em><bdo lang=\"en\" dir=\"ltr\">commits</bdo></em> et le contrôle de mission</li>\n\n\n\n<li>Le ou la <em><bdo lang=\"en\" dir=\"ltr\">core committer</bdo></em> fait un premier <bdo lang=\"en\" dir=\"ltr\"><em>commit</em></bdo> de version</li>\n\n\n\n<li>Le contrôle de mission livre un premier ZIP de la version</li>\n\n\n\n<li>C’EST LÀ QUE VOUS INTERVENEZ ! Vous pouvez&nbsp;:\n<ul class=\"wp-block-list\">\n<li>(plus long) Récupérer le ZIP et l’installer en local</li>\n\n\n\n<li>(plus rapide mais plus technique) Installer la version via <em>WP-CLI</em></li>\n\n\n\n<li>(recommandé) Via Beta Tester :\n<ul class=\"wp-block-list\">\n<li>Aller sur une installation avec l’extension WP Beta Tester installée, paramétrée comme expliqué ci-dessus</li>\n\n\n\n<li>Normalement, au bout de quelques secondes après que le ZIP soit disponible, vous devriez voir un petit message sur l’écran d’accueil de l’admin indiquant qu’une nouvelle version est disponible pour test</li>\n\n\n\n<li>Pensez à noter le numéro de version de WP que vous aviez avant de mettre à jour !</li>\n\n\n\n<li>Cliquez sur le lien de mise à jour et installez la version</li>\n</ul>\n</li>\n</ul>\n</li>\n\n\n\n<li>Les choses que vous pouvez tester :\n<ul class=\"wp-block-list\">\n<li>Fonctionnement de quelques écrans de l’admin</li>\n\n\n\n<li>Bon fonctionnement de l’éditeur : insertion d’un bloc, enregistrement d’un article</li>\n\n\n\n<li>Bon fonctionnement de l’éditeur de site (navigation dans quelques écrans)</li>\n\n\n\n<li>Bon fonctionnement de quelques écrans du front</li>\n\n\n\n<li>Bon fonctionnement de l&rsquo;éditeur après installation d&rsquo;un thème classique</li>\n\n\n\n<li>Bon fonctionnement de l&rsquo;éditeur après installation de l&rsquo;extension <em><bdo lang=\"en\" dir=\"ltr\"><a href=\"https://fr.wordpress.org/plugins/classic-editor/\">Classic Editor</a></bdo></em></li>\n\n\n\n<li>Si vous disposez d&rsquo;une instance multisite, mentionnez-le</li>\n\n\n\n<li>Si vous avez les moyens de tester la mise à jour depuis une vieille version de WP (version 4.9 ou au dessus), c&rsquo;est très utile aussi. Mentionnez la version depuis laquelle vous avez fait la mise à jour</li>\n</ul>\n</li>\n\n\n\n<li>Une fois que vous avez testé, mettez un petit message dans le canal #core, en indiquant la version que vous aviez avant la <abbr title=\"Mise à jour\">MAJ</abbr> et la version vers laquelle vous avez mis à jour. Par exemple :</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-full is-resized\"><a href=\"https://fr.wordpress.org/files/2024/07/Capture-decran-2024-03-05-a-10.42.10.png\"><img loading=\"lazy\" decoding=\"async\" width=\"706\" height=\"806\" src=\"https://fr.wordpress.org/files/2024/07/Capture-decran-2024-03-05-a-10.42.10.png\" alt=\"\" class=\"wp-image-3161\" style=\"width:400px\" srcset=\"https://fr.wordpress.org/files/2024/07/Capture-decran-2024-03-05-a-10.42.10.png 706w, https://fr.wordpress.org/files/2024/07/Capture-decran-2024-03-05-a-10.42.10-263x300.png 263w\" sizes=\"auto, (max-width: 706px) 100vw, 706px\" /></a></figure>\n\n\n\n<p>Vous pourrez ensuite suivre le reste de la <em><bdo lang=\"en\" dir=\"ltr\">release party</bdo></em> tranquillement.</p>\n\n\n\n<p>Et vous serez aussi crédité·es pour votre participation à cette version. Bravo&nbsp;!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3159\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Guide des changements techniques de WordPress 6.6\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://fr.wordpress.org/2024/06/27/guide-des-changements-techniques-de-wordpress-6-6/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 27 Jun 2024 08:36:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:5:\"Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3125\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:140:\"Ce guide décrit les principaux changements techniques que vous trouverez sur WordPress 6.6, dont la sortie est prévue le 16 juillet 2024.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:33232:\"\n<figure class=\"wp-block-image alignfull size-large\"><a href=\"https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"548\" src=\"https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min-1024x548.png\" alt=\"\" class=\"wp-image-3134\" srcset=\"https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min-1024x548.png 1024w, https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min-300x160.png 300w, https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min-768x411.png 768w, https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min-1536x821.png 1536w, https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min-2048x1095.png 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p class=\"is-style-serif has-blueberry-4-background-color has-background\">Ce guide décrit les principaux changements techniques que vous trouverez sur WordPress&nbsp;6.6, dont la sortie est prévue le 16 juillet 2024.</p>\n\n\n\n<p>WordPress 6.6 comprend au minimum la résolution de <a href=\"https://core.trac.wordpress.org/query?resolution=fixed&amp;milestone=6.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;order=type\" target=\"_blank\" rel=\"noreferrer noopener\">299 tickets Trac</a>, dont <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.6&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">108 améliorations et nouvelles fonctionnalités</a>, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.5&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">171 résolutions de bogues</a> et <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=task+(blessed)&amp;milestone=6.6&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">10 autres tâches de maintenance</a>. Pour cette version, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~performance&amp;milestone=6.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=focuses&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">16 tickets étaient centrés sur les performances</a>, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~accessibility&amp;milestone=6.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=focuses&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">24 sur l&rsquo;accessibilité</a> et <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~coding-standards&amp;milestone=6.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=focuses&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">15 tickets portaient sur la modernisation du code source de notre CMS</a>. Les modifications de WP&nbsp;6.6 concernent <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">40 composants du code source de WordPress</a>.</p>\n\n\n\n<p>Cette version comprend aussi 392 améliorations, 462 corrections de bogues et 46 améliorations de l&rsquo;accessibilité de <a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.6\">l&rsquo;éditeur de blocs</a> (Gutenberg).</p>\n\n\n\n<p>Tous les liens de cet article pointent vers des notes de développement rédigées en anglais. L’objectif est de fournir un panorama général des changements techniques apportés par cette version, en français, puis de diriger les personnes qui souhaitent en savoir plus vers les notes de développement en anglais.</p>\n\n\n\n<p>Pour en savoir plus sur la feuille de route et le calendrier de sortie de WP&nbsp;6.6, consultez cette page : <a href=\"https://make.wordpress.org/core/6-5/\">https://make.wordpress.org/core/6-5/</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"Block-Editor\">Changements concernant l’éditeur et le projet Gutenberg</h2>\n\n\n\n<p>WordPress 6.6 implémente 8 versions de Gutenberg &#8211; <a href=\"https://make.wordpress.org/core/2024/02/28/whats-new-in-gutenberg-17-8-28-february/\">17.8</a>, <a href=\"https://make.wordpress.org/core/2024/03/13/whats-new-in-gutenberg-17-9-13-march/\">17.9</a>, <a href=\"https://make.wordpress.org/core/2024/03/27/whats-new-in-gutenberg-18-0-27-march/\">18.0</a>, <a href=\"https://make.wordpress.org/core/2024/04/10/whats-new-in-gutenberg-18-1-10-april/\">18.1</a>, <a href=\"https://make.wordpress.org/core/2024/04/24/whats-new-in-gutenberg-18-2-24-april/\">18.2</a>, <a href=\"https://make.wordpress.org/core/2024/05/08/whats-new-in-gutenberg-18-3-8-may/\">18.3</a>, <a href=\"https://make.wordpress.org/core/2024/05/23/whats-new-in-gutenberg-18-4-22-may/\">18.4</a> et <a href=\"https://make.wordpress.org/core/2024/06/09/what-is-new-in-gutenberg-18-5-05-jun/\">18.5</a>. L&rsquo;éditeur de blocs reçoit ainsi de nombreuses améliorations liées à la bibliothèque React, à l’API <code>Block</code>, à la gestion des thèmes, et bien plus encore.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"react\">React</h3>\n\n\n\n<p>Une nouvelle version de React et la nouvelle <a href=\"https://legacy.reactjs.org/blog/2020/09/22/introducing-the-new-jsx-transform.html\">API JSX transform</a> font leur entrée dans WordPress&nbsp;6.6.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"dWLxJUI3h0\"><a href=\"https://make.wordpress.org/core/2024/06/06/jsx-in-wordpress-6-6/\">JSX in WordPress 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;JSX in WordPress 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/06/jsx-in-wordpress-6-6/embed/#?secret=XMglYBeDLC#?secret=dWLxJUI3h0\" data-secret=\"dWLxJUI3h0\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"52Rfu8yAtE\"><a href=\"https://make.wordpress.org/core/2024/06/07/preparation-for-react-19-upgrade/\">Preparation for React 19 Upgrade</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Preparation for React 19 Upgrade&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/07/preparation-for-react-19-upgrade/embed/#?secret=YV2Zkzjfyy#?secret=52Rfu8yAtE\" data-secret=\"52Rfu8yAtE\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"block-api\">API <code>Block</code></h3>\n\n\n\n<p>Des changements arrivent sur l&rsquo;API <code>Block</code>&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Unification des API d&rsquo;extensibilité entre les éditeurs de publications et du site</li>\n\n\n\n<li>Amélioration de la propriété <code>isActive</code> sur les variations de blocs</li>\n\n\n\n<li>Améliorations de plusieurs blocs proposés par le cœur de WordPress</li>\n</ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"FC595uD9El\"><a href=\"https://make.wordpress.org/core/2024/06/18/editor-unified-extensibility-apis-in-6-6/\">Editor: Unified Extensibility APIs in 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Editor: Unified Extensibility APIs in 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/18/editor-unified-extensibility-apis-in-6-6/embed/#?secret=d9wcTgYeLu#?secret=FC595uD9El\" data-secret=\"FC595uD9El\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"vsiCQ8RUpF\"><a href=\"https://make.wordpress.org/core/2024/06/18/improvements-to-active-block-variation-detection/\">Improvements to active block variation detection</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Improvements to active block variation detection&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/18/improvements-to-active-block-variation-detection/embed/#?secret=BlfgJ2v86t#?secret=vsiCQ8RUpF\" data-secret=\"vsiCQ8RUpF\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"fcUHSrfEG8\"><a href=\"https://make.wordpress.org/core/2024/06/19/social-links-block-changes-in-wordpress-6-6/\">Social Links block changes in WordPress 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Social Links block changes in WordPress 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/19/social-links-block-changes-in-wordpress-6-6/embed/#?secret=KTnVlZwICZ#?secret=fcUHSrfEG8\" data-secret=\"fcUHSrfEG8\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"themes-6-6\">Thèmes</h3>\n\n\n\n<p>WordPress 6.6 introduit plusieurs mises à jour liées aux thèmes, comprenant&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Une nouvelle version 3 du <code>theme.json</code></li>\n\n\n\n<li>L&rsquo;uniformisation de la spécificité CSS appliquée aux styles du cœur de WP</li>\n\n\n\n<li>Introduction de la section «&nbsp;styles&nbsp;» pour améliorer l&rsquo;efficacité de la personnalisation des blocs et de leurs éléments internes</li>\n\n\n\n<li>Fonctionnalités additionnelles de la mise en page en grille dans les blocs</li>\n\n\n\n<li>Capacité de définir des images d&rsquo;arrière-plan pour l&rsquo;ensemble du site via le <code>theme.json</code> et via l’éditeur de site</li>\n</ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"3qkQI6VB3V\"><a href=\"https://make.wordpress.org/core/2024/06/19/theme-json-version-3/\">Theme.json version 3</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Theme.json version 3&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/19/theme-json-version-3/embed/#?secret=qFVVO9yctD#?secret=3qkQI6VB3V\" data-secret=\"3qkQI6VB3V\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"WwNatJ4yuP\"><a href=\"https://make.wordpress.org/core/2024/06/24/section-styles/\">Section Styles</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Section Styles&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/24/section-styles/embed/#?secret=myss8Gv9Su#?secret=WwNatJ4yuP\" data-secret=\"WwNatJ4yuP\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"5tYWFN7C0m\"><a href=\"https://make.wordpress.org/core/2024/06/21/wordpress-6-6-css-specificity/\">WordPress 6.6 CSS Specificity</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;WordPress 6.6 CSS Specificity&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/21/wordpress-6-6-css-specificity/embed/#?secret=0Ak975GLQd#?secret=5tYWFN7C0m\" data-secret=\"5tYWFN7C0m\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"g0n7RPlGmY\"><a href=\"https://make.wordpress.org/core/2024/06/18/grid-layout-type/\">Grid layout type</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Grid layout type&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/18/grid-layout-type/embed/#?secret=c59OLorfmE#?secret=g0n7RPlGmY\" data-secret=\"g0n7RPlGmY\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"ZPfvPc14dl\"><a href=\"https://make.wordpress.org/core/2024/06/20/site-wide-background-images-in-wordpress-6-6/\">Site-wide background images in WordPress 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Site-wide background images in WordPress 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/20/site-wide-background-images-in-wordpress-6-6/embed/#?secret=GtFb16IOEz#?secret=ZPfvPc14dl\" data-secret=\"ZPfvPc14dl\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"miscellaneous-block-editor-changes\">Modifications diverses concernant l’éditeur</h3>\n\n\n\n<p>Plusieurs autres modifications de l’éditeur de bloc sont aussi incluses dans WordPress 6.6 :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Added-wp-block-list-class-to-the-list-block\">Ajout de la classe <code>wp-block-list</code>&nbsp;au bloc Liste</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#New-Interactivity-API-directives\">Nouvelles directives pour l&rsquo;API <code>Interactivity</code></a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Allow-view-access-of-the-template-REST-API-endpoint-to-anyone-with-the-edit_post-capability\">Ajout de l’accès en lecture au point de terminaison <code>template</code> de l’API REST à toute personne disposant de la permission <code>edit_post</code></a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Unified-split-logic-for-writing-flow\">Unification de la logique de séparation dans le flux de rédaction</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#BlockPopover-Component-is-now-public\">Le composant BlockPopover est maintenant public</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Add-filter-to-modify-the-list-of-post-content-block-types\">Ajout d&rsquo;un filtre pour modifier la liste des types de blocs de contenu</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Global-Styles-Filter-out-color-and-typography-variations\">Styles globaux&nbsp;: ajout de filtres pour les variations de couleur et de typographie</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Add-custom-Aspect-Ratio-presets-through-theme-json\">Ajout de pré-réglages de proportions gérables via le fichier&nbsp;<code>theme.json</code></a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#root-padding-style-updates\">Mise à jour des styles de marge interne racine via <code>:root</code></a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Added-Text-alignment-block-support\">Ajout de la prise en charge de l&rsquo;alignement de texte des blocs</a></li>\n</ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"zwjsgiLBc3\"><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/\">Miscellaneous Editor changes in WordPress 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous Editor changes in WordPress 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/embed/#?secret=ixOVYPSn2d#?secret=zwjsgiLBc3\" data-secret=\"zwjsgiLBc3\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p>Un tableau des outils de conception supportés par chaque bloc sur WordPress&nbsp;6.6 a été publié en guise de référence.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"dIjJDZTSGY\"><a href=\"https://make.wordpress.org/core/2024/06/20/roster-of-design-tools-per-block-wordpress-6-6-edition/\">Roster of design tools per block (WordPress 6.6 edition)</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Roster of design tools per block (WordPress 6.6 edition)&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/20/roster-of-design-tools-per-block-wordpress-6-6-edition/embed/#?secret=xV9lWVls3h#?secret=dIjJDZTSGY\" data-secret=\"dIjJDZTSGY\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"html-api\">API HTML</h2>\n\n\n\n<p>WordPress 6.6 comprend une version de maintenance de l&rsquo;API HTML. Cela inclut quelques nouvelles fonctionnalités et une amélioration majeure de l&rsquo;utilisabilité du processeur HTML. Cela poursuit les travaux d&rsquo;amélioration continue engagés depuis WP 6.5.</p>\n\n\n\n<p>Une nouvelle structure de données vient aussi avec la version 6.6&nbsp;: il s&rsquo;agit de l&rsquo;API&nbsp;<code>WP_Token_Map</code>.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"wuD7UIc043\"><a href=\"https://make.wordpress.org/core/2024/06/24/updates-to-the-html-api-in-6-6/\">Updates to the HTML API in 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to the HTML API in 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/24/updates-to-the-html-api-in-6-6/embed/#?secret=jA5d2tI5LY#?secret=wuD7UIc043\" data-secret=\"wuD7UIc043\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"cLzvpODa71\"><a href=\"https://make.wordpress.org/core/2024/06/24/introducing-the-token-map/\">Introducing the Token Map</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Introducing the Token Map&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/24/introducing-the-token-map/embed/#?secret=96WcqwTl9C#?secret=cLzvpODa71\" data-secret=\"cLzvpODa71\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"options-api\">API <code>Options</code></h2>\n\n\n\n<p>Plusieurs modifications ont été faites sur l&rsquo;API <code>Options</code> pour prendre en charge une optimisation du comportement de chargement automatique et pour créer une façon d’appliquer les prochaines optimisations à venir.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"sY4OPd8z50\"><a href=\"https://make.wordpress.org/core/2024/06/18/options-api-disabling-autoload-for-large-options/\">Options API: Disabling autoload for large options</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Options API: Disabling autoload for large options&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/18/options-api-disabling-autoload-for-large-options/embed/#?secret=Fd1Vmk80wn#?secret=sY4OPd8z50\" data-secret=\"sY4OPd8z50\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"i18n\">Internationalisation</h2>\n\n\n\n<p><a href=\"https://core.trac.wordpress.org/query?component=I18N&amp;milestone=6.5&amp;&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">Plusieurs améliorations de l&rsquo;internationalisation</a> ont été intégrées dans WP&nbsp;6.6&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/i18n-improvements-6-6#Enhanced-support-for-only-using-PHP-translation-files\">Amélioration de la prise en charge des fichiers de traduction PHP</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/i18n-improvements-6-6#New-lang_dir_for_domain-filter\">Nouveau filtre&nbsp;<code>lang_dir_for_domain</code></a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/i18n-improvements-6-6#Additional-context-for-the-load_translation_file-filter\">Ajout d&rsquo;un contexte pour le filtre <code>load_translation_file</code></a></li>\n</ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"MSrk50CwxF\"><a href=\"https://make.wordpress.org/core/2024/06/24/i18n-improvements-6-6/\">Internationalization improvements in 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Internationalization improvements in 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/24/i18n-improvements-6-6/embed/#?secret=3bBLcbcQOl#?secret=MSrk50CwxF\" data-secret=\"MSrk50CwxF\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"miscellaneous-developer-changes\">Autres changements techniques</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#allowed-disabling-autosave-support-for-individual-post-types\">Désactivation de la sauvegarde automatique indépendamment pour chaque type de publication</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#default-length-of-time-for-comment-author-cookies-has-changed\">Modification de la durée native de conservation des cookies de commentaires</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#site-editor-patterns-on-classic-themes\">Prise en charge des compositions de l’éditeur de site dans les thèmes classiques</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#fluid-typography\">Prise en charge des polices fluides</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#jquery-ui-library-update\">Mise à jour de la bibliothèque jQuery UI</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#new-array-arguments-for-wp-login-form\">Nouveaux paramètres pour la fonction for wp_login_form()</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#custom-ports-for-multisite-site-addresses\">Ports personnalisés pour les adresses des sites d&rsquo;un multisite</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#update-enabled-mime-types-for-new-multisite-installs\">Mise à jour des types MIME activés pour les nouvelles installations multisite</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#obsolete-polyfills-dependencies-have-been-removed\">Suppression des dépendances polyfill obsolètes</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#script-modules-can-now-be-used-in-the-wordpress-admin\">Les modules de Script peuvent maintenant être utilisés sur l&rsquo;administration</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#search-has-a-much-later-priority\">Mise en place d&rsquo;une priorité moins importante sur le composant de recherche de la barre d&rsquo;administration</a></li>\n</ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"q0i57KuxlF\"><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/\">Miscellaneous developer changes in WordPress 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous developer changes in WordPress 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/embed/#?secret=q70OxXcdsS#?secret=q0i57KuxlF\" data-secret=\"q0i57KuxlF\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"other-updates\">Nouvelles fonctions, crochets, filtres, classes et méthodes</h2>\n\n\n\n<p>Pour obtenir la liste de toutes les nouvelles fonctions, crochets, filtres, classes et méthodes, vous pourrez vous rendre – une fois que WP 6.6 sera sortie – sur cette page&nbsp;: <a href=\"https://developer.wordpress.org/reference/since/6.6.0/\">https://developer.wordpress.org/reference/since/6.6.0/</a>.</p>\n\n\n\n<div class=\"wp-block-group alignfull is-layout-flow wp-block-group-is-layout-flow\">\n<p class=\"is-style-serif has-white-color has-text-color has-background has-link-color wp-elements-9bd75783906267b91255ee59d7f76693\" style=\"background:linear-gradient(135deg,rgb(189,21,50) 0%,rgb(248,68,11) 100%)\">Que vous développiez des thèmes ou des extensions, pensez à tester et retester votre code pour vous assurer de sa compatibilité avec ces changements. Vous pouvez utiliser&nbsp;<a href=\"https://fr.wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\" rel=\"noreferrer noopener\">l’extension «&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">Beta Tester</bdo></em>&nbsp;»</a>&nbsp;sur un site de test pour vérifier la compatibilité de vos développements avec la <a href=\"https://wordpress.org/news/2024/06/wordpress-6-6-rc1/\">version <em><bdo lang=\"en\" dir=\"ltr\">release candidate</bdo></em>&nbsp;de WordPress 6.6</a>.&nbsp;<br>Vous pouvez aussi tester cette nouvelle version directement dans votre navigateur en utilisant <em><a href=\"https://playground.wordpress.net/#%7B%20%22preferredVersions%22:%20%7B%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20%7D,%20%22features%22:%20%7B%20%22networking%22:%20true%20%7D,%20%22steps%22:%20[%20%7B%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20%7D,%20%22options%22:%20%7B%20%22activate%22:%20false%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D%20]%20%7D\"><bdo lang=\"en\" dir=\"ltr\">WordPress Playground</bdo></a></em>.<br><br>Nous comptons sur vous pour vérifier que votre code fonctionne correctement avec le cœur du CMS, pour le bien des millions d’utilisateurs et utilisatrices de WordPress&nbsp;<img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n</div>\n\n\n\n<p class=\"has-small-font-size\">Ce guide a été traduit et réadapté à partir du <a href=\"https://make.wordpress.org/core/2024/06/25/wordpress-6-6-field-guide/\"><em><bdo lang=\"en\" dir=\"ltr\">Field Guide</bdo></em> de WP 6.6</a> par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>.<br>Merci à <a href=\"https://profiles.wordpress.org/fxbenard/\">FX Bénard</a>, <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl</a>, <a href=\"https://profiles.wordpress.org/juliobox/\">Julio</a>, <a href=\"https://profiles.wordpress.org/jdy68\">Jenny</a>, <a href=\"https://profiles.wordpress.org/clementpolito/\">Clément</a> pour leur relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3125\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:72:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"Le 28 juin 2024 : deuxième WordPress Translation Day FR !\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://fr.wordpress.org/2024/06/13/le-28-juin-2024-deuxieme-wordpress-translation-day-fr/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Jun 2024 08:08:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:11:\"Évènement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:10:\"Contribuer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:10:\"Traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"évènement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:10:\"traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:4:\"wptd\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3070\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:391:\"Que vous soyez débutant·e ou aguerri·e à la traduction de WordPress et de son écosystème, rejoignez-nous en visio-conférence quand vous le souhaitez, entre 10 et 17 heures, en toute décontraction, pour rencontrer les membres de l&#8217;équipe de traduction de WordPress en français et pour traduire ensemble aussi bien WordPress lui-même, qu’une extension ou un thème [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jenny Dupuy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10157:\"<figure class=\"wp-block-post-featured-image\"><img loading=\"lazy\" decoding=\"async\" width=\"1200\" height=\"800\" src=\"https://fr.wordpress.org/files/2024/06/WPTD-FR-2024.png\" class=\"attachment-post-thumbnail size-post-thumbnail wp-post-image\" alt=\"\" style=\"object-fit:cover;\" srcset=\"https://fr.wordpress.org/files/2024/06/WPTD-FR-2024.png 1200w, https://fr.wordpress.org/files/2024/06/WPTD-FR-2024-300x200.png 300w, https://fr.wordpress.org/files/2024/06/WPTD-FR-2024-1024x683.png 1024w, https://fr.wordpress.org/files/2024/06/WPTD-FR-2024-768x512.png 768w\" sizes=\"auto, (max-width: 1200px) 100vw, 1200px\" /></figure>\n\n\n<p>Que vous soyez <strong>débutant·e ou aguerri·e</strong> à la traduction de WordPress et de son écosystème, rejoignez-nous en visio-conférence quand vous le souhaitez, <strong>entre 10 et 17 heures</strong>, <em>en toute décontraction</em>, pour rencontrer les membres de l&rsquo;équipe de traduction de WordPress en français et pour traduire ensemble aussi bien WordPress lui-même, qu’une extension ou un thème qui vous tient à cœur, ou encore un des nombreux sites wordpress.org.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Le WordPress Translation Day FR, qu’est-ce que c’est&nbsp;?</h2>\n\n\n\n<p>Habituellement, un&nbsp;<em><strong>WordPress Translation Day</strong></em>, ce sont 24 heures pendant lesquelles les différentes équipes de traduction de chaque langue contribuent ensemble à la traduction de l’écosystème&nbsp;: cœur WordPress, extensions, thèmes, ainsi que tous les sites WordPress.org. Cela se déroule sur 24 heures et sur tous les fuseaux horaires, avec des conférences données en direct dans toutes les langues.</p>\n\n\n\n<p>Le 28 juin prochain, nous vous proposerons une version allégée d’un&nbsp;<em>WordPress Translation Day</em>&nbsp;mondial. Il s’agira de contribuer ensemble à la traduction de WordPress en français, au moment où vous le souhaitez, entre 10 et 17 heures, en visioconférence. Les membres de l’équipe traduction seront là pour vous guider et valider vos suggestions.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Comment participer&nbsp;?</h2>\n\n\n\n<p>Vous aurez besoin d’un compte wordpress.org pour vous inscrire et traduire le jour J.</p>\n\n\n\n<p>Si vous n’avez pas encore de compte, suivez ce <a href=\"https://fr.wordpress.org/team/handbook/polyglots/rejoindre-lequipe-de-traduction-de-wordpress/\">petit guide</a> pour le créer.</p>\n\n\n\n<p>L’évènement se déroulera en visioconférence sur le logiciel Zoom. Vous pouvez déjà vous y inscrire gratuitement&nbsp;:</p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-4 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://translate.wordpress.org/events/2024/wordpress-translation-day-fr-du-28-juin-2024/\">S’inscrire au WPTD du 28 juin 2024<br></a></div>\n</div>\n\n\n\n<p>Grâce à cette inscription, toutes vos contributions du jour seront comptabilisées, ce qui nous permettra de mesurer facilement le travail accompli !</p>\n\n\n\n<div class=\"wp-block-columns are-vertically-aligned-center has-lemon-3-background-color has-background is-layout-flex wp-container-core-columns-is-layout-5 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:4%\">\n<p><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f4a1.png\" alt=\"💡\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:96%\">\n<p>Si vous débutez dans la traduction, nous vous invitons à lire le guide de contribution dédié à la <a href=\"https://fr.wordpress.org/team/handbook/polyglots/\">Traduction de WordPress</a>, et en particulier la page <a href=\"https://fr.wordpress.org/team/handbook/polyglots/recommandations/\">Recommandations</a>.</p>\n</div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Le programme</h2>\n\n\n\n<p>La visio-conférence sera ouverte dès 10h et jusqu’à 17h, l&rsquo;équipe des GTE et GPTE vous accueillera au fil de vos arrivées et vous guidera dans vos traductions ou vos premières traductions, si vous débutez, et répondra bien évidemment à toutes vos questions. </p>\n\n\n\n<p>En parallèle, nous utiliserons le canal <strong><em>#évènements-translationday</em></strong> du <a href=\"https://join.slack.com/t/wordpressfr/shared_invite/zt-1rvk7csl3-M1jWYcn71tSRLsAluZ9CmQ\">slack WordPress-FR</a> pour diffuser des informations et nous coordonner.</p>\n\n\n\n<p>Normalement, les chaînes de la version 6.6 seront disponibles, aussi vous aurez l&rsquo;occasion de les traduire et d&rsquo;être ainsi mentionné·e dans les crédits de cette nouvelle version&nbsp;!</p>\n\n\n\n<h2 class=\"wp-block-heading\">Pourquoi participer à cet évènement</h2>\n\n\n\n<p>WordPress est un projet open source que nous sommes nombreuses et nombreux à utiliser. Qui dit open source dit contribution. Il y a différentes manières de contribuer au projet WordPress : entre autres, en améliorant le cœur du CMS, en organisant des évènements (meetups, WordCamps) mais aussi en traduisant WordPress lui-même, ses extensions, ses thèmes, ses tutoriaux et cours ou encore sa documentation. Alors vous aussi contribuez !</p>\n\n\n\n<p>Si vous souhaitez plus d’informations sur les équipes de contribution en français, consultez&nbsp;<a href=\"https://fr.wordpress.org/team\">le blog officiel</a> des équipes.</p>\n\n\n\n<p class=\"has-white-color has-blueberry-1-background-color has-text-color has-background has-link-color wp-elements-6e90a0661a60803691fd7425a3abb690\" style=\"margin-top:var(--wp--preset--spacing--10);margin-bottom:var(--wp--preset--spacing--10);padding-top:var(--wp--preset--spacing--20);padding-right:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--20);padding-left:var(--wp--preset--spacing--20)\">N’hésitez pas à nous rejoindre le 28 juin 2024, l’équipe de traduction de WordPress en français sera ravie de vous accueillir tout au long de la journée.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Partagez l’info</h2>\n\n\n\n<p>Si vous souhaitez communiquer sur l’évènement, voici différents visuels prévus pour les réseaux sociaux&nbsp;:</p>\n\n\n\n<div class=\"wp-block-file\"><a id=\"wp-block-file--media-f60c68b6-141a-4190-831e-52e56cd44f29\" href=\"https://fr.wordpress.org/files/2024/06/Facebook-Event-image-1920x1005-1.png\">Facebook-Event-image-1920&#215;1005-1</a><a href=\"https://fr.wordpress.org/files/2024/06/Facebook-Event-image-1920x1005-1.png\" class=\"wp-block-file__button wp-element-button\" download aria-describedby=\"wp-block-file--media-f60c68b6-141a-4190-831e-52e56cd44f29\">Télécharger</a></div>\n\n\n\n<div class=\"wp-block-file\"><a id=\"wp-block-file--media-171ff8e2-9a21-4e00-87f4-ea0566ec87ec\" href=\"https://fr.wordpress.org/files/2024/06/Facebook-paysage.png\">Facebook-paysage</a><a href=\"https://fr.wordpress.org/files/2024/06/Facebook-paysage.png\" class=\"wp-block-file__button wp-element-button\" download aria-describedby=\"wp-block-file--media-171ff8e2-9a21-4e00-87f4-ea0566ec87ec\">Télécharger</a></div>\n\n\n\n<div class=\"wp-block-file\"><a id=\"wp-block-file--media-5ca45389-e759-4d1d-b05f-ec5222dddea2\" href=\"https://fr.wordpress.org/files/2024/06/FB-portrait.png\">FB-portrait</a><a href=\"https://fr.wordpress.org/files/2024/06/FB-portrait.png\" class=\"wp-block-file__button wp-element-button\" download aria-describedby=\"wp-block-file--media-5ca45389-e759-4d1d-b05f-ec5222dddea2\">Télécharger</a></div>\n\n\n\n<div class=\"wp-block-file\"><a id=\"wp-block-file--media-b592849b-c93d-4384-8198-16de351f2efc\" href=\"https://fr.wordpress.org/files/2024/06/IG-ou-Li-carousel.png\">IG-ou-Li-carousel</a><a href=\"https://fr.wordpress.org/files/2024/06/IG-ou-Li-carousel.png\" class=\"wp-block-file__button wp-element-button\" download aria-describedby=\"wp-block-file--media-b592849b-c93d-4384-8198-16de351f2efc\">Télécharger</a></div>\n\n\n\n<div class=\"wp-block-file\"><a id=\"wp-block-file--media-191d59ad-b451-4144-ad3b-cfc9206e1311\" href=\"https://fr.wordpress.org/files/2024/06/LinkedIn.png\">LinkedIn</a><a href=\"https://fr.wordpress.org/files/2024/06/LinkedIn.png\" class=\"wp-block-file__button wp-element-button\" download aria-describedby=\"wp-block-file--media-191d59ad-b451-4144-ad3b-cfc9206e1311\">Télécharger</a></div>\n\n\n\n<div class=\"wp-block-file\"><a id=\"wp-block-file--media-b0eb707c-9c03-4976-ad6e-52f596a0701c\" href=\"https://fr.wordpress.org/files/2024/06/Slide-4_3.png\">Slide-4_3</a><a href=\"https://fr.wordpress.org/files/2024/06/Slide-4_3.png\" class=\"wp-block-file__button wp-element-button\" download aria-describedby=\"wp-block-file--media-b0eb707c-9c03-4976-ad6e-52f596a0701c\">Télécharger</a></div>\n\n\n\n<div class=\"wp-block-file\"><a id=\"wp-block-file--media-b948ac87-b032-44c5-9454-9858890e6a94\" href=\"https://fr.wordpress.org/files/2024/06/Slide-16_9.png\">Slide-16_9</a><a href=\"https://fr.wordpress.org/files/2024/06/Slide-16_9.png\" class=\"wp-block-file__button wp-element-button\" download aria-describedby=\"wp-block-file--media-b948ac87-b032-44c5-9454-9858890e6a94\">Télécharger</a></div>\n\n\n\n<div class=\"wp-block-file\"><a id=\"wp-block-file--media-1393cca2-1c84-4e6d-afbe-c067f007a8ee\" href=\"https://fr.wordpress.org/files/2024/06/X-Twitter.png\">X-Twitter</a><a href=\"https://fr.wordpress.org/files/2024/06/X-Twitter.png\" class=\"wp-block-file__button wp-element-button\" download aria-describedby=\"wp-block-file--media-1393cca2-1c84-4e6d-afbe-c067f007a8ee\">Télécharger</a></div>\n\n\n\n<div class=\"wp-block-file\"><a id=\"wp-block-file--media-ca5d6b68-5aea-4207-aa36-af33bba9f158\" href=\"https://fr.wordpress.org/files/2024/06/post-WPTD-2024.png\">post-WPTD-2024</a><a href=\"https://fr.wordpress.org/files/2024/06/post-WPTD-2024.png\" class=\"wp-block-file__button wp-element-button\" download aria-describedby=\"wp-block-file--media-ca5d6b68-5aea-4207-aa36-af33bba9f158\">Télécharger</a></div>\n\n\n\n<p>Merci à Béryl de la Grandière (<a href=\"https://profiles.wordpress.org/beryldlg/\">@beryldlg</a>) pour ces visuels.</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3070\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"WordPress 6.5 « Regina »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://fr.wordpress.org/2024/04/02/wordpress-6-5-regina/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Apr 2024 19:04:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3027\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:388:\"Souhaitons la bienvenue à WordPress&#160;6.5 «&#160;Regina&#160;». Le nom de cette version a été inspiré par le dynamisme de la violoniste de jazz reconnue Regina Carter. Cette artiste renommée et grande pédagogue a tiré profit de ses fondamentaux techniques classiques et de sa grande connaissance du jazz pour se forger la réputation de transcender les possibilités [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:70246:\"\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2024/04/Release-Edition-Inline-Image.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" src=\"https://fr.wordpress.org/files/2024/04/Release-Edition-Inline-Image-1024x683.png\" alt=\"\" class=\"wp-image-3041\" srcset=\"https://fr.wordpress.org/files/2024/04/Release-Edition-Inline-Image-1024x683.png 1024w, https://fr.wordpress.org/files/2024/04/Release-Edition-Inline-Image-300x200.png 300w, https://fr.wordpress.org/files/2024/04/Release-Edition-Inline-Image-768x512.png 768w, https://fr.wordpress.org/files/2024/04/Release-Edition-Inline-Image-1536x1024.png 1536w, https://fr.wordpress.org/files/2024/04/Release-Edition-Inline-Image-2048x1365.png 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>Souhaitons la bienvenue à WordPress&nbsp;6.5 «&nbsp;Regina&nbsp;». Le nom de cette version a été inspiré par le dynamisme de la violoniste de jazz reconnue <a href=\"https://fr.wikipedia.org/wiki/Regina_Carter\">Regina Carter</a>. Cette artiste renommée et grande pédagogue a tiré profit de ses fondamentaux techniques classiques et de sa grande connaissance du jazz pour se forger la réputation de transcender les possibilités du violon.</p>\n\n\n\n<p>N&rsquo;hésitez pas à <a href=\"https://open.spotify.com/playlist/37i9dQZF1DZ06evO1WEiVo?si=534335c984804713\">découvrir les sonorités du violon de Regina</a> pendant que vous jetterez un œil aux nouveautés de WordPress&nbsp;6.5 <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f3bb.png\" alt=\"🎻\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> </p>\n\n\n\n<p>Cette dernière version de WordPress s&rsquo;est consacrée à l&rsquo;amélioration de nombreux détails de l’expérience d’administration et de personnalisation de votre site. De la bibliothèque de polices à la gestion des révisions au sein de l’éditeur de site, en passant par les nombreuses améliorations de performances, WordPress&nbsp;6.5 apportera beaucoup à votre site.</p>\n\n\n\n<p>&nbsp;«&nbsp;Regina&nbsp;» apporte également plusieurs outils de développement ayant pour objectif de transformer la façon dont les développeuses et développeurs interagissent avec l’éditeur afin d’étendre le système de blocs. L&rsquo;API de gestion des interactions ouvre un nouveau champ de possibilités tandis que l’API <em><bdo lang=\"en\" dir=\"ltr\">Block Bindings</bdo></em> permet de réaliser des connexions dynamiques entre les blocs et les champs personnalisés (ou tout autre type de donnée dynamique). Et ce ne sont que deux exemples des nombreuses évolutions techniques de cette version.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://fr.wordpress.org/download/\">Télécharger WordPress 6.5 «&nbsp;Regina&nbsp;»</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Les nouveautés de WordPress&nbsp;6.5</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Gérez les polices d’écriture de votre site</h3>\n\n\n\n<p>La nouvelle bibliothèque de polices vous permet de contrôler la typographie de votre site sans avoir à mettre les mains dans le code. Installez, supprimez et activez sans effort vos polices locales ou les polices Google sur votre site, quel que soit votre thème actif. La possibilité d‘inclure des collections de polices personnalisées offre encore plus de choix aux personnes qui créent et administrent des sites WordPress.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/03/Font-Manager-1024x666.png\" alt=\"A stylized view of the font manager; part of the new Font Library feature in WordPress 6.5.\" class=\"wp-image-17147\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Davantage d’informations sur vos révisions de styles</h3>\n\n\n\n<p>Travaillez sur vos projets de création avec une vision plus complète de ce qui a été fait et de ce sur quoi vous pouvez vous appuyer. Obtenez des détails tels que l&rsquo;horodatage de chaque modification, des résumés rapides et une liste paginée avec toutes les révisions enregistrées. Consultez les révisions du guide de styles pour voir les changements effectués. Des révisions sont également désormais disponibles pour les modèles et les éléments de modèles.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/03/Revisions-1024x666.png\" alt=\"A closer look at some of the comprehensive details now available for revisions. \" class=\"wp-image-17149\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Des nouveaux contrôles de mise en page et de mise en forme</h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Contrôlez les options de taille, de répétition et de point de focalisation afin d’ajouter un intérêt visuel et créatif à vos mises en page.</li>\n\n\n\n<li>Réglez les proportions de taille d’image du bloc Bannière et ajoutez facilement des superpositions de couleurs se basant sur une couleur automatiquement extraite de l’image choisie.</li>\n\n\n\n<li>En activant le support des ombres portées, vous pouvez créer des mises en page avec une profondeur visuelle ou ajouter un peu de personnalité à votre design.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/03/design-tools-1024x666.png\" alt=\"A stylized close up of setting a focal point on a minimalist background image featuring a pale blue sky and contrasting dark grey building. \" class=\"wp-image-17150\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Découvrez les nouvelles vues de données</h3>\n\n\n\n<p>Retrouvez et organisez vos données comme vous le souhaitez avec des vues de données pour les pages, les modèles de pages, les compositions et les éléments de modèles. Affichez-les sous forme de tableau ou de grille avec la possibilité d’afficher ou de masquer les champs et de faire des modifications groupées.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/03/Data-Views-1024x666.png\" alt=\"A snapshot of the UI that lets you choose your data view. \" class=\"wp-image-17151\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Un glisser-déposer plus fluide</h3>\n\n\n\n<p>Vous verrez la différence lorsque vous déplacerez des éléments, grâce à des indices visuels utiles tels que les objets immédiatement déplacés dans la vue liste ou le glissement fluide vers n’importe quel endroit de votre espace de travail.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/03/drag-and-drop-1024x666.png\" alt=\"\" class=\"wp-image-17152\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Amélioration des réglages des liens</h3>\n\n\n\n<p>Créez et gérez facilement les liens avec une expérience de gestion plus intuitive&nbsp;: une interface d’utilisation simplifiée et un raccourci pour copier les liens.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/03/ink-controls-1024x666.png\" alt=\"\" class=\"wp-image-17153\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Quelques nouveautés pour le développement sur WP&nbsp;6.5</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Ajoutez des interactions aux blocs avec l’API de gestion des interactions</h3>\n\n\n\n<p>L’API de gestion des interactions offre aux développeurs et développeuses une méthode normée pour construire des expériences d’interfaces interactives avec des blocs. Elle simplifie le processus en réduisant les dépendances à des outils externes, tout en conservant des performances optimales. Utilisez-la pour créer des expériences utilisateur mémorables, par exemple en récupérant instantanément les résultats de recherche ou en permettant aux internautes d’interagir avec le contenu en temps réel.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Connectez les blocs aux champs personnalisés ou autres contenus dynamiques</h3>\n\n\n\n<p>Liez les attributs des blocs de base aux champs personnalisés et utilisez la valeur des champs personnalisés sans créer de blocs personnalisés. Grâce à l’API «&nbsp;Block Bindings&nbsp;», les développeurs/développeuses peuvent étendre cette fonctionnalité en liant les blocs à n’importe quel contenu dynamique, même au-delà des champs personnalisés. Si des données sont stockées ailleurs, les blocs peuvent facilement pointer vers cette nouvelle source en quelques lignes de code seulement.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Ajoutez les outils de gestion de l’apparence aux thèmes classiques</h3>\n\n\n\n<p>Améliorez l‘expérience de conception des designers et créateurs utilisant des thèmes classiques. Optez pour cela pour l’activation du support des options d‘espacement, de bordure, de typographie et de couleur, même sans utiliser theme.json. Une fois le support activé, plus d‘outils seront automatiquement ajoutés au fur et à mesure de leur disponibilité.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Découvrez les améliorations de l’expérience de gestion des extensions</h3>\n\n\n\n<p>Il existe à présent un moyen plus simple de gérer les dépendances des extensions. Les auteurs et les autrices d’extensions peuvent fournir un nouvel en-tête&nbsp;<code>Requires Plugins</code>&nbsp;avec la liste des slugs, séparés par des virgules, des extensions nécessaires donnant aux utilisateurs et utilisatrices, des liens pour installer et activer ces extensions au préalable.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations des performances</h3>\n\n\n\n<p>Cette version comprend plus de 110 améliorations de performance, avec une augmentation impressionnante de la vitesse et de l’efficacité de l’éditeur de bloc et l’éditeur de site. Le chargement, la saisie et la navigation dans l’éditeur de site sont deux fois plus rapides que sur la version 6.4.</p>\n\n\n\n<p>Les sites traduits bénéficient d’une amélioration de 25% de leur temps de chargement sur cette version.</p>\n\n\n\n<p>Le support du format d’images AVIF a aussi été ajouté.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations de l’accessibilité</h3>\n\n\n\n<p>Cette version comprend plus de 65 améliorations en matière d‘accessibilité sur toute la plateforme, la rendant plus accessible que jamais. Cette mise à jour apporte des corrections aux réglages de contraste, à la focalisation du curseur, aux sous-menus et au positionnement des éléments, parmi bien d‘autres, qui aident à améliorer l‘expérience WordPress pour tout le monde.</p>\n\n\n\n<h2 class=\"wp-block-heading\">En savoir plus sur WordPress 6.5</h2>\n\n\n\n<p>Explorez le&nbsp;<a href=\"https://fr.wordpress.org/2024/03/16/guide-des-changements-techniques-de-wordpress-6-5/\">Guide des changements techniques de WordPress 6.5</a> pour découvrir les changements de cette version avec les notes détaillées des développeurs et développeuses qui vous aident à construire avec WordPress.</p>\n\n\n\n<p>Vous pouvez suivre le <a href=\"https://developer.wordpress.org/news/\">blog d’aide au développement avec WordPress (en anglais)</a> pour suivre l&rsquo;évolution technique de WordPress et consulter des tutoriels sur les fonctionnalités du CMS.</p>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\"><em>Learn WordPress</em></a>&nbsp;est une ressource gratuite pour les personnes qui utilisent WordPress, qu’elles soient débutantes ou expérimentées.&nbsp;<em>Learn</em>&nbsp;contient des vidéos pratiques sur l’utilisation de diverses fonctionnalités de WordPress, des&nbsp;<a href=\"https://learn.wordpress.org/online-workshops/\">évènements interactifs</a>&nbsp;pour explorer des sujets en profondeur, et des plans de cours pour approfondir des domaines spécifiques de WordPress.</p>\n\n\n\n<p>Pour plus d’informations techniques sur WordPress 6.5 comme par exemple les fichiers modifiés, les mises à jour de paquets ou les bugs corrigés consultez la <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-5/\">notice technique de WP&nbsp;6.5 (en anglais)</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">L’équipe de direction de WordPress&nbsp;6.5</h2>\n\n\n\n<p>Voici l’équipe qui a coordonné le développement et la sortie de cette nouvelle version de WordPress&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Direction générale&nbsp;: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Coordination générale&nbsp;: <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a>, <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> et <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a></li>\n\n\n\n<li>Direction technique côté Cœur&nbsp;: <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> et <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a></li>\n\n\n\n<li>Direction technique côté Gutenberg&nbsp;: <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> et <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a></li>\n\n\n\n<li>Gestion de projet technique côté Cœur&nbsp;: <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a> et <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a></li>\n\n\n\n<li>Gestion de projet technique côté Gutenberg&nbsp;: <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> et <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a></li>\n\n\n\n<li>Direction du design&nbsp;: <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> et <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a></li>\n\n\n\n<li>Direction marketing et communication&nbsp;: <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a> et <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a></li>\n\n\n\n<li>Responsable de la documentation&nbsp;: <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a>, <a href=\"https://profiles.wordpress.org/leonnugraha/\">Leonardus Nugraha</a> et <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a></li>\n\n\n\n<li>Responsables des performances&nbsp;: <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> et <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a></li>\n\n\n\n<li>Responsables des tests&nbsp;: <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a>, <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> et <a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a></li>\n\n\n\n<li>Responsable des thèmes natifs&nbsp;: <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux contributeurs et contributrices</h2>\n\n\n\n<p>WordPress 6.5 n’aurait pas pu sortir sans la contribution passionnée de <strong>702 personnes provenant d’au moins 57 pays différents</strong> et de <strong>plus de 200 entreprises</strong>.</p>\n\n\n\n<p>Un remerciement tout spécial pour les 702 personnes qui ont contribué au cœur de WordPress pour la première fois avec WP&nbsp;6.5 <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p class=\"is-style-wporg-props-long alignfull has-black-color has-text-color has-background has-link-color has-extra-small-font-size wp-elements-0d70530c06fde7a1042490da172d9e21\" style=\"background:linear-gradient(150deg,rgb(207,202,190) 0%,rgb(234,233,231) 100%)\"><a href=\"https://profiles.wordpress.org/benniledl/\">!Benni</a> · <a href=\"https://profiles.wordpress.org/_ck_/\">_ck_</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/abletec/\">abletec</a> · <a href=\"https://profiles.wordpress.org/acosmin/\">acosmin</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/adarshposimyth/\">Adarsh Akshat</a> · <a href=\"https://profiles.wordpress.org/ajmcfadyen/\">admcfajn</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/skyakash12/\">Akash Muchandikar</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/akmelias/\">akmelias</a> · <a href=\"https://profiles.wordpress.org/wpfy/\">Akramul Hasan</a> · <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a> · <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a> · <a href=\"https://profiles.wordpress.org/alanfuller/\">Alan Fuller</a> · <a href=\"https://profiles.wordpress.org/ahoereth/\">Alex</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/alexkingorg/\">Alex King</a> · <a href=\"https://profiles.wordpress.org/akirk/\">Alex Kirk</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/viper007bond/\">Alex Mills</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alexanderkoledov/\">Alexander</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a> · <a href=\"https://profiles.wordpress.org/sabreuse/\">Amy Hendrix (sabreuse)</a> · <a href=\"https://profiles.wordpress.org/amykamala/\">Amy Kamala</a> · <a href=\"https://profiles.wordpress.org/anandau14/\">Anand Upadhyay</a> · <a href=\"https://profiles.wordpress.org/anlino/\">Anders Norén</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/andrewhayward/\">Andrew Hayward</a> · <a href=\"https://profiles.wordpress.org/l1nuxjedi/\">Andrew Hutchings</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/norcross/\">Andrew Norcross</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/andrewleap/\">andrewleap</a> · <a href=\"https://profiles.wordpress.org/andbalashov/\">Andrii Balashov</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/apeatling/\">Andy Peatling</a> · <a href=\"https://profiles.wordpress.org/aneeshd16/\">Aneesh Devasthale</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ant1busted/\">Antoine</a> · <a href=\"https://profiles.wordpress.org/antonlukin/\">Anton Lukin</a> · <a href=\"https://profiles.wordpress.org/atimmer/\">Anton Timmermans</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/lighthouse79/\">Antonella</a> · <a href=\"https://profiles.wordpress.org/colomet/\">Antonio D.</a> · <a href=\"https://profiles.wordpress.org/antonisme/\">Antonis Lilis</a> · <a href=\"https://profiles.wordpress.org/arena94/\">arena94</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/passoniate/\">Arslan Kalwar</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/iamarunchaitanyajami/\">Arun Chaitanya Jami</a> · <a href=\"https://profiles.wordpress.org/dextorlobo/\">Arun Sharma</a> · <a href=\"https://profiles.wordpress.org/ideag/\">Arunas Liuiza</a> · <a href=\"https://profiles.wordpress.org/iamasadpolash/\">Asad Polash</a> · <a href=\"https://profiles.wordpress.org/ashfame/\">Ashish Kumar (Ashfame)</a> · <a href=\"https://profiles.wordpress.org/mohonchandra/\">Asish Chandra Mohon</a> · <a href=\"https://profiles.wordpress.org/audunmb/\">audunmb</a> · <a href=\"https://profiles.wordpress.org/aurooba/\">Aurooba Ahmed</a> · <a href=\"https://profiles.wordpress.org/filosofo/\">Austin Matzko</a> · <a href=\"https://profiles.wordpress.org/axwax/\">axwax</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> · <a href=\"https://profiles.wordpress.org/bahia0019/\">bahia0019</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/bangank36/\">bangank36</a> · <a href=\"https://profiles.wordpress.org/barryhughes-1/\">Barry</a> · <a href=\"https://profiles.wordpress.org/barry/\">Barry</a> · <a href=\"https://profiles.wordpress.org/bartkalisz/\">Bart Kalisz</a> · <a href=\"https://profiles.wordpress.org/bartkleinreesink/\">bartkleinreesink</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/beaulebens/\">Beau Lebens</a> · <a href=\"https://profiles.wordpress.org/bedas/\">Beda</a> · <a href=\"https://profiles.wordpress.org/benharri/\">ben</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/ubernaut/\">Ben Hansen</a> · <a href=\"https://profiles.wordpress.org/husobj/\">Ben Huson</a> · <a href=\"https://profiles.wordpress.org/blobaugh/\">Ben Lobaugh (blobaugh)</a> · <a href=\"https://profiles.wordpress.org/britner/\">Ben Ritner – Kadence WP</a> · <a href=\"https://profiles.wordpress.org/retlehs/\">Ben Word</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benjaminknox/\">benjaminknox</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/billseymour/\">billseymour</a> · <a href=\"https://profiles.wordpress.org/bplv/\">Biplav</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/bobbingwide/\">bobbingwide</a> · <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a> · <a href=\"https://profiles.wordpress.org/born2webdesign/\">born2webdesign</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradparbs/\">Brad Parbs</a> · <a href=\"https://profiles.wordpress.org/williamsba1/\">Brad Williams</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/drrobotnik/\">Brandon Lavigne</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/fischfood/\">Brian Fischer</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a> · <a href=\"https://profiles.wordpress.org/brianhenryie/\">Brian Henry</a> · <a href=\"https://profiles.wordpress.org/brookemk/\">Brooke</a> · <a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a> · <a href=\"https://profiles.wordpress.org/ecc/\">camya</a> · <a href=\"https://profiles.wordpress.org/karl94/\">Carlo Cannas</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/cenkdemir/\">cenkdemir</a> · <a href=\"https://profiles.wordpress.org/cfinnberg/\">cfinnberg</a> · <a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a> · <a href=\"https://profiles.wordpress.org/chasedsiedu/\">chased@si.edu</a> · <a href=\"https://profiles.wordpress.org/mel_cha/\">chiilog (Chiaki Okamoto)</a> · <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a> · <a href=\"https://profiles.wordpress.org/chrisdavidmiles/\">Chris David Miles</a> · <a href=\"https://profiles.wordpress.org/jazzs3quence/\">Chris Reynolds</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/itschristiandale/\">christian-dale</a> · <a href=\"https://profiles.wordpress.org/christopherplus/\">Christopher</a> · <a href=\"https://profiles.wordpress.org/chrystl/\">Chrystl</a> · <a href=\"https://profiles.wordpress.org/codepo8/\">codepo8</a> · <a href=\"https://profiles.wordpress.org/cdevroe/\">Colin Devroe</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">Cory Birdsong</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/creativeslice/\">Creative Slice</a> · <a href=\"https://profiles.wordpress.org/crstauf/\">crstauf</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/cvorko/\">cvorko</a> · <a href=\"https://profiles.wordpress.org/didierjm/\">cybeardjm</a> · <a href=\"https://profiles.wordpress.org/cyberchicken/\">Cyberchicken</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/mzaweb/\">Daniel Dvorkin</a> · <a href=\"https://profiles.wordpress.org/mapumba/\">Daniel Käfer</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/schutzsmith/\">Daniel Schutzsmith</a> · <a href=\"https://profiles.wordpress.org/danieldudzic/\">danieldudzic</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/danieltj/\">danieltj</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/darssen/\">darssen</a> · <a href=\"https://profiles.wordpress.org/dartiss/\">David Artiss</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/dglingren/\">David Lingren</a> · <a href=\"https://profiles.wordpress.org/davidperez/\">David Perez</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/denis-de-bernardy/\">Denis de Bernardy</a> · <a href=\"https://profiles.wordpress.org/dingo_d/\">Denis Žoljom</a> · <a href=\"https://profiles.wordpress.org/dionysous/\">Dennis Hipp</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dennysdionigi/\">Dennys Dionigi</a> · <a href=\"https://profiles.wordpress.org/derekblank/\">Derek Blank</a> · <a href=\"https://profiles.wordpress.org/valendesigns/\">Derek Herman</a> · <a href=\"https://profiles.wordpress.org/derekspringer/\">Derek Springer</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/desrosjbot/\">Desrosj Bot</a> · <a href=\"https://profiles.wordpress.org/dernin/\">Devin Curtis</a> · <a href=\"https://profiles.wordpress.org/dlocc/\">Devin Walker</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruvishah2203/\">Dhruvi Shah</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/dougal/\">Dougal Campbell</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/lots0logs/\">Dustin Falgout</a> · <a href=\"https://profiles.wordpress.org/elrae/\">Earle Davies</a> · <a href=\"https://profiles.wordpress.org/ehtis/\">Ehtisham Siddiqui</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a> · <a href=\"https://profiles.wordpress.org/codex-m/\">Emerson Maningo</a> · <a href=\"https://profiles.wordpress.org/emirpprime/\">emirpprime</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/endymion00/\">Endymion00</a> · <a href=\"https://profiles.wordpress.org/ericlewis/\">Eric Andrew Lewis</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a> · <a href=\"https://profiles.wordpress.org/fabiorubioglio/\">Fabio Rubioglio</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisalahmed29/\">Faisal Ahmed</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fanly/\">Fanly</a> · <a href=\"https://profiles.wordpress.org/feastdesignco/\">Feast Design Co.</a> · <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/fgiannar/\">fgiannar</a> · <a href=\"https://profiles.wordpress.org/flhz/\">Florent Hernandez</a> · <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a> · <a href=\"https://profiles.wordpress.org/francescocarlucci/\">FrancescoCarlucci</a> · <a href=\"https://profiles.wordpress.org/fotodrachen/\">Frank Jäger</a> · <a href=\"https://profiles.wordpress.org/nexflaszlo/\">Frank Laszlo</a> · <a href=\"https://profiles.wordpress.org/wazeter/\">Frank Wazeter</a> · <a href=\"https://profiles.wordpress.org/fushar/\">fushar</a> · <a href=\"https://profiles.wordpress.org/gajendrasingh/\">Gajendra Singh</a> · <a href=\"https://profiles.wordpress.org/ecgan/\">Gan Eng Chin</a> · <a href=\"https://profiles.wordpress.org/garibiza/\">Garbiñe</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/gavande1/\">gavande1</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a> · <a href=\"https://profiles.wordpress.org/gerardreches/\">Gerard Reches</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/girishpanchal/\">Girish Panchal</a> · <a href=\"https://profiles.wordpress.org/giuseppemazzapica-1/\">Giuseppe Mazzapica</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/goldenapples/\">goldenapples</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/gregbenz/\">gregbenz</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">gvgvgvijayan</a> · <a href=\"https://profiles.wordpress.org/poran766/\">H.M. Mushfiqur Rahman</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hardik2221/\">Hardik Raval</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harsh175/\">Harsh Patel</a> · <a href=\"https://profiles.wordpress.org/hasanuzzamanshamim/\">Hasanuzzaman Shamim</a> · <a href=\"https://profiles.wordpress.org/halounsbury/\">Heather Lounsbury</a> · <a href=\"https://profiles.wordpress.org/muhme/\">Heiko Lübbe</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/helgatheviking/\">HelgaTheViking</a> · <a href=\"https://profiles.wordpress.org/tejwanihemant/\">Hemant Tejwani</a> · <a href=\"https://profiles.wordpress.org/kurudrive/\">Hidekazu Ishikawa</a> · <a href=\"https://profiles.wordpress.org/panchalhimani711/\">Himani Panchal</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/hiteshtalpada/\">Hitesh Talpada</a> · <a href=\"https://profiles.wordpress.org/h71/\">Hossein</a> · <a href=\"https://profiles.wordpress.org/howdy_mcgee/\">Howdy_McGee</a> · <a href=\"https://profiles.wordpress.org/hrrarya/\">Hridoy Mozumder</a> · <a href=\"https://profiles.wordpress.org/hrithikd/\">Hrithik Dalal</a> · <a href=\"https://profiles.wordpress.org/hlashbrooke/\">Hugh Lashbrooke</a> · <a href=\"https://profiles.wordpress.org/ganon/\">Hugo Chinchilla</a> · <a href=\"https://profiles.wordpress.org/hugod/\">hugod</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/ianbelanger/\">Ian Belanger</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/idad5/\">idad5</a> · <a href=\"https://profiles.wordpress.org/igmoweb/\">Ignacio Cruz Moreno</a> · <a href=\"https://profiles.wordpress.org/ignatiusjeroe/\">ignatiusjeroe</a> · <a href=\"https://profiles.wordpress.org/shaampk1/\">Ihtisham Zahoor</a> · <a href=\"https://profiles.wordpress.org/fnpen/\">Ilya Zolotov</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">ironprogrammer</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/iseulde/\">iseulde</a> · <a href=\"https://profiles.wordpress.org/itpathsolutions/\">IT Path Solutions</a> · <a href=\"https://profiles.wordpress.org/itecrs/\">itecrs</a> · <a href=\"https://profiles.wordpress.org/ivanzhuck/\">Ivan Zhuck</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/jadpm/\">jadpm</a> · <a href=\"https://profiles.wordpress.org/jamescollins/\">James Collins</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/james roberts/\">James Roberts</a> · <a href=\"https://profiles.wordpress.org/jamieblomerus/\">Jamie Blomerus</a> · <a href=\"https://profiles.wordpress.org/perrelet/\">Jamie Perrelet</a> · <a href=\"https://profiles.wordpress.org/janthiel/\">Jan Thiel</a> · <a href=\"https://profiles.wordpress.org/jane/\">jane</a> · <a href=\"https://profiles.wordpress.org/whiteshadow/\">Janis Elsts</a> · <a href=\"https://profiles.wordpress.org/jsandtro/\">jansan</a> · <a href=\"https://profiles.wordpress.org/japh/\">Japh</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarednova/\">jarednova</a> · <a href=\"https://profiles.wordpress.org/jason_the_adams/\">Jason Adams</a> · <a href=\"https://profiles.wordpress.org/pbking/\">Jason Crist</a> · <a href=\"https://profiles.wordpress.org/coolmann/\">Jason Crouse</a> · <a href=\"https://profiles.wordpress.org/jsnjohnston/\">Jason Johnston</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/jayadevankbh/\">Jayadevan k</a> · <a href=\"https://profiles.wordpress.org/jbobich/\">jbobich</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/amieiro/\">Jesús Amieiro</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jghazally/\">jghazally</a> · <a href=\"https://profiles.wordpress.org/jipmoors/\">Jip Moors</a> · <a href=\"https://profiles.wordpress.org/jivygraphics/\">jivygraphics</a> · <a href=\"https://profiles.wordpress.org/jltallon/\">jltallon</a> · <a href=\"https://profiles.wordpress.org/joanrodas/\">Joan</a> · <a href=\"https://profiles.wordpress.org/morehawes/\">Joe</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joelcj91/\">Joel James</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen A.</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnciacia/\">johnciacia</a> · <a href=\"https://profiles.wordpress.org/jb510/\">Jon Brown</a> · <a href=\"https://profiles.wordpress.org/duck_/\">Jon Cave</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/jbrinley/\">Jonathan Brinley</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/joppuyo/\">joppuyo</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/jorgevilchez/\">Jorge Vilchez</a> · <a href=\"https://profiles.wordpress.org/jornp/\">jornp</a> · <a href=\"https://profiles.wordpress.org/joefusco/\">Joseph Fusco</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a> · <a href=\"https://profiles.wordpress.org/joshcanhelp/\">joshcanhelp</a> · <a href=\"https://profiles.wordpress.org/joshuatf/\">joshuatf</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/jrtashjian/\">JR Tashjian</a> · <a href=\"https://profiles.wordpress.org/jsmoriss/\">JS Morisset</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juhise/\">Juhi Saxena</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/ashikur698/\">K M Ashikur Rahman</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/bosskhj/\">Kamrul Hasan</a> · <a href=\"https://profiles.wordpress.org/karinclimber/\">Kari Anderson</a> · <a href=\"https://profiles.wordpress.org/karlijnbk/\">Karlijn Bok</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/tadamarketing/\">Katka</a> · <a href=\"https://profiles.wordpress.org/kawsaralameven/\">kawsaralameven</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/kbat82/\">Kevin Batdorf</a> · <a href=\"https://profiles.wordpress.org/kevincoleman/\">Kevin Coleman</a> · <a href=\"https://profiles.wordpress.org/ktaron/\">Kevin Taron</a> · <a href=\"https://profiles.wordpress.org/kharisblank/\">Kharis Sulistiyono</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kitchin/\">kitchin</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/koen12344/\">Koen Reus</a> · <a href=\"https://profiles.wordpress.org/koesper/\">Koesper</a> · <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/kurtpayne/\">Kurt Payne</a> · <a href=\"https://profiles.wordpress.org/kushang78/\">Kushang Tailor</a> · <a href=\"https://profiles.wordpress.org/kdowns/\">Kylen Downs</a> · <a href=\"https://profiles.wordpress.org/laumindproductscomau/\">lau@mindproducts.com.au</a> · <a href=\"https://profiles.wordpress.org/lada7042/\">Laura Adamonis</a> · <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a> · <a href=\"https://profiles.wordpress.org/wplmillet/\">Laurent MILLET</a> · <a href=\"https://profiles.wordpress.org/lakshmananphp/\">Lax Mariappan</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/munizleo/\">Leo Muniz</a> · <a href=\"https://profiles.wordpress.org/leonnugraha/\">Leonardus Nugraha</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/liammcarthur/\">LiamMcArthur</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/lkraav/\">lkraav</a> · <a href=\"https://profiles.wordpress.org/logikal16/\">logikal16</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/luboslives/\">luboslives</a> · <a href=\"https://profiles.wordpress.org/lucasbustamante/\">lucasbustamante</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">Luis Herranz</a> · <a href=\"https://profiles.wordpress.org/lpawlik/\">Lukas Pawlik</a> · <a href=\"https://profiles.wordpress.org/wpfed/\">Lukasz</a> · <a href=\"https://profiles.wordpress.org/lukefiretoss/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/maartenbelmans/\">Maarten</a> · <a href=\"https://profiles.wordpress.org/mrdollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/mhimon/\">Mahbub Hasan Imon</a> · <a href=\"https://profiles.wordpress.org/mahnewr/\">mahnewr</a> · <a href=\"https://profiles.wordpress.org/maahrokh/\">Mahrokh</a> · <a href=\"https://profiles.wordpress.org/malae/\">Malae</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manyourisms/\">manyourisms</a> · <a href=\"https://profiles.wordpress.org/marc_j/\">Marc_J</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/marcoevich/\">Marcoevich</a> · <a href=\"https://profiles.wordpress.org/margolisj/\">margolisj</a> · <a href=\"https://profiles.wordpress.org/chaton666/\">Marie Comet</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/markjaquith/\">Mark Jaquith</a> · <a href=\"https://profiles.wordpress.org/markoheijnen/\">Marko Heijnen</a> · <a href=\"https://profiles.wordpress.org/flootr/\">Markus</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/mathewemoore/\">mathewemoore</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matiasrecondo77/\">matiasrecondo77</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/cadic/\">Max Lyuchin</a> · <a href=\"https://profiles.wordpress.org/maxpertici/\">Maxime Pertici</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/mhshohel/\">Md Hossain Shohel</a> · <a href=\"https://profiles.wordpress.org/hrshahin/\">Md HR Shahin</a> · <a href=\"https://profiles.wordpress.org/megphillips91/\">Meg Phillips</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/melcarthus/\">melcarthus</a> · <a href=\"https://profiles.wordpress.org/meta4/\">meta4</a> · <a href=\"https://profiles.wordpress.org/metropolis_john/\">metropolis_john</a> · <a href=\"https://profiles.wordpress.org/254volkan/\">mevolkan</a> · <a href=\"https://profiles.wordpress.org/wpscholar/\">Micah Wood</a> · <a href=\"https://profiles.wordpress.org/mshowes/\">Michael Showes</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/michalooki/\">Michalooki</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/miguelsansegundo/\">miguelsansegundo</a> · <a href=\"https://profiles.wordpress.org/miikkamakela/\">Miikka</a> · <a href=\"https://profiles.wordpress.org/mbijon/\">Mike Bijon</a> · <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley (a11n)</a> · <a href=\"https://profiles.wordpress.org/mikeschinkel/\">Mike Schinkel</a> · <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a> · <a href=\"https://profiles.wordpress.org/mikinc860/\">Mikin Chauhan</a> · <a href=\"https://profiles.wordpress.org/gonzomir/\">Milen Petrinski – Gonzo</a> · <a href=\"https://profiles.wordpress.org/mimitips/\">mimi</a> · <a href=\"https://profiles.wordpress.org/mkismy/\">mkismy</a> · <a href=\"https://profiles.wordpress.org/mnydigital/\">mnydigital</a> · <a href=\"https://profiles.wordpress.org/batmoo/\">Mohammad Jangda</a> · <a href=\"https://profiles.wordpress.org/boemedia/\">Monique Dubbelman</a> · <a href=\"https://profiles.wordpress.org/monzuralam/\">Monzur Alam</a> · <a href=\"https://profiles.wordpress.org/man4toman/\">Morteza Geransayeh</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/seusmaniqbal/\">Muhammad Usman Iqbal</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/tanjimtc71/\">Musarrat Anjum Chowdhury</a> · <a href=\"https://profiles.wordpress.org/naoki0h/\">Naoki Ohashi</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/nateallen/\">Nate Allen</a> · <a href=\"https://profiles.wordpress.org/navjotjsingh/\">Navjot Singh</a> · <a href=\"https://profiles.wordpress.org/neffff/\">neffff</a> · <a href=\"https://profiles.wordpress.org/neilorangepeel/\">Neil Hainsworth</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/nerdpressteam/\">NerdPress</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/sessioncookiemonster/\">Nick Martianov</a> · <a href=\"https://profiles.wordpress.org/nickpagz/\">nickpagz</a> · <a href=\"https://profiles.wordpress.org/nico23/\">Nico</a> · <a href=\"https://profiles.wordpress.org/nicolefurlan/\">Nicole Furlan</a> · <a href=\"https://profiles.wordpress.org/bgnicolepaschen/\">Nicole Paschen Caylor</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nielslange/\">Niels Lange</a> · <a href=\"https://profiles.wordpress.org/nihar007/\">Nihar Ranjan Das</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/nko/\">Nikita</a> · <a href=\"https://profiles.wordpress.org/nikmeyer/\">nikmeyer</a> · <a href=\"https://profiles.wordpress.org/rabmalin/\">Nilambar Sharma</a> · <a href=\"https://profiles.wordpress.org/nilovelez/\">Nilo Velez</a> · <a href=\"https://profiles.wordpress.org/dhrupo/\">Niluthpal Purkayastha</a> · <a href=\"https://profiles.wordpress.org/niravsherasiya7707/\">niravsherasiya7707</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a> · <a href=\"https://profiles.wordpress.org/nvwd/\">Nowell VanHoesen</a> · <a href=\"https://profiles.wordpress.org/nudge/\">Nudge Themes</a> · <a href=\"https://profiles.wordpress.org/nwjames/\">nwjames</a> · <a href=\"https://profiles.wordpress.org/obliviousharmony/\">obliviousharmony</a> · <a href=\"https://profiles.wordpress.org/ockham/\">ockham</a> · <a href=\"https://profiles.wordpress.org/oguzkocer/\">oguzkocer</a> · <a href=\"https://profiles.wordpress.org/okat/\">okat</a> · <a href=\"https://profiles.wordpress.org/dargus/\">Old account</a> · <a href=\"https://profiles.wordpress.org/olegfuture/\">olegfuture</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pacicio/\">Pacicio</a> · <a href=\"https://profiles.wordpress.org/pannelars/\">pannelars</a> · <a href=\"https://profiles.wordpress.org/partyfrikadelle/\">partyfrikadelle</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/pauldewouters/\">Paul de Wouters</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/djpaul/\">Paul Wong-Gibbs</a> · <a href=\"https://profiles.wordpress.org/pavelevap/\">pavelevap</a> · <a href=\"https://profiles.wordpress.org/pbaylies/\">Peter Baylies</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/philipp15b/\">Philipp15b</a> · <a href=\"https://profiles.wordpress.org/phillsav/\">Phill</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/mordauk/\">Pippin Williamson</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pmeenan/\">pmeenan</a> · <a href=\"https://profiles.wordpress.org/webtechpooja/\">Pooja Derashri</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/pouicpouic/\">pouicpouic</a> · <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a> · <a href=\"https://profiles.wordpress.org/pratikthink/\">Pratik Kumar</a> · <a href=\"https://profiles.wordpress.org/freewebmentor/\">Prem Tiwari</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">presstoke</a> · <a href=\"https://profiles.wordpress.org/prionkor/\">prionkor</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiq</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/rashiguptaa/\">Rashi Gupta</a> · <a href=\"https://profiles.wordpress.org/rawrly/\">rawrly</a> · <a href=\"https://profiles.wordpress.org/rcain/\">rcain</a> · <a href=\"https://profiles.wordpress.org/rebasaurus/\">rebasaurus</a> · <a href=\"https://profiles.wordpress.org/tabrisrp/\">Remy Perona</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho (a11n)</a> · <a href=\"https://profiles.wordpress.org/renehermi/\">Rene Hermenau</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/rdcoll/\">Rich Collier</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/ravanh/\">Rolf Allard van Hagen</a> · <a href=\"https://profiles.wordpress.org/room34/\">room34</a> · <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/pogidude/\">Ryann Micua</a> · <a href=\"https://profiles.wordpress.org/looswebstudio/\">Ryo</a> · <a href=\"https://profiles.wordpress.org/sereedmedia/\">Sé Reed</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a> · <a href=\"https://profiles.wordpress.org/sabbirshouvo/\">Sabbir Hasan</a> · <a href=\"https://profiles.wordpress.org/sachyya-sachet/\">Sachyya</a> · <a href=\"https://profiles.wordpress.org/sadizaman/\">Sadi Mohammad Zaman</a> · <a href=\"https://profiles.wordpress.org/sadpencil/\">sadpencil</a> · <a href=\"https://profiles.wordpress.org/introvertedbot/\">Sahil</a> · <a href=\"https://profiles.wordpress.org/tohincoderex/\">Saiduzzaman Tohin</a> · <a href=\"https://profiles.wordpress.org/sakibsnaz/\">Sakib MD Nazmush</a> · <a href=\"https://profiles.wordpress.org/salcode/\">Sal Ferrarello</a> · <a href=\"https://profiles.wordpress.org/samba45/\">samba45</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/kim88/\">Samuel Rüegger</a> · <a href=\"https://profiles.wordpress.org/samuelsidler/\">Samuel Sidler</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/sacerro/\">Santiago Cerro López</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarathar/\">Sarath AR</a> · <a href=\"https://profiles.wordpress.org/hellosatya/\">Satyam Vishwakarma (Satya)</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/sayful/\">Sayful Islam</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/sgr33n/\">Sergio de Falco</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shahariaazam/\">Shaharia Azam</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/shanef/\">ShaneF</a> · <a href=\"https://profiles.wordpress.org/cafenoirdesign/\">Shannon Smith</a> · <a href=\"https://profiles.wordpress.org/shaunandrews/\">shaunandrews</a> · <a href=\"https://profiles.wordpress.org/shooper/\">Shawn Hooper</a> · <a href=\"https://profiles.wordpress.org/shidouhikari/\">shidouhikari</a> · <a href=\"https://profiles.wordpress.org/shiponkarmakar/\">Shipon Karmakar</a> · <a href=\"https://profiles.wordpress.org/shreyash3087/\">Shreyash Srivastava</a> · <a href=\"https://profiles.wordpress.org/shubhamsedani/\">Shubham Sedani</a> · <a href=\"https://profiles.wordpress.org/rsiddharth/\">siddharth ravikumar</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/sirajummahdi/\">Sirajum Mahdi</a> · <a href=\"https://profiles.wordpress.org/sjregan/\">sjregan</a> · <a href=\"https://profiles.wordpress.org/soean/\">Soren Wrede</a> · <a href=\"https://profiles.wordpress.org/virtality-marketing-solutions/\">SourceView</a> · <a href=\"https://profiles.wordpress.org/sruthi89/\">sruthi89</a> · <a href=\"https://profiles.wordpress.org/stacimc/\">stacimc</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stephencronin/\">Stephen Cronin</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/stephenh1988/\">Stephen Harris</a> · <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a> · <a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sumisubedi/\">Sumi Subedi</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/svitlana41319/\">Svitlana Sukhoveiko</a> · <a href=\"https://profiles.wordpress.org/syamraj24/\">syamraj24</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/smub/\">Syed Balkhi</a> · <a href=\"https://profiles.wordpress.org/nuhel/\">Syed Nuhel</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/sparklingrobots/\">Tara King</a> · <a href=\"https://profiles.wordpress.org/buley/\">Taylor</a> · <a href=\"https://profiles.wordpress.org/taylorde/\">Taylor Dewey</a> · <a href=\"https://profiles.wordpress.org/taylorgorman/\">Taylor Gorman</a> · <a href=\"https://profiles.wordpress.org/tazotodua/\">tazotodua</a> · <a href=\"https://profiles.wordpress.org/tykoted/\">Teddy Patriarca</a> · <a href=\"https://profiles.wordpress.org/tellyworth/\">Tellyworth</a> · <a href=\"https://profiles.wordpress.org/thakordarshil/\">Thakor Darshil</a> · <a href=\"https://profiles.wordpress.org/themes-1/\">them.es</a> · <a href=\"https://profiles.wordpress.org/thinkluke/\">thinkluke</a> · <a href=\"https://profiles.wordpress.org/griffinjt/\">Thomas Griffin</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kräftner</a> · <a href=\"https://profiles.wordpress.org/threadi/\">threadi</a> · <a href=\"https://profiles.wordpress.org/tnolte/\">Tim Nolte</a> · <a href=\"https://profiles.wordpress.org/timbroddin/\">timbroddin</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timothée Brosille</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tmatsuur/\">tmatsuur</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomybyte/\">Tom</a> · <a href=\"https://profiles.wordpress.org/tomjcafferkey/\">Tom Cafferkey</a> · <a href=\"https://profiles.wordpress.org/hifidesign/\">Tom Finley</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/tomluckies/\">tomluckies</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/tomsommer/\">tomsommer</a> · <a href=\"https://profiles.wordpress.org/tomxygen/\">tomxygen</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemerö</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/torres126/\">torres126</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/toru/\">Toru Miki</a> · <a href=\"https://profiles.wordpress.org/toscho/\">toscho</a> · <a href=\"https://profiles.wordpress.org/wpsmith/\">Travis Smith</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">Utsav Patel</a> · <a href=\"https://profiles.wordpress.org/utsav72640/\">Utsav tilava</a> · <a href=\"https://profiles.wordpress.org/ukdrahul/\">Uttam Kumar Dash</a> · <a href=\"https://profiles.wordpress.org/valerogarte/\">valerogarte</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/vikram6/\">vikram6</a> · <a href=\"https://profiles.wordpress.org/viliamkopecky/\">viliamkopecky</a> · <a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vivekawsm/\">vivekawsm</a> · <a href=\"https://profiles.wordpress.org/vladimiraus/\">vladimiraus</a> · <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a> · <a href=\"https://profiles.wordpress.org/vrajadas/\">Vraja Das</a> · <a href=\"https://profiles.wordpress.org/wasiur195/\">Wasiur Rahman</a> · <a href=\"https://profiles.wordpress.org/welaunchio/\">welaunchio</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whsajid/\">WHSajid</a> · <a href=\"https://profiles.wordpress.org/wpcorner/\">WP Corner</a> · <a href=\"https://profiles.wordpress.org/xlthlx/\">xlthlx</a> · <a href=\"https://profiles.wordpress.org/yansern/\">Yan Sern</a> · <a href=\"https://profiles.wordpress.org/yguyon/\">Yannis Guyon</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yuliyan/\">Yuliyan Slavchev</a> · <a href=\"https://profiles.wordpress.org/yuvrajsinh2211/\">Yuvrajsinh Sisodiya</a> · <a href=\"https://profiles.wordpress.org/tollmanz/\">Zack Tollman</a> · <a href=\"https://profiles.wordpress.org/zanematthew/\">Zane Matthew</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">zieladam</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a> · <a href=\"https://profiles.wordpress.org/chesio/\">Česlav Przywara</a></p>\n\n\n\n<h3 class=\"wp-block-heading\">Merci aux personnes ayant contribué à traduire WordPress&nbsp;6.5 en français</h3>\n\n\n\n<p>WordPress est un projet international et la version 6.5 est déjà complètement disponible dans plus de 70 langues différentes.</p>\n\n\n\n<p>Nous souhaitons remercier ici les personnes ayant participé à la traduction de WordPress 6.5 en français&nbsp;:</p>\n\n\n\n<p class=\"has-black-color has-text-color has-background has-link-color has-small-font-size wp-elements-82f462fa066a7b8c1ada5f06497f997d\" style=\"background:linear-gradient(150deg,rgb(207,202,190) 0%,rgb(234,233,231) 100%)\"><a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/wolforg\">Didier Demory</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/fxbenard\">fxbenard</a>, <a href=\"https://profiles.wordpress.org/xibe\">Xavier Borderie</a>, <a href=\"https://profiles.wordpress.org/beryldlg\">Béryl de La Grandière</a>, <a href=\"https://profiles.wordpress.org/bonaldi\">Bonaldi</a>, <a href=\"https://profiles.wordpress.org/btpub\">Bruno Tritsch</a>, <a href=\"https://profiles.wordpress.org/cauzyolo\">cauzyolo</a>, <a href=\"https://profiles.wordpress.org/charlie67p\">charlie67p</a>, <a href=\"https://profiles.wordpress.org/clementpolito\">Clément Polito</a>, <a href=\"https://profiles.wordpress.org/coralietixeront\">coralietixeront</a>, <a href=\"https://profiles.wordpress.org/ebrockway\">EBrockway</a>, <a href=\"https://profiles.wordpress.org/milouze\">Emil1</a>, <a href=\"https://profiles.wordpress.org/emlebrun\">Emilie LEBRUN</a>, <a href=\"https://profiles.wordpress.org/scoco\">Emilien M.</a>, <a href=\"https://profiles.wordpress.org/frmo\">Frmo</a>, <a href=\"https://profiles.wordpress.org/gaeldenysiak\">Gael Denysiak</a>, <a href=\"https://profiles.wordpress.org/gaellebesson\">gaellebesson</a>, <a href=\"https://profiles.wordpress.org/wplmillet\">Laurent MILLET</a>, <a href=\"https://profiles.wordpress.org/webaxones\">Loïc Antignac</a>, <a href=\"https://profiles.wordpress.org/oellin\">Magali</a>, <a href=\"https://profiles.wordpress.org/nuryko\">Marianna</a>, <a href=\"https://profiles.wordpress.org/marineevain\">Marine EVAIN</a>, <a href=\"https://profiles.wordpress.org/maxpertici\">Maxime Pertici</a>, <a href=\"https://profiles.wordpress.org/nandow\">nandow</a>, <a href=\"https://profiles.wordpress.org/nicolasricher\">Nicolas Richer</a>, <a href=\"https://profiles.wordpress.org/mrbalou06\">Pascal T</a>, <a href=\"https://profiles.wordpress.org/nekojonez\">Pieterjan Deneys</a>, <a href=\"https://profiles.wordpress.org/larrach\">Rachel Peter</a>, <a href=\"https://profiles.wordpress.org/spaceshipone\">Timothée Brosille</a>, <a href=\"https://profiles.wordpress.org/tobifjellner\">tobifjellner (Tor-Bjorn Fjellner)</a>, <a href=\"https://profiles.wordpress.org/virgar\">Virginie Garnier</a> et <a href=\"https://profiles.wordpress.org/whaze\">whaze</a>.</p>\n\n\n\n<p>N’hésitez pas à&nbsp;<a href=\"https://fr.wordpress.org/team/handbook/\">rejoindre les équipes de contribution francophones&nbsp;!</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-small-font-size\">Article publié par&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>. Merci à <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> pour sa relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3027\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Guide des changements techniques de WordPress 6.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://fr.wordpress.org/2024/03/16/guide-des-changements-techniques-de-wordpress-6-5/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 16 Mar 2024 00:04:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=2999\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:399:\"Ce guide décrit les principaux changements techniques que vous trouverez sur WordPress&#160;6.5, dont la sortie est prévue le 26 mars 2024. Sur Trac (l&#8217;outil de tickets utilisés par le cœur de WordPress, environ 344 tickets on été clôturés&#160;: 99 d&#8217;entre eux concernent des améliorations et des nouvelles fonctionnalités, 210 concernent des corrections de bugs, et [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:31860:\"\n<p class=\"has-very-light-gray-to-cyan-bluish-gray-gradient-background has-background\">Ce guide décrit les principaux changements techniques que vous trouverez sur WordPress&nbsp;6.5, dont la sortie est prévue le 26 mars 2024.</p>\n\n\n\n<p>Sur Trac (l&rsquo;outil de tickets utilisés par le cœur de WordPress, environ <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.5&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">344 tickets</a> on été clôturés&nbsp;: <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.5&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">99 d&rsquo;entre eux concernent des améliorations et des nouvelles fonctionnalités</a>, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.5&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">210 concernent des corrections de bugs</a>, et <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=task+(blessed)&amp;milestone=6.5&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">35 d&rsquo;autres tâches diverses et variées</a>. Cette fois, il y a eu <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~performance&amp;milestone=6.5&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=focuses&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">20 tickets qui se sont concentrés sur les performances</a>, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~accessibility&amp;milestone=6.5&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=focuses&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">19 sur l&rsquo;accessibilité</a> et <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~coding-standards&amp;milestone=6.5&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=focuses&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">23 sur la modernisation du code source et sur l&rsquo;application des standards de programmation du CMS</a>.</p>\n\n\n\n<p>Les <a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.5\">versions du projet Gutenberg inclues dans WP 6.5</a> contiennent 373 évolutions, 515 corrections de bugs et 65 améliorations de l&rsquo;accessibilité.</p>\n\n\n\n<p>Les évolutions apportées sur la version 6.5 s&rsquo;étalent sur <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.5&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">40 composants du cœur WP</a>. Vous trouverez dans cet article une liste des changements les plus importants.</p>\n\n\n\n<p>Tous les liens de cet article pointent vers des notes de développement rédigées en anglais. L’objectif est de fournir un panorama général des changements techniques apportés par cette version, en français, puis de diriger les personnes qui souhaitent en savoir plus vers les notes de développement en anglais.</p>\n\n\n\n<p>Pour en savoir plus sur la feuille de route et le calendrier de sortie de WP&nbsp;6.5, consultez cette page : <a href=\"https://make.wordpress.org/core/6-5/\">https://make.wordpress.org/core/6-5/</a></p>\n\n\n\n<h2 class=\"wp-block-heading has-black-color has-text-color has-link-color wp-elements-6df67768f7a11549211ad53b7e24c257\" id=\"high-impact-changes\">Prérequis techniques pour faire tourner WordPress&nbsp;6.5</h2>\n\n\n\n<p>La version minimale supportée de MySQL est passée de 5.0 à 5.5.5 (<a href=\"https://core.trac.wordpress.org/ticket/60036\">ticket #60036</a>).</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"tlSiCOHR47\"><a href=\"https://make.wordpress.org/core/2023/12/08/raising-the-minimum-version-of-mysql-required-in-wordpress-6-5/\">Raising the minimum version of MySQL required in WordPress 6.5</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Raising the minimum version of MySQL required in WordPress 6.5&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2023/12/08/raising-the-minimum-version-of-mysql-required-in-wordpress-6-5/embed/#?secret=RQN3EtHRSy#?secret=tlSiCOHR47\" data-secret=\"tlSiCOHR47\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"major-features-dev-notes\">Fonctionnalités majeures apportées par WP&nbsp;6.5</h2>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"block-editor\">Changements concernant l’éditeur</h3>\n\n\n\n<p>WordPress 6.5 implémente 10 versions de Gutenberg&nbsp;: <a href=\"https://make.wordpress.org/core/2023/10/11/whats-new-in-gutenberg-16-8-11-october/\">16.8</a>, <a href=\"https://make.wordpress.org/core/2023/10/25/whats-new-in-gutenberg-16-9-25-october-2/\">16.9</a>, <a href=\"https://make.wordpress.org/core/2023/11/10/whats-new-in-gutenberg-17-0-9-november/\">17.0</a>, <a href=\"https://make.wordpress.org/core/2023/11/22/whats-new-in-gutenberg-17-1-22-november/\">17.1</a>, <a href=\"https://make.wordpress.org/core/2023/12/06/whats-new-in-gutenberg-17-2-6-december/\">17.2</a>, <a href=\"https://make.wordpress.org/core/2023/12/20/whats-new-in-gutenberg-17-3-20-december/\">17.3</a>, <a href=\"https://make.wordpress.org/core/2024/01/04/whats-new-in-gutenberg-17-4-03-january/\">17.4</a>, <a href=\"https://make.wordpress.org/core/2024/01/17/whats-new-in-gutenberg-17-5-17-january-2024/\">17.5</a>, <a href=\"https://make.wordpress.org/core/2024/01/31/whats-new-in-gutenberg-17-6-31-january/\">17.6</a> et <a href=\"https://make.wordpress.org/core/2024/02/14/whats-new-in-gutenberg-17-7-14th-february/\">17.7</a>. Vous trouverez de nouvelles fonctionnalités, de nouvelles API et de nombreuses améliorations comme par exemple l&rsquo;API de gestion des interactions, la bibliothèque de polices ou l&rsquo;API <em><bdo lang=\"en\" dir=\"ltr\">Block Bindings</bdo></em> qui permet de charger dynamiquement du contenu dans les blocs.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"zTGJeIG79x\"><a href=\"https://make.wordpress.org/core/2024/03/04/interactivity-api-dev-note/\">Interactivity API in 6.5</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Interactivity API in 6.5&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/04/interactivity-api-dev-note/embed/#?secret=BP3bfBzPe0#?secret=zTGJeIG79x\" data-secret=\"zTGJeIG79x\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"aeHTn70nhm\"><a href=\"https://make.wordpress.org/core/2024/03/14/new-feature-font-library/\">New Feature: Font Library</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New Feature: Font Library&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/14/new-feature-font-library/embed/#?secret=t8LR8aiZf0#?secret=aeHTn70nhm\" data-secret=\"aeHTn70nhm\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"wXhMjnlZWs\"><a href=\"https://make.wordpress.org/core/2024/03/06/new-feature-the-block-bindings-api/\">New Feature: The Block Bindings API</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New Feature: The Block Bindings API&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/06/new-feature-the-block-bindings-api/embed/#?secret=9LDqQR1jOn#?secret=wXhMjnlZWs\" data-secret=\"wXhMjnlZWs\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"kSOEJXANFd\"><a href=\"https://make.wordpress.org/core/2024/03/04/block-metadata-viewscriptmodule-field-in-6-5/\">Block metadata viewScriptModule field in 6.5</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Block metadata viewScriptModule field in 6.5&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/04/block-metadata-viewscriptmodule-field-in-6-5/embed/#?secret=yRl8NrcZXE#?secret=kSOEJXANFd\" data-secret=\"kSOEJXANFd\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"fgr7Eh9WG0\"><a href=\"https://make.wordpress.org/core/2024/03/04/updates-to-block-hooks-in-6-5/\">Updates to Block Hooks in 6.5</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to Block Hooks in 6.5&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/04/updates-to-block-hooks-in-6-5/embed/#?secret=xqHNQnC5pX#?secret=fgr7Eh9WG0\" data-secret=\"fgr7Eh9WG0\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"i7jW1A2sTY\"><a href=\"https://make.wordpress.org/core/2024/02/29/performance-improvements-for-registering-block-variations-with-callbacks/\">Performance improvements for registering block variations with callbacks</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Performance improvements for registering block variations with callbacks&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/02/29/performance-improvements-for-registering-block-variations-with-callbacks/embed/#?secret=wBSi3tRFIE#?secret=i7jW1A2sTY\" data-secret=\"i7jW1A2sTY\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"7oIfaxmlW9\"><a href=\"https://make.wordpress.org/core/2024/03/05/unification-of-the-site-and-post-editors-in-6-5/\">Unification of the site and post editors in 6.5</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Unification of the site and post editors in 6.5&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/05/unification-of-the-site-and-post-editors-in-6-5/embed/#?secret=1EIvfu7nj1#?secret=7oIfaxmlW9\" data-secret=\"7oIfaxmlW9\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"6EIPP73tAr\"><a href=\"https://make.wordpress.org/core/2024/03/09/miscellaneous-editor-changes-in-wordpress-6-5/\">Miscellaneous Editor changes in WordPress 6.5</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous Editor changes in WordPress 6.5&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/09/miscellaneous-editor-changes-in-wordpress-6-5/embed/#?secret=WtvUY2vLJl#?secret=6EIPP73tAr\" data-secret=\"6EIPP73tAr\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"html-api\">API processeur HTML</h3>\n\n\n\n<p>WordPress 6.5 apporte des changements significatifs de l&rsquo;API HTML. Le processeur de balises a reçu une attention particulière et un plus grand nombre d&rsquo;éléments HTML sont maintenant supportés. Si vous utilisez la classe <code>WP_HTML_Tag_Processor</code>, alors il y a plusieurs changements dont vous devriez prendre connaissance.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"BN0e1F8yMe\"><a href=\"https://make.wordpress.org/core/2024/03/04/updates-to-the-html-api-in-6-5/\">Updates to the HTML API in 6.5</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to the HTML API in 6.5&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/04/updates-to-the-html-api-in-6-5/embed/#?secret=ln9KARtfky#?secret=BN0e1F8yMe\" data-secret=\"BN0e1F8yMe\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"i18n\">Internationalisation</h3>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/performant-translations/\" target=\"_blank\" rel=\"noreferrer noopener\">L&rsquo;extension «&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">Performant Translations</bdo></em> »</a> a été intégrée au cœur de WordPress. Ce nouveau système de gestion des traductions est bien plus rapide et bien moins gourmand en mémoire que l&rsquo;ancien, grâce au nouveau format <code>.l10n.php</code>. Tous les formats disponibles restent supportés&nbsp;: le nouveau format <code>.l10n.php</code>, mais aussi les formats classiques basés sur des fichiers <code>.mo</code> et <code>.po</code>. Deux nouveau filtres font leur entrée dans le cœur du CMS&nbsp;: <code>translation_file_format</code> et <code>load_translation_file</code>.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"KT4MEhfgP4\"><a href=\"https://make.wordpress.org/core/2024/02/27/i18n-improvements-6-5-performant-translations/\">I18N Improvements in 6.5 (Performant Translations)</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;I18N Improvements in 6.5 (Performant Translations)&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/02/27/i18n-improvements-6-5-performant-translations/embed/#?secret=fbxqrebUJq#?secret=KT4MEhfgP4\" data-secret=\"KT4MEhfgP4\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"media\">Gestion des médias</h3>\n\n\n\n<p>La prise en charge du format d&rsquo;image AVIF a été ajoutée dans WP 6.5. AVIF est un format moderne qui peut être jusqu&rsquo;à 50&nbsp;% moins lourd que JPEG, avec la même qualité d&rsquo;image. Vous pouvez maintenant téléverser, modifier, redimensionner et enregistrer ce format d&rsquo;image, s&rsquo;il est pris en charge par votre hébergement web. La façon de travailler avec des fichiers AVIF reste la même que pour les autres formats d&rsquo;images déjà supportés. En revanche si vous utilisez un réseau multisite il y a quelques spécificités à connaître. Nous vous conseillons dans ce cas de jeter un œil à la FAQ disponible sur cette note de développement.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"682RAd31H2\"><a href=\"https://make.wordpress.org/core/2024/02/23/wordpress-6-5-adds-avif-support/\">WordPress 6.5 adds AVIF support </a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;WordPress 6.5 adds AVIF support &#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/02/23/wordpress-6-5-adds-avif-support/embed/#?secret=dxdpDKfjp5#?secret=682RAd31H2\" data-secret=\"682RAd31H2\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"script-loader\">Chargement des ressources</h3>\n\n\n\n<p>L&rsquo;API de gestion des scripts apporte la prise en charge native des <em>Modules JavaScript</em> et fournit deux modules utilisables dans le cas de <a href=\"https://make.wordpress.org/core/2024/03/04/interactivity-api-dev-note/\">l&rsquo;API de gestion des interactions</a>.</p>\n\n\n\n<p>qu&rsquo;un</p>\n\n\n\n<p></p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"SDLOPVPvCc\"><a href=\"https://make.wordpress.org/core/2024/03/04/script-modules-in-6-5/\">Script Modules in 6.5</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Script Modules in 6.5&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/04/script-modules-in-6-5/embed/#?secret=vjQsNq4gMQ#?secret=SDLOPVPvCc\" data-secret=\"SDLOPVPvCc\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"upgrade-install\">Gestion des mises à jour</h3>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/wp-plugin-dependencies/\">L&rsquo;extension « <em><bdo lang=\"en\" dir=\"ltr\">Plugin Dependencies</bdo></em> »</a> fait enfin son entrée dans le cœur du CMS. Elle permet de gérer les dépendances entre extensions, par exemple pour indiquer qu&rsquo;une extension dépend de l&rsquo;activation d&rsquo;une autre extension et d&rsquo;en informer les personnes chargées de l&rsquo;administration du site directement sur l&rsquo;interface d&rsquo;admin.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"4svgv5uY7m\"><a href=\"https://make.wordpress.org/core/2024/03/05/introducing-plugin-dependencies-in-wordpress-6-5/\">Introducing Plugin Dependencies in WordPress 6.5</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Introducing Plugin Dependencies in WordPress 6.5&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/05/introducing-plugin-dependencies-in-wordpress-6-5/embed/#?secret=tPhoOCr57d#?secret=4svgv5uY7m\" data-secret=\"4svgv5uY7m\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<details class=\"wp-block-details is-layout-flow wp-block-details-is-layout-flow\"><summary>Plus d&rsquo;informations sur la gestion des dépendances d&rsquo;extensions (cliquer pour déplier le contenu)</summary>\n<p>Les dépendances d&rsquo;une extension peuvent être déclarées en utilisant le nouvel entête <code>Requires Plugins</code> sur le fichier principal de l&rsquo;extension. L&rsquo;entête doit contenir une liste de slugs d&rsquo;extensions séparés par une virgule.</p>\n\n\n\n<p>Exemple&nbsp;:</p>\n\n\n\n<pre class=\"wp-block-code\"><code>/**<br> * Plugin Name: Ma super extension<br> * Requires Plugins: une-extension-cool, une-autre-extension<br> */</code></pre>\n\n\n\n<p>Conditions d&rsquo;utilisation&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Les extensions hébergées sur WordPress.org ne peuvent que déclarer des dépendances aussi hébergées sur WordPress.org</li>\n\n\n\n<li>Les extensions qui ne sont pas hébergées sur WordPress.org peuvent déclarer des dépendances hébergées sur WordPress.org ou n&rsquo;importe où ailleurs</li>\n</ul>\n\n\n\n<p>La déclaration de dépendances nécessite de respecter les prérequis suivants&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Pour les extensions déclarant une dépendance&nbsp;:\n<ul class=\"wp-block-list\">\n<li>Elles ne peuvent pas être installées avant que les dépendances ne soient installées</li>\n\n\n\n<li>Elles ne peuvent pas être activées avant que les dépendances ne soient activées</li>\n</ul>\n</li>\n\n\n\n<li>Pour les extensions qui sont des dépendances d&rsquo;autres extensions&nbsp;:\n<ul class=\"wp-block-list\">\n<li>Elles ne peuvent pas être désactivées avant que les extensions qui en dépendent ne soient désactivées</li>\n\n\n\n<li>Elles ne peuvent pas être supprimées tant que les extensions qui en dépendent sont toujours installées sur le site</li>\n</ul>\n</li>\n</ul>\n\n\n\n<p>Les fonctionnalités suivantes <strong>ne sont pas encore prises en charge</strong>&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Gestion des versions</li>\n\n\n\n<li>Déclaration des extensions indispensables («&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">Must-Use</bdo></em>&nbsp;», ou «&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">mu-plugins</bdo></em>&nbsp;») en tant que dépendances</li>\n\n\n\n<li>Thèmes nécessitant des extensions spécifiques</li>\n\n\n\n<li>Désactivation automatique des extensions dépendant d&rsquo;autres extensions qui ont été supprimées</li>\n</ul>\n\n\n\n<p>Un nouveau filtre <code>wp_plugin_dependencies_slug</code> a été introduit afin de permettre d&rsquo;altérer les slugs des dépendances.</p>\n\n\n\n<p>Une nouvelle classe PHP <code>WP_Plugin_Dependencies</code> a été introduite avec une API contenant plusieurs méthodes publiques.</p>\n\n\n\n<p>L&rsquo;interface de l&rsquo;écran de gestion des extensions a été modifiée afin d&rsquo;afficher les dépendances des extensions. L&rsquo;interface des fiches des extensions qui sont dépendantes d&rsquo;autres extensions a été modifiée pour afficher leurs dépendances, avec des liens vers des fenêtres modales pour les installer/activer en premier.</p>\n\n\n\n<p>La redirection automatique depuis l&rsquo;écran <strong>Extensions &gt; Ajouter</strong> n&rsquo;est plus disponible pour les développeuses et développeurs d&rsquo;extensions, qui ne pourront donc plus directement rediriger par exemple vers un écran de configuration après activation de leur extension depuis cet écran.</p>\n</details>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"additional-changes\">Autres changements</h2>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"external-libraries\">Bibliothèques tierces</h3>\n\n\n\n<p>Les bibliothèques tierces suivantes ont été mises à jour&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>getID3 a été mises à jour vers la version 1.9.23 (<a href=\"https://core.trac.wordpress.org/ticket/59683\">ticket #59683</a>)</li>\n\n\n\n<li>PHPMailer a été mise à jour vers la version 6.9.1 (<a href=\"https://core.trac.wordpress.org/ticket/59966\">ticket #59966</a>)</li>\n\n\n\n<li><code>@wordpress/scripts</code> en version 17 arrête le support des versions de Node.js non maintenues. La plus vieille version de Node.js encore supportée est la version 18 (cf. note de développement&nbsp;: <a href=\"https://make.wordpress.org/core/2024/03/09/miscellaneous-editor-changes-in-wordpress-6-5/\" data-type=\"link\" data-id=\"https://make.wordpress.org/core/2024/03/09/miscellaneous-editor-changes-in-wordpress-6-5/\" target=\"_blank\" rel=\"noreferrer noopener\"><bdo lang=\"en\" dir=\"ltr\">Misc Editor Dev Changes</bdo></a>)</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"themes\">Thèmes</h3>\n\n\n\n<p>Les thèmes classiques (non basés sur des blocs) peuvent maintenant proposer l&rsquo;accès aux outils d&rsquo;apparence (<a href=\"https://core.trac.wordpress.org/ticket/60118\">ticket #60118</a>).</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"media-1\">Bibliothèque de médias</h3>\n\n\n\n<p>La gestion des images JEPG progressives a été activée. Un nouveau filtre <code>image_save_progressive</code> a été ajouté, afin de contrôler si les tailles d&rsquo;images intermédiaires sont enregistrées en format progressif ou non (s&rsquo;il est disponible). Par défaut, le rendu progressif est désactivé, ce qui correspond au fonctionnement passé (<a href=\"https://core.trac.wordpress.org/ticket/21668\">ticket #21668</a>).</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"permalinks\">Permaliens</h3>\n\n\n\n<p>Prise en charge de la gestion des permaliens sur les serveurs <em>Caddy</em> (<a href=\"https://core.trac.wordpress.org/ticket/41877\">ticket #41877</a>).</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"rest-api\">API REST</h3>\n\n\n\n<p>Un champ <code>featured_media</code> pour les vignettes de publications a été ajouté au point de terminaison <code>wp/v2/media</code> de l’API REST (<a href=\"https://core.trac.wordpress.org/ticket/41692\">ticket #41692</a>).</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"site-health\">Santé du site</h3>\n\n\n\n<p>L&rsquo;identifiant du site courant a été ajouté aux informations de déboguage pour les installations multisite (<a href=\"https://core.trac.wordpress.org/ticket/60081\">ticket #60081</a>).</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"upgrade-install-1\">Gestion des mises à jours</h3>\n\n\n\n<p>Lors des mises à jour multiples, une vérification des mises à jour des thèmes est maintenant effectuée afin de vérifier que le thème est bien compatible avec la version de WordPress et de PHP utilisée. Cette vérification était déjà en place pour les extensions, mais pas encore pour les thèmes (<a href=\"https://core.trac.wordpress.org/ticket/59758\">ticket #59758</a>).</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"miscellaneous-developer-changes\">Autres modifications</h3>\n\n\n\n<p>Consultez la note de développement listant les autres modifications plus mineures sur WordPress&nbsp;6.5. Certaines modifications peuvent vous concerner.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"g7PUJV073d\"><a href=\"https://make.wordpress.org/core/2024/03/08/miscellaneous-developer-changes-in-wordpress-6-5/\">Miscellaneous developer changes in WordPress 6.5</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous developer changes in WordPress 6.5&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/08/miscellaneous-developer-changes-in-wordpress-6-5/embed/#?secret=Ho1X2giOH7#?secret=g7PUJV073d\" data-secret=\"g7PUJV073d\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"new-modified-hooks\">Nouveaux filtres et crochets d&rsquo;action, ou modifications sur les <bdo lang=\"en\" dir=\"ltr\"><em>hooks</em></bdo> existants</h2>\n\n\n\n<p>Pour une liste complète de tous les filtres et crochets d&rsquo;actions modifiés ou ajoutés sur WP 6.5, veuillez consulter le lien suivant (note : il ne sera disponible qu&rsquo;après la sortie de la version) : <a href=\"https://developer.wordpress.org/reference/since/6.5.0/\">https://developer.wordpress.org/reference/since/6.5.0/</a></p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"new-filter-hooks\">Nouveaux filtres</h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li><code>new_admin_email_subject</code> (<a href=\"https://core.trac.wordpress.org/ticket/59250\">ticket #59250</a>)</li>\n\n\n\n<li><code>wp_is_rest_endpoint</code> (<a href=\"https://core.trac.wordpress.org/ticket/42061\">ticket #42061</a>)</li>\n\n\n\n<li><code>image_save_progressive</code> (<a href=\"https://core.trac.wordpress.org/ticket/21668\">ticket #21668</a>)</li>\n\n\n\n<li><code>wp_admin_canonical_url</code> (<a href=\"https://core.trac.wordpress.org/ticket/59545\">ticket #59545</a>)</li>\n\n\n\n<li><code>wp_plugin_dependencies_slug</code> (<a href=\"https://core.trac.wordpress.org/ticket/22316\">ticket #22316</a>)</li>\n\n\n\n<li><code>hooked_block</code> (<a href=\"https://core.trac.wordpress.org/ticket/59572\">ticket #59572</a>)</li>\n\n\n\n<li><code>hooked_block_{$block_type}</code> (<a href=\"https://core.trac.wordpress.org/ticket/59572\">ticket #59572</a>)</li>\n\n\n\n<li><code>get_block_type_variations</code> (<a href=\"https://core.trac.wordpress.org/ticket/59969\">ticket #59969</a>)</li>\n\n\n\n<li><code>translation_file_format</code> (<a href=\"https://core.trac.wordpress.org/ticket/59656\">ticket #59656</a>)</li>\n\n\n\n<li><code>load_translation_file</code> (<a href=\"https://core.trac.wordpress.org/ticket/59656\">ticket #59656</a>)</li>\n</ul>\n\n\n\n<p class=\"has-very-light-gray-to-cyan-bluish-gray-gradient-background has-background\">Que vous développiez des thèmes ou des extensions, pensez à tester et retester votre code pour vous assurer de sa compatibilité avec ces changements. Vous pouvez utiliser&nbsp;<a href=\"https://fr.wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\" rel=\"noreferrer noopener\">l’extension «&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">Beta Tester</bdo></em>&nbsp;»</a>&nbsp;sur un site de test pour vérifier la compatibilité de vos développements avec la version de test&nbsp;<a href=\"https://wordpress.org/news/2024/03/wordpress-6-5-release-candidate-2/\">WordPress 6.5&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">Release Candidate</bdo></em>&nbsp;2</a>.&nbsp;Nous comptons sur vous pour vérifier que votre code fonctionne correctement avec le cœur du CMS, pour le bien des millions d’utilisateurs et utilisatrices de WordPress&nbsp;<img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p class=\"has-small-font-size\">Ce guide a été traduit et réadapté à partir du <a href=\"https://make.wordpress.org/core/2024/03/15/wordpress-6-5-field-guide/\"><em><bdo lang=\"en\" dir=\"ltr\">Field Guide</bdo></em> de WP 6.5</a> par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>.<br>Merci à <a href=\"https://profiles.wordpress.org/altitudedev/\">Florian Prache</a> et <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> pour leur relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"2999\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"WordCamp Europe – Turin – Juin 2024\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://fr.wordpress.org/2023/12/26/wordcamp-europe-turin-juin-2024/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 26 Dec 2023 13:55:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Évènement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:4:\"wceu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=2952\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:363:\"Le prochain WordCamp Europe aura lieu du 13 au 15 juin à Turin en Italie. Nous vous invitons à vous y rendre pour rencontrer d’autres personnes des communautés européennes et vivre une expérience intéressante et enrichissante. D’ailleurs, vous pouvez y participer de plusieurs manières, en tant que&#160;: Et si vous gérez un meetup local et [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jenny Dupuy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5926:\"\n<p>Le prochain <strong>WordCamp Europe</strong> aura lieu du <strong>13 au 15 juin à Turin en Italie</strong>. Nous vous invitons à vous y rendre pour rencontrer d’autres personnes des communautés européennes et vivre une expérience intéressante et enrichissante.</p>\n\n\n\n<div class=\"wp-block-group is-layout-constrained wp-block-group-is-layout-constrained\">\n<p>D’ailleurs, vous pouvez y participer de plusieurs manières, en tant que&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://europe.wordcamp.org/2024/volunteers/call-for-volunteers/\">bénévole</a> (date limite de candidature : 28 février 2024)&nbsp;;</li>\n\n\n\n<li>ou <a href=\"https://europe.wordcamp.org/2024/sponsors/call-for-sponsors/\">sponsor</a>&nbsp;;</li>\n\n\n\n<li>ou <a href=\"https://europe.wordcamp.org/2024/media-partners/call-for-media-partners/\">partenaire de communication</a> (postulez jusqu’au 9 février 2024)&nbsp;;</li>\n\n\n\n<li>ou encore comme <a href=\"https://europe.wordcamp.org/2024/speakers/call-for-speakers/\">orateur ou oratrice</a> (soumettez vos sujets de conférences jusqu’au 15 janvier 2024).</li>\n</ul>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-2 is-cropped wp-block-gallery-1 is-layout-flex wp-block-gallery-is-layout-flex\">\n<figure class=\"wp-block-image size-large is-style-default\"><a href=\"https://europe.wordcamp.org/2024/volunteers/call-for-volunteers/\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"538\" data-id=\"2966\" src=\"https://fr.wordpress.org/files/2023/12/Call-for-Volunteers-WC-Turin-1024x538.jpg\" alt=\"\" class=\"wp-image-2966\" srcset=\"https://fr.wordpress.org/files/2023/12/Call-for-Volunteers-WC-Turin-1024x538.jpg 1024w, https://fr.wordpress.org/files/2023/12/Call-for-Volunteers-WC-Turin-300x158.jpg 300w, https://fr.wordpress.org/files/2023/12/Call-for-Volunteers-WC-Turin-768x403.jpg 768w, https://fr.wordpress.org/files/2023/12/Call-for-Volunteers-WC-Turin.jpg 1200w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large is-style-default\"><a href=\"https://europe.wordcamp.org/2024/sponsors/call-for-sponsors/\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"538\" data-id=\"2964\" src=\"https://fr.wordpress.org/files/2023/12/Call-for-Sponsors-WC-Turin-1024x538.png\" alt=\"\" class=\"wp-image-2964\" srcset=\"https://fr.wordpress.org/files/2023/12/Call-for-Sponsors-WC-Turin-1024x538.png 1024w, https://fr.wordpress.org/files/2023/12/Call-for-Sponsors-WC-Turin-300x158.png 300w, https://fr.wordpress.org/files/2023/12/Call-for-Sponsors-WC-Turin-768x403.png 768w, https://fr.wordpress.org/files/2023/12/Call-for-Sponsors-WC-Turin.png 1200w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large is-style-default\"><a href=\"https://europe.wordcamp.org/2024/media-partners/call-for-media-partners/\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"538\" data-id=\"2963\" src=\"https://fr.wordpress.org/files/2023/12/Call-for-Media-Partners-WC-Turin-1024x538.jpg\" alt=\"\" class=\"wp-image-2963\" srcset=\"https://fr.wordpress.org/files/2023/12/Call-for-Media-Partners-WC-Turin-1024x538.jpg 1024w, https://fr.wordpress.org/files/2023/12/Call-for-Media-Partners-WC-Turin-300x158.jpg 300w, https://fr.wordpress.org/files/2023/12/Call-for-Media-Partners-WC-Turin-768x403.jpg 768w, https://fr.wordpress.org/files/2023/12/Call-for-Media-Partners-WC-Turin.jpg 1200w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large is-style-default\"><a href=\"https://europe.wordcamp.org/2024/call-for-2025-host-city/\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"538\" data-id=\"2967\" src=\"https://fr.wordpress.org/files/2023/12/Call-for-Host-City-WC-Turin-1024x538.jpg\" alt=\"\" class=\"wp-image-2967\" srcset=\"https://fr.wordpress.org/files/2023/12/Call-for-Host-City-WC-Turin-1024x538.jpg 1024w, https://fr.wordpress.org/files/2023/12/Call-for-Host-City-WC-Turin-300x158.jpg 300w, https://fr.wordpress.org/files/2023/12/Call-for-Host-City-WC-Turin-768x403.jpg 768w, https://fr.wordpress.org/files/2023/12/Call-for-Host-City-WC-Turin.jpg 1200w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://europe.wordcamp.org/2024/speakers/call-for-speakers/\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"538\" data-id=\"2962\" src=\"https://fr.wordpress.org/files/2023/12/Call-for-Speakers-WC-Turin-1024x538.jpg\" alt=\"\" class=\"wp-image-2962\" srcset=\"https://fr.wordpress.org/files/2023/12/Call-for-Speakers-WC-Turin-1024x538.jpg 1024w, https://fr.wordpress.org/files/2023/12/Call-for-Speakers-WC-Turin-300x158.jpg 300w, https://fr.wordpress.org/files/2023/12/Call-for-Speakers-WC-Turin-768x403.jpg 768w, https://fr.wordpress.org/files/2023/12/Call-for-Speakers-WC-Turin.jpg 1200w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n</figure>\n\n\n\n<p>Et si vous gérez un meetup local et souhaitez proposer votre ville comme <a href=\"https://europe.wordcamp.org/2024/call-for-2025-host-city/\">prochaine ville hôte</a> pour le <strong>WordCamp Europe 2025</strong>, l’appel à candidature est ouvert jusqu’au 14 février 2024.</p>\n</div>\n\n\n\n<p>Concernant les conférences, <strong>l’équipe organisatrice souhaite recevoir une grande variété de candidatures</strong>, y compris de personnes issues de groupes habituellement sous-représentés, afin d’offrir aux participants un programme diversifié. Notez qu’un programme de mentorat est disponible pour les personnes sélectionnées qui le désirent. Donc n’hésitez pas à postuler&nbsp;!</p>\n\n\n\n<p>Au final, il vous suffit de choisir comment vous souhaitez participer à ce prochain WordCamp Europe via les liens proposés ci-dessus, et vous ne serez plus qu’à quelques clics de votre départ pour Turin ! Lancez-vous, vous ne le regretterez pas…</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"2952\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:35:\"https://fr.wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"13096031\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Tue, 21 Jan 2025 07:35:03 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:37:\"Accept-Encoding, accept, content-type\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Tue, 10 Dec 2024 16:47:42 GMT\";s:4:\"link\";s:61:\"<https://fr.wordpress.org/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:4:\"gzip\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 1\";}}s:5:\"build\";s:14:\"20240910142038\";}", "off");
INSERT INTO `wp_options` VALUES("868", "_transient_timeout_feed_mod_0d2db5fea5a8633b56992c916819b198", "1737488105", "off");
INSERT INTO `wp_options` VALUES("869", "_transient_feed_mod_0d2db5fea5a8633b56992c916819b198", "1737444905", "off");
INSERT INTO `wp_options` VALUES("870", "_transient_timeout_feed_48c2a7450ae14f12ef8a9b58ca9f0748", "1737488105", "off");
INSERT INTO `wp_options` VALUES("871", "_transient_feed_48c2a7450ae14f12ef8a9b58ca9f0748", "a:4:{s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"feed\";a:1:{i:0;a:6:{s:4:\"data\";s:126:\"\n    \n    \n    \n    \n    \n    \n\n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Planet WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"subtitle\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Planet WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:36:\"https://rss.wpfr.net/feed/wp-planet/\";s:3:\"rel\";s:4:\"self\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"https://rss.wpfr.net/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2025-01-21T07:37:21+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"\n        WP RSS Aggregator\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"uri\";s:27:\"https://wprssaggregator.com\";s:7:\"version\";s:7:\"4.23.13\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"entry\";a:10:{i:0;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://kinsta.com/fr/blog/mode-sombre-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"Mode sombre de WordPress : principaux avantages et comment le configurer\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:49:\"https://kinsta.com/fr/blog/mode-sombre-wordpress/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-01-17T08:14:36.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-01-17T08:14:36.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:265:\"Si vous souhaitez ajouter une option de mode sombre à votre site WordPress, cet article va couvrir tout ce que vous devez savoir. Tout d’abord, vous ...\nThe post Mode sombre de WordPress : principaux avantages et comment le configurer appeared first on Kinsta®.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:428:\"\n        <p>Si vous souhaitez ajouter une option de mode sombre à votre site WordPress, cet article va couvrir tout ce que vous devez savoir. Tout d&#8217;abord, vous ...</p>\n<p>The post <a rel=\"nofollow\" href=\"https://kinsta.com/fr/blog/mode-sombre-wordpress/\">Mode sombre de WordPress : principaux avantages et comment le configurer</a> appeared first on <a rel=\"nofollow\" href=\"https://kinsta.com/fr\">Kinsta®</a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Jeremy Holcombe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://kinsta.com/fr/blog/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Kinsta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:1;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wp-rocket.me/fr/blog/wp-rocket-3-18/#comment-5157329\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"Commentaires sur WP Rocket 3.18 : peaufiner le moteur de performance de votre site web par Valentina Orlandi\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:60:\"https://wp-rocket.me/fr/blog/wp-rocket-3-18/#comment-5157329\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-01-15T17:30:01.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-01-15T17:30:01.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:228:\"En réponse à Benj.\n\nBonjour Benji, pour activer l’option Auto-héberger les Google Fonts, rendez-vous en bas de l’onglet Media > Polices. Assurez-vous d’avoir bien mis WP Rocket à jour pour qu’elle soit disponible. :)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:336:\"\n        <p>En réponse à <a href=\"https://wp-rocket.me/fr/blog/wp-rocket-3-18/#comment-5157054\">Benj</a>.</p>\n<p>Bonjour Benji, pour activer l’option Auto-héberger les Google Fonts, rendez-vous en bas de l’onglet Media &gt; Polices. Assurez-vous d’avoir bien mis WP Rocket à jour pour qu’elle soit disponible. 🙂</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Valentina Orlandi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wp-rocket.me/fr/blog/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WP Rocket\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:2;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://wpmarmite.com/bilan-2024/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Retour sur l’année 2024 de WPMarmite\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:33:\"https://wpmarmite.com/bilan-2024/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-01-14T12:37:25.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-01-14T12:37:25.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:358:\"Bonne année 2025 ! Nous voilà au premier quart du XXIème siècle. Le moins que l’on puisse dire est que ça pique ! Enfin, comme chaque année, je vous partage la rétrospective des 12 derniers mois de WPMarmite. Au passage,...\nRetour sur l’année 2024 de WPMarmite est un article de WPMarmite, le blog qui vous aide à tirer le meilleur de WordPress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:672:\"\n        <p><img width=\"1500\" height=\"830\" src=\"https://wpmarmite.com/wp-content/uploads/2025/01/cover-bilan-2024.jpg\" class=\"attachment-full size-full wp-post-image\" alt=\"Bilan 2024 WPMarmite\" //></p>\n<p>Bonne année 2025 ! Nous voilà au premier quart du XXIème siècle. Le moins que l&#8217;on puisse dire est que ça pique ! Enfin, comme chaque année, je vous partage la rétrospective des 12 derniers mois de WPMarmite. Au passage,...</p>\n<p><a href=\"https://wpmarmite.com/bilan-2024/\">Retour sur l&#8217;année 2024 de WPMarmite</a> est un article de <a href=\"https://wpmarmite.com\">WPMarmite</a>, le blog qui vous aide à tirer le meilleur de WordPress.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Alex Borto\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"http://feedpress.me/WPMarmite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"WP Marmite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:3;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://beapi.fr/blog/tout-ce-que-vous-devez-savoir-avant-de-migrer-vers-gutenberg/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"Tout ce que vous devez savoir avant de migrer vers Gutenberg\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:83:\"https://beapi.fr/blog/tout-ce-que-vous-devez-savoir-avant-de-migrer-vers-gutenberg/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-01-14T11:50:13.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-01-14T11:50:13.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:476:\"Passer à l’éditeur WordPress Gutenberg n’est pas un simple changement technique. C’est une vraie opportunité de moderniser votre façon de gérer les contenus et d’accélérer vos projets. Mais attention : une migration vers Gutenberg ne s’improvise pas. Elle nécessite un plan clair et des choix stratégiques. Chez Be API, nous avons accompagné des entreprises de […]\nThe post Tout ce que vous devez savoir avant de migrer vers Gutenberg appeared first on .\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:15968:\"\n        \n<p>Passer à l’éditeur WordPress Gutenberg n&rsquo;est pas un simple changement technique. C&rsquo;est une vraie opportunité de moderniser votre façon de gérer les contenus et d’accélérer vos projets. Mais attention : une migration vers Gutenberg ne s’improvise pas. Elle nécessite un plan clair et des choix stratégiques. Chez Be API, nous avons accompagné des entreprises de toutes tailles dans cette transition. Et on le voit clairement : <strong>Gutenberg peut transformer le quotidien des équipes, à condition de bien le déployer.</strong></p>\n\n\n\n<h2 class=\"wp-block-heading\">Pourquoi migrer vers Gutenberg ?</h2>\n\n\n\n<p>La gestion de contenu et la contribution sont des enjeux majeurs pour les performances des entreprises. Quand il s&rsquo;agit de gérer vos contenus, l’outil que vous choisissez fait toute la différence. Il peut ralentir vos équipes&#8230; ou soutenir leur productivité. En cela, Gutenberg, l’éditeur de blocs natif de WordPress, change complètement la donne avec une approche simple, flexible et évolutive.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Les avantages clés de Gutenberg</h3>\n\n\n\n<h4 class=\"wp-block-heading\">Une gestion ultra-intuitive grâce aux blocs</h4>\n\n\n\n<p>Imaginez que chaque élément de votre page — texte, image, vidéo — soit un bloc indépendant. Avec Gutenberg, déplacer, modifier ou personnaliser ces blocs devient intuitif et rapide, même pour des non-techniciens.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Des blocs réutilisables qui vous font gagner du temps</strong></h4>\n\n\n\n<p>Les blocs réutilisables standardisent vos éléments fréquents comme les appels à l’action (CTA) ou les tableaux, pour permettre de les déployer en quelques clics sur l’ensemble du site.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Un contrôle total avec le Full Site Editing (FSE)</strong></h4>\n\n\n\n<p>Le Full Site Editing (FSE) dépasse la simple modification des pages pour offrir un contrôle complet sur l’ensemble du site, de l’en-tête au pied de page. Les équipes peuvent ainsi ajuster leur site rapidement, sans nécessiter des développements complexes.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Une interface pensée pour vos équipes</strong></h4>\n\n\n\n<p>Moderne et ergonomique, Gutenberg améliore le quotidien des utilisateurs internes. Résultat : les équipes peuvent gérer leurs contenus plus efficacement, sans être freinées par des outils compliqués.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Les enjeux stratégiques pour les grandes entreprises</h3>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Rédui</strong>re ses coûts </h4>\n\n\n\n<p>En tant que solution open source, Gutenberg supprime les frais de licence des outils propriétaires, tout en limitant les coûts liés aux développements sur-mesure. En prime, vos équipes deviennent plus autonomes, ce qui réduit votre dépendance aux prestataires externes.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Centraliser et harmoniser ses contenus</strong></h4>\n\n\n\n<p>Si vous gérez un réseau de sites web, vous savez combien il peut être difficile de maintenir une cohérence. Avec Gutenberg, il est plus facile de standardiser les contenus tout en offrant la flexibilité nécessaire pour des adaptations locales, renforçant ainsi la gouvernance et l’homogénéité éditoriale.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Accélérer vos délais de mise en ligne</h4>\n\n\n\n<p>Besoin de mettre à jour une page ou de modifier un élément ? Avec Gutenberg, vos équipes internes peuvent agir directement &#8211; et ainsi raccourcir les cycles de validation et d’accélérer la mise en ligne.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Quand est-ce pertinent de migrer ?</h2>\n\n\n\n<p>Adopter une nouvelle technologie est un investissement stratégique qui doit répondre à des besoins clairs ou s’inscrire dans une transformation digitale plus globale. Comment savoir si le moment est venu ? Voici quelques situations et signaux qui peuvent indiquer qu’une migration est la bonne option.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Les signes qu’il est temps de changer</h3>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Votre CMS actuel est trop rigide ou coûteux à maintenir</strong></h4>\n\n\n\n<p>Les CMS propriétaires ou sur-mesure finissent par peser lourd à long terme. Les coûts de licence augmentent, chaque nouvelle fonctionnalité nécessite des développements spécifiques, et cela peut freiner vos projets tout en augmentant votre dépendance à des prestataires externes.</p>\n\n\n\n<p>Posez-vous ces questions :</p>\n\n\n\n<ul>\n<li>Combien de temps et d’argent dépensez-vous pour ajouter ou modifier une fonctionnalité ?</li>\n\n\n\n<li>Votre CMS vous empêche-t-il de répondre rapidement aux besoins de votre organisation ?</li>\n</ul>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Vos équipes peinent à travailler efficacement sur le back-office</strong></h4>\n\n\n\n<p>Une interface complexe ou mal pensée ralentit vos équipes. Résultat : des frustrations, des workflows pénibles, parfois des erreurs de saisie et des pertes de temps. Lorsque la contribution devient un casse-tête, cela peut impacter votre capacité à répondre rapidement aux besoins des clients ou aux évolutions du marché.</p>\n\n\n\n<figure class=\"wp-block-pullquote\"><blockquote><p>Gutenberg permet de réduire d’environ 50% la dépendance des équipes éditoriales aux développeurs, et de ce fait, créer +40% de contenu supplémentaire.</p><cite><strong>source : wp vip</strong></cite></blockquote></figure>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Votre infrastructure technique manque de modernité</strong></h4>\n\n\n\n<p>Au-delà du CMS, c’est votre stack technique globale qui peut freiner vos projets. Si vos outils deviennent obsolètes et ne s’intègrent plus avec des solutions modernes &#8211;  comme des CRM avancés, des DAM ou des outils marketing, c’est un signe qu’il faut changer.</p>\n\n\n\n<p>Questions à vous poser :</p>\n\n\n\n<ul>\n<li>Votre CMS communique facilement avec vos autres outils (CRM, DAM, solutions marketing) ?</li>\n\n\n\n<li>Vos outils actuels ralentissent vos projets techniques (intégrations, mises à jour) ?</li>\n\n\n\n<li>Pouvez-vous facilement ajouter des solutions modernes (IA, automatisations)?</li>\n</ul>\n\n\n\n<p>Face à ces défis, Gutenberg se démarque par sa flexibilité, son interface intuitive et sa capacité à évoluer avec vos besoins, et répond donc à de nombreux enjeux stratégiques, techniques et organisationnels.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Identifier les projets propices à une migration</h3>\n\n\n\n<p>Certains contextes se prêtent plus facilement à la mise en place d’une migration.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Refonte globale ou technique de votre site</strong></h4>\n\n\n\n<p>Une refonte implique souvent une restructuration importante des contenus et des templates. Que ce soit pour moderniser le design, améliorer les performances techniques ou revoir l’architecture globale, inclure Gutenberg dès le départ lors d’une refonte permet d’optimiser les coûts et repartir sur des bases solides pour votre projet.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Déploiement multi-sites</strong></h4>\n\n\n\n<p>Gérer un réseau de sites multi-marques ou multi-filiales pose des défis spécifiques que l’on connait bien :</p>\n\n\n\n<ul>\n<li>Maintenir une identité de marque cohérente sur tous les sites</li>\n\n\n\n<li>Offrir un équilibre entre centralisation et flexibilité.</li>\n\n\n\n<li>Optimiser les ressources dans la gestion des contenus</li>\n</ul>\n\n\n\n<p>Comme mentionné plus haut, avec ses caractéristiques (bloc réutilisables, FSE,…), Gutenberg offre des solutions pour ces différentes problématiques.</p>\n\n\n\n<p>De plus, l’interface intuitive de Gutenberg réduit la courbe d’apprentissage et permet de travailler rapidement. C’est donc l’outil de prédilection à privilégier en cas de refonte ou de création d’une usine à sites.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Les pièges à éviter lors de la migration vers Gutenberg</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Ignorer l’existant lors de la conception UX/UI</h3>\n\n\n\n<p>Un des pièges classiques consiste à redessiner entièrement le site sans tenir compte des contraintes ou des opportunités offertes par Gutenberg.</p>\n\n\n\n<p><strong>Pourquoi c’est un problème ?</strong> Repenser l’interface utilisateur sans intégrer les spécificités de Gutenberg (comme l’éditeur de blocs ou le Full Site Editing) peut rendre le projet plus complexe et coûteux. De plus, négliger l’existant (contenu, structure actuelle) risque de multiplier les incompatibilités et les ajustements imprévus.</p>\n\n\n\n<p><strong>Comment l’éviter ?</strong></p>\n\n\n\n<ul>\n<li>Associez dès le départ vos équipes UX/UI pour qu’elles conçoivent une interface adaptée aux capacités de Gutenberg. </li>\n\n\n\n<li>Réalisez un audit complet de l’existant pour identifier les éléments à conserver, adapter ou supprimer.</li>\n\n\n\n<li>Créez des maquettes pensées pour l’éditeur de blocs, ce qui limitera les besoins en développements spécifiques.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Sous-estimer l’importance du script d’import</h3>\n\n\n\n<p>L’import des contenus est souvent traité en fin de projet comme un simple détail technique. Pourtant, c’est une étape critique qui peut affecter tout le déroulement de la migration.</p>\n\n\n\n<p><strong>Pourquoi c’est un problème ?</strong></p>\n\n\n\n<p>Les contenus existants peuvent être mal formatés ou non compatibles avec les blocs de Gutenberg, ce qui complique leur transfert. Un import mal anticipé peut générer des erreurs, entraîner des pertes de données ou nécessiter des ajustements manuels coûteux en temps.</p>\n\n\n\n<p><strong>Comment l’éviter ?</strong></p>\n\n\n\n<ul>\n<li>Planifiez le script d’import dès la phase de conception technique.</li>\n\n\n\n<li>Identifiez les contenus prioritaires et ceux à exclure.</li>\n\n\n\n<li>Préparez des tests d’import sur un échantillon représentatif pour anticiper les éventuelles corrections.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Penser que tout sera automatisé</h3>\n\n\n\n<p>L’importation des contenus n’est jamais totalement automatique : même avec un script performant, des ajustements manuels (webmastering) seront nécessaires.</p>\n\n\n\n<p><strong>Pourquoi c’est un problème ?</strong></p>\n\n\n\n<ul>\n<li>Les contenus migrés peuvent nécessiter des adaptations pour s’intégrer parfaitement aux blocs de Gutenberg (par exemple, restructurer un article complexe ou ajuster un tableau).</li>\n\n\n\n<li>Cela peut entraîner des retards si l’effort de webmastering n’a pas été anticipé.</li>\n</ul>\n\n\n\n<p><strong>Comment l’éviter ?</strong></p>\n\n\n\n<ul>\n<li>Préparez une équipe dédiée pour gérer les ajustements après l’import.</li>\n\n\n\n<li>Intégrez ces tâches dans le planning global du projet, avec une estimation réaliste des délais.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Négliger les considérations SEO lors de la migration</h3>\n\n\n\n<p>Revoir ses contenus et nettoyer les pages obsolètes est souvent tentant lors d’une migration. Mais ces modifications peuvent avoir un impact négatif sur le référencement si elles ne sont pas correctement planifiées.</p>\n\n\n\n<p><strong>Pourquoi c’est un problème ?</strong></p>\n\n\n\n<ul>\n<li>Supprimer ou déplacer des pages sans redirection peut entraîner une perte de trafic organique.</li>\n\n\n\n<li>Modifier la structure des contenus sans tenir compte des mots-clés ou de l’indexation peut nuire à votre visibilité.</li>\n</ul>\n\n\n\n<p><strong>Comment l’éviter ?</strong></p>\n\n\n\n<ul>\n<li>Effectuez un audit SEO préalable pour identifier les pages stratégiques à conserver.</li>\n\n\n\n<li>Planifiez des redirections pour toutes les pages supprimées ou modifiées.</li>\n\n\n\n<li>Travaillez en collaboration avec un expert SEO pour garantir que la migration n’impacte pas négativement vos performances organiques.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Comment Be API vous accompagne dans votre migration vers Gutenberg</h2>\n\n\n\n<p>Une migration vers Gutenberg peut sembler complexe, mais avec une méthodologie rigoureuse et bien planifiée, tout devient plus simple. Voici comment Be API travaille avec vous pour garantir une transition fluide et réussie :</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Inventaire complet de l’existant</strong></h4>\n\n\n\n<p>On commence par un inventaire précis de votre site actuel. Chaque contenu, structure et fonctionnalité est passé au crible pour évaluer la faisabilité et la complexité de l’importation vers Gutenberg.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Plan clair pour optimiser vos contenus</strong></h4>\n\n\n\n<p>On décide ensemble de ce qui sera conservé, enrichi ou simplifié. On adapte la stratégie d’importation pour ne conserver que les contenus essentiels, organiser vos pages de façon plus performante, et répondre à vos objectifs métiers.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Phase de design &#8211; avec check technique</strong></h4>\n\n\n\n<p>On ne travaille pas en silo. À chaque étape de conception, des vérifications techniques sont effectuées pour garantir que les maquettes soient parfaitement compatibles avec Gutenberg.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Document de mapping précis</strong></h4>\n\n\n\n<p>On produit un document de mapping clair et précis, qui sert de plan directeur pour aligner les contenus existants avec la structure des blocs Gutenberg. Rien n’est laissé au hasard.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Développement anticipé</strong></h4>\n\n\n\n<p>Les développements commencent dès les premières phases pour garantir une progression fluide, sans goulots d’étranglement.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Tests rigoureux tout au long du projet</strong></h4>\n\n\n\n<p>On utilise des jeux de données complexes et aléatoires pour valider chaque étape, et assurer une migration réussie, et s’assurer que rien n’est oublié.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Recette et ajustements continus</strong></h4>\n\n\n\n<p>Chaque élément est vérifié et ajusté en temps réel pour éviter les surprises lors de l’import final.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Import final optimisé</strong></h4>\n\n\n\n<p>On planifie l’importation au moment stratégique, déterminé ensemble, pour garantir une transition fluide et sans interruption.”</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Retour d’expérience</strong></h4>\n\n\n\n<p>Une fois la migration terminée, on organise un REX avec le client pour analyser ensemble les points forts et les éventuelles améliorations. Et, bien sûr, on célèbre le succès du projet (avec un verre de champomy) !</p>\n\n\n\n<h2 class=\"wp-block-heading\">Conclusion</h2>\n\n\n\n<p>Migrer vers Gutenberg, ce n’est pas juste adopter un nouvel outil, c’est repenser votre façon de gérer et de produire vos contenus. Avec une approche modulaire, intuitive et évolutive, Gutenberg offre des opportunités uniques pour simplifier vos processus, gagner en autonomie et répondre aux défis d’un environnement digital en constante évolution.</p>\n\n\n\n<p>Mais une migration réussie ne s’improvise pas. Elle nécessite une vision claire, une stratégie adaptée et un accompagnement rigoureux. Chez Be API, nous mettons notre expertise au service de vos ambitions pour faire de cette transition un levier de modernisation et de performance.</p>\n\n\n\n<p>Prêts à faire évoluer votre gestion de contenu ? <a href=\"https://beapi.fr/contact/?mtm_campaign=migration%20gutenberg&amp;mtm_source=blog\">Bookez un call gratuit : nous sommes à disposition pour en discuter</a> !</p>\n<p>The post <a href=\"https://beapi.fr/blog/tout-ce-que-vous-devez-savoir-avant-de-migrer-vers-gutenberg/\">Tout ce que vous devez savoir avant de migrer vers Gutenberg</a> appeared first on <a href=\"https://beapi.fr\"></a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Alizée Ragoin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://beapi.fr/blog/categories/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BeAPI\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:4;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:119:\"https://promatec.digital/blog/2025/01/13/nouveautes-wordpress-pour-les-developpeurs-ce-qui-vous-attend-en-janvier-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"Nouveautés WordPress pour les développeurs : ce qui vous attend en janvier 2025\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:119:\"https://promatec.digital/blog/2025/01/13/nouveautes-wordpress-pour-les-developpeurs-ce-qui-vous-attend-en-janvier-2025/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-01-13T14:00:00.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-01-13T14:00:00.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:524:\"En tant qu’agence web spécialisée WordPress à Lille, nous continuons notre veille sur les évolutions de ce CMS qui représente une part majeure des sites web dans le monde. En ce début d’année 2025, de nouvelles fonctionnalités passionnantes font leur apparition pour les développeurs. Découvrons ensemble les principales innovations qui vont impacter notre façon de […]\nL’article Nouveautés WordPress pour les développeurs : ce qui vous attend en janvier 2025 est apparu en premier sur Promatec Digital.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:738:\"\n        <p>En tant qu&#8217;agence web spécialisée WordPress à Lille, nous continuons notre veille sur les évolutions de ce CMS qui représente une part majeure des sites web dans le monde. En ce début d&#8217;année 2025, de nouvelles fonctionnalités passionnantes font leur apparition pour les développeurs. Découvrons ensemble les principales innovations qui vont impacter notre façon de [&#8230;]</p>\n<p>L’article <a href=\"https://promatec.digital/blog/2025/01/13/nouveautes-wordpress-pour-les-developpeurs-ce-qui-vous-attend-en-janvier-2025/\">Nouveautés WordPress pour les développeurs : ce qui vous attend en janvier 2025</a> est apparu en premier sur <a href=\"https://promatec.digital\">Promatec Digital</a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Promatec Digital\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://promatec.digital/blog/tag/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Promatec\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:5;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://vincentdubroeucq.com/utiliser-wp-cli-pour-gerer-votre-site-wordpress-partie-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"Utiliser WP CLI pour gérer votre site WordPress – Partie 1\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:86:\"https://vincentdubroeucq.com/utiliser-wp-cli-pour-gerer-votre-site-wordpress-partie-1/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-01-10T11:08:07.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-01-10T11:08:07.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:721:\"Si vous êtes développeur ou que vous utilisez WordPress depuis un certain temps, vous avez forcément entendu parler de WP CLI. Tout comme Git, c’est un outil quasi-incontournable pour vous aider à gérer vos sites WordPress ou accélerer vos développements. Dans cette petite série d’articles, on va voir ce qu’est WP CLI exactement, explorer ses commandes les plus courantes et voir comment vous pouvez l’utiliser dans votre travail quotidien. Qu’est-ce que WP CLI ? WP CLI est l’outil de ligne de commande de WordPress (CLI pour Command Line Interface). Un CLI est simplement un outil qui s’utilise dans un terminal […]Lire la suite : Utiliser WP CLI pour gérer votre site WordPress – Partie 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:893:\"\n        Si vous êtes développeur ou que vous utilisez WordPress depuis un certain temps, vous avez forcément entendu parler de WP CLI. Tout comme Git, c&#8217;est un outil quasi-incontournable pour vous aider à gérer vos sites WordPress ou accélerer vos développements. Dans cette petite série d&#8217;articles, on va voir ce qu&#8217;est WP CLI exactement, explorer ses commandes les plus courantes et voir comment vous pouvez l&#8217;utiliser dans votre travail quotidien. Qu&#8217;est-ce que WP CLI ? WP CLI est l&#8217;outil de ligne de commande de WordPress (CLI pour Command Line Interface). Un CLI est simplement un outil qui s&#8217;utilise dans un terminal [&#8230;]<br><strong>Lire la suite :</strong> <a href=\"https://vincentdubroeucq.com/utiliser-wp-cli-pour-gerer-votre-site-wordpress-partie-1/\">Utiliser WP CLI pour gérer votre site WordPress &#8211; Partie 1</a>\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Vincent\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://vincentdubroeucq.com/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Vincent Dubroeucq\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:6;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://www.geekpress.fr/wplingua-solution-wordpress-multilingue/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"wpLingua : obtenez un site WordPress multilingue en quelques clics !\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:65:\"https://www.geekpress.fr/wplingua-solution-wordpress-multilingue/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-01-09T12:35:38.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-01-09T12:35:38.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:222:\"Découvrez wpLingua, une alternative intuitive et facile à utiliser pour traduire vos sites WordPress !\nCet article wpLingua : obtenez un site WordPress multilingue en quelques clics ! est apparu en premier sur GeekPress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:370:\"\n        <p>Découvrez wpLingua, une alternative intuitive et facile à utiliser pour traduire vos sites WordPress !</p>\n<p>Cet article <a href=\"https://www.geekpress.fr/wplingua-solution-wordpress-multilingue/\">wpLingua : obtenez un site WordPress multilingue en quelques clics !</a> est apparu en premier sur <a href=\"https://www.geekpress.fr\">GeekPress</a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Lycia Diaz\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"http://www.geekpress.fr/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Geekpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:7;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://yesweblog.fr/liste-plugins-themes-wordpress-laissent-taches-cron-apres-desinstallation/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"Liste des plugins et thèmes WordPress qui laissent des tâches Cron après désinstallation\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:95:\"https://yesweblog.fr/liste-plugins-themes-wordpress-laissent-taches-cron-apres-desinstallation/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-01-09T09:40:06.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-01-09T09:40:06.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:551:\"Nouvel Article\n\n	\n	\n	Comme indiqué dans l’article qui présente ce qu’est le Cron WordPress, certains plugins WordPress (=extensions en français) laissent hélas des événements (=tâches) dans le Cron WordPress même quand ils sont désactivés et désinstallés. Ce qui évidemment n’est pas utile et peut heureusement être supprimé. Mais qui devrait pourtant si on est logique être supprimé quand […]\n- Yes We Blog ! - Créer un site web, le faire vivre et le faire connaître - Griselidis GAILLET - Webmaster Freelance - Webdesigner\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:918:\"\n        <p>Nouvel Article</p>\n<div>\n	<a href=\"https://yesweblog.fr/liste-plugins-themes-wordpress-laissent-taches-cron-apres-desinstallation/\"><img title=\"cron wordpress\" src=\"https://yesweblog.fr/wp-content/uploads/2025/01/cron-wordpress-300x200.avif\" alt=\"Cron WordPress\" width=\"300\" height=\"200\" //></a>\n	</div>\n<p>	Comme indiqué dans l&#8217;article qui présente ce qu&#8217;est le Cron WordPress, certains plugins WordPress (=extensions en français) laissent hélas des événements (=tâches) dans le Cron WordPress même quand ils sont désactivés et désinstallés. Ce qui évidemment n&#8217;est pas utile et peut heureusement être supprimé. Mais qui devrait pourtant si on est logique être supprimé quand [&#8230;]</p>\n<p>- <a href=\"https://yesweblog.fr\">Yes We Blog ! - Créer un site web, le faire vivre et le faire connaître - Griselidis GAILLET - Webmaster Freelance - Webdesigner</a></p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Griselidis\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://yesweblog.fr/category/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Yes we blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:8;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"https://wpchannel.com/wordpress/plugins-wordpress/wplingua-extension-multilingue-traduction-automatique/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"wpLingua, une extension multilingue avec traduction automatique\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:104:\"https://wpchannel.com/wordpress/plugins-wordpress/wplingua-extension-multilingue-traduction-automatique/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-01-06T17:49:06.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-01-06T17:49:06.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:378:\"Dans un monde de plus en plus globalisé, disposer d’un site Web accessible dans plusieurs langues est devenu essentiel. Que vous gériez un blog personnel ou une boutique en ligne, offrir une expérience utilisateur adaptée à un public international peut considérablement augmenter votre audience et vos revenus. C’est ici qu’entre en jeu wpLingua, une extension […]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:396:\"\n        Dans un monde de plus en plus globalisé, disposer d’un site Web accessible dans plusieurs langues est devenu essentiel. Que vous gériez un blog personnel ou une boutique en ligne, offrir une expérience utilisateur adaptée à un public international peut considérablement augmenter votre audience et vos revenus. C’est ici qu’entre en jeu wpLingua, une extension [&#8230;]\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Aurélien Denis\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wpchannel.com/feed\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"WP channel\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:9;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://www.gregoirenoyelle.com/ajouter-en-tete-dynamique-wordpress-dans-taxonomie/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"Ajouter un en-tête dynamique dans une taxonomie\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:83:\"https://www.gregoirenoyelle.com/ajouter-en-tete-dynamique-wordpress-dans-taxonomie/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-12-22T11:43:30.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-12-22T11:43:30.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:533:\"J’avais un challenge, Ajouter une image différente pour chaque terme de ma taxonomie sur mesure. J’ai tout de suite pensé à ACF. Nativement, il est possible d’ajouter des métadonnées à n’importe quel terme. Dans la base, c’est la table term_meta qui permet d’ajouter des réglages très variés. D’ailleurs, tous les outils de SEO l’utilisent à […]Cet article a été publié le 22 décembre 2024 par Grégoire Noyelle. Pour le lire en ligne, suivre le lien: Ajouter un en-tête dynamique dans une taxonomie.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:734:\"\n        J&#8217;avais un challenge, Ajouter une image différente pour chaque terme de ma taxonomie sur mesure. J&#8217;ai tout de suite pensé à ACF. Nativement, il est possible d&#8217;ajouter des métadonnées à n&#8217;importe quel terme. Dans la base, c&#8217;est la table term_meta qui permet d&#8217;ajouter des réglages très variés. D&#8217;ailleurs, tous les outils de SEO l&#8217;utilisent à [&#8230;]<p>Cet article a été publié le 22 décembre 2024 par <a href=\"https://www.gregoirenoyelle.com\">Grégoire Noyelle</a>. Pour le lire en ligne, suivre le lien: <a href=\"https://www.gregoirenoyelle.com/ajouter-en-tete-dynamique-wordpress-dans-taxonomie/\">Ajouter un en-tête dynamique dans une taxonomie</a>.</p>\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Grégoire Noyelle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"http://www.gregoirenoyelle.com/category/tuto/wordpress-tutos/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Grégoire Noyelle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:512;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:6:\"server\";s:12:\"nginx/1.27.0\";s:4:\"date\";s:29:\"Tue, 21 Jan 2025 07:37:21 GMT\";s:12:\"content-type\";s:20:\"application/atom+xml\";s:12:\"x-powered-by\";s:10:\"PHP/8.0.30\";s:13:\"last-modified\";s:29:\"Fri, 01 Dec 2023 22:13:18 GMT\";s:4:\"etag\";s:34:\"\"c11b85e08f9a55c369b83cdc4e5e720f\"\";s:4:\"link\";s:57:\"<https://rss.wpfr.net/wp-json/>; rel=\"https://api.w.org/\"\";s:13:\"cache-control\";s:35:\"no-cache, no-store, must-revalidate\";s:6:\"pragma\";s:8:\"no-cache\";s:7:\"expires\";s:1:\"0\";s:25:\"strict-transport-security\";s:16:\"max-age=63072000\";}}s:5:\"build\";s:14:\"20240910142038\";}", "off");
INSERT INTO `wp_options` VALUES("872", "_transient_timeout_feed_mod_48c2a7450ae14f12ef8a9b58ca9f0748", "1737488105", "off");
INSERT INTO `wp_options` VALUES("873", "_transient_feed_mod_48c2a7450ae14f12ef8a9b58ca9f0748", "1737444905", "off");
INSERT INTO `wp_options` VALUES("874", "_transient_timeout_dash_v2_bd94b8f41e74bae2f4dc72e9bd8379af", "1737488105", "off");
INSERT INTO `wp_options` VALUES("875", "_transient_dash_v2_bd94b8f41e74bae2f4dc72e9bd8379af", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://fr.wordpress.org/2024/11/12/wordpress-6-7-rollins/\'>WordPress 6.7 « Rollins »</a></li><li><a class=\'rsswidget\' href=\'https://fr.wordpress.org/2024/10/28/guide-des-changements-techniques-de-wordpress-6-7/\'>Guide des changements techniques de WordPress 6.7</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://kinsta.com/fr/blog/mode-sombre-wordpress/\'>Mode sombre de WordPress : principaux avantages et comment le configurer</a></li><li><a class=\'rsswidget\' href=\'https://wp-rocket.me/fr/blog/wp-rocket-3-18/#comment-5157329\'>Commentaires sur WP Rocket 3.18 : peaufiner le moteur de performance de votre site web par Valentina Orlandi</a></li><li><a class=\'rsswidget\' href=\'https://wpmarmite.com/bilan-2024/\'>Retour sur l’année 2024 de WPMarmite</a></li></ul></div>", "off");
INSERT INTO `wp_options` VALUES("876", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1737455711", "off");
INSERT INTO `wp_options` VALUES("877", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "O:8:\"stdClass\":100:{s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";i:6756;}s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";i:4866;}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";i:2791;}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";i:2691;}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";i:2101;}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";i:1995;}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";i:1936;}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";i:1810;}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";i:1594;}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";i:1590;}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";i:1572;}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";i:1546;}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";i:1511;}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";i:1507;}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";i:1450;}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";i:1317;}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";i:1316;}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";i:1192;}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";i:1172;}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";i:1170;}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";i:1160;}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";i:1032;}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";i:1027;}s:7:\"payment\";a:3:{s:4:\"name\";s:7:\"payment\";s:4:\"slug\";s:7:\"payment\";s:5:\"count\";i:999;}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";i:994;}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";i:964;}s:5:\"block\";a:3:{s:4:\"name\";s:5:\"block\";s:4:\"slug\";s:5:\"block\";s:5:\"count\";i:963;}s:9:\"gutenberg\";a:3:{s:4:\"name\";s:9:\"gutenberg\";s:4:\"slug\";s:9:\"gutenberg\";s:5:\"count\";i:940;}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";i:911;}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";i:908;}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";i:902;}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";i:902;}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";i:896;}s:15:\"payment-gateway\";a:3:{s:4:\"name\";s:15:\"payment gateway\";s:4:\"slug\";s:15:\"payment-gateway\";s:5:\"count\";i:862;}s:9:\"elementor\";a:3:{s:4:\"name\";s:9:\"elementor\";s:4:\"slug\";s:9:\"elementor\";s:5:\"count\";i:849;}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";i:822;}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";i:815;}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";i:791;}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";i:779;}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";i:760;}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";i:759;}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";i:755;}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";i:741;}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";i:721;}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";i:706;}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";i:703;}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"ajax\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";i:672;}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";i:662;}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";i:661;}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";i:643;}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";i:641;}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"css\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";i:632;}s:8:\"shipping\";a:3:{s:4:\"name\";s:8:\"shipping\";s:4:\"slug\";s:8:\"shipping\";s:5:\"count\";i:616;}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";i:615;}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";i:613;}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";i:610;}s:4:\"chat\";a:3:{s:4:\"name\";s:4:\"chat\";s:4:\"slug\";s:4:\"chat\";s:5:\"count\";i:609;}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";i:607;}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";i:606;}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";i:601;}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";i:594;}s:14:\"contact-form-7\";a:3:{s:4:\"name\";s:14:\"contact form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"count\";i:589;}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";i:584;}s:11:\"performance\";a:3:{s:4:\"name\";s:11:\"performance\";s:4:\"slug\";s:11:\"performance\";s:5:\"count\";i:580;}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";i:578;}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";i:574;}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";i:573;}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";i:572;}s:5:\"forms\";a:3:{s:4:\"name\";s:5:\"forms\";s:4:\"slug\";s:5:\"forms\";s:5:\"count\";i:563;}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";i:555;}s:6:\"blocks\";a:3:{s:4:\"name\";s:6:\"blocks\";s:4:\"slug\";s:6:\"blocks\";s:5:\"count\";i:552;}s:5:\"popup\";a:3:{s:4:\"name\";s:5:\"popup\";s:4:\"slug\";s:5:\"popup\";s:5:\"count\";i:549;}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";i:544;}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";i:529;}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";i:529;}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";i:520;}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";i:517;}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";i:505;}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";i:504;}s:8:\"payments\";a:3:{s:4:\"name\";s:8:\"payments\";s:4:\"slug\";s:8:\"payments\";s:5:\"count\";i:500;}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";i:497;}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";i:472;}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";i:462;}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";i:458;}s:7:\"gateway\";a:3:{s:4:\"name\";s:7:\"gateway\";s:4:\"slug\";s:7:\"gateway\";s:5:\"count\";i:458;}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";i:454;}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";i:453;}s:8:\"checkout\";a:3:{s:4:\"name\";s:8:\"checkout\";s:4:\"slug\";s:8:\"checkout\";s:5:\"count\";i:452;}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";i:451;}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";i:449;}s:8:\"redirect\";a:3:{s:4:\"name\";s:8:\"redirect\";s:4:\"slug\";s:8:\"redirect\";s:5:\"count\";i:448;}s:6:\"import\";a:3:{s:4:\"name\";s:6:\"import\";s:4:\"slug\";s:6:\"import\";s:5:\"count\";i:443;}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";i:430;}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"news\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";i:428;}s:5:\"cache\";a:3:{s:4:\"name\";s:5:\"cache\";s:4:\"slug\";s:5:\"cache\";s:5:\"count\";i:418;}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";i:418;}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";i:417;}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";i:407;}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";i:400;}s:2:\"ai\";a:3:{s:4:\"name\";s:2:\"AI\";s:4:\"slug\";s:2:\"ai\";s:5:\"count\";i:397;}}", "off");
INSERT INTO `wp_options` VALUES("881", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1737444998;s:8:\"response\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:28:\"w.org/plugins/contact-form-7\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:5:\"6.0.3\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.6.0.3.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";s:3:\"svg\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/contact-form-7/assets/banner-1544x500.png?rev=860901\";s:2:\"1x\";s:68:\"https://ps.w.org/contact-form-7/assets/banner-772x250.png?rev=880427\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";s:6:\"tested\";s:5:\"6.7.1\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}}}s:12:\"translations\";a:6:{i:0;a:7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:7:\"akismet\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"5.3.5\";s:7:\"updated\";s:19:\"2025-01-12 13:13:51\";s:7:\"package\";s:74:\"https://downloads.wordpress.org/translation/plugin/akismet/5.3.5/fr_FR.zip\";s:10:\"autoupdate\";b:1;}i:1;a:7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:14:\"contact-form-7\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"6.0.1\";s:7:\"updated\";s:19:\"2024-10-17 17:27:10\";s:7:\"package\";s:81:\"https://downloads.wordpress.org/translation/plugin/contact-form-7/6.0.1/fr_FR.zip\";s:10:\"autoupdate\";b:1;}i:2;a:7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:10:\"duplicator\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:8:\"1.5.11.2\";s:7:\"updated\";s:19:\"2025-01-17 09:34:09\";s:7:\"package\";s:80:\"https://downloads.wordpress.org/translation/plugin/duplicator/1.5.11.2/fr_FR.zip\";s:10:\"autoupdate\";b:1;}i:3;a:7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:11:\"hello-dolly\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.7.2\";s:7:\"updated\";s:19:\"2024-05-24 07:04:35\";s:7:\"package\";s:78:\"https://downloads.wordpress.org/translation/plugin/hello-dolly/1.7.2/fr_FR.zip\";s:10:\"autoupdate\";b:1;}i:4;a:7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:12:\"wpforms-lite\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:7:\"1.9.3.1\";s:7:\"updated\";s:19:\"2025-01-12 10:29:02\";s:7:\"package\";s:81:\"https://downloads.wordpress.org/translation/plugin/wpforms-lite/1.9.3.1/fr_FR.zip\";s:10:\"autoupdate\";b:1;}i:5;a:7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:12:\"wp-mail-smtp\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.3.0\";s:7:\"updated\";s:19:\"2024-11-06 15:15:10\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/plugin/wp-mail-smtp/4.3.0/fr_FR.zip\";s:10:\"autoupdate\";b:1;}}s:9:\"no_update\";a:7:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"5.3.5\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.5.3.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:60:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=2818463\";s:2:\"1x\";s:60:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=2818463\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/akismet/assets/banner-1544x500.png?rev=2900731\";s:2:\"1x\";s:62:\"https://ps.w.org/akismet/assets/banner-772x250.png?rev=2900731\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.8\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:8:\"1.5.11.2\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/duplicator.1.5.11.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2906985\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2906985\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/duplicator/assets/banner-1544x500.png?rev=2906985\";s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2906985\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:9:\"hello.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:25:\"w.org/plugins/hello-dolly\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:5:\"1.7.2\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/hello-dolly.1.7.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=2052855\";s:2:\"1x\";s:64:\"https://ps.w.org/hello-dolly/assets/icon-128x128.jpg?rev=2052855\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/hello-dolly/assets/banner-1544x500.jpg?rev=2645582\";s:2:\"1x\";s:66:\"https://ps.w.org/hello-dolly/assets/banner-772x250.jpg?rev=2052855\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.6\";}s:16:\"kubio/plugin.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:19:\"w.org/plugins/kubio\";s:4:\"slug\";s:5:\"kubio\";s:6:\"plugin\";s:16:\"kubio/plugin.php\";s:11:\"new_version\";s:5:\"2.4.3\";s:3:\"url\";s:36:\"https://wordpress.org/plugins/kubio/\";s:7:\"package\";s:54:\"https://downloads.wordpress.org/plugin/kubio.2.4.3.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:50:\"https://ps.w.org/kubio/assets/icon.svg?rev=2642537\";s:3:\"svg\";s:50:\"https://ps.w.org/kubio/assets/icon.svg?rev=2642537\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:61:\"https://ps.w.org/kubio/assets/banner-1544x500.png?rev=2997702\";s:2:\"1x\";s:60:\"https://ps.w.org/kubio/assets/banner-772x250.png?rev=2997702\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.8\";}s:43:\"raratheme-companion/raratheme-companion.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:33:\"w.org/plugins/raratheme-companion\";s:4:\"slug\";s:19:\"raratheme-companion\";s:6:\"plugin\";s:43:\"raratheme-companion/raratheme-companion.php\";s:11:\"new_version\";s:5:\"1.4.3\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/raratheme-companion/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/raratheme-companion.1.4.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:72:\"https://ps.w.org/raratheme-companion/assets/icon-256x256.png?rev=1858916\";s:2:\"1x\";s:72:\"https://ps.w.org/raratheme-companion/assets/icon-128x128.png?rev=1858915\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:75:\"https://ps.w.org/raratheme-companion/assets/banner-1544x500.png?rev=1858912\";s:2:\"1x\";s:74:\"https://ps.w.org/raratheme-companion/assets/banner-772x250.png?rev=1858911\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:5:\"4.4.0\";}s:24:\"wpforms-lite/wpforms.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:26:\"w.org/plugins/wpforms-lite\";s:4:\"slug\";s:12:\"wpforms-lite\";s:6:\"plugin\";s:24:\"wpforms-lite/wpforms.php\";s:11:\"new_version\";s:7:\"1.9.3.1\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/wpforms-lite/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/wpforms-lite.1.9.3.1.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:57:\"https://ps.w.org/wpforms-lite/assets/icon.svg?rev=2574198\";s:3:\"svg\";s:57:\"https://ps.w.org/wpforms-lite/assets/icon.svg?rev=2574198\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/wpforms-lite/assets/banner-1544x500.png?rev=3091364\";s:2:\"1x\";s:67:\"https://ps.w.org/wpforms-lite/assets/banner-772x250.png?rev=3091364\";}s:11:\"banners_rtl\";a:2:{s:2:\"2x\";s:72:\"https://ps.w.org/wpforms-lite/assets/banner-1544x500-rtl.png?rev=3091364\";s:2:\"1x\";s:71:\"https://ps.w.org/wpforms-lite/assets/banner-772x250-rtl.png?rev=3091364\";}s:8:\"requires\";s:3:\"5.5\";}s:29:\"wp-mail-smtp/wp_mail_smtp.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:26:\"w.org/plugins/wp-mail-smtp\";s:4:\"slug\";s:12:\"wp-mail-smtp\";s:6:\"plugin\";s:29:\"wp-mail-smtp/wp_mail_smtp.php\";s:11:\"new_version\";s:5:\"4.3.0\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/wp-mail-smtp/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/wp-mail-smtp.4.3.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/wp-mail-smtp/assets/icon-256x256.png?rev=1755440\";s:2:\"1x\";s:65:\"https://ps.w.org/wp-mail-smtp/assets/icon-128x128.png?rev=1755440\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/wp-mail-smtp/assets/banner-1544x500.png?rev=3206423\";s:2:\"1x\";s:67:\"https://ps.w.org/wp-mail-smtp/assets/banner-772x250.png?rev=3206423\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.5\";}}s:7:\"checked\";a:8:{s:19:\"akismet/akismet.php\";s:5:\"5.3.5\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:5:\"6.0.1\";s:25:\"duplicator/duplicator.php\";s:8:\"1.5.11.2\";s:9:\"hello.php\";s:5:\"1.7.2\";s:16:\"kubio/plugin.php\";s:5:\"2.4.3\";s:43:\"raratheme-companion/raratheme-companion.php\";s:5:\"1.4.3\";s:24:\"wpforms-lite/wpforms.php\";s:7:\"1.9.3.1\";s:29:\"wp-mail-smtp/wp_mail_smtp.php\";s:5:\"4.3.0\";}}", "off");
INSERT INTO `wp_options` VALUES("882", "duplicator_version_plugin", "1.5.11.2", "auto");
INSERT INTO `wp_options` VALUES("884", "duplicator_install_info", "a:3:{s:7:\"version\";s:8:\"1.5.11.2\";s:4:\"time\";i:1737444999;s:10:\"updateTime\";i:1737444999;}", "off");
INSERT INTO `wp_options` VALUES("885", "duplicator_uninstall_package", "1", "auto");
INSERT INTO `wp_options` VALUES("886", "duplicator_uninstall_settings", "1", "auto");
INSERT INTO `wp_options` VALUES("887", "duplicator_settings", "a:20:{s:7:\"version\";s:8:\"1.5.11.2\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:1;s:14:\"usage_tracking\";b:0;i:0;b:0;}", "auto");
INSERT INTO `wp_options` VALUES("888", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 0,\n    \"identifier\": \"2ZRwfHeF9eGT3FAoyKmbvRTEy7p&4apDvEJXN+-20e+3\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 0,\n    \"buildLastDate\": 0,\n    \"buildFailedCount\": 0,\n    \"buildFailedLastDate\": 0,\n    \"siteSizeMB\": 221.32,\n    \"siteNumFiles\": 16469,\n    \"siteDbSizeMB\": 6.67,\n    \"siteDbNumTables\": 23\n}", "auto");
INSERT INTO `wp_options` VALUES("889", "duplicator_notifications", "a:4:{s:6:\"update\";i:1737445000;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "auto");
INSERT INTO `wp_options` VALUES("892", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-01-21 07:37:55\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.6.1\";s:9:\"VersionDB\";s:6:\"8.0.30\";s:10:\"VersionPHP\";s:6:\"8.1.10\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:30:\"20250121_theovaladouxportfolio\";s:4:\"Hash\";s:35:\"fb4815b39912856a7753_20250121073755\";s:8:\"NameHash\";s:66:\"20250121_theovaladouxportfolio_fb4815b39912856a7753_20250121073755\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:76:\"20250121_theovaladouxportfolio_fb4815b39912856a7753_20250121073755_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:38:\"C:/laragon/www/Portfolio-Theo-Valadoux\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1714;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:14755;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-01-21 07:37:55\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.6.1\";s:9:\"VersionDB\";s:6:\"8.0.30\";s:10:\"VersionPHP\";s:6:\"8.1.10\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:30:\"20250121_theovaladouxportfolio\";s:4:\"Hash\";s:35:\"fb4815b39912856a7753_20250121073755\";s:8:\"NameHash\";s:66:\"20250121_theovaladouxportfolio_fb4815b39912856a7753_20250121073755\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:52:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";N;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:47:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-admin\";i:1;s:50:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-includes\";i:2;s:59:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:38:\"C:/laragon/www/Portfolio-Theo-Valadoux\";i:1;s:38:\"C:/laragon/www/Portfolio-Theo-Valadoux\";i:2;s:49:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content\";i:3;s:57:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content/uploads\";i:4;s:57:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content/plugins\";i:5;s:60:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content/mu-plugins\";i:6;s:56:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:70:\"C:/laragon/www/Portfolio-Theo-Valadoux/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}", "auto");

/* INSERT TABLE DATA: wp_postmeta */
INSERT INTO `wp_postmeta` VALUES("2", "3", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("65", "40", "_wp_attached_file", "2024/10/StockSnap_M6D1GS9PSL.jpg");
INSERT INTO `wp_postmeta` VALUES("66", "40", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2000;s:6:\"height\";i:1317;s:4:\"file\";s:32:\"2024/10/StockSnap_M6D1GS9PSL.jpg\";s:8:\"filesize\";i:481226;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:32:\"StockSnap_M6D1GS9PSL-300x198.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:198;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24307;}s:5:\"large\";a:5:{s:4:\"file\";s:33:\"StockSnap_M6D1GS9PSL-1024x674.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:674;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:242355;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:32:\"StockSnap_M6D1GS9PSL-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10563;}s:12:\"inspiro-loop\";a:5:{s:4:\"file\";s:32:\"StockSnap_M6D1GS9PSL-950x320.jpg\";s:5:\"width\";i:950;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:106077;}s:15:\"inspiro-loop@2x\";a:5:{s:4:\"file\";s:33:\"StockSnap_M6D1GS9PSL-1900x640.jpg\";s:5:\"width\";i:1900;s:6:\"height\";i:640;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:341372;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("67", "40", "_starter_content_theme", "inspiro");
INSERT INTO `wp_postmeta` VALUES("68", "40", "_customize_draft_post_name", "aerial-land");
INSERT INTO `wp_postmeta` VALUES("69", "41", "_wp_attached_file", "2024/10/StockSnap_6O7JXC5DC5.jpg");
INSERT INTO `wp_postmeta` VALUES("70", "41", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2200;s:6:\"height\";i:1468;s:4:\"file\";s:32:\"2024/10/StockSnap_6O7JXC5DC5.jpg\";s:8:\"filesize\";i:140562;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:32:\"StockSnap_6O7JXC5DC5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11483;}s:5:\"large\";a:5:{s:4:\"file\";s:33:\"StockSnap_6O7JXC5DC5-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:70552;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:32:\"StockSnap_6O7JXC5DC5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5391;}s:22:\"inspiro-featured-image\";a:5:{s:4:\"file\";s:34:\"StockSnap_6O7JXC5DC5-2000x1335.jpg\";s:5:\"width\";i:2000;s:6:\"height\";i:1335;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:201713;}s:12:\"inspiro-loop\";a:5:{s:4:\"file\";s:32:\"StockSnap_6O7JXC5DC5-950x320.jpg\";s:5:\"width\";i:950;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:30882;}s:15:\"inspiro-loop@2x\";a:5:{s:4:\"file\";s:33:\"StockSnap_6O7JXC5DC5-1900x640.jpg\";s:5:\"width\";i:1900;s:6:\"height\";i:640;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:90930;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("71", "41", "_starter_content_theme", "inspiro");
INSERT INTO `wp_postmeta` VALUES("72", "41", "_customize_draft_post_name", "contact");
INSERT INTO `wp_postmeta` VALUES("73", "42", "_wp_page_template", "page-templates/homepage-no-hero.php");
INSERT INTO `wp_postmeta` VALUES("74", "42", "_customize_draft_post_name", "homepage");
INSERT INTO `wp_postmeta` VALUES("75", "42", "_customize_changeset_uuid", "4a7165cc-cd9c-486f-a5cf-22a8782821bc");
INSERT INTO `wp_postmeta` VALUES("76", "43", "_thumbnail_id", "40");
INSERT INTO `wp_postmeta` VALUES("77", "43", "_customize_draft_post_name", "about");
INSERT INTO `wp_postmeta` VALUES("78", "43", "_customize_changeset_uuid", "4a7165cc-cd9c-486f-a5cf-22a8782821bc");
INSERT INTO `wp_postmeta` VALUES("79", "44", "_thumbnail_id", "41");
INSERT INTO `wp_postmeta` VALUES("80", "44", "_customize_draft_post_name", "contact");
INSERT INTO `wp_postmeta` VALUES("81", "44", "_customize_changeset_uuid", "4a7165cc-cd9c-486f-a5cf-22a8782821bc");
INSERT INTO `wp_postmeta` VALUES("82", "45", "_customize_draft_post_name", "blog");
INSERT INTO `wp_postmeta` VALUES("83", "45", "_customize_changeset_uuid", "4a7165cc-cd9c-486f-a5cf-22a8782821bc");
INSERT INTO `wp_postmeta` VALUES("84", "43", "_oembed_170fdabeb3c63e5e04de253241b460bd", "<iframe title=\"VideoPress Video Player\" aria-label=\'VideoPress Video Player\' width=\'950\' height=\'534\' src=\'https://video.wordpress.com/embed/bjvmxiQS?hd=0&amp;cover=1\' frameborder=\'0\' allowfullscreen allow=\'clipboard-write\'></iframe><script src=\'https://v0.wordpress.com/js/next/videopress-iframe.js?m=1725245713\'></script>");
INSERT INTO `wp_postmeta` VALUES("85", "43", "_oembed_time_170fdabeb3c63e5e04de253241b460bd", "1728370426");
INSERT INTO `wp_postmeta` VALUES("99", "51", "_edit_lock", "1728371871:1");
INSERT INTO `wp_postmeta` VALUES("100", "43", "_edit_lock", "1728377576:1");
INSERT INTO `wp_postmeta` VALUES("101", "42", "_edit_lock", "1728375659:1");
INSERT INTO `wp_postmeta` VALUES("104", "43", "_wp_desired_post_slug", "");
INSERT INTO `wp_postmeta` VALUES("107", "45", "_wp_desired_post_slug", "");
INSERT INTO `wp_postmeta` VALUES("110", "44", "_wp_desired_post_slug", "");
INSERT INTO `wp_postmeta` VALUES("113", "42", "_wp_desired_post_slug", "");
INSERT INTO `wp_postmeta` VALUES("124", "60", "wpzoom_slide_button_title", "");
INSERT INTO `wp_postmeta` VALUES("125", "60", "wpzoom_slide_url", "");
INSERT INTO `wp_postmeta` VALUES("126", "60", "wpzoom_slide_button_url", "");
INSERT INTO `wp_postmeta` VALUES("127", "60", "wpzoom_slide_button_url_open", "1");
INSERT INTO `wp_postmeta` VALUES("128", "61", "_wp_attached_file", "2024/10/StockSnap_ECZV5RZKSZ.jpg");
INSERT INTO `wp_postmeta` VALUES("129", "61", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2100;s:6:\"height\";i:1356;s:4:\"file\";s:32:\"2024/10/StockSnap_ECZV5RZKSZ.jpg\";s:8:\"filesize\";i:440262;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:32:\"StockSnap_ECZV5RZKSZ-300x194.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:194;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15999;}s:5:\"large\";a:5:{s:4:\"file\";s:33:\"StockSnap_ECZV5RZKSZ-1024x661.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:661;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:185458;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:32:\"StockSnap_ECZV5RZKSZ-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7177;}s:22:\"inspiro-featured-image\";a:5:{s:4:\"file\";s:34:\"StockSnap_ECZV5RZKSZ-2000x1291.jpg\";s:5:\"width\";i:2000;s:6:\"height\";i:1291;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:576178;}s:12:\"inspiro-loop\";a:5:{s:4:\"file\";s:32:\"StockSnap_ECZV5RZKSZ-950x320.jpg\";s:5:\"width\";i:950;s:6:\"height\";i:320;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:89743;}s:15:\"inspiro-loop@2x\";a:5:{s:4:\"file\";s:33:\"StockSnap_ECZV5RZKSZ-1900x640.jpg\";s:5:\"width\";i:1900;s:6:\"height\";i:640;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:295514;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("130", "60", "_thumbnail_id", "61");
INSERT INTO `wp_postmeta` VALUES("131", "45", "_edit_lock", "1728377591:1");
INSERT INTO `wp_postmeta` VALUES("136", "44", "_edit_lock", "1728377608:1");
INSERT INTO `wp_postmeta` VALUES("138", "62", "_wp_attached_file", "2024/10/Capture-decran-2023-10-03-210725.png");
INSERT INTO `wp_postmeta` VALUES("139", "62", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1314;s:6:\"height\";i:880;s:4:\"file\";s:44:\"2024/10/Capture-decran-2023-10-03-210725.png\";s:8:\"filesize\";i:97809;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:44:\"Capture-decran-2023-10-03-210725-300x201.png\";s:5:\"width\";i:300;s:6:\"height\";i:201;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:26228;}s:5:\"large\";a:5:{s:4:\"file\";s:45:\"Capture-decran-2023-10-03-210725-1024x686.png\";s:5:\"width\";i:1024;s:6:\"height\";i:686;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:171451;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:44:\"Capture-decran-2023-10-03-210725-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:9807;}s:12:\"inspiro-loop\";a:5:{s:4:\"file\";s:44:\"Capture-decran-2023-10-03-210725-950x320.png\";s:5:\"width\";i:950;s:6:\"height\";i:320;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:73494;}s:15:\"inspiro-loop@2x\";a:5:{s:4:\"file\";s:45:\"Capture-decran-2023-10-03-210725-1314x640.png\";s:5:\"width\";i:1314;s:6:\"height\";i:640;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:68260;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("140", "65", "_kubio_created_at_activation", "1");
INSERT INTO `wp_postmeta` VALUES("141", "65", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("142", "66", "_kubio_created_at_activation", "1");
INSERT INTO `wp_postmeta` VALUES("143", "66", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("144", "67", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("145", "67", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("146", "67", "_menu_item_object_id", "65");
INSERT INTO `wp_postmeta` VALUES("147", "67", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("148", "67", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("149", "67", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("150", "67", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("151", "67", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("160", "69", "_kubio_template_source", "kubio");
INSERT INTO `wp_postmeta` VALUES("161", "70", "_kubio_template_source", "kubio");
INSERT INTO `wp_postmeta` VALUES("162", "71", "_kubio_template_source", "kubio");
INSERT INTO `wp_postmeta` VALUES("163", "72", "_kubio_template_source", "kubio");
INSERT INTO `wp_postmeta` VALUES("164", "73", "_kubio_template_source", "kubio");
INSERT INTO `wp_postmeta` VALUES("165", "74", "_kubio_template_source", "kubio");
INSERT INTO `wp_postmeta` VALUES("166", "75", "_kubio_template_source", "kubio");
INSERT INTO `wp_postmeta` VALUES("167", "76", "_kubio_template_source", "kubio");
INSERT INTO `wp_postmeta` VALUES("168", "77", "_kubio_template_source", "kubio");
INSERT INTO `wp_postmeta` VALUES("169", "78", "_kubio_template_source", "kubio");
INSERT INTO `wp_postmeta` VALUES("170", "79", "_kubio_template_source", "kubio");
INSERT INTO `wp_postmeta` VALUES("171", "80", "_kubio_template_source", "kubio");
INSERT INTO `wp_postmeta` VALUES("172", "81", "_kubio_template_source", "kubio");
INSERT INTO `wp_postmeta` VALUES("173", "82", "_kubio_template_source", "kubio");
INSERT INTO `wp_postmeta` VALUES("174", "83", "_kubio_template_source", "kubio");
INSERT INTO `wp_postmeta` VALUES("175", "84", "_kubio_template_source", "kubio");
INSERT INTO `wp_postmeta` VALUES("176", "85", "_kubio_template_source", "kubio");
INSERT INTO `wp_postmeta` VALUES("177", "43", "_oembed_1097ec2a80955e9903e8a87d1c0292c8", "<iframe title=\"VideoPress Video Player\" aria-label=\'VideoPress Video Player\' width=\'500\' height=\'281\' src=\'https://video.wordpress.com/embed/bjvmxiQS?hd=0&amp;cover=1\' frameborder=\'0\' allowfullscreen allow=\'clipboard-write\'></iframe><script src=\'https://v0.wordpress.com/js/next/videopress-iframe.js?m=1725245713\'></script>");
INSERT INTO `wp_postmeta` VALUES("178", "43", "_oembed_time_1097ec2a80955e9903e8a87d1c0292c8", "1728377716");
INSERT INTO `wp_postmeta` VALUES("179", "66", "_edit_lock", "1728377599:1");
INSERT INTO `wp_postmeta` VALUES("180", "65", "_edit_lock", "1728461689:1");
INSERT INTO `wp_postmeta` VALUES("181", "46", "_edit_lock", "1728386688:1");
INSERT INTO `wp_postmeta` VALUES("182", "90", "saved_in_kubio", "1");
INSERT INTO `wp_postmeta` VALUES("183", "90", "_form", "<label> Your name\n    [text* your-name autocomplete:name] </label>\n\n<label> Your email\n    [email* your-email autocomplete:email] </label>\n\n<label> Subject\n    [text* your-subject] </label>\n\n<label> Your message (optional)\n    [textarea your-message] </label>\n\n[submit \"Submit\"]");
INSERT INTO `wp_postmeta` VALUES("184", "90", "_mail", "a:8:{s:7:\"subject\";s:30:\"[_site_title] \"[your-subject]\"\";s:6:\"sender\";s:54:\"[_site_title] <wordpress@portfolio-theo-valadoux.test>\";s:4:\"body\";s:191:\"From: [your-name] [your-email]\nSubject: [your-subject]\n\nMessage Body:\n[your-message]\n\n-- \nThis is a notification that a contact form was submitted on your website ([_site_title] [_site_url]).\";s:9:\"recipient\";s:19:\"[_site_admin_email]\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";i:0;s:13:\"exclude_blank\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("185", "90", "_mail_2", "a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:30:\"[_site_title] \"[your-subject]\"\";s:6:\"sender\";s:54:\"[_site_title] <wordpress@portfolio-theo-valadoux.test>\";s:4:\"body\";s:220:\"Message Body:\n[your-message]\n\n-- \nThis email is a receipt for your contact form submission on our website ([_site_title] [_site_url]) in which your email address was used. If that was not you, please ignore this message.\";s:9:\"recipient\";s:12:\"[your-email]\";s:18:\"additional_headers\";s:29:\"Reply-To: [_site_admin_email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";i:0;s:13:\"exclude_blank\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("186", "90", "_messages", "a:12:{s:12:\"mail_sent_ok\";s:45:\"Thank you for your message. It has been sent.\";s:12:\"mail_sent_ng\";s:71:\"There was an error trying to send your message. Please try again later.\";s:16:\"validation_error\";s:61:\"One or more fields have an error. Please check and try again.\";s:4:\"spam\";s:71:\"There was an error trying to send your message. Please try again later.\";s:12:\"accept_terms\";s:69:\"You must accept the terms and conditions before sending your message.\";s:16:\"invalid_required\";s:27:\"Please fill out this field.\";s:16:\"invalid_too_long\";s:32:\"This field has a too long input.\";s:17:\"invalid_too_short\";s:33:\"This field has a too short input.\";s:13:\"upload_failed\";s:46:\"There was an unknown error uploading the file.\";s:24:\"upload_file_type_invalid\";s:49:\"You are not allowed to upload files of this type.\";s:21:\"upload_file_too_large\";s:31:\"The uploaded file is too large.\";s:23:\"upload_failed_php_error\";s:38:\"There was an error uploading the file.\";}");
INSERT INTO `wp_postmeta` VALUES("187", "90", "_additional_settings", "");
INSERT INTO `wp_postmeta` VALUES("188", "90", "_locale", "fr_FR");
INSERT INTO `wp_postmeta` VALUES("189", "90", "_hash", "821a2eac44524c302bdc9d8f559549d31b7cf648");
INSERT INTO `wp_postmeta` VALUES("190", "91", "_wp_attached_file", "2024/10/pexels-photo-7108095.jpeg");
INSERT INTO `wp_postmeta` VALUES("191", "91", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:33:\"2024/10/pexels-photo-7108095.jpeg\";s:8:\"filesize\";i:196939;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:33:\"pexels-photo-7108095-300x200.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14771;}s:5:\"large\";a:5:{s:4:\"file\";s:34:\"pexels-photo-7108095-1024x683.jpeg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:96762;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:33:\"pexels-photo-7108095-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6857;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:33:\"pexels-photo-7108095-768x512.jpeg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:61472;}s:22:\"post-slider-thumb-size\";a:5:{s:4:\"file\";s:33:\"pexels-photo-7108095-330x190.jpeg\";s:5:\"width\";i:330;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15156;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:35:\"pexels-photo-7108095-1536x1024.jpeg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:177344;}s:12:\"kubio-fullhd\";a:5:{s:4:\"file\";s:35:\"pexels-photo-7108095-1620x1080.jpeg\";s:5:\"width\";i:1620;s:6:\"height\";i:1080;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:193460;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("192", "92", "_wp_attached_file", "2024/10/ingenieur-IA.jpg");
INSERT INTO `wp_postmeta` VALUES("193", "92", "saved_in_kubio", "1");
INSERT INTO `wp_postmeta` VALUES("194", "92", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:275;s:6:\"height\";i:183;s:4:\"file\";s:24:\"2024/10/ingenieur-IA.jpg\";s:8:\"filesize\";i:14731;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:24:\"ingenieur-IA-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9426;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("195", "93", "_wp_attached_file", "2024/10/ingenieur-IA-edited.jpg");
INSERT INTO `wp_postmeta` VALUES("196", "93", "_wp_attachment_metadata", "a:7:{s:5:\"width\";i:274;s:6:\"height\";i:183;s:4:\"file\";s:31:\"2024/10/ingenieur-IA-edited.jpg\";s:8:\"filesize\";i:20204;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"ingenieur-IA-edited-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9344;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:12:\"parent_image\";a:2:{s:13:\"attachment_id\";s:2:\"92\";s:4:\"file\";s:24:\"2024/10/ingenieur-IA.jpg\";}}");
INSERT INTO `wp_postmeta` VALUES("197", "83", "saved_in_kubio", "1");
INSERT INTO `wp_postmeta` VALUES("198", "82", "saved_in_kubio", "1");
INSERT INTO `wp_postmeta` VALUES("199", "82", "kubio_template_autosave_type", "preview");
INSERT INTO `wp_postmeta` VALUES("200", "83", "kubio_template_autosave_type", "preview");
INSERT INTO `wp_postmeta` VALUES("201", "65", "saved_in_kubio", "1");
INSERT INTO `wp_postmeta` VALUES("202", "65", "kubio_template_autosave_type", "preview");
INSERT INTO `wp_postmeta` VALUES("203", "63", "saved_in_kubio", "1");
INSERT INTO `wp_postmeta` VALUES("205", "99", "_wp_attached_file", "2024/10/Capture-decran-2023-10-04-080920.png");
INSERT INTO `wp_postmeta` VALUES("206", "99", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1919;s:6:\"height\";i:882;s:4:\"file\";s:44:\"2024/10/Capture-decran-2023-10-04-080920.png\";s:8:\"filesize\";i:1115591;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:44:\"Capture-decran-2023-10-04-080920-300x138.png\";s:5:\"width\";i:300;s:6:\"height\";i:138;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:45507;}s:5:\"large\";a:5:{s:4:\"file\";s:45:\"Capture-decran-2023-10-04-080920-1024x471.png\";s:5:\"width\";i:1024;s:6:\"height\";i:471;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:366153;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:44:\"Capture-decran-2023-10-04-080920-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:25078;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:44:\"Capture-decran-2023-10-04-080920-768x353.png\";s:5:\"width\";i:768;s:6:\"height\";i:353;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:224935;}s:22:\"post-slider-thumb-size\";a:5:{s:4:\"file\";s:44:\"Capture-decran-2023-10-04-080920-330x190.png\";s:5:\"width\";i:330;s:6:\"height\";i:190;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:61708;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:45:\"Capture-decran-2023-10-04-080920-1536x706.png\";s:5:\"width\";i:1536;s:6:\"height\";i:706;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:717403;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("207", "100", "_wp_attached_file", "2024/10/formation.webp");
INSERT INTO `wp_postmeta` VALUES("208", "100", "saved_in_kubio", "1");
INSERT INTO `wp_postmeta` VALUES("209", "100", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1000;s:6:\"height\";i:351;s:4:\"file\";s:22:\"2024/10/formation.webp\";s:8:\"filesize\";i:19902;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"formation-300x105.webp\";s:5:\"width\";i:300;s:6:\"height\";i:105;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:6376;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"formation-150x150.webp\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:4476;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:22:\"formation-768x270.webp\";s:5:\"width\";i:768;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:16812;}s:22:\"post-slider-thumb-size\";a:5:{s:4:\"file\";s:22:\"formation-330x190.webp\";s:5:\"width\";i:330;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/webp\";s:8:\"filesize\";i:9188;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("210", "103", "_wp_attached_file", "2024/10/pexels-photo-28792248.jpeg");
INSERT INTO `wp_postmeta` VALUES("211", "103", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:700;s:6:\"height\";i:525;s:4:\"file\";s:34:\"2024/10/pexels-photo-28792248.jpeg\";s:8:\"filesize\";i:91662;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:34:\"pexels-photo-28792248-300x225.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26071;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:34:\"pexels-photo-28792248-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10776;}s:22:\"post-slider-thumb-size\";a:5:{s:4:\"file\";s:34:\"pexels-photo-28792248-330x190.jpeg\";s:5:\"width\";i:330;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24353;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("212", "104", "_wp_attached_file", "2024/10/pexels-photo-28777948.jpeg");
INSERT INTO `wp_postmeta` VALUES("213", "104", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:700;s:6:\"height\";i:525;s:4:\"file\";s:34:\"2024/10/pexels-photo-28777948.jpeg\";s:8:\"filesize\";i:34225;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:34:\"pexels-photo-28777948-300x225.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12723;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:34:\"pexels-photo-28777948-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6055;}s:22:\"post-slider-thumb-size\";a:5:{s:4:\"file\";s:34:\"pexels-photo-28777948-330x190.jpeg\";s:5:\"width\";i:330;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11048;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("214", "105", "_wp_attached_file", "2024/10/logoipsum-285-1.png");
INSERT INTO `wp_postmeta` VALUES("215", "105", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:500;s:6:\"height\";i:110;s:4:\"file\";s:27:\"2024/10/logoipsum-285-1.png\";s:8:\"filesize\";i:2727;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:26:\"logoipsum-285-1-300x66.png\";s:5:\"width\";i:300;s:6:\"height\";i:66;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:5858;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:27:\"logoipsum-285-1-150x110.png\";s:5:\"width\";i:150;s:6:\"height\";i:110;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2373;}s:22:\"post-slider-thumb-size\";a:5:{s:4:\"file\";s:27:\"logoipsum-285-1-330x110.png\";s:5:\"width\";i:330;s:6:\"height\";i:110;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4885;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("216", "106", "_wp_attached_file", "2024/10/pexels-photo-15863000.jpeg");
INSERT INTO `wp_postmeta` VALUES("217", "106", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1920;s:6:\"height\";i:1280;s:4:\"file\";s:34:\"2024/10/pexels-photo-15863000.jpeg\";s:8:\"filesize\";i:78505;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:34:\"pexels-photo-15863000-300x200.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6440;}s:5:\"large\";a:5:{s:4:\"file\";s:35:\"pexels-photo-15863000-1024x683.jpeg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:43078;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:34:\"pexels-photo-15863000-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3393;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:34:\"pexels-photo-15863000-768x512.jpeg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:25960;}s:22:\"post-slider-thumb-size\";a:5:{s:4:\"file\";s:34:\"pexels-photo-15863000-330x190.jpeg\";s:5:\"width\";i:330;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6965;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:36:\"pexels-photo-15863000-1536x1024.jpeg\";s:5:\"width\";i:1536;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:85292;}s:12:\"kubio-fullhd\";a:5:{s:4:\"file\";s:36:\"pexels-photo-15863000-1620x1080.jpeg\";s:5:\"width\";i:1620;s:6:\"height\";i:1080;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:93709;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("218", "107", "_wp_attached_file", "2024/10/logoipsum-287-1.png");
INSERT INTO `wp_postmeta` VALUES("219", "107", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:500;s:6:\"height\";i:190;s:4:\"file\";s:27:\"2024/10/logoipsum-287-1.png\";s:8:\"filesize\";i:5790;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:27:\"logoipsum-287-1-300x114.png\";s:5:\"width\";i:300;s:6:\"height\";i:114;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:10608;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:27:\"logoipsum-287-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:5985;}s:22:\"post-slider-thumb-size\";a:5:{s:4:\"file\";s:27:\"logoipsum-287-1-330x190.png\";s:5:\"width\";i:330;s:6:\"height\";i:190;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:8433;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("220", "108", "_wp_attached_file", "2024/10/logoipsum-288-1.png");
INSERT INTO `wp_postmeta` VALUES("221", "108", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:500;s:6:\"height\";i:114;s:4:\"file\";s:27:\"2024/10/logoipsum-288-1.png\";s:8:\"filesize\";i:4300;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:26:\"logoipsum-288-1-300x68.png\";s:5:\"width\";i:300;s:6:\"height\";i:68;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:11325;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:27:\"logoipsum-288-1-150x114.png\";s:5:\"width\";i:150;s:6:\"height\";i:114;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3300;}s:22:\"post-slider-thumb-size\";a:5:{s:4:\"file\";s:27:\"logoipsum-288-1-330x114.png\";s:5:\"width\";i:330;s:6:\"height\";i:114;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:5910;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("222", "109", "_wp_attached_file", "2024/10/logoipsum-284.png");
INSERT INTO `wp_postmeta` VALUES("223", "109", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:500;s:6:\"height\";i:314;s:4:\"file\";s:25:\"2024/10/logoipsum-284.png\";s:8:\"filesize\";i:6879;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"logoipsum-284-300x188.png\";s:5:\"width\";i:300;s:6:\"height\";i:188;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:12095;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"logoipsum-284-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6818;}s:22:\"post-slider-thumb-size\";a:5:{s:4:\"file\";s:25:\"logoipsum-284-330x190.png\";s:5:\"width\";i:330;s:6:\"height\";i:190;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:13493;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("224", "110", "_wp_attached_file", "2024/10/pexels-photo-10474130.jpeg");
INSERT INTO `wp_postmeta` VALUES("225", "110", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1448;s:6:\"height\";i:965;s:4:\"file\";s:34:\"2024/10/pexels-photo-10474130.jpeg\";s:8:\"filesize\";i:170811;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:34:\"pexels-photo-10474130-300x200.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18150;}s:5:\"large\";a:5:{s:4:\"file\";s:35:\"pexels-photo-10474130-1024x682.jpeg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:125233;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:34:\"pexels-photo-10474130-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8070;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:34:\"pexels-photo-10474130-768x512.jpeg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:79558;}s:22:\"post-slider-thumb-size\";a:5:{s:4:\"file\";s:34:\"pexels-photo-10474130-330x190.jpeg\";s:5:\"width\";i:330;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19337;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("226", "65", "footnotes", "");
INSERT INTO `wp_postmeta` VALUES("227", "65", "kubio_ai_page_context", "a:3:{s:7:\"purpose\";s:7:\"general\";s:10:\"short_desc\";s:0:\"\";s:11:\"isFrontPage\";b:1;}");
INSERT INTO `wp_postmeta` VALUES("228", "112", "footnotes", "");
INSERT INTO `wp_postmeta` VALUES("229", "118", "footnotes", "");
INSERT INTO `wp_postmeta` VALUES("231", "122", "footnotes", "");
INSERT INTO `wp_postmeta` VALUES("232", "124", "footnotes", "");
INSERT INTO `wp_postmeta` VALUES("234", "125", "footnotes", "");
INSERT INTO `wp_postmeta` VALUES("235", "127", "_wp_attached_file", "2024/10/capture-code-domicilometre.png");
INSERT INTO `wp_postmeta` VALUES("236", "127", "saved_in_kubio", "1");
INSERT INTO `wp_postmeta` VALUES("237", "127", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:569;s:6:\"height\";i:671;s:4:\"file\";s:38:\"2024/10/capture-code-domicilometre.png\";s:8:\"filesize\";i:36057;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:38:\"capture-code-domicilometre-254x300.png\";s:5:\"width\";i:254;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:41614;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:38:\"capture-code-domicilometre-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:16266;}s:22:\"post-slider-thumb-size\";a:5:{s:4:\"file\";s:38:\"capture-code-domicilometre-330x190.png\";s:5:\"width\";i:330;s:6:\"height\";i:190;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:28369;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("238", "128", "_wp_attached_file", "2024/10/Capture-decran-2023-10-04-080920-1.png");
INSERT INTO `wp_postmeta` VALUES("239", "128", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1919;s:6:\"height\";i:882;s:4:\"file\";s:46:\"2024/10/Capture-decran-2023-10-04-080920-1.png\";s:8:\"filesize\";i:1115591;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:46:\"Capture-decran-2023-10-04-080920-1-300x138.png\";s:5:\"width\";i:300;s:6:\"height\";i:138;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:45507;}s:5:\"large\";a:5:{s:4:\"file\";s:47:\"Capture-decran-2023-10-04-080920-1-1024x471.png\";s:5:\"width\";i:1024;s:6:\"height\";i:471;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:366153;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:46:\"Capture-decran-2023-10-04-080920-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:25078;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:46:\"Capture-decran-2023-10-04-080920-1-768x353.png\";s:5:\"width\";i:768;s:6:\"height\";i:353;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:224935;}s:22:\"post-slider-thumb-size\";a:5:{s:4:\"file\";s:46:\"Capture-decran-2023-10-04-080920-1-330x190.png\";s:5:\"width\";i:330;s:6:\"height\";i:190;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:61708;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:47:\"Capture-decran-2023-10-04-080920-1-1536x706.png\";s:5:\"width\";i:1536;s:6:\"height\";i:706;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:717403;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("240", "129", "_wp_attached_file", "2024/10/Capture-decran-2023-09-26-151138.png");
INSERT INTO `wp_postmeta` VALUES("241", "129", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:922;s:6:\"height\";i:859;s:4:\"file\";s:44:\"2024/10/Capture-decran-2023-09-26-151138.png\";s:8:\"filesize\";i:72581;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:44:\"Capture-decran-2023-09-26-151138-300x280.png\";s:5:\"width\";i:300;s:6:\"height\";i:280;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:34414;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:44:\"Capture-decran-2023-09-26-151138-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:12450;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:44:\"Capture-decran-2023-09-26-151138-768x716.png\";s:5:\"width\";i:768;s:6:\"height\";i:716;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:134327;}s:22:\"post-slider-thumb-size\";a:5:{s:4:\"file\";s:44:\"Capture-decran-2023-09-26-151138-330x190.png\";s:5:\"width\";i:330;s:6:\"height\";i:190;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:26890;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("242", "130", "_wp_attached_file", "2024/10/Capture-decran-2023-10-04-080920-2.png");
INSERT INTO `wp_postmeta` VALUES("243", "130", "saved_in_kubio", "1");
INSERT INTO `wp_postmeta` VALUES("244", "130", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1919;s:6:\"height\";i:882;s:4:\"file\";s:46:\"2024/10/Capture-decran-2023-10-04-080920-2.png\";s:8:\"filesize\";i:1115591;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:46:\"Capture-decran-2023-10-04-080920-2-300x138.png\";s:5:\"width\";i:300;s:6:\"height\";i:138;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:45507;}s:5:\"large\";a:5:{s:4:\"file\";s:47:\"Capture-decran-2023-10-04-080920-2-1024x471.png\";s:5:\"width\";i:1024;s:6:\"height\";i:471;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:366153;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:46:\"Capture-decran-2023-10-04-080920-2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:25078;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:46:\"Capture-decran-2023-10-04-080920-2-768x353.png\";s:5:\"width\";i:768;s:6:\"height\";i:353;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:224935;}s:22:\"post-slider-thumb-size\";a:5:{s:4:\"file\";s:46:\"Capture-decran-2023-10-04-080920-2-330x190.png\";s:5:\"width\";i:330;s:6:\"height\";i:190;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:61708;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:47:\"Capture-decran-2023-10-04-080920-2-1536x706.png\";s:5:\"width\";i:1536;s:6:\"height\";i:706;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:717403;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("245", "131", "_wp_attached_file", "2024/10/Capture-decran-2023-10-03-210725-1.png");
INSERT INTO `wp_postmeta` VALUES("246", "131", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1314;s:6:\"height\";i:880;s:4:\"file\";s:46:\"2024/10/Capture-decran-2023-10-03-210725-1.png\";s:8:\"filesize\";i:97809;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:46:\"Capture-decran-2023-10-03-210725-1-300x201.png\";s:5:\"width\";i:300;s:6:\"height\";i:201;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:26228;}s:5:\"large\";a:5:{s:4:\"file\";s:47:\"Capture-decran-2023-10-03-210725-1-1024x686.png\";s:5:\"width\";i:1024;s:6:\"height\";i:686;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:171451;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:46:\"Capture-decran-2023-10-03-210725-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:9807;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:46:\"Capture-decran-2023-10-03-210725-1-768x514.png\";s:5:\"width\";i:768;s:6:\"height\";i:514;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:115272;}s:22:\"post-slider-thumb-size\";a:5:{s:4:\"file\";s:46:\"Capture-decran-2023-10-03-210725-1-330x190.png\";s:5:\"width\";i:330;s:6:\"height\";i:190;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:26353;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("247", "134", "_wp_attached_file", "2024/10/gallery11.jpg");
INSERT INTO `wp_postmeta` VALUES("248", "134", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:700;s:6:\"height\";i:525;s:4:\"file\";s:21:\"2024/10/gallery11.jpg\";s:8:\"filesize\";i:51039;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:21:\"gallery11-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11482;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:21:\"gallery11-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5115;}s:22:\"post-slider-thumb-size\";a:5:{s:4:\"file\";s:21:\"gallery11-330x190.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10792;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("249", "135", "footnotes", "");
INSERT INTO `wp_postmeta` VALUES("250", "136", "_wp_attached_file", "2024/10/Capture-decran-2023-09-25-211946.png");
INSERT INTO `wp_postmeta` VALUES("251", "136", "saved_in_kubio", "1");
INSERT INTO `wp_postmeta` VALUES("252", "136", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1912;s:6:\"height\";i:1064;s:4:\"file\";s:44:\"2024/10/Capture-decran-2023-09-25-211946.png\";s:8:\"filesize\";i:228536;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:44:\"Capture-decran-2023-09-25-211946-300x167.png\";s:5:\"width\";i:300;s:6:\"height\";i:167;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:17923;}s:5:\"large\";a:5:{s:4:\"file\";s:45:\"Capture-decran-2023-09-25-211946-1024x570.png\";s:5:\"width\";i:1024;s:6:\"height\";i:570;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:125097;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:44:\"Capture-decran-2023-09-25-211946-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:7311;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:44:\"Capture-decran-2023-09-25-211946-768x427.png\";s:5:\"width\";i:768;s:6:\"height\";i:427;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:78855;}s:22:\"post-slider-thumb-size\";a:5:{s:4:\"file\";s:44:\"Capture-decran-2023-09-25-211946-330x190.png\";s:5:\"width\";i:330;s:6:\"height\";i:190;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:20265;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:45:\"Capture-decran-2023-09-25-211946-1536x855.png\";s:5:\"width\";i:1536;s:6:\"height\";i:855;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:233442;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("253", "137", "footnotes", "");
INSERT INTO `wp_postmeta` VALUES("255", "141", "footnotes", "");
INSERT INTO `wp_postmeta` VALUES("256", "142", "_wp_attached_file", "2024/11/formulaire-de-contact-html.png");
INSERT INTO `wp_postmeta` VALUES("257", "142", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:874;s:6:\"height\";i:868;s:4:\"file\";s:38:\"2024/11/formulaire-de-contact-html.png\";s:8:\"filesize\";i:52533;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:38:\"formulaire-de-contact-html-300x298.png\";s:5:\"width\";i:300;s:6:\"height\";i:298;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:37688;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:38:\"formulaire-de-contact-html-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:12476;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:38:\"formulaire-de-contact-html-768x763.png\";s:5:\"width\";i:768;s:6:\"height\";i:763;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:158141;}s:22:\"post-slider-thumb-size\";a:5:{s:4:\"file\";s:38:\"formulaire-de-contact-html-330x190.png\";s:5:\"width\";i:330;s:6:\"height\";i:190;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:25281;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("258", "143", "_wp_attached_file", "2024/11/image-formation.jpg");
INSERT INTO `wp_postmeta` VALUES("259", "143", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:425;s:6:\"height\";i:118;s:4:\"file\";s:27:\"2024/11/image-formation.jpg\";s:8:\"filesize\";i:16298;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:26:\"image-formation-300x83.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:83;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8627;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:27:\"image-formation-150x118.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:118;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6846;}s:22:\"post-slider-thumb-size\";a:5:{s:4:\"file\";s:27:\"image-formation-330x118.jpg\";s:5:\"width\";i:330;s:6:\"height\";i:118;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12876;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("260", "144", "footnotes", "");
INSERT INTO `wp_postmeta` VALUES("261", "145", "_wp_attached_file", "2024/11/image-blanche.avif");
INSERT INTO `wp_postmeta` VALUES("262", "145", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:626;s:6:\"height\";i:417;s:4:\"file\";s:26:\"2024/11/image-blanche.avif\";s:8:\"filesize\";i:11375;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:26:\"image-blanche-300x200.avif\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/avif\";s:8:\"filesize\";i:4333;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:26:\"image-blanche-150x150.avif\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/avif\";s:8:\"filesize\";i:2074;}s:22:\"post-slider-thumb-size\";a:5:{s:4:\"file\";s:26:\"image-blanche-330x190.avif\";s:5:\"width\";i:330;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/avif\";s:8:\"filesize\";i:4355;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("263", "146", "footnotes", "");
INSERT INTO `wp_postmeta` VALUES("264", "147", "footnotes", "");
INSERT INTO `wp_postmeta` VALUES("265", "67", "_wp_old_date", "2024-10-08");
INSERT INTO `wp_postmeta` VALUES("266", "148", "footnotes", "");
INSERT INTO `wp_postmeta` VALUES("267", "67", "saved_in_kubio", "1");
INSERT INTO `wp_postmeta` VALUES("277", "151", "footnotes", "");
INSERT INTO `wp_postmeta` VALUES("279", "67", "_wp_old_date", "2024-11-19");
INSERT INTO `wp_postmeta` VALUES("280", "153", "saved_in_kubio", "1");
INSERT INTO `wp_postmeta` VALUES("281", "153", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("282", "153", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("283", "153", "_menu_item_object_id", "153");
INSERT INTO `wp_postmeta` VALUES("284", "153", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("285", "153", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("286", "153", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("287", "153", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("288", "153", "_menu_item_url", "http://portfolio-theo-valadoux.test/#experience");
INSERT INTO `wp_postmeta` VALUES("289", "154", "saved_in_kubio", "1");
INSERT INTO `wp_postmeta` VALUES("290", "154", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("291", "154", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("292", "154", "_menu_item_object_id", "154");
INSERT INTO `wp_postmeta` VALUES("293", "154", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("294", "154", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("295", "154", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("296", "154", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("297", "154", "_menu_item_url", "http://portfolio-theo-valadoux.test/#competences");
INSERT INTO `wp_postmeta` VALUES("298", "155", "saved_in_kubio", "1");
INSERT INTO `wp_postmeta` VALUES("299", "155", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("300", "155", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("301", "155", "_menu_item_object_id", "155");
INSERT INTO `wp_postmeta` VALUES("302", "155", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("303", "155", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("304", "155", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("305", "155", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("306", "155", "_menu_item_url", "http://portfolio-theo-valadoux.test/#projets");
INSERT INTO `wp_postmeta` VALUES("307", "157", "saved_in_kubio", "1");
INSERT INTO `wp_postmeta` VALUES("308", "157", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("309", "158", "footnotes", "");
INSERT INTO `wp_postmeta` VALUES("310", "157", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("311", "157", "_menu_item_object_id", "157");
INSERT INTO `wp_postmeta` VALUES("312", "157", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("313", "157", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("314", "157", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("315", "157", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("316", "157", "_menu_item_url", "http://portfolio-theo-valadoux.test/#projet-image");
INSERT INTO `wp_postmeta` VALUES("317", "159", "saved_in_kubio", "1");
INSERT INTO `wp_postmeta` VALUES("318", "159", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("319", "159", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("320", "159", "_menu_item_object_id", "159");
INSERT INTO `wp_postmeta` VALUES("321", "159", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("322", "159", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("323", "159", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("324", "159", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("325", "159", "_menu_item_url", "http://portfolio-theo-valadoux.test/#documents-bts-sio");
INSERT INTO `wp_postmeta` VALUES("326", "160", "saved_in_kubio", "1");
INSERT INTO `wp_postmeta` VALUES("327", "160", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("328", "160", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("329", "160", "_menu_item_object_id", "160");
INSERT INTO `wp_postmeta` VALUES("330", "160", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("331", "160", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("332", "160", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("333", "160", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("334", "160", "_menu_item_url", "http://portfolio-theo-valadoux.test/#contact");
INSERT INTO `wp_postmeta` VALUES("335", "4", "saved_in_kubio", "1");

/* INSERT TABLE DATA: wp_posts */
INSERT INTO `wp_posts` VALUES("1", "1", "2024-10-08 08:28:49", "2024-10-08 06:28:49", "<!-- wp:paragraph -->\n<p>Bienvenue sur WordPress. Ceci est votre premier article. Modifiez-le ou supprimez-le, puis commencez à écrire !</p>\n<!-- /wp:paragraph -->", "Bonjour tout le monde !", "", "publish", "open", "open", "", "bonjour-tout-le-monde", "", "", "2024-10-08 08:28:49", "2024-10-08 06:28:49", "", "0", "http://portfolio-theo-valadoux.test/?p=1", "0", "post", "", "1");
INSERT INTO `wp_posts` VALUES("3", "1", "2024-10-08 08:28:49", "2024-10-08 06:28:49", "<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Qui sommes-nous ?</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>L’adresse de notre site est : http://portfolio-theo-valadoux.test.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Commentaires</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Quand vous laissez un commentaire sur notre site, les données inscrites dans le formulaire de commentaire, ainsi que votre adresse IP et l’agent utilisateur de votre navigateur sont collectés pour nous aider à la détection des commentaires indésirables.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>Une chaîne anonymisée créée à partir de votre adresse e-mail (également appelée hash) peut être envoyée au service Gravatar pour vérifier si vous utilisez ce dernier. Les clauses de confidentialité du service Gravatar sont disponibles ici : https://automattic.com/privacy/. Après validation de votre commentaire, votre photo de profil sera visible publiquement à coté de votre commentaire.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Médias</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous téléversez des images sur le site, nous vous conseillons d’éviter de téléverser des images contenant des données EXIF de coordonnées GPS. Les personnes visitant votre site peuvent télécharger et extraire des données de localisation depuis ces images.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Cookies</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous déposez un commentaire sur notre site, il vous sera proposé d’enregistrer votre nom, adresse e-mail et site dans des cookies. C’est uniquement pour votre confort afin de ne pas avoir à saisir ces informations si vous déposez un autre commentaire plus tard. Ces cookies expirent au bout d’un an.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>Si vous vous rendez sur la page de connexion, un cookie temporaire sera créé afin de déterminer si votre navigateur accepte les cookies. Il ne contient pas de données personnelles et sera supprimé automatiquement à la fermeture de votre navigateur.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>Lorsque vous vous connecterez, nous mettrons en place un certain nombre de cookies pour enregistrer vos informations de connexion et vos préférences d’écran. La durée de vie d’un cookie de connexion est de deux jours, celle d’un cookie d’option d’écran est d’un an. Si vous cochez « Se souvenir de moi », votre cookie de connexion sera conservé pendant deux semaines. Si vous vous déconnectez de votre compte, le cookie de connexion sera effacé.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>En modifiant ou en publiant une publication, un cookie supplémentaire sera enregistré dans votre navigateur. Ce cookie ne comprend aucune donnée personnelle. Il indique simplement l’ID de la publication que vous venez de modifier. Il expire au bout d’un jour.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Contenu embarqué depuis d’autres sites</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Les articles de ce site peuvent inclure des contenus intégrés (par exemple des vidéos, images, articles…). Le contenu intégré depuis d’autres sites se comporte de la même manière que si le visiteur se rendait sur cet autre site.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>Ces sites web pourraient collecter des données sur vous, utiliser des cookies, embarquer des outils de suivis tiers, suivre vos interactions avec ces contenus embarqués si vous disposez d’un compte connecté sur leur site web.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Utilisation et transmission de vos données personnelles</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous demandez une réinitialisation de votre mot de passe, votre adresse IP sera incluse dans l’e-mail de réinitialisation.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Durées de stockage de vos données</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous laissez un commentaire, le commentaire et ses métadonnées sont conservés indéfiniment. Cela permet de reconnaître et approuver automatiquement les commentaires suivants au lieu de les laisser dans la file de modération.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>Pour les comptes qui s’inscrivent sur notre site (le cas échéant), nous stockons également les données personnelles indiquées dans leur profil. Tous les comptes peuvent voir, modifier ou supprimer leurs informations personnelles à tout moment (à l’exception de leur identifiant). Les gestionnaires du site peuvent aussi voir et modifier ces informations.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les droits que vous avez sur vos données</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous avez un compte ou si vous avez laissé des commentaires sur le site, vous pouvez demander à recevoir un fichier contenant toutes les données personnelles que nous possédons à votre sujet, incluant celles que vous nous avez fournies. Vous pouvez également demander la suppression des données personnelles vous concernant. Cela ne prend pas en compte les données stockées à des fins administratives, légales ou pour des raisons de sécurité.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Où vos données sont envoyées</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Les commentaires des visiteurs peuvent être vérifiés à l’aide d’un service automatisé de détection des commentaires indésirables.</p>\n<!-- /wp:paragraph -->\n", "Politique de confidentialité", "", "draft", "closed", "open", "", "politique-de-confidentialite", "", "", "2024-10-08 09:27:55", "2024-10-08 07:27:55", "", "0", "http://portfolio-theo-valadoux.test/?page_id=3", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("4", "0", "2024-10-08 08:28:52", "2024-10-08 06:28:52", "<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"className\":\"is-style-fill\",\"fontSize\":\"medium\"} -->\n<div class=\"wp-block-button has-custom-font-size is-style-fill has-medium-font-size\" id=\"experience\"><a class=\"wp-block-button__link wp-element-button\" href=\"http://portfolio-theo-valadoux.test/#experience\">Expérience</a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"fontSize\":\"medium\"} -->\n<div class=\"wp-block-button has-custom-font-size has-medium-font-size\"><a class=\"wp-block-button__link wp-element-button\" href=\"http://portfolio-theo-valadoux.test/#competences\">Compétences</a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"fontSize\":\"medium\"} -->\n<div class=\"wp-block-button has-custom-font-size has-medium-font-size\"><a class=\"wp-block-button__link wp-element-button\" href=\"http://portfolio-theo-valadoux.test/#projets\">Projets</a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"fontSize\":\"medium\"} -->\n<div class=\"wp-block-button has-custom-font-size has-medium-font-size\"><a class=\"wp-block-button__link wp-element-button\" href=\"http://portfolio-theo-valadoux.test/#projet-image\">Projets galerie</a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"fontSize\":\"medium\"} -->\n<div class=\"wp-block-button has-custom-font-size has-medium-font-size\"><a class=\"wp-block-button__link wp-element-button\" href=\"http://portfolio-theo-valadoux.test/#documents-bts-sio\">BTS SIO</a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"fontSize\":\"medium\"} -->\n<div class=\"wp-block-button has-custom-font-size has-medium-font-size\"><a class=\"wp-block-button__link wp-element-button\" href=\"http://portfolio-theo-valadoux.test/#contact\">Contact</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons -->", "Navigation", "", "publish", "closed", "closed", "", "navigation", "", "", "2024-11-21 11:06:13", "2024-11-21 10:06:13", "", "0", "http://portfolio-theo-valadoux.test/2024/10/08/navigation/", "0", "wp_navigation", "", "0");
INSERT INTO `wp_posts` VALUES("7", "1", "2024-10-08 08:34:17", "2024-10-08 06:34:17", "{\"version\": 3, \"isGlobalStylesUserThemeJSON\": true }", "Custom Styles", "", "publish", "closed", "closed", "", "wp-global-styles-twentytwentyfour", "", "", "2024-10-08 08:34:17", "2024-10-08 06:34:17", "", "0", "http://portfolio-theo-valadoux.test/2024/10/08/wp-global-styles-twentytwentyfour/", "0", "wp_global_styles", "", "0");
INSERT INTO `wp_posts` VALUES("40", "1", "2024-10-08 08:53:30", "0000-00-00 00:00:00", "", "Aerial Land", "", "draft", "open", "closed", "", "", "", "", "2024-10-08 08:53:27", "0000-00-00 00:00:00", "", "0", "http://portfolio-theo-valadoux.test/wp-content/uploads/2024/10/StockSnap_M6D1GS9PSL.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("41", "1", "2024-10-08 08:53:30", "0000-00-00 00:00:00", "", "Contact", "", "draft", "open", "closed", "", "", "", "", "2024-10-08 08:53:28", "0000-00-00 00:00:00", "", "0", "http://portfolio-theo-valadoux.test/wp-content/uploads/2024/10/StockSnap_6O7JXC5DC5.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("42", "1", "2024-10-08 09:25:16", "2024-10-08 07:25:16", "\n                    <!-- wp:cover {\"url\":\"https://demo.wpzoom.com/inspiro-lite/files/2022/03/Pexels-Videos-1409899-1.mp4\",\"id\":6672,\"dimRatio\":20,\"backgroundType\":\"video\",\"minHeight\":100,\"minHeightUnit\":\"vh\",\"contentPosition\":\"center center\",\"isDark\":false,\"align\":\"full\",\"layout\":{\"type\":\"constrained\"}} -->\n                    <div class=\"wp-block-cover alignfull is-light\" style=\"min-height:100vh\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-20 has-background-dim\"></span><video class=\"wp-block-cover__video-background intrinsic-ignore\" autoplay muted loop playsinline src=\"https://demo.wpzoom.com/inspiro-lite/files/2022/03/Pexels-Videos-1409899-1.mp4\" data-object-fit=\"cover\"></video><div class=\"wp-block-cover__inner-container\"><!-- wp:paragraph {\"align\":\"center\",\"placeholder\":\"Write title…\",\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"900\",\"lineHeight\":\"1.2\"}},\"textColor\":\"white\",\"fontSize\":\"max-60\"} -->\n                    <p class=\"has-text-align-center has-white-color has-text-color has-max-60-font-size\" style=\"font-style:normal;font-weight:900;line-height:1.2\"><strong>Create. Amaze. Inspire.</strong></p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:paragraph {\"align\":\"center\",\"textColor\":\"white\",\"fontSize\":\"medium\"} -->\n                    <p class=\"has-text-align-center has-white-color has-text-color has-medium-font-size\">Inspiro is a Portfolio &amp; Photography WordPress Theme. This area supports self-hosted videos as well as videos from YouTube and Vimeo.</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:spacer {\"height\":\"55px\"} -->\n                    <div style=\"height:55px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n                    <div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"white\",\"style\":{\"border\":{\"radius\":\"0px\"}},\"className\":\"is-style-outline\"} -->\n                    <div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-white-color has-text-color wp-element-button\" href=\"#\" style=\"border-radius:0px\">Learn More</a></div>\n                    <!-- /wp:button --></div>\n                    <!-- /wp:buttons --></div></div>\n                    <!-- /wp:cover -->\n\n                    <!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\n                    <div class=\"wp-block-group\"><!-- wp:spacer {\"height\":\"57px\"} -->\n                    <div style=\"height:57px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:heading {\"textAlign\":\"center\",\"style\":{\"typography\":{\"letterSpacing\":\"1px\"}},\"fontSize\":\"medium\"} -->\n                    <h2 class=\"wp-block-heading has-text-align-center has-medium-font-size\" style=\"letter-spacing:1px\">WE ARE A CREATIVE AGENCY LOCATED IN LONDON</h2>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:paragraph {\"align\":\"center\"} -->\n                    <p class=\"has-text-align-center\">This is some dummy copy. You’re not really supposed to read this dummy copy, it is just a placeholder for people who need some type to visualize what the actual copy might look like if it were real content.</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\",\"orientation\":\"horizontal\"}} -->\n                    <div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"border\":{\"radius\":\"0px\"}},\"className\":\"is-style-outline\",\"fontSize\":\"small\"} -->\n                    <div class=\"wp-block-button has-custom-font-size is-style-outline has-small-font-size\"><a class=\"wp-block-button__link wp-element-button\" href=\"#\" style=\"border-radius:0px\">ABOUT US</a></div>\n                    <!-- /wp:button --></div>\n                    <!-- /wp:buttons -->\n\n                    <!-- wp:spacer {\"height\":\"57px\"} -->\n                    <div style=\"height:57px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer --></div>\n                    <!-- /wp:group -->\n\n                    <!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#f8f8f8\"}},\"className\":\"pattern_multiple_covers\",\"layout\":{\"type\":\"constrained\"}} -->\n                    <div class=\"wp-block-group alignfull pattern_multiple_covers has-background\" id=\"services\" style=\"background-color:#f8f8f8\"><!-- wp:spacer {\"height\":\"84px\"} -->\n                    <div style=\"height:84px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:paragraph {\"align\":\"left\",\"style\":{\"typography\":{\"letterSpacing\":\"1px\"}},\"textColor\":\"secondary\"} -->\n                    <p class=\"has-text-align-left has-secondary-color has-text-color\" style=\"letter-spacing:1px\">LET\'S WORK TOGETHER!</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:heading {\"textAlign\":\"left\"} -->\n                    <h2 class=\"wp-block-heading has-text-align-left\">Our Services</h2>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:paragraph {\"align\":\"left\"} -->\n                    <p class=\"has-text-align-left\">Inspiro is the perfect solution to create a beautiful website for your portfolio or your business. If you’re looking to create a captivating presence online, then you’ve found the right tool. The theme is easy to manage, with a drag-and-drop interface and fully customizable using the Theme Customizer.</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:spacer {\"height\":\"46px\"} -->\n                    <div style=\"height:46px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:columns -->\n                    <div class=\"wp-block-columns\"><!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"}}}} -->\n                    <div class=\"wp-block-column\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:cover {\"url\":\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/StockSnap_356BERTH29.jpg\",\"id\":7392,\"dimRatio\":70,\"overlayColor\":\"primary\",\"contentPosition\":\"bottom left\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|small\",\"right\":\"var:preset|spacing|x-small\",\"bottom\":\"var:preset|spacing|small\",\"left\":\"var:preset|spacing|x-small\"}}}} -->\n                    <div class=\"wp-block-cover has-custom-content-position is-position-bottom-left\" style=\"padding-top:var(--wp--preset--spacing--small);padding-right:var(--wp--preset--spacing--x-small);padding-bottom:var(--wp--preset--spacing--small);padding-left:var(--wp--preset--spacing--x-small)\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-primary-background-color has-background-dim-70 has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-7392\" alt=\"\" src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/StockSnap_356BERTH29.jpg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"margin\":{\"left\":\"0\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\"}}},\"textColor\":\"white\",\"fontSize\":\"medium\"} -->\n                    <h3 class=\"wp-block-heading has-white-color has-text-color has-medium-font-size\" style=\"margin-top:0;margin-right:0;margin-bottom:0;margin-left:0\">Video<br>Production</h3>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"left\":\"0\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|secondary\"}}}},\"textColor\":\"secondary\"} -->\n                    <p class=\"has-secondary-color has-text-color has-link-color\" style=\"margin-top:0;margin-right:0;margin-bottom:0;margin-left:0\"><a href=\"#\">Explore more →</a></p>\n                    <!-- /wp:paragraph --></div></div>\n                    <!-- /wp:cover --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"}}}} -->\n                    <div class=\"wp-block-column\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:cover {\"url\":\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/StockSnap_KV0WLH355C.jpg\",\"id\":7394,\"dimRatio\":70,\"overlayColor\":\"primary\",\"contentPosition\":\"bottom left\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|small\",\"right\":\"var:preset|spacing|x-small\",\"bottom\":\"var:preset|spacing|small\",\"left\":\"var:preset|spacing|x-small\"}}}} -->\n                    <div class=\"wp-block-cover has-custom-content-position is-position-bottom-left\" style=\"padding-top:var(--wp--preset--spacing--small);padding-right:var(--wp--preset--spacing--x-small);padding-bottom:var(--wp--preset--spacing--small);padding-left:var(--wp--preset--spacing--x-small)\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-primary-background-color has-background-dim-70 has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-7394\" alt=\"\" src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/StockSnap_KV0WLH355C.jpg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"margin\":{\"left\":\"0\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\"}}},\"textColor\":\"white\",\"fontSize\":\"medium\"} -->\n                    <h3 class=\"wp-block-heading has-white-color has-text-color has-medium-font-size\" style=\"margin-top:0;margin-right:0;margin-bottom:0;margin-left:0\">Professional<br>Editing</h3>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"left\":\"0\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|secondary\"}}}},\"textColor\":\"secondary\"} -->\n                    <p class=\"has-secondary-color has-text-color has-link-color\" style=\"margin-top:0;margin-right:0;margin-bottom:0;margin-left:0\"><a href=\"#\">Explore more →</a></p>\n                    <!-- /wp:paragraph --></div></div>\n                    <!-- /wp:cover --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"}}}} -->\n                    <div class=\"wp-block-column\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:cover {\"url\":\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/StockSnap_P9QYJ8AAL8.jpg\",\"id\":7497,\"dimRatio\":70,\"overlayColor\":\"primary\",\"contentPosition\":\"bottom left\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|small\",\"right\":\"var:preset|spacing|x-small\",\"bottom\":\"var:preset|spacing|small\",\"left\":\"var:preset|spacing|x-small\"}}}} -->\n                    <div class=\"wp-block-cover has-custom-content-position is-position-bottom-left\" style=\"padding-top:var(--wp--preset--spacing--small);padding-right:var(--wp--preset--spacing--x-small);padding-bottom:var(--wp--preset--spacing--small);padding-left:var(--wp--preset--spacing--x-small)\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-primary-background-color has-background-dim-70 has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-7497\" alt=\"\" src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/StockSnap_P9QYJ8AAL8.jpg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"margin\":{\"left\":\"0\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\"}}},\"textColor\":\"white\",\"fontSize\":\"medium\"} -->\n                    <h3 class=\"wp-block-heading has-white-color has-text-color has-medium-font-size\" style=\"margin-top:0;margin-right:0;margin-bottom:0;margin-left:0\">Aerial<br>Video</h3>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"left\":\"0\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|secondary\"}}}},\"textColor\":\"secondary\"} -->\n                    <p class=\"has-secondary-color has-text-color has-link-color\" style=\"margin-top:0;margin-right:0;margin-bottom:0;margin-left:0\"><a href=\"#\">Explore more →</a></p>\n                    <!-- /wp:paragraph --></div></div>\n                    <!-- /wp:cover --></div>\n                    <!-- /wp:column --></div>\n                    <!-- /wp:columns -->\n\n                    <!-- wp:spacer {\"height\":\"103px\"} -->\n                    <div style=\"height:103px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer --></div>\n                    <!-- /wp:group -->\n\n                    <!-- wp:group {\"align\":\"full\",\"layout\":{\"type\":\"constrained\"}} -->\n                    <div class=\"wp-block-group alignfull\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|small\",\"bottom\":\"var:preset|spacing|small\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n                    <div class=\"wp-block-group\" style=\"padding-top:var(--wp--preset--spacing--small);padding-bottom:var(--wp--preset--spacing--small)\"><!-- wp:spacer {\"height\":\"30px\"} -->\n                    <div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|small\"}}}} -->\n                    <div class=\"wp-block-columns\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\n                    <div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:heading {\"style\":{\"typography\":{\"textTransform\":\"uppercase\"}},\"fontSize\":\"medium\"} -->\n                    <h2 class=\"wp-block-heading has-medium-font-size\" style=\"text-transform:uppercase\">About us</h2>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:paragraph -->\n                    <p>This is some dummy copy. You’re not really supposed to read this dummy copy, it is just a placeholder for people who need some type to visualize what the actual copy might look like if it were real content.</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"left\",\"orientation\":\"horizontal\"}} -->\n                    <div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"border\":{\"radius\":\"0px\"}},\"className\":\"is-style-outline\"} -->\n                    <div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\" href=\"#\" style=\"border-radius:0px\">ABOUT US</a></div>\n                    <!-- /wp:button --></div>\n                    <!-- /wp:buttons -->\n\n                    <!-- wp:paragraph -->\n                    <p></p>\n                    <!-- /wp:paragraph --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column -->\n                    <div class=\"wp-block-column\"><!-- wp:image {\"id\":26,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n                    <figure class=\"wp-block-image size-large\"><img src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/StockSnap_JKMGVEJMPU.jpg\" alt=\"\" class=\"wp-image-26\"/></figure>\n                    <!-- /wp:image --></div>\n                    <!-- /wp:column --></div>\n                    <!-- /wp:columns -->\n\n                    <!-- wp:spacer {\"height\":\"30px\"} -->\n                    <div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer --></div>\n                    <!-- /wp:group --></div>\n                    <!-- /wp:group -->\n\n                    <!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#f8f8f8\"}},\"layout\":{\"type\":\"constrained\"}} -->\n                    <div class=\"wp-block-group alignfull has-background\" style=\"background-color:#f8f8f8\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|small\",\"bottom\":\"var:preset|spacing|small\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n                    <div class=\"wp-block-group\" style=\"padding-top:var(--wp--preset--spacing--small);padding-bottom:var(--wp--preset--spacing--small)\"><!-- wp:spacer {\"height\":\"30px\"} -->\n                    <div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:columns {\"verticalAlignment\":\"center\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|small\"}}}} -->\n                    <div class=\"wp-block-columns are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\n                    <div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:image {\"id\":27,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n                    <figure class=\"wp-block-image size-large\"><img src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/StockSnap_M6D1GS9PSL.jpg\" alt=\"\" class=\"wp-image-27\"/></figure>\n                    <!-- /wp:image --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column {\"verticalAlignment\":\"center\"} -->\n                    <div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:heading {\"style\":{\"typography\":{\"textTransform\":\"uppercase\"}},\"fontSize\":\"medium\"} -->\n                    <h2 class=\"wp-block-heading has-medium-font-size\" style=\"text-transform:uppercase\">Our Services</h2>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:paragraph -->\n                    <p>This is some dummy copy. You’re not really supposed to read this dummy copy, it is just a placeholder for people who need some type to visualize what the actual copy might look like if it were real content.</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:buttons -->\n                    <div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"border\":{\"radius\":\"0px\"}},\"className\":\"is-style-outline\"} -->\n                    <div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\" href=\"#\" style=\"border-radius:0px\">SERVICES</a></div>\n                    <!-- /wp:button --></div>\n                    <!-- /wp:buttons --></div>\n                    <!-- /wp:column --></div>\n                    <!-- /wp:columns -->\n\n                    <!-- wp:spacer {\"height\":\"30px\"} -->\n                    <div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer --></div>\n                    <!-- /wp:group --></div>\n                    <!-- /wp:group -->\n\n                    <!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0px\"}}},\"backgroundColor\":\"black\",\"className\":\"portfolio-dark\",\"layout\":{\"type\":\"constrained\"}} -->\n                    <div class=\"wp-block-group alignfull portfolio-dark has-black-background-color has-background\" id=\"portfolio\" style=\"margin-top:0px\"><!-- wp:spacer {\"height\":\"122px\"} -->\n                    <div style=\"height:122px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:paragraph {\"align\":\"left\",\"style\":{\"typography\":{\"letterSpacing\":\"1px\"},\"color\":{\"text\":\"#0bb4aa\"}}} -->\n                    <p class=\"has-text-align-left has-text-color\" style=\"color:#0bb4aa;letter-spacing:1px\">FROM THE PORTFOLIO</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:heading {\"textAlign\":\"left\",\"textColor\":\"white\",\"fontSize\":\"large\"} -->\n                    <h2 class=\"wp-block-heading has-text-align-left has-white-color has-text-color has-large-font-size\">Our Work</h2>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:spacer {\"height\":\"44px\"} -->\n                    <div style=\"height:44px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:wpzoom-blocks/portfolio {\"align\":\"full\",\"textColor\":\"white\",\"btnHoverTextColor\":\"#101010\",\"btnBgColor\":\"#0bb4aa\",\"btnHoverBgColor\":\"#ffffff\"} /-->\n\n                    <!-- wp:spacer {\"height\":\"50px\"} -->\n                    <div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer --></div>\n                    <!-- /wp:group -->\n\n                    <!-- wp:group {\"layout\":{\"type\":\"constrained\",\"contentSize\":\"1200px\",\"justifyContent\":\"center\"}} -->\n                    <div id=\"partners\" class=\"wp-block-group\"><!-- wp:spacer {\"height\":\"80px\"} -->\n                    <div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0px\",\"bottom\":\"var:preset|spacing|small\",\"right\":\"0\",\"left\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"contentSize\":\"\",\"justifyContent\":\"left\",\"wideSize\":\"\"}} -->\n                    <div class=\"wp-block-group\" style=\"padding-top:0px;padding-right:0;padding-bottom:var(--wp--preset--spacing--small);padding-left:0\"><!-- wp:columns -->\n                    <div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"60%\"} -->\n                    <div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:spacer {\"height\":\"20px\"} -->\n                    <div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:paragraph {\"textColor\":\"secondary\"} -->\n                    <p class=\"has-secondary-color has-text-color\">WE WORK WITH</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:heading {\"textAlign\":\"left\"} -->\n                    <h2 class=\"wp-block-heading has-text-align-left\">Our Clients</h2>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:spacer {\"height\":\"20px\"} -->\n                    <div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:paragraph {\"align\":\"left\",\"textColor\":\"tertiary\"} -->\n                    <p class=\"has-text-align-left has-tertiary-color has-text-color\">This is some dummy copy. You’re not really supposed to read this dummy copy, it is just a place holder for people who need some type to visualize.</p>\n                    <!-- /wp:paragraph --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column {\"width\":\"40%\"} -->\n                    <div class=\"wp-block-column\" style=\"flex-basis:40%\"></div>\n                    <!-- /wp:column --></div>\n                    <!-- /wp:columns --></div>\n                    <!-- /wp:group -->\n\n                    <!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\n                    <div class=\"wp-block-group\"><!-- wp:columns {\"verticalAlignment\":\"center\"} -->\n                    <div class=\"wp-block-columns are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"20%\"} -->\n                    <div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:20%\"><!-- wp:outermost/icon-block {\"iconName\":\"\",\"itemsJustification\":\"center\",\"width\":\"200px\"} -->\n                    <div class=\"wp-block-outermost-icon-block items-justified-center\"><div class=\"icon-container\" style=\"width:200px\"><svg width=\"147\" height=\"46\" viewBox=\"0 0 147 46\" fill=\"none\" xmlns=\"https://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M72.6763 7.40747C74.0641 6.01977 76.3141 6.01977 77.7019 7.40747C79.0897 8.79527 79.0897 11.0453 77.7019 12.4331L69.241 20.894C66.8118 17.6384 67.0757 13.0082 70.0327 10.0512L72.6763 7.40747Z\" fill=\"#ECECEC\"></path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M84.7713 26.4967C86.1593 27.8844 86.1593 30.1345 84.7713 31.5222C83.3843 32.91 81.1339 32.91 79.7461 31.5222L71.2852 23.0614C74.5408 20.6322 79.171 20.896 82.128 23.853L84.7713 26.4967Z\" fill=\"#ECECEC\"></path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M65.6835 38.5924C64.2958 39.9802 62.0457 39.9802 60.658 38.5924C59.2702 37.2046 59.2702 34.9546 60.658 33.5668L69.1188 25.106C71.548 28.3616 71.2842 32.9918 68.3272 35.9487L65.6835 38.5924Z\" fill=\"#ECECEC\"></path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M53.5877 19.503C52.1999 18.1152 52.1999 15.8652 53.5877 14.4774C54.9755 13.0896 57.2255 13.0896 58.6133 14.4774L67.0742 22.9383C63.8186 25.3675 59.1883 25.1036 56.2314 22.1467L53.5877 19.503Z\" fill=\"#ECECEC\"></path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M70.7852 37.5563C72.8315 35.2811 73.7826 32.3698 73.6383 29.5034L77.7017 33.5668C77.7118 33.5769 77.722 33.587 77.7322 33.5971V36.4981C77.7322 38.4607 76.1412 40.0517 74.1786 40.0517C72.5845 40.0517 71.2356 39.0021 70.7852 37.5563Z\" fill=\"#ECECEC\"></path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M54.6243 24.606C56.8994 26.6524 59.8107 27.6035 62.6771 27.4592L58.6138 31.5226C58.6036 31.5327 58.5935 31.5429 58.5835 31.553H55.6825C53.7199 31.5531 52.1289 29.962 52.1289 27.9994C52.1289 26.4054 53.1785 25.0564 54.6243 24.606Z\" fill=\"#ECECEC\"></path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M83.7362 21.3944C81.4613 19.348 78.55 18.3969 75.6836 18.5411L79.7469 14.4778C79.7571 14.4677 79.7671 14.4575 79.7772 14.4473H82.6783C84.6412 14.4473 86.2322 16.0384 86.2322 18.001C86.2322 19.5951 85.1822 20.944 83.7362 21.3944Z\" fill=\"#ECECEC\"></path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M67.572 8.44374C65.5256 10.7189 64.5746 13.6302 64.7188 16.4967L60.6555 12.4333C60.6453 12.4232 60.6352 12.4131 60.625 12.403V9.50194C60.625 7.53934 62.216 5.94824 64.1786 5.94824C65.7727 5.94824 67.1216 6.99794 67.572 8.44374Z\" fill=\"#ECECEC\"></path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M64.1781 3.05713C60.6187 3.05713 57.7332 5.94263 57.7332 9.50203V10.7555C55.5918 10.196 53.2186 10.7552 51.5405 12.4333C49.0236 14.9502 49.0236 19.0309 51.5405 21.5478L52.4268 22.4341C50.517 23.5527 49.2344 25.6262 49.2344 27.9993C49.2344 31.5587 52.1199 34.4442 55.6793 34.4442H56.9327C56.3732 36.5856 56.9324 38.9588 58.6105 40.6368C61.1274 43.1537 65.2081 43.1537 67.725 40.6368L70.3686 37.9932C72.7007 35.6611 73.7899 32.5567 73.6362 29.5033L77.6997 33.5667C80.2166 36.0836 84.2974 36.0836 86.8144 33.5667C89.3314 31.0498 89.3314 26.9691 86.8144 24.4523L85.9284 23.5661C87.8374 22.4475 89.1204 20.374 89.1204 18.0009C89.1204 14.4415 86.2344 11.556 82.6754 11.556H81.4219C81.9815 9.41453 81.4222 7.04133 79.7441 5.36323C77.2273 2.84633 73.1466 2.84633 70.6297 5.36323L67.986 8.00693C65.6539 10.339 64.5647 13.4433 64.7184 16.4967L60.655 12.4333C60.6448 12.4232 60.6347 12.4131 60.6245 12.403V9.50203C60.6245 7.53943 62.2155 5.94843 64.1781 5.94843C65.7722 5.94843 67.1211 6.99803 67.5715 8.44383C67.705 8.29543 67.8431 8.14973 67.9859 8.00693L69.7433 6.24953C68.6247 4.33973 66.5512 3.05713 64.1781 3.05713ZM79.7744 14.4473C79.7643 14.4574 79.7543 14.4676 79.7441 14.4777L75.6808 18.541C78.5473 18.3968 81.4585 19.3478 83.7334 21.3943C85.1794 20.9439 86.2294 19.5949 86.2294 18.0009C86.2294 16.0383 84.6384 14.4473 82.6754 14.4473H79.7744ZM58.5801 31.5529C58.5902 31.5427 58.6003 31.5325 58.6105 31.5224L62.6738 27.459C59.8074 27.6033 56.8962 26.6522 54.6211 24.6059C53.1753 25.0563 52.1256 26.4052 52.1256 27.9993C52.1256 29.9619 53.7167 31.5529 55.6793 31.5529H58.5801ZM54.5103 24.5049C54.4 24.403 54.2913 24.2985 54.1842 24.1914V24.1915C54.2913 24.2986 54.4 24.403 54.5103 24.5049ZM74.1766 42.9431C71.8034 42.9431 69.7299 41.6604 68.6113 39.7506L70.3686 37.9932C70.5115 37.8504 70.6496 37.7047 70.7831 37.5563C71.2335 39.0021 72.5824 40.0518 74.1766 40.0518C76.1392 40.0518 77.7302 38.4608 77.7302 36.4982V33.5972C78.563 34.4191 79.564 34.9683 80.6215 35.2446V36.4982C80.6215 40.0576 77.736 42.9431 74.1766 42.9431ZM77.6997 7.40763C76.3119 6.01993 74.0619 6.01993 72.6741 7.40763L70.0304 10.0513C67.0735 13.0083 66.8096 17.6385 69.2388 20.8941L77.6997 12.4332C79.0875 11.0454 79.0875 8.79543 77.6997 7.40763ZM84.7694 31.5223C86.1574 30.1345 86.1574 27.8845 84.7694 26.4967L82.126 23.853C79.1691 20.8961 74.5388 20.6322 71.2832 23.0614L79.7441 31.5223C81.1319 32.9101 83.3824 32.9101 84.7694 31.5223ZM65.6805 38.5924C64.2927 39.9802 62.0427 39.9802 60.6549 38.5924C59.2672 37.2046 59.2672 34.9546 60.6549 33.5668L69.1158 25.1059C71.545 28.3615 71.2811 32.9918 68.3242 35.9487L65.6805 38.5924ZM53.5849 14.4777C52.1972 15.8655 52.1972 18.1155 53.5849 19.5033L56.2286 22.147C59.1856 25.1039 63.8158 25.3678 67.0714 22.9386L58.6105 14.4777C57.2227 13.09 54.9727 13.09 53.5849 14.4777Z\" fill=\"#6C6C77\"></path><path d=\"M1.53125 16.0898H4.69185V25.911H10.1202V28.5716H1.53125V16.0898Z\" fill=\"#6C6C77\"></path><path d=\"M15.8598 28.8393C14.8003 28.8393 13.8717 28.6488 13.0741 28.2679C12.2765 27.875 11.6575 27.3393 11.217 26.6608C10.7885 25.9703 10.5742 25.1787 10.5742 24.2858C10.5742 23.393 10.7885 22.6073 11.217 21.9288C11.6575 21.2383 12.2765 20.7026 13.0741 20.3217C13.8717 19.9288 14.8003 19.7324 15.8598 19.7324C16.9193 19.7324 17.8478 19.9288 18.6454 20.3217C19.443 20.7026 20.0561 21.2383 20.4846 21.9288C20.9251 22.6073 21.1453 23.393 21.1453 24.2858C21.1453 25.1787 20.9251 25.9703 20.4846 26.6608C20.0561 27.3393 19.443 27.875 18.6454 28.2679C17.8478 28.6488 16.9193 28.8393 15.8598 28.8393ZM15.8598 26.3929C16.4907 26.3929 16.9907 26.2084 17.3597 25.8394C17.7407 25.4584 17.9311 24.9406 17.9311 24.2858C17.9311 23.6311 17.7407 23.1192 17.3597 22.7502C16.9907 22.3692 16.4907 22.1788 15.8598 22.1788C15.2288 22.1788 14.7229 22.3692 14.342 22.7502C13.9729 23.1192 13.7884 23.6311 13.7884 24.2858C13.7884 24.9406 13.9729 25.4584 14.342 25.8394C14.7229 26.2084 15.2288 26.3929 15.8598 26.3929Z\" fill=\"#6C6C77\"></path><path d=\"M27.049 32.6785C26.4776 32.6785 25.9002 32.6249 25.3169 32.5178C24.7455 32.4106 24.2513 32.2678 23.8347 32.0892V29.9107C24.7751 30.3154 25.8466 30.5178 27.049 30.5178C27.918 30.5178 28.543 30.3392 28.9239 29.9821C29.3168 29.625 29.5131 29.1012 29.5131 28.4107V27.8929C29.1679 28.1905 28.7393 28.4226 28.2274 28.5893C27.7274 28.756 27.1918 28.8393 26.6203 28.8393C25.7156 28.8393 24.9181 28.6488 24.2276 28.2679C23.5372 27.8869 22.9954 27.3512 22.6026 26.6608C22.2216 25.9703 22.0312 25.1787 22.0312 24.2858C22.0312 23.3811 22.2216 22.5835 22.6026 21.8931C22.9835 21.2026 23.5192 20.6728 24.2097 20.3038C24.9001 19.9229 25.6919 19.7324 26.5847 19.7324C27.8109 19.7324 28.8227 20.1074 29.6203 20.8574V20.0002H32.656V27.9822C32.656 29.4702 32.1976 30.625 31.281 31.4464C30.3763 32.2678 28.9656 32.6785 27.049 32.6785ZM27.406 26.4108C27.8941 26.4108 28.3287 26.2858 28.7096 26.0358C29.0906 25.7858 29.3583 25.4525 29.5131 25.0358V23.5359C29.3464 23.1192 29.0726 22.7918 28.6917 22.5537C28.3107 22.3038 27.8822 22.1788 27.406 22.1788C26.7632 22.1788 26.2454 22.3692 25.8526 22.7502C25.4597 23.1192 25.2633 23.6251 25.2633 24.268C25.2633 24.9227 25.4597 25.4465 25.8526 25.8394C26.2454 26.2203 26.7632 26.4108 27.406 26.4108Z\" fill=\"#6C6C77\"></path><path d=\"M38.7387 28.8393C37.6792 28.8393 36.7507 28.6488 35.9531 28.2679C35.1555 27.875 34.5364 27.3393 34.096 26.6608C33.6674 25.9703 33.4531 25.1787 33.4531 24.2858C33.4531 23.393 33.6674 22.6073 34.096 21.9288C34.5364 21.2383 35.1555 20.7026 35.9531 20.3217C36.7507 19.9288 37.6792 19.7324 38.7387 19.7324C39.7982 19.7324 40.7267 19.9288 41.5243 20.3217C42.3219 20.7026 42.935 21.2383 43.3636 21.9288C43.804 22.6073 44.0243 23.393 44.0243 24.2858C44.0243 25.1787 43.804 25.9703 43.3636 26.6608C42.935 27.3393 42.3219 27.875 41.5243 28.2679C40.7267 28.6488 39.7982 28.8393 38.7387 28.8393ZM38.7387 26.3929C39.3696 26.3929 39.8696 26.2084 40.2387 25.8394C40.6196 25.4584 40.8101 24.9406 40.8101 24.2858C40.8101 23.6311 40.6196 23.1192 40.2387 22.7502C39.8696 22.3692 39.3696 22.1788 38.7387 22.1788C38.1078 22.1788 37.6018 22.3692 37.2209 22.7502C36.8518 23.1192 36.6673 23.6311 36.6673 24.2858C36.6673 24.9406 36.8518 25.4584 37.2209 25.8394C37.6018 26.2084 38.1078 26.3929 38.7387 26.3929Z\" fill=\"#6C6C77\"></path><path d=\"M94.4336 16.0898H97.5946V28.5716H94.4336V16.0898Z\" fill=\"#6C6C77\"></path><path d=\"M99.1914 20.0002H102.227V20.8574C103.024 20.1074 104.036 19.7324 105.262 19.7324C106.155 19.7324 106.947 19.9229 107.637 20.3038C108.328 20.6728 108.863 21.2026 109.244 21.8931C109.625 22.5716 109.816 23.3633 109.816 24.268C109.816 25.1608 109.625 25.9584 109.244 26.6608C108.863 27.3512 108.328 27.8869 107.637 28.2679C106.959 28.6488 106.167 28.8393 105.262 28.8393C104.691 28.8393 104.143 28.75 103.62 28.5714C103.108 28.4048 102.679 28.1726 102.334 27.875V32.482H99.1914V20.0002ZM104.441 26.3929C105.084 26.3929 105.602 26.2025 105.994 25.8215C106.387 25.4406 106.584 24.9227 106.584 24.268C106.584 23.6132 106.387 23.1014 105.994 22.7323C105.602 22.3514 105.084 22.1609 104.441 22.1609C103.965 22.1609 103.536 22.2859 103.155 22.5359C102.774 22.774 102.501 23.1014 102.334 23.518V25.0358C102.501 25.4525 102.774 25.7858 103.155 26.0358C103.536 26.2739 103.965 26.3929 104.441 26.3929Z\" fill=\"#6C6C77\"></path><path d=\"M114.502 28.8393C113.812 28.8393 113.092 28.7679 112.342 28.625C111.592 28.4941 110.996 28.3036 110.556 28.0536V25.7501C111.044 26.0358 111.627 26.2739 112.306 26.4644C112.996 26.6429 113.627 26.7322 114.199 26.7322C114.615 26.7322 114.919 26.7024 115.109 26.6429C115.3 26.5834 115.395 26.4644 115.395 26.2858C115.395 26.1429 115.33 26.0298 115.199 25.9465C115.08 25.8513 114.853 25.756 114.52 25.6608C114.199 25.5537 113.824 25.4406 113.395 25.3215C112.669 25.1072 112.098 24.887 111.681 24.6608C111.264 24.4346 110.955 24.1489 110.752 23.8037C110.55 23.4585 110.449 23.024 110.449 22.5002C110.449 21.5716 110.812 20.8812 111.538 20.4288C112.276 19.9645 113.282 19.7324 114.556 19.7324C115.175 19.7324 115.824 19.7979 116.502 19.9288C117.193 20.0598 117.71 20.2324 118.056 20.4467V22.7145C117.699 22.4764 117.222 22.2799 116.627 22.1252C116.044 21.9704 115.496 21.8931 114.984 21.8931C114.58 21.8931 114.264 21.9347 114.038 22.018C113.812 22.0895 113.699 22.2204 113.699 22.4109C113.699 22.5895 113.812 22.7264 114.038 22.8216C114.264 22.9168 114.669 23.0359 115.252 23.1787C115.633 23.274 115.794 23.3156 115.734 23.3037C116.496 23.5061 117.085 23.7323 117.502 23.9823C117.919 24.2323 118.21 24.5299 118.377 24.8751C118.556 25.2084 118.645 25.637 118.645 26.1608C118.645 26.9822 118.288 27.6369 117.574 28.125C116.871 28.6012 115.847 28.8393 114.502 28.8393Z\" fill=\"#6C6C77\"></path><path d=\"M123.34 28.8396C122.162 28.8396 121.275 28.5122 120.68 27.8575C120.097 27.2027 119.805 26.3397 119.805 25.2683V20.0005H122.948V24.9111C122.948 25.8992 123.394 26.3932 124.287 26.3932C124.692 26.3932 125.061 26.298 125.394 26.1075C125.727 25.917 126.001 25.6373 126.215 25.2683V20.0005H129.358V28.5717H126.323V27.6432C125.954 28.036 125.507 28.3336 124.983 28.536C124.46 28.7384 123.912 28.8396 123.34 28.8396Z\" fill=\"#6C6C77\"></path><path d=\"M130.965 20.0004H133.876V20.929C134.233 20.5481 134.644 20.2564 135.108 20.054C135.572 19.8397 136.066 19.7326 136.59 19.7326C137.233 19.7326 137.745 19.8278 138.126 20.0183C138.519 20.2088 138.834 20.4945 139.072 20.8754C139.429 20.5183 139.864 20.2385 140.376 20.0362C140.888 19.8338 141.406 19.7326 141.929 19.7326C143.06 19.7326 143.864 20.0243 144.34 20.6076C144.816 21.179 145.054 22.0063 145.054 23.0896V28.5716H142.054V23.5361C142.054 23.0599 141.965 22.7147 141.786 22.5004C141.608 22.2861 141.31 22.179 140.894 22.179C140.358 22.179 139.923 22.3694 139.59 22.7504C139.602 22.9527 139.608 23.2623 139.608 23.6789V28.5716H136.608V23.4111C136.608 22.9706 136.531 22.6551 136.376 22.4647C136.221 22.2742 135.947 22.179 135.555 22.179C134.947 22.179 134.424 22.5182 133.983 23.1968V28.5716H130.965V20.0004Z\" fill=\"#6C6C77\"></path></svg></div></div>\n                    <!-- /wp:outermost/icon-block --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"20%\"} -->\n                    <div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:20%\"><!-- wp:outermost/icon-block {\"iconName\":\"\",\"itemsJustification\":\"center\",\"width\":\"105px\",\"align\":\"center\"} -->\n                    <div class=\"wp-block-outermost-icon-block aligncenter items-justified-center\"><div class=\"icon-container\" style=\"width:105px\"><svg width=\"70\" height=\"44\" viewBox=\"0 0 70 44\" fill=\"none\" xmlns=\"https://www.w3.org/2000/svg\"><g clip-path=\"url(#clip0_3236_3431)\"><path d=\"M65.5256 5.40859C65.5256 5.45989 65.5256 5.52402 65.5125 5.5625C65.4469 6.06271 65.4469 6.56292 65.4862 7.07596C65.5125 7.20422 65.5387 7.33248 65.6437 7.43509C65.8142 7.62747 66.0765 7.589 66.1815 7.35813C66.234 7.2427 66.234 7.12726 66.2077 7.01183C66.0765 6.52444 66.0503 6.01141 66.0372 5.51119C66.0372 5.48554 66.0372 5.44706 66.0372 5.40859C66.1815 5.39576 66.3127 5.38293 66.4307 5.38293C66.5226 5.37011 66.6013 5.35728 66.6669 5.3188C66.8636 5.2162 66.8636 4.99816 66.6537 4.89555C66.575 4.85707 66.4701 4.84424 66.3783 4.84424C66.0503 4.85707 65.7224 4.85707 65.3944 4.85707C65.2764 4.85707 65.1583 4.8699 65.0402 4.88272C64.9746 4.89555 64.8959 4.89555 64.8435 4.93403C64.7516 4.9725 64.6992 5.03663 64.6992 5.12641C64.7123 5.2162 64.7516 5.2675 64.8435 5.30598C64.8959 5.34446 64.9615 5.35728 65.0271 5.35728C65.1845 5.37011 65.3551 5.39576 65.5256 5.40859ZM69.133 5.99858C69.133 6.01141 69.1461 6.02423 69.1461 6.02423C69.1986 6.37053 69.2511 6.70401 69.2904 7.03748C69.3036 7.15291 69.3167 7.25552 69.3954 7.3453C69.5659 7.56334 69.8283 7.53769 69.9463 7.30683C69.9988 7.19139 70.0119 7.07596 69.9857 6.9477C69.907 6.56292 69.8676 6.17814 69.7889 5.80619C69.7364 5.57532 69.6709 5.35728 69.6053 5.15207C69.5659 5.02381 69.4741 4.93402 69.3167 4.9212C69.1593 4.89555 69.0412 4.9725 68.9756 5.08794C68.8969 5.19054 68.8313 5.29315 68.7788 5.40859C68.687 5.6138 68.6083 5.81902 68.5034 6.01141C68.4902 6.06271 68.4771 6.10119 68.4509 6.13966C68.4378 6.11401 68.4247 6.10119 68.4247 6.10119C68.2541 5.78054 68.0967 5.45989 67.9262 5.15207C67.8999 5.12641 67.8868 5.10076 67.8737 5.07511C67.795 4.95968 67.7032 4.89555 67.5589 4.89555C67.4277 4.90837 67.3227 4.98533 67.2572 5.10076C67.2309 5.15207 67.2309 5.19054 67.2178 5.24185C67.1653 5.65228 67.0997 6.06271 67.0473 6.47314C67.021 6.70401 67.0079 6.93487 67.0079 7.16574C66.9948 7.21704 67.0079 7.28117 67.0341 7.33248C67.0604 7.43508 67.1391 7.49922 67.244 7.51204C67.3752 7.52487 67.467 7.48639 67.5064 7.38378C67.5457 7.30683 67.5589 7.2427 67.572 7.17857C67.6245 6.9477 67.6638 6.72966 67.7032 6.51162C67.7294 6.38336 67.7425 6.28075 67.7819 6.13966C67.8081 6.19097 67.8343 6.22945 67.8606 6.26792C67.9786 6.42184 68.0967 6.57575 68.241 6.70401C68.3853 6.80661 68.5034 6.79379 68.6214 6.67835C68.6477 6.6527 68.6608 6.63988 68.687 6.61422C68.8051 6.43466 68.9494 6.2551 69.0674 6.07553C69.0937 6.04988 69.1068 6.02423 69.133 5.99858Z\" fill=\"#6C6C77\"></path><path d=\"M38.9086 5.66047C38.8174 5.90422 38.8 6.07983 38.8421 6.22579C38.8886 6.42427 39.0093 6.48925 39.1731 6.43877C40.7139 6.06624 44.0926 7.12364 45.3435 7.41835C45.6385 7.48023 45.8785 7.10788 45.6772 6.77404C45.3834 6.45074 42.0062 5.06657 40.7176 4.9911C40.2125 4.96319 39.3095 4.83655 38.9086 5.66047Z\" fill=\"#6C6C77\"></path><path d=\"M52.1116 1.17977C52.2758 1.27244 52.3676 1.36084 52.4129 1.45961C52.4804 1.58917 52.4448 1.67881 52.3314 1.72455C51.3129 2.21057 49.9576 4.30298 49.4105 5.02463C49.2779 5.19064 48.972 5.09417 48.9258 4.82117C48.9353 4.51249 50.1367 2.24176 50.8072 1.62329C51.0707 1.38182 51.506 0.908026 52.1116 1.17977Z\" fill=\"#6C6C77\"></path><path d=\"M44.0017 0.149796C44.199 0.00441888 44.404 -0.0465256 44.5087 0.0479512C46.0454 1.3329 46.8603 3.36773 47.3649 5.23057C47.3839 5.27397 47.3851 5.33625 47.3699 5.40122C47.3636 5.45675 47.3221 5.51541 47.2562 5.5608C47.1858 5.61091 47.1252 5.62617 47.0967 5.58299C46.4232 4.68732 42.5765 1.20242 44.0017 0.149796Z\" fill=\"#6C6C77\"></path><path d=\"M11.461 22.4276C11.8293 22.1595 12.2297 21.9363 12.6534 21.7631C13.0967 21.6392 13.5692 21.6597 13.9995 21.8217C14.4297 21.9837 14.7944 22.2782 15.0382 22.6608C15.2563 23.0424 15.3416 23.483 15.2814 23.9162C15.2212 24.3493 15.0187 24.7516 14.7043 25.0625C14.4606 25.3145 14.1839 25.534 13.8816 25.7154C12.5342 26.5665 11.1748 27.3709 9.81547 28.222C9.53732 28.435 9.24225 28.6261 8.93308 28.7933C8.46281 29.0226 7.92537 29.084 7.41368 28.9669C6.902 28.8499 6.44826 28.5616 6.13092 28.1521C5.89369 27.8621 5.69348 27.545 5.53471 27.2077C4.24691 24.5612 2.91142 21.9263 1.67131 19.2331C1.09895 18.0673 0.633913 16.7265 0.180798 15.4324C-0.0152406 15.0564 -0.0535225 14.6205 0.0741037 14.2173C0.20173 13.8141 0.485195 13.4755 0.864201 13.2735C1.24321 13.0715 1.68785 13.0221 2.10357 13.1357C2.51929 13.2493 2.87329 13.517 3.09027 13.8818C3.75722 14.7484 4.34761 15.6689 4.85504 16.6333C6.14284 18.965 7.37103 21.2967 8.61113 23.5585C8.68334 23.6835 8.76296 23.8041 8.84961 23.9199C9.783 23.5362 10.6609 23.0345 11.461 22.4276Z\" fill=\"#6C6C77\"></path><path d=\"M24.7776 21.6142C21.8324 24.9835 16.8958 24.1324 14.4156 19.7954C12.6508 16.7175 12.3408 11.6343 16.1804 8.42819C17.0003 7.75696 17.9807 7.29971 19.0302 7.09909C20.317 6.91872 21.6292 7.14068 22.7792 7.73326C23.9292 8.32584 24.8582 9.2587 25.4335 10.3985C27.5321 14.1293 27.234 18.886 24.7776 21.6142ZM23.5852 13.7562C23.2723 12.8394 22.6446 12.0567 21.8085 11.541C21.3354 11.2113 20.7605 11.051 20.1807 11.0871C19.6008 11.1232 19.0514 11.3535 18.6248 11.7392C16.9197 13.2199 16.5619 16.7292 17.802 18.8161C17.9601 19.1564 18.1922 19.4588 18.4823 19.7022C18.7724 19.9456 19.1134 20.1241 19.4814 20.2251C19.8494 20.3262 20.2355 20.3474 20.6128 20.2873C20.9901 20.2271 21.3493 20.0871 21.6655 19.877C22.5898 19.1763 23.2679 18.2115 23.6055 17.1167C23.9432 16.0218 23.9236 14.8513 23.5495 13.7679L23.5852 13.7562Z\" fill=\"#6C6C77\"></path><path d=\"M36.7949 15.2251C36.4934 15.2885 36.1819 15.2923 35.8788 15.2362C35.5758 15.1801 35.2872 15.0654 35.0302 14.8987C34.8053 14.7729 34.6117 14.6 34.4633 14.3923C34.315 14.1846 34.2156 13.9474 34.1723 13.6976C34.1289 13.4479 34.1428 13.1919 34.2127 12.948C34.2827 12.7041 34.4072 12.4784 34.5771 12.2871C34.8731 11.9027 35.2933 11.6275 35.7695 11.506C37.0128 11.1532 38.2927 10.9381 39.5852 10.8648C39.8692 10.8325 40.1569 10.856 40.4314 10.9339C40.706 11.0119 40.9618 11.1426 41.184 11.3186C41.4061 11.4945 41.5901 11.7121 41.7251 11.9585C41.86 12.2049 41.9433 12.4752 41.97 12.7535C42.3426 14.1205 42.3834 15.5538 42.0892 16.939C41.0161 21.4159 37.3196 22.9548 33.17 21.5208C32.0052 21.1374 30.9839 20.423 30.2367 19.4689C29.2401 18.3199 28.5335 16.9582 28.1738 15.4933C27.8824 14.1888 27.9143 12.8352 28.267 11.5453C28.6196 10.2554 29.2827 9.06664 30.2009 8.07834C31.0723 7.00417 32.2033 6.1588 33.492 5.61835C34.3063 5.1795 35.2592 5.05472 36.163 5.26859C36.368 5.32407 36.5541 5.43217 36.702 5.58168C36.8499 5.7312 36.9542 5.91667 37.0041 6.11888C37.054 6.32108 37.0476 6.53265 36.9857 6.73165C36.9237 6.93064 36.8085 7.10981 36.6519 7.25057C36.3541 7.51412 36.0306 7.74842 35.686 7.95009C34.6259 8.61016 33.7034 9.46071 32.9673 10.4567C32.4848 11.1012 32.1525 11.8413 31.9939 12.6248C31.8352 13.4083 31.8541 14.2163 32.0492 14.992C32.3196 16.0496 32.9197 16.9989 33.7662 17.7084C36.3895 20.0402 39.7998 17.79 39.2036 14.6072C38.3332 14.8171 37.57 15.0386 36.7949 15.2251Z\" fill=\"#6C6C77\"></path><path d=\"M52.8235 21.8007C48.9482 24.1325 44.5363 21.8007 43.5704 16.9041C42.8669 13.4065 44.2024 8.50979 48.8767 6.6444C49.8712 6.25605 50.9499 6.1197 52.0127 6.248C53.2896 6.47655 54.461 7.09118 55.3616 8.00525C56.2622 8.91931 56.8468 10.0867 57.0327 11.3429C57.8197 15.505 56.0311 19.947 52.8235 21.8007ZM54.171 13.9544C54.1698 12.9859 53.8194 12.0487 53.1813 11.3079C52.8402 10.8497 52.3471 10.5214 51.7861 10.3789C51.225 10.2365 50.6309 10.2887 50.1048 10.5268C48.0062 11.4128 46.5276 14.6306 47.0642 16.9974C47.1052 17.3688 47.2286 17.727 47.4259 18.0469C47.6232 18.3668 47.8896 18.6407 48.2065 18.8495C48.5233 19.0582 48.883 19.1968 49.2603 19.2555C49.6377 19.3141 50.0236 19.2915 50.391 19.1892C51.5003 18.8103 52.4608 18.1022 53.1384 17.1637C53.8161 16.2252 54.1771 15.1032 54.171 13.9544Z\" fill=\"#6C6C77\"></path><path d=\"M60.9503 22.78C60.8918 23.2067 60.6624 23.5932 60.3124 23.8545C59.9624 24.1157 59.5206 24.2304 59.0842 24.1732C58.6478 24.116 58.2525 23.8916 57.9853 23.5494C57.718 23.2073 57.6008 22.7753 57.6593 22.3486C57.7178 21.9219 57.9473 21.5354 58.2972 21.2741C58.6472 21.0128 59.089 20.8982 59.5254 20.9554C59.9618 21.0126 60.3571 21.2369 60.6244 21.5791C60.8916 21.9213 61.0089 22.3533 60.9503 22.78ZM59.9129 7.0524C60.1397 6.71375 60.4724 6.45586 60.8614 6.31719C61.2503 6.17852 61.6747 6.1665 62.0712 6.28293C62.4743 6.38154 62.8304 6.61255 63.0801 6.93728C63.3297 7.26202 63.4576 7.66075 63.4425 8.06671C63.3899 8.71788 63.2903 9.36461 63.1444 10.002C62.7509 12.1589 62.3693 14.3157 61.952 16.4493C61.7612 17.3004 61.5108 18.1165 61.2365 18.9792C61.1411 19.2489 60.9817 19.4926 60.7715 19.6904C60.6408 19.8392 60.4739 19.9533 60.2861 20.0222C60.0983 20.0912 59.8958 20.1127 59.6973 20.0848C59.4988 20.0569 59.3106 19.9805 59.1503 19.8627C58.99 19.7448 58.8627 19.5893 58.7802 19.4106C58.6384 19.09 58.5614 18.7455 58.5536 18.3963C58.5536 16.9506 58.5536 15.4933 58.649 14.0359C58.8111 11.9561 59.1299 9.89081 59.6029 7.85685C59.6586 7.58435 59.7635 7.32376 59.9129 7.08738V7.0524Z\" fill=\"#6C6C77\"></path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M6.42117 32.1487C6.28038 32.456 6.24177 32.7986 6.31057 33.1283C6.35634 33.5629 6.45687 33.9904 6.60987 34.401C6.80089 34.9038 7.01464 35.401 7.2782 36.0138C7.33881 36.1548 7.40215 36.302 7.46843 36.4569C7.82385 37.2871 8.26981 38.3481 8.86466 39.8836C9.03303 40.3198 9.18254 40.7596 9.3331 41.2024C9.39392 41.3813 9.45496 41.5608 9.51744 41.7407C9.7414 42.3803 10.1268 42.9549 10.6376 43.4103C10.8545 43.6606 11.1422 43.843 11.4648 43.9342C11.7937 44.0272 12.1435 44.0213 12.4689 43.9173C12.7943 43.8132 13.0801 43.6158 13.2892 43.3507C13.4942 43.0908 13.6161 42.7776 13.6398 42.4504C13.7728 41.813 13.7274 41.1521 13.5082 40.5376C13.1603 39.5173 12.764 38.4955 12.307 37.4961L12.3049 37.4917C11.5531 35.9281 10.7889 34.3753 9.9885 32.8219L9.98251 32.811C9.74821 32.4063 9.44372 32.0445 9.08272 31.7419C8.84836 31.4718 8.52509 31.2896 8.16809 31.2268C7.80348 31.1627 7.42744 31.2273 7.1071 31.4092C6.80406 31.5784 6.56384 31.8373 6.42117 32.1487Z\" fill=\"#6C6C77\"></path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M17.9044 28.2986C16.7256 28.0001 15.4945 27.9566 14.2969 28.1712C13.3693 28.2605 12.457 28.4697 11.8235 28.8841C11.5013 29.095 11.2408 29.3658 11.0959 29.71C10.9502 30.0561 10.9316 30.4519 11.051 30.8929C11.269 31.7007 11.5521 32.4861 11.8342 33.269L11.8799 33.3958L11.881 33.3986C12.7304 35.673 13.5879 37.9397 14.4532 40.1986C14.5541 40.5546 14.6968 40.898 14.8784 41.2219L14.8818 41.2279C15.1217 41.6303 15.4294 41.9902 15.7919 42.2925C15.9732 42.4587 16.1974 42.5737 16.4405 42.6251C16.686 42.6769 16.9413 42.6619 17.1786 42.5815C17.416 42.5012 17.6262 42.3587 17.7864 42.1695C17.944 41.9834 18.0472 41.7592 18.0851 41.5206C18.2415 40.8724 18.1914 40.1929 17.9414 39.5733C17.8634 39.3648 17.8022 39.1517 17.7377 38.9274C17.7162 38.8526 17.6944 38.7765 17.6714 38.699C19.6521 37.942 21.7596 36.9241 22.5007 34.5561C22.7909 33.7378 22.8151 32.8517 22.5699 32.0193C22.3245 31.186 21.821 30.4474 21.1288 29.9052C20.1867 29.1462 19.0862 28.5978 17.9044 28.2986ZM14.6369 31.2031C14.6759 31.1921 14.7152 31.1819 14.7546 31.1724C16.0441 30.9742 17.3634 31.2383 18.4696 31.9159C18.9571 32.2474 19.1568 32.6157 19.1911 32.9701C19.2265 33.335 19.0908 33.7304 18.8182 34.1105C18.3031 34.8285 17.3631 35.4032 16.514 35.5103C15.895 34.1165 15.2664 32.6663 14.6369 31.2031Z\" fill=\"#6C6C77\"></path><path d=\"M25.7637 25.7473C27.1675 25.1134 28.9064 25.0039 30.2671 25.4496C30.6098 25.5472 30.9071 25.7583 31.1082 26.0468C31.308 26.3335 31.4002 26.679 31.3694 27.0244C31.3674 27.2486 31.3111 27.4692 31.2052 27.6682C31.0974 27.8708 30.9413 28.045 30.7501 28.1762C30.5589 28.3073 30.3382 28.3916 30.1067 28.4217C29.8751 28.4519 29.6396 28.4271 29.4199 28.3494L29.4032 28.3435L29.3875 28.3354C29.2751 28.2779 29.1557 28.2346 29.0322 28.2064L29.0244 28.2047C28.0672 27.9561 27.1643 28.368 26.8345 28.8741C26.6772 29.1154 26.6577 29.359 26.7887 29.5806C26.929 29.8179 27.2731 30.0842 27.9694 30.274C28.1609 30.3254 28.3572 30.375 28.5563 30.4254C29.1069 30.5648 29.6791 30.7096 30.2324 30.9103L30.2345 30.9111C32.7871 31.8607 33.7376 33.8274 33.4122 35.6772C33.0903 37.5065 31.5278 39.1713 29.1781 39.564C28.3231 39.7493 27.4333 39.7132 26.5968 39.4593C25.7582 39.2046 25.0023 38.7399 24.4042 38.1111L24.3886 38.0947C24.1998 37.8578 24.0728 37.5795 24.0165 37.2842C23.9647 37.0177 23.992 36.7423 24.095 36.4904C24.1974 36.24 24.3706 36.0233 24.5941 35.8654C24.8302 35.6864 25.1148 35.579 25.4127 35.5566C25.7096 35.5343 26.0067 35.5974 26.2674 35.738C26.5278 35.861 26.77 36.0179 26.9874 36.2045L26.9915 36.2079C27.3761 36.5518 27.8414 36.6414 28.2876 36.5584C28.7403 36.4742 29.166 36.2123 29.4398 35.8648C29.7118 35.5195 29.821 35.1093 29.6914 34.7111C29.561 34.31 29.1689 33.8606 28.3074 33.4849C28.0822 33.3914 27.8487 33.316 27.6058 33.2426C27.5403 33.2228 27.4737 33.2031 27.4063 33.1831C27.2267 33.1298 27.0419 33.0749 26.8607 33.0144C26.7359 32.9728 26.6121 32.9334 26.4895 32.8943C26.1544 32.7876 25.8277 32.6836 25.5133 32.5441C24.829 32.3163 24.2378 31.8789 23.8277 31.2966C23.4159 30.712 23.2087 30.0129 23.2369 29.3037C23.2391 27.5754 24.3524 26.3847 25.7637 25.7473Z\" fill=\"#6C6C77\"></path><path d=\"M43.5631 25.5634C43.2909 25.4334 42.9899 25.3717 42.6873 25.3838C42.3846 25.396 42.0898 25.4816 41.8295 25.6331C41.5708 25.7835 41.3542 25.9941 41.199 26.2462C41.0567 26.4585 40.9582 26.6959 40.9091 26.9452C40.86 27.1943 40.8612 27.4503 40.9125 27.6988C40.9632 28.0182 41.0194 28.3288 41.0749 28.6351C41.1668 29.142 41.2562 29.6375 41.3152 30.1427L41.3174 30.1555C41.4517 30.9478 41.522 31.7491 41.5283 32.5521L41.5289 32.5635C41.5748 33.4307 41.2726 34.281 40.6871 34.934L40.6778 34.9456C40.4873 35.1843 40.2326 35.3665 39.9421 35.4718C39.6517 35.5771 39.3371 35.6013 39.0334 35.5417C38.7297 35.4821 38.449 35.3411 38.2226 35.1344C37.9962 34.9277 37.8329 34.6627 37.7514 34.3706C37.5774 33.7549 37.4767 33.1216 37.4511 32.4834L37.7483 27.8571C37.7527 27.7967 37.7577 27.7347 37.7628 27.6721C37.7741 27.5316 37.7857 27.3885 37.7905 27.255C37.7975 27.0586 37.7915 26.8566 37.7447 26.6654C37.6968 26.47 37.6057 26.2841 37.4441 26.1258C37.2841 25.9691 37.0681 25.8535 36.7963 25.7748C36.3048 25.6357 35.8892 25.6401 35.5429 25.7838C35.1964 25.9275 34.959 26.1943 34.791 26.5025C34.6243 26.8081 34.5172 27.1699 34.4362 27.5323C34.3761 27.8012 34.3278 28.0835 34.2819 28.3522C34.266 28.4448 34.2505 28.5357 34.2348 28.624L34.2344 28.6266C33.9888 30.1002 33.9157 31.5964 34.0165 33.0862C34.0353 33.8913 34.207 34.686 34.523 35.4297C34.8795 36.3893 35.5252 37.2207 36.3749 37.8142C37.2264 38.4089 38.2425 38.7366 39.2887 38.7539C40.3349 38.7712 41.3618 38.4773 42.2334 37.9112C43.1036 37.3459 43.778 36.5357 44.1674 35.5878C44.7121 34.3803 44.9679 33.0671 44.9151 31.7483C44.8831 30.7855 44.8295 29.8153 44.7762 28.85C44.75 28.3765 44.7239 27.904 44.7005 27.4344C44.6887 26.9635 44.5299 26.5074 44.2453 26.1273C44.0692 25.887 43.8348 25.6932 43.5631 25.5634Z\" fill=\"#6C6C77\"></path><path d=\"M53.195 32.8172C53.1674 32.8515 53.1383 32.887 53.1079 32.9239C52.8865 31.6751 52.6813 30.4267 52.4758 29.1764C52.4021 28.7278 52.328 28.2773 52.2535 27.8281L52.2451 27.778L52.2179 27.7347C52.1666 27.6532 52.1615 27.5733 52.1615 27.4029V27.3832L52.1584 27.3637C52.1028 27.0118 51.94 26.6843 51.6913 26.4241C51.4433 26.1646 51.1212 25.984 50.7669 25.9056C50.4132 25.8203 50.0415 25.8391 49.6986 25.9597C49.3566 26.08 49.0585 26.2962 48.8415 26.5812C48.6611 26.7999 48.5132 27.0425 48.4024 27.3017C48.1509 27.8601 47.8972 28.4199 47.6428 28.9812L47.6384 28.9909C47.0033 30.3922 46.3639 31.8029 45.7431 33.2247L45.7412 33.2293C45.3601 34.1512 45.0455 35.1226 44.732 36.091C44.6694 36.2843 44.6068 36.4775 44.5437 36.6702C44.4305 36.9758 44.381 37.3004 44.398 37.6249C44.3774 37.9154 44.4485 38.2052 44.6019 38.4551C44.7583 38.7101 44.9926 38.9107 45.2717 39.0288C45.5675 39.1556 45.8982 39.1825 46.2115 39.1053C46.5241 39.0282 46.8017 38.8518 47.0006 38.6038C47.2546 38.2983 47.4731 37.9651 47.6513 37.6121C48.1772 36.5603 48.6798 35.4957 49.1801 34.4357C49.3737 34.0257 49.5618 33.6585 49.7758 33.2586C49.7905 33.3079 49.8055 33.356 49.821 33.4042C50.0453 34.3697 50.4239 35.2945 50.9428 36.1447C51.041 36.3248 51.1778 36.4822 51.3438 36.6061C51.5118 36.7315 51.7057 36.8195 51.912 36.8642C52.1183 36.9089 52.3321 36.9091 52.5385 36.8648C52.7446 36.8206 52.9391 36.7325 53.1072 36.6077L53.4399 36.3642L56.0222 34.2375L55.8695 35.189C55.6599 36.4969 55.4519 37.7939 55.2309 39.0912C55.0863 39.6662 55.0865 40.2668 55.2315 40.8416C55.2943 41.1651 55.4543 41.4629 55.6911 41.6971C55.9299 41.9332 56.2357 42.0936 56.5689 42.1576C56.9021 42.2215 57.2473 42.1861 57.5596 42.0558C57.8674 41.9275 58.1292 41.7129 58.3122 41.4394C58.738 40.9229 59.003 40.2976 59.0758 39.6379C59.1854 38.7063 59.3092 37.762 59.4331 36.818C59.5758 35.7299 59.7185 34.6421 59.839 33.5752L59.8394 33.5719C59.9554 32.404 60.0115 31.2313 60.0076 30.0579C60.033 29.6871 59.9386 29.3177 59.7374 29.002C59.5355 28.6852 59.2365 28.4389 58.8831 28.298C58.5155 28.1346 58.104 28.0909 57.7091 28.1735C57.3168 28.2555 56.9617 28.4577 56.6953 28.7506C56.219 29.1813 55.7722 29.6422 55.3577 30.1303L55.3549 30.1336C54.9024 30.6849 54.453 31.247 54.0065 31.8055C53.735 32.145 53.4643 32.4837 53.195 32.8172Z\" fill=\"#6C6C77\"></path></g><defs><clipPath id=\"clip0_3236_3431\"><rect width=\"70\" height=\"44\" fill=\"white\"></rect></clipPath></defs></svg></div></div>\n                    <!-- /wp:outermost/icon-block --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"20%\"} -->\n                    <div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:20%\"><!-- wp:outermost/icon-block {\"iconName\":\"\",\"itemsJustification\":\"center\",\"width\":\"175px\",\"align\":\"center\"} -->\n                    <div class=\"wp-block-outermost-icon-block aligncenter items-justified-center\"><div class=\"icon-container\" style=\"width:175px\"><svg width=\"140\" height=\"32\" viewBox=\"0 0 140 32\" fill=\"none\" xmlns=\"https://www.w3.org/2000/svg\"><g clip-path=\"url(#clip0_3236_3427)\"><path d=\"M136.315 6.13132L139.654 9.49344C139.771 9.58632 139.858 9.71168 139.902 9.85368C139.97 10.6812 139.344 10.7265 138.704 10.7727C138.427 10.7927 138.148 10.813 137.922 10.8968C136.798 11.2007 135.797 11.8426 135.052 12.7354C134.306 13.6282 133.854 14.7287 133.756 15.8874C133.684 16.0213 133.575 16.1314 133.442 16.2046C133.309 16.2779 133.158 16.311 133.006 16.3002C132.83 16.2846 132.665 16.2076 132.54 16.0826L131.444 14.979C131.452 15.0546 131.452 15.1294 131.452 15.1895V15.9174C131.452 15.9634 131.454 16.0078 131.448 16.052C131.441 16.1016 131.424 16.151 131.385 16.2026V16.2702C131.385 16.3046 131.389 16.3367 131.393 16.3693C131.401 16.4359 131.41 16.5046 131.385 16.6004C131.361 16.6898 131.358 16.794 131.355 16.887C131.354 16.9423 131.353 16.9937 131.347 17.0356C131.339 17.0938 131.339 17.1558 131.334 17.2178C131.33 17.2759 131.32 17.3339 131.294 17.3883C131.259 17.4645 131.247 17.5372 131.244 17.6111C131.242 17.6465 131.242 17.6821 131.242 17.7186L131.197 17.9512L129.494 26.0713L129.358 26.6791L129.306 27.5647L128.555 31.3996L128.435 32H67.6998L67.4071 31.7073L67.3546 31.9625H60.8555L57.2382 28.3227L57.5834 26.6791H55.5422L54.2739 25.3958C52.6999 26.542 50.7947 27.1428 48.848 27.107C46.7554 27.1893 44.7153 26.439 43.1745 25.0206L41.2007 23.0319L40.773 25.0281C40.7205 25.3133 40.6529 25.5835 40.5778 25.8462L40.5103 26.0938L40.3978 26.454C40.3885 26.4853 40.3759 26.5155 40.3602 26.5441C40.2485 26.875 40.1157 27.1983 39.9625 27.5122C39.9665 27.5243 39.9665 27.5375 39.9625 27.5497C39.9428 27.5913 39.9202 27.6314 39.8949 27.6698C39.7816 27.894 39.6564 28.1119 39.5197 28.3227C39.4943 28.361 39.4718 28.4012 39.4522 28.4428L39.3696 28.5328C39.1862 28.7959 38.9856 29.0466 38.7692 29.2833C38.7098 29.3426 38.6505 29.3984 38.5902 29.4531C38.5286 29.5091 38.466 29.5641 38.4014 29.621L38.2364 29.7786C38.1323 29.865 38.0258 29.9485 37.9171 30.0289C37.8274 30.0952 37.7362 30.1594 37.6435 30.2214C36.0969 31.1378 34.3128 31.5739 32.5178 31.4746C30.0413 31.4746 28.06 30.7542 26.8067 29.4934L23.2795 25.9437C21.8706 26.741 20.2754 27.1502 18.6566 27.1294C16.5703 27.194 14.5426 26.4336 13.0131 25.0131L11.0394 23.0244L10.4015 26.0938L10.2739 26.7017H3.63229L0 23.0394L0.187617 22.1538L4.18012 2.97934L4.30017 2.37898H10.9643L11.137 2.5441V2.37898H56.0375L56.2026 2.5441V2.37898H62.7017L66.3339 6.04126L66.1538 6.9193L65.9587 7.87992H67.8274L68.1201 8.17264C68.9423 7.69075 69.8762 7.43204 70.8293 7.42215C71.5301 7.40831 72.226 7.54142 72.8722 7.81286C73.5186 8.08432 74.1008 8.488 74.5816 8.99808L74.484 8.88552L76.2476 10.6642C77.3208 8.64544 79.7298 7.42215 83.0016 7.42215C85.5384 7.42215 87.4072 8.06752 88.54 9.23824L89.816 10.5216L90.244 8.45776L90.3712 7.85738H96.8776L98.7392 9.72608L99.0016 8.46528L99.1296 7.8649H111.933L112.278 8.21016C113.145 7.69845 114.138 7.43854 115.145 7.45966C115.75 7.43602 116.354 7.54692 116.912 7.78438C117.47 8.02184 117.968 8.38 118.371 8.83304C118.35 8.80944 118.33 8.78584 118.31 8.76264C118.274 8.7196 118.238 8.6776 118.2 8.63872L118.852 9.2908C119.42 8.70256 120.103 8.23672 120.858 7.92188C121.613 7.60702 122.424 7.44968 123.242 7.45966C123.676 7.43296 124.11 7.46992 124.53 7.56826L123.82 6.85178C123.723 6.74822 123.658 6.61937 123.631 6.48017C123.605 6.34097 123.618 6.19705 123.67 6.06518C123.722 5.93326 123.81 5.81874 123.924 5.73483C124.038 5.65092 124.174 5.60103 124.315 5.591H124.886C125.039 5.57634 125.192 5.55381 125.343 5.52344C126.141 5.35579 126.891 5.01299 127.54 4.51976C128.19 4.02658 128.721 3.39534 129.096 2.67167C129.129 2.6157 129.158 2.55812 129.186 2.49907V2.46156C129.444 1.90572 129.601 1.30865 129.651 0.697933C129.664 0.508162 129.75 0.330485 129.889 0.200949C130.028 0.0713663 130.211 -0.000455872 130.402 2.1775e-06H130.462C130.575 0.0108122 130.686 0.0475478 130.783 0.107369C130.881 0.167236 130.963 0.248586 131.025 0.345234C131.565 0.870568 134.566 3.92494 134.566 3.92494C134.817 4.1939 134.798 4.54308 134.779 4.89637C134.767 5.11482 134.755 5.33486 134.806 5.53846C134.943 5.56297 135.082 5.58152 135.219 5.59407C135.352 5.60602 135.485 5.61253 135.618 5.6135C135.773 5.61674 135.924 5.66832 136.049 5.76112C136.174 5.85388 136.267 5.98328 136.315 6.13132Z\" fill=\"#6C6C77\"></path><path d=\"M34.3474 8.60057H39.0904L36.4337 21.2009C35.946 23.5874 35.0153 24.9533 33.6045 25.9214C32.1774 26.7495 30.5388 27.1408 28.8916 27.0471C25.7546 27.0471 22.7452 25.7338 22.445 22.5442H27.218C27.3681 23.2947 28.0585 23.7225 29.1092 23.7225C30.5276 23.7225 31.1805 22.867 31.4732 21.5236L31.7583 20.1352H31.6533C31.2345 20.5956 30.7265 20.966 30.1601 21.224C29.5937 21.482 28.9809 21.6222 28.3587 21.6362C25.597 21.6362 23.4056 19.4373 23.4506 16.2178C23.5107 12.4654 25.9572 8.20281 30.0623 8.20281C30.8402 8.15041 31.6169 8.32185 32.3005 8.69689C32.9841 9.07185 33.5459 9.63481 33.9197 10.3191H34.0022L34.3474 8.60057ZM30.2724 18.1165C32.0961 18.1165 33.1092 16.0152 33.1392 14.2066C33.1392 12.9983 32.6664 11.76 31.2705 11.76C29.3643 11.76 28.3962 13.8838 28.3662 15.7074C28.3662 16.9382 28.839 18.1165 30.2349 18.1165M83.5185 18.5218C83.5185 19.3247 82.8273 19.6474 81.9193 19.6474C80.4185 19.6474 79.9159 18.897 79.9084 17.8463H75.188C75.1054 21.7638 78.6026 22.7318 81.7097 22.7318C85.6793 22.7318 88.2537 21.0133 88.3065 17.5837C88.3065 14.8444 85.9721 14.0114 83.6761 13.4786C81.9121 13.0734 81.1393 12.7807 81.1465 12.1127C81.1545 11.4448 81.9425 11.1746 82.7153 11.1746C83.6833 11.1746 84.3433 11.5198 84.4113 12.4054H88.9969C88.9441 9.13337 85.9945 8.17281 82.9929 8.17281C79.3456 8.17281 76.5013 9.83129 76.4562 12.9682C76.4562 15.4373 78.1223 16.3454 80.6361 16.9908C82.2497 17.4186 83.5329 17.5536 83.5185 18.5218ZM118.587 10.6343H118.505C118.301 9.89529 117.85 9.24833 117.227 8.80057C116.605 8.35289 115.848 8.13137 115.083 8.17281C113.042 8.17281 111.796 9.18593 110.618 10.7169H110.535L110.971 8.60057H106.197L103.338 22.2741H108.329L109.83 14.897C110.175 13.291 110.993 12.1653 112.231 12.1653C113.47 12.1653 113.635 13.1558 113.379 14.3642L111.728 22.2741H116.719L118.22 14.897C118.565 13.1859 119.383 12.1653 120.621 12.1653C121.859 12.1653 122.025 13.1034 121.77 14.3642L120.119 22.2741H125.109L126.895 14.1465C127.646 10.7169 126.498 8.14273 123.203 8.14273C122.287 8.13897 121.384 8.36505 120.578 8.80033C119.771 9.23561 119.087 9.86617 118.587 10.6343ZM0.914062 22.2741H6.06978L10.0548 3.09961H4.90656L0.914062 22.2741ZM16.4337 8.19529C19.9159 8.19529 23.2405 10.1014 23.188 14.4166C23.1429 19.1371 19.9309 22.6719 15.0229 22.6719C11.6457 22.6719 8.26869 20.7957 8.32869 16.503C8.41125 11.8951 11.5782 8.19529 16.4337 8.19529ZM15.1655 19.3247C17.3644 19.3247 18.1673 16.1352 18.1673 14.2591C18.1673 12.9158 17.7546 11.6024 16.3061 11.6024C14.1298 11.6024 13.3869 14.9795 13.3869 16.7206C13.3869 18.1165 13.7771 19.3247 15.1955 19.3247M11.7733 3.09961L11.0229 6.93451H54.3174L55.0679 3.09961H11.7733ZM46.5951 8.19529C50.0773 8.19529 53.4018 10.1014 53.3493 14.4166C53.3043 19.1371 50.0848 22.6719 45.1767 22.6719C41.7996 22.6719 38.4225 20.7957 38.4901 16.503C38.5951 11.8951 41.7621 8.19529 46.5951 8.19529ZM45.3493 19.3247C47.5482 19.3247 48.3512 16.1352 48.3512 14.2591C48.3512 12.9158 47.9309 11.6024 46.4825 11.6024C44.3137 11.6024 43.5632 14.9795 43.5632 16.7206C43.5632 18.1165 43.9534 19.3247 45.3793 19.3247M56.839 3.09961L56.0885 6.93451H61.0717L61.8221 3.09961H56.839ZM52.8465 22.2741H57.8371L60.6964 8.60057H55.6757L52.8465 22.2741ZM68.7714 22.7318C67.9772 22.7882 67.1829 22.6222 66.4776 22.2524C65.7724 21.8826 65.1841 21.3235 64.7789 20.6381H64.6964L63.1955 27.5574H58.1448L62.1973 8.60057H66.9403L66.5651 10.4242C67.0604 9.75057 67.702 9.19801 68.4416 8.80801C69.1812 8.41809 69.9996 8.20089 70.8353 8.17281C73.8371 8.17281 75.6007 10.7469 75.5482 14.094C75.4806 18.3041 73.2968 22.7318 68.7414 22.7318H68.7714ZM68.5763 12.0452C66.6477 12.0452 65.4619 14.5142 65.4319 16.413C65.4319 17.7338 65.8972 19.2046 67.4806 19.2046C69.5445 19.2046 70.3925 16.473 70.4149 14.6493C70.4149 13.411 70.0548 12.0452 68.5763 12.0452ZM97.4321 20.1203H97.5145L97.0793 22.2891H101.822L104.682 8.61553H99.6985L98.1073 16.2553C97.7849 17.8388 96.8089 18.6718 95.5785 18.6718C94.3473 18.6718 94.0769 17.5161 94.3249 16.3078L95.9385 8.61553H90.9553L89.1913 17.0583C88.4409 20.7356 90.1521 22.7169 93.0193 22.7169C93.9193 22.7081 94.8017 22.4621 95.5761 22.0035C96.3505 21.545 96.9913 20.8902 97.4321 20.1052V20.1203ZM124.201 27.625L124.951 23.79H65.7696L65.0191 27.625H124.201Z\" fill=\"white\"></path><path d=\"M129.569 12.3526C129.52 12.3488 129.472 12.3353 129.428 12.3128C129.383 12.2904 129.344 12.2595 129.312 12.2218C129.28 12.1841 129.256 12.1405 129.241 12.0934C129.225 12.0463 129.22 11.9967 129.224 11.9473C129.286 11.279 129.207 10.6049 128.991 9.9694C128.775 9.33388 128.427 8.75108 127.969 8.2594C127.513 7.76769 126.957 7.37807 126.339 7.11607C125.721 6.85408 125.054 6.72561 124.383 6.7391C124.284 6.7391 124.189 6.69957 124.118 6.6292C124.048 6.55883 124.008 6.46338 124.008 6.36386C124.008 6.26434 124.048 6.16891 124.118 6.09854C124.189 6.02817 124.284 5.98863 124.383 5.98863C124.563 6.00026 124.744 6.00026 124.924 5.98863C126.257 5.84662 127.498 5.24439 128.435 4.28557C129.373 3.32674 129.945 2.0713 130.057 0.735347C130.065 0.641121 130.107 0.553228 130.177 0.489226C130.246 0.425224 130.337 0.389835 130.432 0.390139C130.481 0.393927 130.529 0.407437 130.573 0.429886C130.617 0.452335 130.657 0.483281 130.689 0.520946C130.721 0.558611 130.745 0.602248 130.761 0.649349C130.776 0.69645 130.781 0.746079 130.777 0.795387C130.715 1.46312 130.794 2.13652 131.009 2.77154C131.225 3.40656 131.573 3.9889 132.029 4.4805C132.485 4.97209 133.04 5.36187 133.657 5.62434C134.274 5.88681 134.94 6.01606 135.61 6.00364C135.709 6.00364 135.805 6.04318 135.876 6.11355C135.946 6.18392 135.985 6.27936 135.985 6.37888C135.985 6.4784 135.946 6.57385 135.876 6.64421C135.805 6.71458 135.709 6.75411 135.61 6.75411C134.185 6.77766 132.817 7.32689 131.772 8.29644C130.726 9.26596 130.075 10.5875 129.945 12.0074C129.937 12.1016 129.894 12.1896 129.825 12.2536C129.755 12.3176 129.664 12.3529 129.569 12.3526Z\" fill=\"white\"></path></g><defs><clipPath id=\"clip0_3236_3427\"><rect width=\"140\" height=\"32\" fill=\"white\"></rect></clipPath></defs></svg></div></div>\n                    <!-- /wp:outermost/icon-block --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"20%\"} -->\n                    <div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:20%\"><!-- wp:outermost/icon-block {\"iconName\":\"\",\"itemsJustification\":\"center\",\"width\":\"180px\"} -->\n                    <div class=\"wp-block-outermost-icon-block items-justified-center\"><div class=\"icon-container\" style=\"width:180px\"><svg width=\"132\" height=\"35\" viewBox=\"0 0 132 35\" fill=\"none\" xmlns=\"https://www.w3.org/2000/svg\"><path d=\"M44.8293 25.2045C44.2345 25.2368 43.6462 25.0677 43.1593 24.7245C42.9559 24.5737 42.7922 24.3756 42.6824 24.1474C42.5726 23.9191 42.5201 23.6676 42.5293 23.4145V14.1445C42.5245 14.1053 42.5286 14.0654 42.5415 14.028C42.5543 13.9906 42.5755 13.9567 42.6035 13.9287C42.6315 13.9007 42.6654 13.8795 42.7028 13.8667C42.7402 13.8538 42.7801 13.8497 42.8193 13.8545H44.4993C44.6893 13.8545 44.7793 13.9545 44.7793 14.1445V22.6945C44.7793 23.0745 44.9493 23.2645 45.2993 23.2645C45.4477 23.2706 45.5961 23.2538 45.7393 23.2145C45.9393 23.2145 46.0493 23.2745 46.0593 23.4545L46.2093 24.7045C46.2165 24.741 46.2158 24.7785 46.2073 24.8147C46.1988 24.8508 46.1826 24.8848 46.1598 24.9141C46.1371 24.9435 46.1083 24.9677 46.0755 24.985C46.0426 25.0023 46.0064 25.0124 45.9693 25.0145C45.6013 25.1361 45.2168 25.2002 44.8293 25.2045Z\" fill=\"#6C6C77\"></path><path d=\"M54.2793 24.1347C53.4352 24.8322 52.3743 25.2137 51.2793 25.2137C50.1843 25.2137 49.1235 24.8322 48.2793 24.1347C47.5374 23.3857 47.1211 22.374 47.1211 21.3197C47.1211 20.2654 47.5374 19.2537 48.2793 18.5047C49.1251 17.8108 50.1853 17.4316 51.2793 17.4316C52.3733 17.4316 53.4335 17.8108 54.2793 18.5047C55.0042 19.2606 55.4089 20.2674 55.4089 21.3147C55.4089 22.362 55.0042 23.3688 54.2793 24.1247V24.1347ZM49.8593 22.8147C50.2511 23.1696 50.7607 23.3661 51.2893 23.3661C51.8179 23.3661 52.3276 23.1696 52.7193 22.8147C53.0739 22.4071 53.2691 21.885 53.2691 21.3447C53.2691 20.8045 53.0739 20.2824 52.7193 19.8747C52.3276 19.5199 51.8179 19.3233 51.2893 19.3233C50.7607 19.3233 50.2511 19.5199 49.8593 19.8747C49.5048 20.2824 49.3095 20.8045 49.3095 21.3447C49.3095 21.885 49.5048 22.4071 49.8593 22.8147Z\" fill=\"#6C6C77\"></path><path d=\"M64.6589 17.6846C64.8489 17.6846 64.9389 17.7846 64.9389 17.9746V25.1446C64.9564 25.6286 64.8658 26.1103 64.6738 26.5548C64.4818 26.9994 64.1932 27.3956 63.8289 27.7146C63.0203 28.4041 61.9805 28.7614 60.9189 28.7146C59.9601 28.7483 59.014 28.4865 58.2089 27.9646C57.8651 27.7389 57.5714 27.4448 57.3461 27.1008C57.1207 26.7567 56.9685 26.37 56.8989 25.9646C56.8989 25.7646 56.8989 25.6746 57.1689 25.6746H58.8489C58.9202 25.677 58.9894 25.7001 59.0479 25.7409C59.1065 25.7817 59.152 25.8385 59.1789 25.9046C59.2879 26.2083 59.5051 26.4612 59.7889 26.6146C60.1348 26.7931 60.5198 26.8825 60.9089 26.8746C61.1437 26.8875 61.3787 26.8534 61.6002 26.7744C61.8217 26.6955 62.0252 26.5731 62.1989 26.4146C62.3576 26.2488 62.481 26.0525 62.5618 25.8377C62.6426 25.6229 62.679 25.3939 62.6689 25.1646V24.5346C62.0674 24.977 61.3353 25.2058 60.5889 25.1846C60.0665 25.2036 59.5457 25.1169 59.0576 24.9296C58.5696 24.7422 58.1245 24.4583 57.7489 24.0946C57.028 23.3488 56.625 22.352 56.625 21.3146C56.625 20.2773 57.028 19.2805 57.7489 18.5346C58.1263 18.1742 58.572 17.893 59.0597 17.7075C59.5475 17.522 60.0674 17.436 60.5889 17.4546C61.3569 17.4343 62.1087 17.6779 62.7189 18.1446V17.9846C62.7143 17.9463 62.7183 17.9074 62.7306 17.8708C62.7429 17.8343 62.7632 17.8009 62.79 17.7731C62.8168 17.7453 62.8495 17.7239 62.8856 17.7103C62.9218 17.6967 62.9605 17.6914 62.9989 17.6946L64.6589 17.6846ZM60.7789 23.4046C61.0365 23.4126 61.2928 23.3639 61.5295 23.2619C61.7662 23.16 61.9777 23.0073 62.1489 22.8146C62.4814 22.3853 62.6618 21.8576 62.6618 21.3146C62.6618 20.7716 62.4814 20.244 62.1489 19.8146C61.9783 19.6246 61.7681 19.4741 61.5332 19.3739C61.2982 19.2737 61.0442 19.2262 60.7889 19.2346C60.5283 19.2264 60.2691 19.2749 60.0291 19.3768C59.7891 19.4787 59.5741 19.6315 59.3989 19.8246C59.0306 20.2353 58.8369 20.7734 58.8589 21.3246C58.8409 21.8704 59.0303 22.4028 59.3889 22.8146C59.5645 23.0072 59.7796 23.1597 60.0195 23.2615C60.2594 23.3633 60.5184 23.4121 60.7789 23.4046Z\" fill=\"#6C6C77\"></path><path d=\"M73.5719 24.1348C72.7261 24.8287 71.6659 25.2079 70.5719 25.2079C69.4779 25.2079 68.4177 24.8287 67.5719 24.1348C66.8464 23.3772 66.4414 22.3688 66.4414 21.3198C66.4414 20.2709 66.8464 19.2624 67.5719 18.5048C68.4185 17.8127 69.4784 17.4346 70.5719 17.4346C71.6654 17.4346 72.7253 17.8127 73.5719 18.5048C74.2968 19.2607 74.7015 20.2675 74.7015 21.3148C74.7015 22.3621 74.2968 23.3689 73.5719 24.1248V24.1348ZM69.1419 22.8148C69.3336 22.9972 69.5596 23.1397 69.8068 23.2341C70.054 23.3285 70.3174 23.373 70.5819 23.3648C70.8447 23.3716 71.1063 23.3266 71.3517 23.2322C71.5971 23.1378 71.8214 22.996 72.0119 22.8148C72.3607 22.4044 72.5522 21.8834 72.5522 21.3448C72.5522 20.8062 72.3607 20.2852 72.0119 19.8748C71.8214 19.6937 71.5971 19.5518 71.3517 19.4575C71.1063 19.3631 70.8447 19.318 70.5819 19.3248C70.3174 19.3167 70.054 19.3611 69.8068 19.4555C69.5596 19.5499 69.3336 19.6925 69.1419 19.8748C68.7932 20.2852 68.6017 20.8062 68.6017 21.3448C68.6017 21.8834 68.7932 22.4044 69.1419 22.8148Z\" fill=\"#6C6C77\"></path><path d=\"M78.309 15.9848C78.0447 16.2162 77.7053 16.3437 77.354 16.3437C77.0027 16.3437 76.6634 16.2162 76.399 15.9848C76.2792 15.8717 76.1837 15.7353 76.1184 15.584C76.0532 15.4327 76.0195 15.2696 76.0195 15.1048C76.0195 14.94 76.0532 14.777 76.1184 14.6256C76.1837 14.4743 76.2792 14.3379 76.399 14.2248C76.6661 13.9992 77.0044 13.8755 77.354 13.8755C77.7036 13.8755 78.0419 13.9992 78.309 14.2248C78.4289 14.3379 78.5244 14.4743 78.5896 14.6256C78.6549 14.777 78.6885 14.94 78.6885 15.1048C78.6885 15.2696 78.6549 15.4327 78.5896 15.584C78.5244 15.7353 78.4289 15.8717 78.309 15.9848ZM78.519 25.2048C77.9246 25.234 77.3373 25.0652 76.849 24.7248C76.6487 24.5718 76.4878 24.373 76.38 24.1451C76.2721 23.9172 76.2203 23.6668 76.229 23.4148V17.9748C76.2242 17.9356 76.2283 17.8957 76.2412 17.8583C76.254 17.8209 76.2752 17.787 76.3032 17.759C76.3312 17.731 76.3651 17.7098 76.4025 17.697C76.4399 17.6841 76.4798 17.68 76.519 17.6848H78.199C78.389 17.6848 78.479 17.7848 78.479 17.9748V22.6948C78.479 23.0748 78.649 23.2648 78.989 23.2648C79.1407 23.2703 79.2923 23.2534 79.439 23.2148C79.639 23.2148 79.749 23.2748 79.759 23.4548L79.909 24.7048C79.9162 24.7413 79.9155 24.7788 79.907 24.815C79.8985 24.8511 79.8823 24.8851 79.8595 24.9144C79.8368 24.9438 79.808 24.968 79.7752 24.9853C79.7423 25.0026 79.7061 25.0127 79.669 25.0148C79.2978 25.1371 78.9099 25.2012 78.519 25.2048Z\" fill=\"#6C6C77\"></path><path d=\"M86.0908 17.4447C86.6156 17.424 87.1391 17.5089 87.6304 17.6944C88.1217 17.88 88.5708 18.1623 88.9508 18.5247C89.658 19.2837 90.0512 20.2824 90.0512 21.3197C90.0512 22.357 89.658 23.3558 88.9508 24.1147C88.5726 24.4804 88.1241 24.7655 87.6325 24.9528C87.1409 25.1402 86.6165 25.2259 86.0908 25.2047C85.342 25.2214 84.6081 24.9932 84.0008 24.5547V28.1647C84.0008 28.3547 83.9008 28.4447 83.7108 28.4447H82.0308C81.9925 28.4519 81.953 28.4496 81.9157 28.4381C81.8785 28.4265 81.8446 28.4061 81.817 28.3785C81.7895 28.3509 81.769 28.3171 81.7575 28.2798C81.7459 28.2426 81.7437 28.2031 81.7508 28.1647V19.9647C81.7626 19.8845 81.7554 19.8027 81.73 19.7257C81.7045 19.6488 81.6613 19.5788 81.604 19.5215C81.5467 19.4642 81.4768 19.4211 81.3998 19.3956C81.3229 19.3701 81.241 19.363 81.1608 19.3747H80.8308C80.6108 19.3747 80.5008 19.2947 80.5008 19.1347V17.9547C80.4956 17.8817 80.5156 17.8091 80.5575 17.7491C80.5993 17.689 80.6605 17.6451 80.7308 17.6247C81.0767 17.499 81.4428 17.438 81.8108 17.4447C82.1778 17.4122 82.5461 17.4901 82.8686 17.6682C83.191 17.8464 83.453 18.1168 83.6208 18.4447C83.9429 18.1189 84.3281 17.8622 84.7528 17.6902C85.1775 17.5183 85.6328 17.4347 86.0908 17.4447ZM84.5308 22.8147C84.7091 23.0011 84.9233 23.1494 85.1605 23.2507C85.3977 23.352 85.6529 23.4042 85.9108 23.4042C86.1687 23.4042 86.424 23.352 86.6611 23.2507C86.8983 23.1494 87.1125 23.0011 87.2908 22.8147C87.6664 22.3958 87.8637 21.8469 87.8408 21.2847C87.867 20.7221 87.6692 20.1719 87.2908 19.7547C87.1125 19.5684 86.8983 19.4201 86.6611 19.3188C86.424 19.2174 86.1687 19.1652 85.9108 19.1652C85.6529 19.1652 85.3977 19.2174 85.1605 19.3188C84.9233 19.4201 84.7091 19.5684 84.5308 19.7547C84.167 20.1793 83.9776 20.726 84.0008 21.2847C83.9805 21.843 84.1696 22.3887 84.5308 22.8147Z\" fill=\"#6C6C77\"></path><path d=\"M94.7691 25.2046C93.8714 25.2415 92.9813 25.0268 92.1991 24.5846C91.8853 24.3956 91.6181 24.1383 91.4172 23.8319C91.2164 23.5255 91.0872 23.1778 91.0391 22.8146C91.0391 22.6146 91.1091 22.5146 91.3291 22.5146H92.7991C92.869 22.5174 92.9369 22.5393 92.9951 22.5782C93.0533 22.617 93.0997 22.6711 93.1291 22.7346C93.3391 23.2746 93.8891 23.5446 94.7691 23.5446C95.0761 23.5587 95.3817 23.4968 95.6591 23.3646C95.7549 23.3214 95.837 23.253 95.8969 23.1667C95.9568 23.0804 95.9921 22.9794 95.9991 22.8746C95.9991 22.6146 95.8391 22.4346 95.5191 22.3146C95.1396 22.1883 94.7472 22.1044 94.3491 22.0646C93.8776 22.0112 93.41 21.9277 92.9491 21.8146C92.5009 21.7132 92.0934 21.4798 91.7791 21.1446C91.594 20.9168 91.4578 20.6533 91.3788 20.3706C91.2999 20.0879 91.28 19.7919 91.3203 19.5012C91.3607 19.2104 91.4604 18.931 91.6133 18.6805C91.7662 18.4299 91.969 18.2135 92.2091 18.0446C92.9299 17.5855 93.7756 17.3618 94.6291 17.4046C95.4555 17.3767 96.2731 17.5811 96.9891 17.9946C97.2777 18.1581 97.5261 18.3838 97.7164 18.6554C97.9067 18.927 98.034 19.2376 98.0891 19.5646C98.0891 19.7646 97.9991 19.8646 97.8191 19.8646H96.3391C96.2768 19.8683 96.2148 19.8531 96.1613 19.821C96.1078 19.7889 96.0652 19.7413 96.0391 19.6846C95.9402 19.4478 95.754 19.258 95.5191 19.1546C95.2541 19.016 94.9581 18.9471 94.6591 18.9546C94.366 18.9387 94.0736 18.9972 93.8091 19.1246C93.7159 19.1606 93.6357 19.2236 93.5786 19.3056C93.5216 19.3876 93.4904 19.4848 93.4891 19.5846C93.4955 19.7214 93.5456 19.8525 93.632 19.9587C93.7184 20.0649 93.8365 20.1405 93.9691 20.1746C94.3531 20.3194 94.7524 20.42 95.1591 20.4746C95.6268 20.5362 96.0908 20.623 96.5491 20.7346C96.9973 20.8361 97.4048 21.0694 97.7191 21.4046C97.8873 21.5893 98.0171 21.8054 98.1012 22.0406C98.1853 22.2757 98.222 22.5252 98.2091 22.7746C98.2177 23.1203 98.1366 23.4623 97.9736 23.7673C97.8106 24.0722 97.5713 24.3297 97.2791 24.5146C96.532 24.9943 95.6565 25.2349 94.7691 25.2046Z\" fill=\"#6C6C77\"></path><path d=\"M108.781 24.7046C108.787 24.7401 108.785 24.7764 108.777 24.8113C108.768 24.8463 108.753 24.8791 108.731 24.908C108.71 24.9369 108.683 24.9612 108.652 24.9795C108.621 24.9978 108.587 25.0097 108.551 25.0146C108.186 25.1338 107.805 25.1979 107.421 25.2046C107.041 25.244 106.657 25.1846 106.307 25.0322C105.956 24.8798 105.651 24.6395 105.421 24.3346C104.715 24.9419 103.801 25.2535 102.871 25.2046C102.439 25.2245 102.008 25.1538 101.605 24.9971C101.202 24.8404 100.836 24.6011 100.531 24.2946C100.228 23.9735 99.9928 23.5945 99.8398 23.1804C99.6869 22.7663 99.6192 22.3256 99.6406 21.8846V17.9746C99.6406 17.7846 99.7306 17.6846 99.9206 17.6846H101.601C101.791 17.6846 101.881 17.7846 101.881 17.9746V21.5846C101.863 22.0344 102.016 22.4742 102.311 22.8146C102.458 22.9706 102.637 23.0932 102.835 23.1743C103.033 23.2554 103.247 23.293 103.461 23.2846C103.68 23.2942 103.899 23.2603 104.105 23.1847C104.311 23.1092 104.5 22.9936 104.661 22.8446C104.813 22.6876 104.932 22.501 105.009 22.2963C105.087 22.0916 105.121 21.8732 105.111 21.6546V17.9746C105.111 17.7846 105.201 17.6846 105.391 17.6846H107.091C107.281 17.6846 107.371 17.7846 107.371 17.9746V22.6846C107.371 23.0746 107.541 23.2646 107.871 23.2646C108.026 23.2706 108.181 23.2538 108.331 23.2146C108.369 23.204 108.409 23.2021 108.447 23.2091C108.486 23.216 108.522 23.2316 108.554 23.2547C108.586 23.2778 108.612 23.3078 108.631 23.3424C108.649 23.377 108.659 23.4154 108.661 23.4546L108.781 24.7046Z\" fill=\"#6C6C77\"></path><path d=\"M124.669 24.7048C124.678 24.7406 124.679 24.778 124.672 24.8142C124.664 24.8503 124.649 24.8845 124.627 24.9141C124.605 24.9437 124.577 24.9681 124.544 24.9855C124.512 25.003 124.476 25.013 124.439 25.0148C124.067 25.1357 123.68 25.1998 123.289 25.2048C122.694 25.2355 122.107 25.0666 121.619 24.7248C121.408 24.5784 121.237 24.3823 121.12 24.1538C121.003 23.9253 120.944 23.6714 120.949 23.4148V21.0648C120.97 20.6164 120.82 20.1767 120.529 19.8348C120.389 19.6785 120.215 19.5553 120.022 19.474C119.828 19.3928 119.619 19.3555 119.409 19.3648C119.22 19.3577 119.032 19.3936 118.858 19.4698C118.685 19.546 118.532 19.6606 118.409 19.8048C118.145 20.1399 118.01 20.5587 118.029 20.9848V24.6748C118.029 24.8648 117.939 24.9648 117.749 24.9648H116.059C116.02 24.9697 115.98 24.9655 115.943 24.9527C115.905 24.9398 115.871 24.9186 115.843 24.8906C115.815 24.8627 115.794 24.8287 115.781 24.7913C115.768 24.7539 115.764 24.7141 115.769 24.6748V21.0648C115.791 20.6213 115.652 20.1847 115.379 19.8348C115.257 19.6878 115.104 19.5695 114.931 19.4883C114.759 19.4071 114.57 19.3649 114.379 19.3648C114.175 19.3566 113.972 19.3915 113.782 19.4674C113.592 19.5432 113.421 19.6582 113.279 19.8048C112.993 20.1292 112.846 20.553 112.869 20.9848V24.6748C112.874 24.7141 112.87 24.7539 112.857 24.7913C112.844 24.8287 112.823 24.8627 112.795 24.8906C112.767 24.9186 112.733 24.9398 112.696 24.9527C112.658 24.9655 112.618 24.9697 112.579 24.9648H110.949C110.759 24.9648 110.669 24.8648 110.669 24.6748V19.9648C110.681 19.8846 110.674 19.8028 110.648 19.7258C110.623 19.6489 110.58 19.5789 110.522 19.5216C110.465 19.4643 110.395 19.4212 110.318 19.3957C110.241 19.3702 110.159 19.3631 110.079 19.3748H109.749C109.529 19.3748 109.419 19.2948 109.419 19.1348V17.9548C109.414 17.8818 109.434 17.8092 109.476 17.7492C109.518 17.6891 109.579 17.6452 109.649 17.6248C109.995 17.4991 110.361 17.4381 110.729 17.4448C111.082 17.4147 111.437 17.4851 111.752 17.6479C112.067 17.8107 112.329 18.0592 112.509 18.3648C112.846 18.0451 113.246 17.7983 113.683 17.64C114.12 17.4817 114.585 17.4153 115.049 17.4448C115.5 17.4228 115.949 17.5073 116.361 17.6915C116.773 17.8757 117.135 18.1543 117.419 18.5048C117.75 18.1451 118.157 17.8635 118.61 17.6801C119.063 17.4968 119.551 17.4165 120.039 17.4448C120.475 17.4244 120.911 17.4947 121.319 17.6514C121.727 17.808 122.098 18.0475 122.409 18.3548C122.713 18.6753 122.948 19.0542 123.101 19.4685C123.254 19.8827 123.322 20.3238 123.299 20.7648V22.6948C123.299 23.0748 123.469 23.2648 123.789 23.2648C123.944 23.272 124.099 23.2552 124.249 23.2148C124.456 23.2148 124.566 23.2948 124.579 23.4548L124.669 24.7048Z\" fill=\"#6C6C77\"></path><path d=\"M7.41 16.3847C8.14777 13.4194 9.85643 10.7861 12.2639 8.90424C14.6714 7.02234 17.6393 6 20.695 6C23.7507 6 26.7186 7.02234 29.1261 8.90424C31.5336 10.7861 33.2422 13.4194 33.98 16.3847H32.78C30.7557 16.3549 28.7729 16.9599 27.11 18.1147C27.014 18.1842 26.9138 18.2477 26.81 18.3047H26.67C26.5662 18.2477 26.466 18.1842 26.37 18.1147C24.6924 16.9866 22.7166 16.3841 20.695 16.3841C18.6734 16.3841 16.6976 16.9866 15.02 18.1147C14.924 18.1842 14.8238 18.2477 14.72 18.3047H14.58C14.4762 18.2477 14.376 18.1842 14.28 18.1147C12.6171 16.9599 10.6343 16.3549 8.61 16.3847H7.41ZM30.62 22.6547C31.236 22.175 31.9995 21.924 32.78 21.9447H34.39V18.7347H32.78C31.4052 18.7181 30.0619 19.146 28.95 19.9547C28.3243 20.416 27.5674 20.6649 26.79 20.6649C26.0126 20.6649 25.2557 20.416 24.63 19.9547C23.4899 19.1611 22.1341 18.7356 20.745 18.7356C19.3559 18.7356 18.0001 19.1611 16.86 19.9547C16.2343 20.416 15.4774 20.6649 14.7 20.6649C13.9226 20.6649 13.1657 20.416 12.54 19.9547C11.4144 19.1356 10.0518 18.7072 8.66 18.7347H7V21.9447H8.61C9.39051 21.924 10.154 22.175 10.77 22.6547C11.908 23.4489 13.2623 23.8747 14.65 23.8747C16.0377 23.8747 17.392 23.4489 18.53 22.6547C19.1468 22.1765 19.9097 21.9257 20.69 21.9447C21.4708 21.9223 22.2348 22.1735 22.85 22.6547C23.9901 23.4484 25.3459 23.8738 26.735 23.8738C28.1241 23.8738 29.4799 23.4484 30.62 22.6547ZM30.62 28.3947C31.236 27.915 31.9995 27.664 32.78 27.6847H34.39V24.4747H32.78C31.4052 24.4581 30.0619 24.886 28.95 25.6947C28.3243 26.156 27.5674 26.4049 26.79 26.4049C26.0126 26.4049 25.2557 26.156 24.63 25.6947C23.4899 24.9011 22.1341 24.4757 20.745 24.4757C19.3559 24.4757 18.0001 24.9011 16.86 25.6947C16.2343 26.156 15.4774 26.4049 14.7 26.4049C13.9226 26.4049 13.1657 26.156 12.54 25.6947C11.4144 24.8757 10.0518 24.4472 8.66 24.4747H7V27.6847H8.61C9.39051 27.664 10.154 27.915 10.77 28.3947C11.908 29.1889 13.2623 29.6147 14.65 29.6147C16.0377 29.6147 17.392 29.1889 18.53 28.3947C19.1468 27.9165 19.9097 27.6657 20.69 27.6847C21.4708 27.6623 22.2348 27.9135 22.85 28.3947C23.9901 29.1884 25.3459 29.6138 26.735 29.6138C28.1241 29.6138 29.4799 29.1884 30.62 28.3947Z\" fill=\"#6C6C77\"></path></svg></div></div>\n                    <!-- /wp:outermost/icon-block --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"20%\"} -->\n                    <div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:20%\"><!-- wp:outermost/icon-block {\"iconName\":\"\",\"itemsJustification\":\"center\",\"width\":\"180px\"} -->\n                    <div class=\"wp-block-outermost-icon-block items-justified-center\"><div class=\"icon-container\" style=\"width:180px\"><svg width=\"164\" height=\"30\" viewBox=\"0 0 164 30\" fill=\"none\" xmlns=\"https://www.w3.org/2000/svg\"><g clip-path=\"url(#clip0_3236_3412)\"><path d=\"M91.7656 22.143H95.2629V8.95158H91.7656V22.143ZM91.7656 6.89447H95.2629V3.75732H91.7656V6.89447Z\" fill=\"#6C6C77\"></path><path d=\"M97.5156 26.4628H101.013V20.6513H101.064C101.809 21.7828 103.018 22.5285 104.869 22.5285C108.264 22.5285 110.578 19.8285 110.578 15.5599C110.578 11.4456 108.341 8.59131 104.844 8.59131C103.044 8.59131 101.809 9.43993 100.961 10.597H100.884V8.95131H97.5156V26.4628ZM104.124 19.6228C102.041 19.6228 100.936 18.0542 100.936 15.6628C100.936 13.297 101.809 11.4199 103.996 11.4199C106.156 11.4199 107.029 13.1685 107.029 15.6628C107.029 18.157 105.898 19.6228 104.124 19.6228Z\" fill=\"#6C6C77\"></path><path d=\"M117.554 22.5285C120.846 22.5285 123.108 20.9342 123.108 18.2856C123.108 15.1999 120.666 14.5828 118.454 14.1199C116.577 13.7342 114.828 13.6313 114.828 12.4999C114.828 11.5485 115.728 11.0342 117.091 11.0342C118.583 11.0342 119.483 11.5485 119.637 12.9628H122.799C122.543 10.3142 120.614 8.59131 117.143 8.59131C114.134 8.59131 111.768 9.95421 111.768 12.8085C111.768 15.6885 114.083 16.3313 116.448 16.7942C118.248 17.1542 119.919 17.2828 119.919 18.5428C119.919 19.4685 119.046 20.0599 117.503 20.0599C115.934 20.0599 114.854 19.3913 114.623 17.8742H111.383C111.588 20.677 113.723 22.5285 117.554 22.5285Z\" fill=\"#6C6C77\"></path><path d=\"M136.389 22.1426V8.95117H132.891V16.5626C132.891 18.3112 131.889 19.5454 130.243 19.5454C128.751 19.5454 128.058 18.6969 128.058 17.1541V8.95117H124.586V17.7454C124.586 20.6254 126.231 22.5026 129.163 22.5026C131.015 22.5026 132.043 21.8083 132.943 20.5998H133.02V22.1426H136.389Z\" fill=\"#6C6C77\"></path><path d=\"M138.648 22.1428H142.146V14.4799C142.146 12.7313 143.097 11.5999 144.512 11.5999C145.797 11.5999 146.543 12.3713 146.543 13.8628V22.1428H150.04V14.4799C150.04 12.7313 150.94 11.5999 152.406 11.5999C153.692 11.5999 154.437 12.3713 154.437 13.8628V22.1428H157.935V13.2713C157.935 10.3913 156.366 8.59131 153.588 8.59131C151.917 8.59131 150.528 9.46558 149.628 10.9056H149.577C148.935 9.51703 147.597 8.59131 145.926 8.59131C144.1 8.59131 142.815 9.51703 142.095 10.7256H142.017V8.95131H138.648V22.1428Z\" fill=\"#6C6C77\"></path><path d=\"M0.617188 22.143H4.11433V3.75732H0.617188V22.143Z\" fill=\"#6C6C77\"></path><path d=\"M12.6649 22.5285C16.7535 22.5285 19.5563 19.4942 19.5563 15.5599C19.5563 11.6256 16.7535 8.59131 12.6649 8.59131C8.57628 8.59131 5.77344 11.6256 5.77344 15.5599C5.77344 19.4942 8.57628 22.5285 12.6649 22.5285ZM12.6649 19.8542C10.5049 19.8542 9.322 18.1313 9.322 15.5599C9.322 12.9885 10.5049 11.2399 12.6649 11.2399C14.7992 11.2399 16.0077 12.9885 16.0077 15.5599C16.0077 18.1313 14.7992 19.8542 12.6649 19.8542Z\" fill=\"#6C6C77\"></path><path d=\"M26.9933 26.6428C28.9476 26.6428 30.6448 26.1799 31.7504 25.1513C32.7276 24.2513 33.3191 22.9913 33.3191 21.1399V8.95131H29.9505V10.3399H29.8991C29.1019 9.23421 27.8933 8.59131 26.2476 8.59131C22.9048 8.59131 20.5391 11.1113 20.5391 15.0456C20.5391 19.0313 23.4191 21.3456 26.3505 21.3456C28.0219 21.3456 29.0248 20.677 29.7962 19.8028H29.8733V21.2428C29.8733 23.0428 28.9219 23.9942 26.9419 23.9942C25.3219 23.9942 24.5762 23.3513 24.2933 22.5285H20.8219C21.1819 25.0999 23.3933 26.6428 26.9933 26.6428ZM26.9419 18.5428C25.1419 18.5428 23.9591 17.2313 23.9591 14.9942C23.9591 12.7828 25.1419 11.3942 26.9162 11.3942C29.0248 11.3942 30.0533 13.0399 30.0533 14.9685C30.0533 16.9228 29.1533 18.5428 26.9419 18.5428Z\" fill=\"#6C6C77\"></path><path d=\"M41.8211 22.5285C45.9097 22.5285 48.7126 19.4942 48.7126 15.5599C48.7126 11.6256 45.9097 8.59131 41.8211 8.59131C37.7326 8.59131 34.9297 11.6256 34.9297 15.5599C34.9297 19.4942 37.7326 22.5285 41.8211 22.5285ZM41.8211 19.8542C39.6611 19.8542 38.4783 18.1313 38.4783 15.5599C38.4783 12.9885 39.6611 11.2399 41.8211 11.2399C43.9554 11.2399 45.164 12.9885 45.164 15.5599C45.164 18.1313 43.9554 19.8542 41.8211 19.8542Z\" fill=\"#6C6C77\"></path><path d=\"M159.207 6.78578C159.207 6.19405 159.687 5.71436 160.279 5.71436H162.422C163.013 5.71436 163.493 6.19405 163.493 6.78578C163.493 7.37752 163.013 7.85722 162.422 7.85722H160.279C159.687 7.85722 159.207 7.37752 159.207 6.78578Z\" fill=\"#6C6C77\"></path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M69.9219 0C78.2058 0 84.9221 6.71573 84.9221 15C84.9221 23.2843 78.2058 30 69.9219 30C61.6376 30 54.9219 23.2843 54.9219 15C54.9219 6.71573 61.6376 0 69.9219 0ZM69.3797 1.12244C67.6684 1.36327 66.039 2.73831 64.7741 5.03805C64.4072 5.70512 64.0761 6.4421 63.7877 7.23783C65.5076 6.80563 67.3969 6.55082 69.3797 6.5114V1.12244ZM62.5199 7.5981C62.8787 6.47219 63.3175 5.4363 63.824 4.51549C64.451 3.37544 65.1951 2.39096 66.0336 1.63483C61.4744 2.95892 57.8808 6.55259 56.5567 11.1118C57.3128 10.2733 58.2972 9.5292 59.4373 8.9022C60.3582 8.39573 61.394 7.95683 62.5199 7.5981ZM62.1597 8.86583C61.7274 10.5857 61.4727 12.475 61.4332 14.4578H56.0442C56.2851 12.7465 57.6601 11.1171 59.9599 9.8523C60.627 9.4854 61.3639 9.15435 62.1597 8.86583ZM62.5178 14.4578C62.5626 12.294 62.8741 10.2626 63.3895 8.46765C65.1844 7.95225 67.2159 7.6407 69.3797 7.59593V9.9381C68.5725 12.0047 66.9261 13.6509 64.8594 14.4578H62.5178ZM61.4332 15.5422H56.0442C56.2851 17.2535 57.6601 18.8828 59.9599 20.1477C60.627 20.5146 61.3639 20.8456 62.1597 21.1342C61.7274 19.4143 61.4727 17.525 61.4332 15.5422ZM63.3895 21.5324C62.8741 19.7374 62.5626 17.706 62.5178 15.5422H64.8594C66.9261 16.3491 68.5725 17.9953 69.3797 20.0619V22.4041C67.2159 22.3593 65.1844 22.0478 63.3895 21.5324ZM62.5199 22.4019C61.394 22.0432 60.3582 21.6043 59.4373 21.0978C58.2972 20.4708 57.3128 19.7267 56.5567 18.8882C57.8808 23.4474 61.4744 27.0411 66.0336 28.3652C65.1951 27.609 64.451 26.6246 63.824 25.4845C63.3175 24.5637 62.8787 23.5278 62.5199 22.4019ZM69.3797 28.8775C67.6684 28.6367 66.039 27.2617 64.7741 24.962C64.4072 24.2949 64.0761 23.5579 63.7877 22.7622C65.5076 23.1943 67.3969 23.4492 69.3797 23.4886V28.8775ZM73.8101 28.3652C74.6485 27.609 75.3926 26.6246 76.0196 25.4845C76.5259 24.5637 76.9654 23.5278 77.3239 22.4019C78.4496 22.0432 79.4854 21.6043 80.4064 21.0978C81.5464 20.4708 82.5311 19.7267 83.2871 18.8882C81.9626 23.4474 78.3694 27.0411 73.8101 28.3652ZM76.0563 22.7622C75.7676 23.5579 75.4361 24.2949 75.0694 24.962C73.8047 27.2617 72.1753 28.6367 70.464 28.8775V23.4886C72.4468 23.4492 74.3361 23.1943 76.0563 22.7622ZM77.6839 21.1342C78.4796 20.8456 79.2169 20.5146 79.8836 20.1477C82.1839 18.8829 83.5586 17.2535 83.7994 15.5422H78.4106C78.3708 17.525 78.1159 19.4143 77.6839 21.1342ZM77.3261 15.5422C77.2811 17.706 76.9698 19.7374 76.4538 21.5324C74.6592 22.0478 72.6278 22.3593 70.464 22.4041V20.0636C71.271 17.9963 72.9178 16.3493 74.9849 15.5422H77.3261ZM78.4106 14.4578H83.7994C83.5586 12.7465 82.1839 11.1171 79.8836 9.8523C79.2169 9.4854 78.4796 9.15435 77.6839 8.86583C78.1159 10.5857 78.3708 12.475 78.4106 14.4578ZM76.4538 8.46765C76.9698 10.2626 77.2811 12.294 77.3261 14.4578H74.985C72.9178 13.6507 71.271 12.0037 70.464 9.93637V7.59593C72.6278 7.6407 74.6592 7.95225 76.4538 8.46765ZM77.3239 7.5981C78.4496 7.95683 79.4854 8.39573 80.4064 8.9022C81.5464 9.5292 82.5311 10.2733 83.2871 11.1118C81.9626 6.55259 78.3694 2.95892 73.8101 1.63483C74.6485 2.39096 75.3926 3.37544 76.0196 4.51549C76.5259 5.4363 76.9654 6.47219 77.3239 7.5981ZM70.464 1.12244C72.1753 1.36327 73.8047 2.73831 75.0694 5.03805C75.4361 5.70513 75.7676 6.4421 76.0563 7.23783C74.3361 6.80563 72.4468 6.55082 70.464 6.5114V1.12244Z\" fill=\"#6C6C77\"></path></g><defs><clipPath id=\"clip0_3236_3412\"><rect width=\"163.5\" height=\"30\" fill=\"white\"></rect></clipPath></defs></svg></div></div>\n                    <!-- /wp:outermost/icon-block --></div>\n                    <!-- /wp:column --></div>\n                    <!-- /wp:columns --></div>\n                    <!-- /wp:group -->\n\n                    <!-- wp:spacer -->\n                    <div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer --></div>\n                    <!-- /wp:group -->\n\n                    <!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\n                    <div id=\"team\" class=\"wp-block-group\"><!-- wp:group {\"layout\":{\"type\":\"default\"}} -->\n                    <div class=\"wp-block-group\"><!-- wp:spacer {\"height\":\"74px\"} -->\n                    <div style=\"height:74px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:paragraph {\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|secondary\"}}}},\"textColor\":\"secondary\"} -->\n                    <p class=\"has-secondary-color has-text-color has-link-color\">MEET US</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:heading -->\n                    <h2 class=\"wp-block-heading\">Our Team</h2>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:spacer {\"height\":\"27px\"} -->\n                    <div style=\"height:27px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:spacer {\"height\":\"0px\"} -->\n                    <div style=\"height:0px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:columns -->\n                    <div class=\"wp-block-columns\"><!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"}},\"border\":{\"width\":\"0px\",\"style\":\"none\"}},\"className\":\"is-style-default\"} -->\n                    <div class=\"wp-block-column is-style-default\" style=\"border-style:none;border-width:0px;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:image {\"id\":7403,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"is-style-default\"} -->\n                    <figure class=\"wp-block-image size-full is-style-default\"><img src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/team1.jpg\" alt=\"\" class=\"wp-image-7403\"/></figure>\n                    <!-- /wp:image -->\n\n                    <!-- wp:heading {\"level\":3} -->\n                    <h3 class=\"wp-block-heading\">Cynthia Howery</h3>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:paragraph {\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|tertiary\"}}}},\"textColor\":\"tertiary\"} -->\n                    <p class=\"has-tertiary-color has-text-color has-link-color\">Co-founder / CEO</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:paragraph -->\n                    <p>This is some dummy copy. You’re not really supposed to read this dummy copy, it is just a place holder for people who need some type.</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:social-links {\"iconColor\":\"primary\",\"iconColorValue\":\"currentColor\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|x-small\",\"left\":\"var:preset|spacing|x-small\"}}},\"className\":\"is-style-logos-only\",\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\"}} -->\n                    <ul class=\"wp-block-social-links has-icon-color is-style-logos-only\"><!-- wp:social-link {\"url\":\"#\",\"service\":\"instagram\"} /-->\n\n                    <!-- wp:social-link {\"url\":\"#\",\"service\":\"linkedin\"} /--></ul>\n                    <!-- /wp:social-links --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"}},\"border\":{\"width\":\"0px\",\"style\":\"none\"}},\"className\":\"is-style-default\"} -->\n                    <div class=\"wp-block-column is-style-default\" style=\"border-style:none;border-width:0px;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:image {\"id\":7404,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n                    <figure class=\"wp-block-image size-full\"><img src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/team2.jpg\" alt=\"\" class=\"wp-image-7404\"/></figure>\n                    <!-- /wp:image -->\n\n                    <!-- wp:heading {\"level\":3} -->\n                    <h3 class=\"wp-block-heading\">Jimmy Banh</h3>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:paragraph {\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|tertiary\"}}}},\"textColor\":\"tertiary\"} -->\n                    <p class=\"has-tertiary-color has-text-color has-link-color\">LEAD DESIGNER</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:paragraph -->\n                    <p>This is some dummy copy. You’re not really supposed to read this dummy copy, it is just a place holder for people who need some type.</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:social-links {\"iconColor\":\"primary\",\"iconColorValue\":\"currentColor\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|x-small\",\"left\":\"var:preset|spacing|x-small\"}}},\"className\":\"is-style-logos-only\"} -->\n                    <ul class=\"wp-block-social-links has-icon-color is-style-logos-only\"><!-- wp:social-link {\"url\":\"#\",\"service\":\"linkedin\"} /-->\n\n                    <!-- wp:social-link {\"url\":\"#\",\"service\":\"x\"} /--></ul>\n                    <!-- /wp:social-links --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"}},\"border\":{\"width\":\"0px\",\"style\":\"none\"}},\"className\":\"is-style-default\"} -->\n                    <div class=\"wp-block-column is-style-default\" style=\"border-style:none;border-width:0px;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:image {\"id\":7405,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n                    <figure class=\"wp-block-image size-full\"><img src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/team3.jpg\" alt=\"\" class=\"wp-image-7405\"/></figure>\n                    <!-- /wp:image -->\n\n                    <!-- wp:heading {\"level\":3} -->\n                    <h3 class=\"wp-block-heading\">Leo Palmieri</h3>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:paragraph {\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|tertiary\"}}}},\"textColor\":\"tertiary\"} -->\n                    <p class=\"has-tertiary-color has-text-color has-link-color\">CFO</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:paragraph -->\n                    <p>This is some dummy copy. You’re not really supposed to read this dummy copy, it is just a place holder for people who need some type.</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:social-links {\"iconColor\":\"primary\",\"iconColorValue\":\"currentColor\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|x-small\",\"left\":\"var:preset|spacing|x-small\"}}},\"className\":\"is-style-logos-only\"} -->\n                    <ul class=\"wp-block-social-links has-icon-color is-style-logos-only\"><!-- wp:social-link {\"url\":\"#\",\"service\":\"instagram\"} /-->\n\n                    <!-- wp:social-link {\"url\":\"#\",\"service\":\"linkedin\"} /--></ul>\n                    <!-- /wp:social-links --></div>\n                    <!-- /wp:column --></div>\n                    <!-- /wp:columns -->\n\n                    <!-- wp:spacer {\"height\":\"63px\"} -->\n                    <div style=\"height:63px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n                    <div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"border\":{\"radius\":\"0px\"}},\"className\":\"is-style-outline\"} -->\n                    <div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\" href=\"#\" style=\"border-radius:0px\">VIEW ALL</a></div>\n                    <!-- /wp:button --></div>\n                    <!-- /wp:buttons -->\n\n                    <!-- wp:spacer {\"height\":\"81px\"} -->\n                    <div style=\"height:81px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer --></div>\n                    <!-- /wp:group --></div>\n                    <!-- /wp:group -->\n\n                    <!-- wp:cover {\"url\":\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/StockSnap_89BQZ89TLH.jpg\",\"id\":24,\"hasParallax\":true,\"dimRatio\":40,\"overlayColor\":\"black\",\"minHeightUnit\":\"px\",\"contentPosition\":\"center center\",\"align\":\"full\",\"style\":{\"border\":{\"radius\":\"0px\"}},\"className\":\"is-position-center-center\"} -->\n                    <div class=\"wp-block-cover alignfull has-parallax is-position-center-center\" style=\"border-radius:0px\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-black-background-color has-background-dim-40 has-background-dim\"></span><div role=\"img\" class=\"wp-block-cover__image-background wp-image-24 has-parallax\" style=\"background-position:50% 50%;background-image:url(http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/StockSnap_89BQZ89TLH.jpg)\"></div><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\n                    <div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"color\":{\"text\":\"#fffffa\"},\"typography\":{\"textTransform\":\"uppercase\"}},\"fontSize\":\"medium\"} -->\n                    <h3 class=\"wp-block-heading has-text-align-center has-text-color has-medium-font-size\" style=\"color:#fffffa;text-transform:uppercase\">Unleash your creativity with Inspiro</h3>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:paragraph {\"align\":\"center\",\"textColor\":\"white\"} -->\n                    <p class=\"has-text-align-center has-white-color has-text-color\">This is some dummy copy. You’re not really supposed to read this dummy copy, it is just a placeholder for people who need some type to visualize what the actual copy might look like if it were real content.</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:spacer {\"height\":\"31px\"} -->\n                    <div style=\"height:31px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\",\"orientation\":\"horizontal\"}} -->\n                    <div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"white\",\"style\":{\"border\":{\"radius\":\"0px\"}},\"className\":\"is-style-outline\"} -->\n                    <div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-white-color has-text-color wp-element-button\" href=\"#\" style=\"border-radius:0px\">CONTACT US</a></div>\n                    <!-- /wp:button --></div>\n                    <!-- /wp:buttons --></div>\n                    <!-- /wp:group --></div></div>\n                    <!-- /wp:cover -->\n\n                    <!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\n                    <div id=\"news\" class=\"wp-block-group\"><!-- wp:spacer {\"height\":\"108px\"} -->\n                    <div style=\"height:108px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:paragraph {\"align\":\"left\",\"textColor\":\"secondary\"} -->\n                    <p class=\"has-text-align-left has-secondary-color has-text-color\">FROM THE BLOG</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:heading {\"textAlign\":\"left\",\"className\":\"wp-block-heading\"} -->\n                    <h2 class=\"wp-block-heading has-text-align-left\">Latest News</h2>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:spacer {\"height\":\"33px\"} -->\n                    <div style=\"height:33px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:query {\"queryId\":4,\"query\":{\"perPage\":\"3\",\"pages\":0,\"offset\":0,\"postType\":\"post\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false}} -->\n                    <div class=\"wp-block-query\"><!-- wp:post-template {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|small\"}},\"layout\":{\"type\":\"grid\",\"columnCount\":3}} -->\n                    <!-- wp:post-featured-image {\"isLink\":true,\"width\":\"100%\",\"height\":\"240px\",\"style\":{\"border\":{\"radius\":\"5px\"},\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|x-small\"}}}} /-->\n\n                    <!-- wp:post-date {\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|tertiary\"}}},\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"textColor\":\"tertiary\"} /-->\n\n                    <!-- wp:post-title {\"level\":3,\"isLink\":true,\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|foreground\"}}},\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"var:preset|spacing|x-small\"}}}} /-->\n\n                    <!-- wp:post-excerpt {\"excerptLength\":38,\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|tertiary\"}}}},\"textColor\":\"tertiary\"} /-->\n\n                    <!-- wp:read-more {\"style\":{\"border\":{\"width\":\"2px\"},\"spacing\":{\"padding\":{\"right\":\"var:preset|spacing|x-small\",\"left\":\"var:preset|spacing|x-small\",\"top\":\"10px\",\"bottom\":\"10px\"}},\"typography\":{\"textTransform\":\"uppercase\"}},\"textColor\":\"foreground\"} /-->\n                    <!-- /wp:post-template -->\n\n                    <!-- wp:query-no-results -->\n                    <!-- wp:paragraph {\"placeholder\":\"Add text or blocks that will display when a query returns no results.\"} -->\n                    <p></p>\n                    <!-- /wp:paragraph -->\n                    <!-- /wp:query-no-results --></div>\n                    <!-- /wp:query -->\n\n                    <!-- wp:spacer {\"height\":\"85px\"} -->\n                    <div style=\"height:85px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer --></div>\n                    <!-- /wp:group -->", "Homepage", "", "draft", "closed", "closed", "", "__trashed-4", "", "", "2024-10-08 09:28:52", "2024-10-08 07:28:52", "", "0", "http://portfolio-theo-valadoux.test/?page_id=42", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("43", "1", "2024-10-08 09:25:10", "2024-10-08 07:25:10", "<!-- wp:heading {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"100\"}},\"fontSize\":\"large\"} -->\n<h2 class=\"wp-block-heading has-large-font-size\" id=\"inspiro-is-a-digital-product-agency-that-focuses-on-strategy-and-design\" style=\"font-style:normal;font-weight:100\"><strong>Inspiro is a digital product agency that focuses on strategy and design.</strong></h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":62,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://portfolio-theo-valadoux.test/wp-content/uploads/2024/10/Capture-decran-2023-10-03-210725-1024x686.png\" alt=\"\" class=\"wp-image-62\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"textColor\":\"black\",\"fontSize\":\"medium\"} -->\n<p class=\"has-black-color has-text-color has-medium-font-size\"><a href=\"#\">HTML/CSS</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#7a7a7a\"}}} -->\n<p class=\"has-text-color\" style=\"color:#7a7a7a\">This is some dummy copy. You’re not really supposed to read this dummy copy, it is just a place holder for people who need some type to visualize what the actual copy might look like if it were real content.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/video-2.jpeg\" alt=\"\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"textColor\":\"black\",\"fontSize\":\"medium\"} -->\n<p class=\"has-black-color has-text-color has-medium-font-size\"><a href=\"#\">Our Philosophy</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#7a7a7a\"}}} -->\n<p class=\"has-text-color\" style=\"color:#7a7a7a\">This is some dummy copy. You’re not really supposed to read this dummy copy, it is just a place holder for people who need some type to visualize what the actual copy might look like if it were real content.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/video-3.jpeg\" alt=\"\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"textColor\":\"black\",\"fontSize\":\"medium\"} -->\n<p class=\"has-black-color has-text-color has-medium-font-size\"><a href=\"#\">Services</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#7a7a7a\"}}} -->\n<p class=\"has-text-color\" style=\"color:#7a7a7a\">This is some dummy copy. You’re not really supposed to read this dummy copy, it is just a place holder for people who need some type to visualize what the actual copy might look like if it were real content.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontWeight\":\"300\"}},\"fontSize\":\"large\"} -->\n<h3 class=\"wp-block-heading has-large-font-size\" id=\"inspiro-is-a-digital-product-agency-that-focuses-on-strategy-and-desig\" style=\"font-weight:300\">Showreel</h3>\n<!-- /wp:heading -->\n\n<!-- wp:embed {\"url\":\"https://videopress.com/v/bjvmxiQS\",\"type\":\"video\",\"providerNameSlug\":\"videopress\",\"responsive\":true,\"align\":\"wide\",\"className\":\"wp-embed-aspect-16-9 wp-has-aspect-ratio\"} -->\n<figure class=\"wp-block-embed alignwide is-type-video is-provider-videopress wp-block-embed-videopress wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\nhttps://videopress.com/v/bjvmxiQS\n</div></figure>\n<!-- /wp:embed -->\n\n<!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:cover {\"overlayColor\":\"black\",\"minHeight\":316,\"minHeightUnit\":\"px\",\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"50px\",\"right\":\"50px\",\"bottom\":\"50px\",\"left\":\"50px\"}}}} -->\n<div class=\"wp-block-cover alignfull\" style=\"padding-top:50px;padding-right:50px;padding-bottom:50px;padding-left:50px;min-height:316px\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-black-background-color has-background-dim-100 has-background-dim\"></span><div class=\"wp-block-cover__inner-container\"><!-- wp:columns {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-columns are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"20px\",\"right\":\"0px\",\"bottom\":\"20px\",\"left\":\"0px\"}}}} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"padding-top:20px;padding-right:0px;padding-bottom:20px;padding-left:0px\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0px\"}},\"layout\":{\"type\":\"flex\",\"allowOrientation\":false,\"justifyContent\":\"space-between\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:image {\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/laurel_left.png\" alt=\"\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:group -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"center\",\"style\":{\"typography\":{\"lineHeight\":\"1\",\"fontSize\":\"18px\"}},\"textColor\":\"white\"} -->\n<p class=\"has-text-align-center has-white-color has-text-color\" style=\"font-size:18px;line-height:1\"><strong>\"Best Film\"<br></strong>Winner</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:image {\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/laurel_right.png\" alt=\"\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"20px\",\"right\":\"0px\",\"bottom\":\"20px\",\"left\":\"0px\"}}}} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"padding-top:20px;padding-right:0px;padding-bottom:20px;padding-left:0px\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0px\"}},\"layout\":{\"type\":\"flex\",\"allowOrientation\":false,\"justifyContent\":\"space-between\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:image {\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/laurel_left.png\" alt=\"\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:group -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"center\",\"style\":{\"typography\":{\"lineHeight\":\"1\",\"fontSize\":\"18px\"}},\"textColor\":\"white\"} -->\n<p class=\"has-text-align-center has-white-color has-text-color\" style=\"font-size:18px;line-height:1\"><strong>\"New Film Festival\"</strong><br>Winner</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:image {\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/laurel_right.png\" alt=\"\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"20px\",\"right\":\"0px\",\"bottom\":\"20px\",\"left\":\"0px\"}}}} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"padding-top:20px;padding-right:0px;padding-bottom:20px;padding-left:0px\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0px\"}},\"layout\":{\"type\":\"flex\",\"allowOrientation\":false,\"justifyContent\":\"space-between\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:image {\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/laurel_left.png\" alt=\"\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:group -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"center\",\"style\":{\"typography\":{\"lineHeight\":\"1\",\"fontSize\":\"18px\"}},\"textColor\":\"white\"} -->\n<p class=\"has-text-align-center has-white-color has-text-color\" style=\"font-size:18px;line-height:1\"><strong>\"Best Short\"</strong><br>Winner</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:image {\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/laurel_right.png\" alt=\"\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:cover -->", "About", "", "draft", "closed", "closed", "", "__trashed", "", "", "2024-10-08 10:27:43", "2024-10-08 08:27:43", "", "0", "http://portfolio-theo-valadoux.test/?page_id=43", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("44", "1", "2024-10-08 09:25:15", "2024-10-08 07:25:15", "\n                    <!-- wp:spacer {\"height\":\"156px\"} -->\n                    <div style=\"height:156px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\n                    <div class=\"wp-block-group\"><!-- wp:columns {\"verticalAlignment\":\"top\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"}}}} -->\n                    <div class=\"wp-block-columns are-vertically-aligned-top\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"50%\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"7%\"}}},\"layout\":{\"type\":\"default\"}} -->\n                    <div class=\"wp-block-column is-vertically-aligned-top\" style=\"padding-right:7%;flex-basis:50%\"><!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#0bb4aa\"}}} -->\n                    <p class=\"has-text-color\" style=\"color:#0bb4aa\">Let\'s Connect!</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:heading {\"fontSize\":\"large\"} -->\n                    <h2 class=\"wp-block-heading has-large-font-size\">Ready to start your next project?</h2>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:paragraph -->\n                    <p>This is some dummy copy. You’re not really supposed to read this dummy copy, it is just a place holder for people who <a href=\"#\">need some type</a> to visualize what the actual copy might look like if it were real content.<br></p>\n                    <!-- /wp:paragraph --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"50%\",\"layout\":{\"type\":\"default\"}} -->\n                    <div class=\"wp-block-column is-vertically-aligned-top\" style=\"flex-basis:50%\"><!-- wp:wpzoom-forms/form-block {\"formId\":\"21\"} /--></div>\n                    <!-- /wp:column --></div>\n                    <!-- /wp:columns -->\n\n                    <!-- wp:spacer {\"height\":\"135px\"} -->\n                    <div style=\"height:135px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer --></div>\n                    <!-- /wp:group -->\n\n                    <!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"blockGap\":\"0\"}},\"layout\":{\"type\":\"constrained\"}} -->\n                    <div class=\"wp-block-group alignfull\"><!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"},\"blockGap\":{\"top\":\"0\",\"left\":\"var:preset|spacing|x-small\"}}},\"backgroundColor\":\"light-background\"} -->\n                    <div class=\"wp-block-columns alignfull are-vertically-aligned-center has-light-background-background-color has-background\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"50%\",\"className\":\"map-grayscale\",\"layout\":{\"type\":\"default\"}} -->\n                    <div class=\"wp-block-column is-vertically-aligned-center map-grayscale\" style=\"flex-basis:50%\"><!-- wp:image {\"id\":7500,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n                    <figure class=\"wp-block-image size-large\"><img src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/map2.png\" alt=\"\" class=\"wp-image-7500\"/></figure>\n                    <!-- /wp:image --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"50%\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|small\",\"bottom\":\"var:preset|spacing|small\",\"right\":\"var:preset|spacing|small\",\"left\":\"2%\"}}},\"layout\":{\"type\":\"default\"}} -->\n                    <div class=\"wp-block-column is-vertically-aligned-center\" style=\"padding-top:var(--wp--preset--spacing--small);padding-right:var(--wp--preset--spacing--small);padding-bottom:var(--wp--preset--spacing--small);padding-left:2%;flex-basis:50%\"><!-- wp:heading {\"level\":3,\"fontSize\":\"large\"} -->\n                    <h3 class=\"wp-block-heading has-large-font-size\">Inspiro</h3>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:paragraph -->\n                    <p></p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:heading {\"level\":3} -->\n                    <h3 class=\"wp-block-heading\"><strong>Address</strong></h3>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:paragraph -->\n                    <p>1500 Broadway, New York, NY 10036, United States</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:heading {\"level\":3} -->\n                    <h3 class=\"wp-block-heading\"><strong>Email</strong></h3>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:paragraph -->\n                    <p>office@example.com</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:heading {\"level\":3} -->\n                    <h3 class=\"wp-block-heading\"><strong>Phone</strong></h3>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:paragraph -->\n                    <p>509-394-2555</p>\n                    <!-- /wp:paragraph --></div>\n                    <!-- /wp:column --></div>\n                    <!-- /wp:columns --></div>\n                    <!-- /wp:group -->\n\n                    <!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#f9f9f9\"}},\"layout\":{\"type\":\"constrained\"}} -->\n                    <div class=\"wp-block-group alignfull has-background\" style=\"background-color:#f9f9f9\"><!-- wp:group {\"layout\":{\"type\":\"default\"}} -->\n                    <div class=\"wp-block-group\"><!-- wp:spacer {\"height\":\"69px\"} -->\n                    <div style=\"height:69px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:columns -->\n                    <div class=\"wp-block-columns\"><!-- wp:column -->\n                    <div class=\"wp-block-column\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"color\":{\"text\":\"#0bb4aa\"}}} -->\n                    <p class=\"has-text-align-left has-text-color\" style=\"color:#0bb4aa\">WHERE ARE WE LOCATED</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:heading {\"textAlign\":\"left\",\"fontSize\":\"large\"} -->\n                    <h2 class=\"wp-block-heading has-text-align-left has-large-font-size\">Our Locations</h2>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:columns -->\n                    <div class=\"wp-block-columns\"><!-- wp:column -->\n                    <div class=\"wp-block-column\"><!-- wp:paragraph {\"style\":{\"typography\":{\"lineHeight\":\"2.5\"}}} -->\n                    <p style=\"line-height:2.5\">Amsterdam<br>Munich<br>Brussels<br>Hong Kong<br>Barcelona</p>\n                    <!-- /wp:paragraph --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column -->\n                    <div class=\"wp-block-column\"><!-- wp:paragraph {\"style\":{\"typography\":{\"lineHeight\":\"2.5\"}}} -->\n                    <p style=\"line-height:2.5\">New York<br>Paris<br>San Francisco<br>Sydney<br>Tokyo</p>\n                    <!-- /wp:paragraph --></div>\n                    <!-- /wp:column --></div>\n                    <!-- /wp:columns --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column -->\n                    <div class=\"wp-block-column\"><!-- wp:image {\"id\":5640,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n                    <figure class=\"wp-block-image size-large\"><img src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/map.png\" alt=\"\" class=\"wp-image-5640\"/></figure>\n                    <!-- /wp:image --></div>\n                    <!-- /wp:column --></div>\n                    <!-- /wp:columns -->\n\n                    <!-- wp:spacer {\"height\":\"52px\"} -->\n                    <div style=\"height:52px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer --></div>\n                    <!-- /wp:group --></div>\n                    <!-- /wp:group -->\n\n                    <!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\n                    <div class=\"wp-block-group\"><!-- wp:spacer {\"height\":\"33px\"} -->\n                    <div style=\"height:33px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:columns {\"verticalAlignment\":\"center\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|60\",\"left\":\"0\",\"bottom\":\"var:preset|spacing|60\"}}}} -->\n                    <div class=\"wp-block-columns are-vertically-aligned-center\" style=\"padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60);padding-left:0\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"66.66%\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\"}} -->\n                    <div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:66.66%\"><!-- wp:heading -->\n                    <h2 class=\"wp-block-heading\">Thinking about joining our team?</h2>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:paragraph -->\n                    <p>Check out our open positions, or drop us a line, say hi.</p>\n                    <!-- /wp:paragraph --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"33.33%\"} -->\n                    <div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:33.33%\"><!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"right\"}} -->\n                    <div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"border\":{\"radius\":\"0px\"},\"typography\":{\"textTransform\":\"uppercase\",\"fontStyle\":\"normal\",\"fontWeight\":\"600\",\"fontSize\":\"14px\",\"letterSpacing\":\"1px\"}},\"className\":\"is-style-fill\"} -->\n                    <div class=\"wp-block-button has-custom-font-size is-style-fill\" style=\"font-size:14px;font-style:normal;font-weight:600;letter-spacing:1px;text-transform:uppercase\"><a class=\"wp-block-button__link wp-element-button\" style=\"border-radius:0px\">View Job Openings</a></div>\n                    <!-- /wp:button --></div>\n                    <!-- /wp:buttons --></div>\n                    <!-- /wp:column --></div>\n                    <!-- /wp:columns -->\n\n                    <!-- wp:spacer {\"height\":\"45px\"} -->\n                    <div style=\"height:45px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer --></div>\n                    <!-- /wp:group -->\n                ", "Contact", "", "draft", "closed", "closed", "", "__trashed-3", "", "", "2024-10-08 09:28:49", "2024-10-08 07:28:49", "", "0", "http://portfolio-theo-valadoux.test/?page_id=44", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("45", "1", "2024-10-08 09:25:13", "2024-10-08 07:25:13", "", "Blog", "", "draft", "closed", "closed", "", "__trashed-2", "", "", "2024-10-08 09:27:59", "2024-10-08 07:27:59", "", "0", "http://portfolio-theo-valadoux.test/?page_id=45", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("46", "1", "2024-10-08 08:55:24", "0000-00-00 00:00:00", "{\n    \"widget_search[2]\": {\n        \"value\": {\n            \"encoded_serialized_instance\": \"YToxOntzOjU6InRpdGxlIjtzOjEwOiJSZWNoZXJjaGVyIjt9\",\n            \"title\": \"Rechercher\",\n            \"is_widget_customizer_js_value\": true,\n            \"instance_hash_key\": \"1b4b4405351f73b797d4afa3e985e059\",\n            \"raw_instance\": {\n                \"title\": \"Rechercher\"\n            }\n        },\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2024-10-08 06:55:24\"\n    },\n    \"widget_text[2]\": {\n        \"value\": {\n            \"encoded_serialized_instance\": \"YTo0OntzOjU6InRpdGxlIjtzOjIwOiLDgCBwcm9wb3MgZGUgY2Ugc2l0ZSI7czo0OiJ0ZXh0IjtzOjk5OiJD4oCZZXN0IHBldXQtw6p0cmUgbGUgYm9uIGVuZHJvaXQgcG91ciB2b3VzIHByw6lzZW50ZXIgZXQgdm90cmUgc2l0ZSBvdSBpbnPDqXJlciBxdWVscXVlcyBjcsOpZGl0cy4iO3M6NjoiZmlsdGVyIjtiOjE7czo2OiJ2aXN1YWwiO2I6MTt9\",\n            \"title\": \"\\u00c0 propos de ce site\",\n            \"is_widget_customizer_js_value\": true,\n            \"instance_hash_key\": \"eb578722b43fb4a4ae224135cd00bcfe\",\n            \"raw_instance\": {\n                \"title\": \"\\u00c0 propos de ce site\",\n                \"text\": \"C\\u2019est peut-\\u00eatre le bon endroit pour vous pr\\u00e9senter et votre site ou ins\\u00e9rer quelques cr\\u00e9dits.\",\n                \"filter\": true,\n                \"visual\": true\n            }\n        },\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2024-10-08 06:55:24\"\n    },\n    \"widget_text[3]\": {\n        \"value\": {\n            \"encoded_serialized_instance\": \"YTo0OntzOjU6InRpdGxlIjtzOjE0OiJSZXRyb3V2ZXotbm91cyI7czo0OiJ0ZXh0IjtzOjE4NToiPHN0cm9uZz5BZHJlc3NlPC9zdHJvbmc+CkF2ZW51ZSBkZXMgQ2hhbXBzLcOJbHlzw6llcwo3NTAwOCwgUGFyaXMKCjxzdHJvbmc+SGV1cmVzIGTigJlvdXZlcnR1cmU8L3N0cm9uZz4KRHUgbHVuZGkgYXUgdmVuZHJlZGnCoDogOWgwMOKAlDE3aDAwCkxlcyBzYW1lZGkgZXQgZGltYW5jaGXCoDogMTFoMDAmbmRhc2g7MTVoMDAiO3M6NjoiZmlsdGVyIjtiOjE7czo2OiJ2aXN1YWwiO2I6MTt9\",\n            \"title\": \"Retrouvez-nous\",\n            \"is_widget_customizer_js_value\": true,\n            \"instance_hash_key\": \"e75befa492729dcecd682012d33c8c5a\",\n            \"raw_instance\": {\n                \"title\": \"Retrouvez-nous\",\n                \"text\": \"<strong>Adresse</strong>\\nAvenue des Champs-\\u00c9lys\\u00e9es\\n75008, Paris\\n\\n<strong>Heures d\\u2019ouverture</strong>\\nDu lundi au vendredi\\u00a0: 9h00\\u201417h00\\nLes samedi et dimanche\\u00a0: 11h00&ndash;15h00\",\n                \"filter\": true,\n                \"visual\": true\n            }\n        },\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2024-10-08 06:55:24\"\n    },\n    \"sidebars_widgets[sidebar]\": {\n        \"starter_content\": true,\n        \"value\": [\n            \"search-2\",\n            \"text-2\",\n            \"text-3\"\n        ],\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2024-10-08 06:53:30\"\n    },\n    \"widget_text[4]\": {\n        \"value\": {\n            \"encoded_serialized_instance\": \"YTo0OntzOjU6InRpdGxlIjtzOjE0OiJSZXRyb3V2ZXotbm91cyI7czo0OiJ0ZXh0IjtzOjE4NToiPHN0cm9uZz5BZHJlc3NlPC9zdHJvbmc+CkF2ZW51ZSBkZXMgQ2hhbXBzLcOJbHlzw6llcwo3NTAwOCwgUGFyaXMKCjxzdHJvbmc+SGV1cmVzIGTigJlvdXZlcnR1cmU8L3N0cm9uZz4KRHUgbHVuZGkgYXUgdmVuZHJlZGnCoDogOWgwMOKAlDE3aDAwCkxlcyBzYW1lZGkgZXQgZGltYW5jaGXCoDogMTFoMDAmbmRhc2g7MTVoMDAiO3M6NjoiZmlsdGVyIjtiOjE7czo2OiJ2aXN1YWwiO2I6MTt9\",\n            \"title\": \"Retrouvez-nous\",\n            \"is_widget_customizer_js_value\": true,\n            \"instance_hash_key\": \"e75befa492729dcecd682012d33c8c5a\",\n            \"raw_instance\": {\n                \"title\": \"Retrouvez-nous\",\n                \"text\": \"<strong>Adresse</strong>\\nAvenue des Champs-\\u00c9lys\\u00e9es\\n75008, Paris\\n\\n<strong>Heures d\\u2019ouverture</strong>\\nDu lundi au vendredi\\u00a0: 9h00\\u201417h00\\nLes samedi et dimanche\\u00a0: 11h00&ndash;15h00\",\n                \"filter\": true,\n                \"visual\": true\n            }\n        },\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2024-10-08 06:55:24\"\n    },\n    \"sidebars_widgets[footer_1]\": {\n        \"starter_content\": true,\n        \"value\": [\n            \"text-4\"\n        ],\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2024-10-08 06:53:30\"\n    },\n    \"widget_text[5]\": {\n        \"value\": {\n            \"encoded_serialized_instance\": \"YTo0OntzOjU6InRpdGxlIjtzOjIwOiLDgCBwcm9wb3MgZGUgY2Ugc2l0ZSI7czo0OiJ0ZXh0IjtzOjk5OiJD4oCZZXN0IHBldXQtw6p0cmUgbGUgYm9uIGVuZHJvaXQgcG91ciB2b3VzIHByw6lzZW50ZXIgZXQgdm90cmUgc2l0ZSBvdSBpbnPDqXJlciBxdWVscXVlcyBjcsOpZGl0cy4iO3M6NjoiZmlsdGVyIjtiOjE7czo2OiJ2aXN1YWwiO2I6MTt9\",\n            \"title\": \"\\u00c0 propos de ce site\",\n            \"is_widget_customizer_js_value\": true,\n            \"instance_hash_key\": \"eb578722b43fb4a4ae224135cd00bcfe\",\n            \"raw_instance\": {\n                \"title\": \"\\u00c0 propos de ce site\",\n                \"text\": \"C\\u2019est peut-\\u00eatre le bon endroit pour vous pr\\u00e9senter et votre site ou ins\\u00e9rer quelques cr\\u00e9dits.\",\n                \"filter\": true,\n                \"visual\": true\n            }\n        },\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2024-10-08 06:55:24\"\n    },\n    \"sidebars_widgets[footer_2]\": {\n        \"starter_content\": true,\n        \"value\": [\n            \"text-5\"\n        ],\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2024-10-08 06:53:30\"\n    },\n    \"widget_search[3]\": {\n        \"value\": {\n            \"encoded_serialized_instance\": \"YToxOntzOjU6InRpdGxlIjtzOjEwOiJSZWNoZXJjaGVyIjt9\",\n            \"title\": \"Rechercher\",\n            \"is_widget_customizer_js_value\": true,\n            \"instance_hash_key\": \"1b4b4405351f73b797d4afa3e985e059\",\n            \"raw_instance\": {\n                \"title\": \"Rechercher\"\n            }\n        },\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2024-10-08 06:55:24\"\n    },\n    \"sidebars_widgets[footer_3]\": {\n        \"starter_content\": true,\n        \"value\": [\n            \"search-3\"\n        ],\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2024-10-08 06:53:30\"\n    },\n    \"nav_menus_created_posts\": {\n        \"starter_content\": true,\n        \"value\": [\n            40,\n            41,\n            42,\n            43,\n            44,\n            45\n        ],\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2024-10-08 06:53:30\"\n    },\n    \"nav_menu[-1]\": {\n        \"value\": {\n            \"name\": \"Main Menu\",\n            \"description\": \"\",\n            \"parent\": 0,\n            \"auto_add\": false\n        },\n        \"type\": \"nav_menu\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2024-10-08 06:55:24\"\n    },\n    \"nav_menu_item[-1]\": {\n        \"value\": {\n            \"object_id\": 0,\n            \"object\": \"\",\n            \"menu_item_parent\": 0,\n            \"position\": 0,\n            \"type\": \"custom\",\n            \"title\": \"Accueil\",\n            \"url\": \"http://portfolio-theo-valadoux.test/\",\n            \"target\": \"\",\n            \"attr_title\": \"\",\n            \"description\": \"\",\n            \"classes\": \"\",\n            \"xfn\": \"\",\n            \"status\": \"publish\",\n            \"original_title\": \"\",\n            \"nav_menu_term_id\": -1,\n            \"_invalid\": false,\n            \"type_label\": \"Lien personnalis\\u00e9\"\n        },\n        \"type\": \"nav_menu_item\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2024-10-08 06:55:24\"\n    },\n    \"nav_menu_item[-2]\": {\n        \"value\": {\n            \"object_id\": 43,\n            \"object\": \"page\",\n            \"menu_item_parent\": 0,\n            \"position\": 1,\n            \"type\": \"post_type\",\n            \"title\": \"About\",\n            \"url\": \"\",\n            \"target\": \"\",\n            \"attr_title\": \"\",\n            \"description\": \"\",\n            \"classes\": \"\",\n            \"xfn\": \"\",\n            \"status\": \"publish\",\n            \"original_title\": \"About\",\n            \"nav_menu_term_id\": -1,\n            \"_invalid\": false,\n            \"type_label\": \"Page\"\n        },\n        \"type\": \"nav_menu_item\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2024-10-08 06:55:24\"\n    },\n    \"nav_menu_item[-3]\": {\n        \"value\": {\n            \"object_id\": 45,\n            \"object\": \"page\",\n            \"menu_item_parent\": 0,\n            \"position\": 2,\n            \"type\": \"post_type\",\n            \"title\": \"Blog\",\n            \"url\": \"\",\n            \"target\": \"\",\n            \"attr_title\": \"\",\n            \"description\": \"\",\n            \"classes\": \"\",\n            \"xfn\": \"\",\n            \"status\": \"publish\",\n            \"original_title\": \"Blog\",\n            \"nav_menu_term_id\": -1,\n            \"_invalid\": false,\n            \"type_label\": \"Page\"\n        },\n        \"type\": \"nav_menu_item\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2024-10-08 06:55:24\"\n    },\n    \"nav_menu_item[-4]\": {\n        \"value\": {\n            \"object_id\": 44,\n            \"object\": \"page\",\n            \"menu_item_parent\": 0,\n            \"position\": 3,\n            \"type\": \"post_type\",\n            \"title\": \"Contact\",\n            \"url\": \"\",\n            \"target\": \"\",\n            \"attr_title\": \"\",\n            \"description\": \"\",\n            \"classes\": \"\",\n            \"xfn\": \"\",\n            \"status\": \"publish\",\n            \"original_title\": \"Contact\",\n            \"nav_menu_term_id\": -1,\n            \"_invalid\": false,\n            \"type_label\": \"Page\"\n        },\n        \"type\": \"nav_menu_item\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2024-10-08 06:55:24\"\n    },\n    \"inspiro::nav_menu_locations[primary]\": {\n        \"starter_content\": true,\n        \"value\": -1,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2024-10-08 06:53:30\"\n    },\n    \"show_on_front\": {\n        \"starter_content\": true,\n        \"value\": \"page\",\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2024-10-08 06:53:30\"\n    },\n    \"page_on_front\": {\n        \"starter_content\": true,\n        \"value\": 42,\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2024-10-08 06:53:30\"\n    },\n    \"page_for_posts\": {\n        \"starter_content\": true,\n        \"value\": 45,\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2024-10-08 06:53:30\"\n    }\n}", "", "", "draft", "closed", "closed", "", "4a7165cc-cd9c-486f-a5cf-22a8782821bc", "", "", "2024-10-08 08:55:24", "2024-10-08 06:55:24", "", "0", "http://portfolio-theo-valadoux.test/?p=46", "0", "customize_changeset", "", "0");
INSERT INTO `wp_posts` VALUES("48", "1", "2024-10-08 08:57:17", "2024-10-08 06:57:17", "{\"version\": 3, \"isGlobalStylesUserThemeJSON\": true }", "Custom Styles", "", "publish", "closed", "closed", "", "wp-global-styles-inspiro", "", "", "2024-10-08 08:57:17", "2024-10-08 06:57:17", "", "0", "http://portfolio-theo-valadoux.test/2024/10/08/wp-global-styles-inspiro/", "0", "wp_global_styles", "", "0");
INSERT INTO `wp_posts` VALUES("51", "1", "2024-10-08 09:12:24", "0000-00-00 00:00:00", "<!-- wp:navigation {\"ref\":4} /-->", "", "", "draft", "open", "open", "", "", "", "", "2024-10-08 09:12:24", "2024-10-08 07:12:24", "", "0", "http://portfolio-theo-valadoux.test/?p=51", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("52", "1", "2024-10-08 09:25:10", "2024-10-08 07:25:10", "\n                    <!-- wp:heading {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"100\"}},\"fontSize\":\"large\"} -->\n                    <h2 class=\"has-large-font-size\" id=\"inspiro-is-a-digital-product-agency-that-focuses-on-strategy-and-design\" style=\"font-style:normal;font-weight:100\"><strong>Inspiro is a digital product agency that focuses on strategy and design.</strong></h2>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:spacer -->\n                    <div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:columns {\"align\":\"wide\"} -->\n                    <div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n                    <div class=\"wp-block-column\"><!-- wp:image {\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n                    <figure class=\"wp-block-image size-large\"><img src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/video-1.jpeg\" alt=\"\"/></figure>\n                    <!-- /wp:image -->\n\n                    <!-- wp:paragraph {\"textColor\":\"black\",\"fontSize\":\"medium\"} -->\n                    <p class=\"has-black-color has-text-color has-medium-font-size\"><a href=\"#\">The Crew</a></p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#7a7a7a\"}}} -->\n                    <p class=\"has-text-color\" style=\"color:#7a7a7a\">This is some dummy copy. You’re not really supposed to read this dummy copy, it is just a place holder for people who need some type to visualize what the actual copy might look like if it were real content.</p>\n                    <!-- /wp:paragraph --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column -->\n                    <div class=\"wp-block-column\"><!-- wp:image {\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n                    <figure class=\"wp-block-image size-large\"><img src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/video-2.jpeg\" alt=\"\"/></figure>\n                    <!-- /wp:image -->\n\n                    <!-- wp:paragraph {\"textColor\":\"black\",\"fontSize\":\"medium\"} -->\n                    <p class=\"has-black-color has-text-color has-medium-font-size\"><a href=\"#\">Our Philosophy</a></p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#7a7a7a\"}}} -->\n                    <p class=\"has-text-color\" style=\"color:#7a7a7a\">This is some dummy copy. You’re not really supposed to read this dummy copy, it is just a place holder for people who need some type to visualize what the actual copy might look like if it were real content.</p>\n                    <!-- /wp:paragraph --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column -->\n                    <div class=\"wp-block-column\"><!-- wp:image {\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n                    <figure class=\"wp-block-image size-large\"><img src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/video-3.jpeg\" alt=\"\"/></figure>\n                    <!-- /wp:image -->\n\n                    <!-- wp:paragraph {\"textColor\":\"black\",\"fontSize\":\"medium\"} -->\n                    <p class=\"has-black-color has-text-color has-medium-font-size\"><a href=\"#\">Services</a></p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#7a7a7a\"}}} -->\n                    <p class=\"has-text-color\" style=\"color:#7a7a7a\">This is some dummy copy. You’re not really supposed to read this dummy copy, it is just a place holder for people who need some type to visualize what the actual copy might look like if it were real content.</p>\n                    <!-- /wp:paragraph --></div>\n                    <!-- /wp:column --></div>\n                    <!-- /wp:columns -->\n\n                    <!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontWeight\":\"300\"}},\"fontSize\":\"large\"} -->\n                    <h3 class=\"has-large-font-size\" id=\"inspiro-is-a-digital-product-agency-that-focuses-on-strategy-and-desig\" style=\"font-weight:300\">Showreel</h3>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:embed {\"url\":\"https://videopress.com/v/bjvmxiQS\",\"type\":\"video\",\"providerNameSlug\":\"videopress\",\"responsive\":true,\"align\":\"wide\",\"className\":\"wp-embed-aspect-16-9 wp-has-aspect-ratio\"} -->\n                    <figure class=\"wp-block-embed alignwide is-type-video is-provider-videopress wp-block-embed-videopress wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n                    https://videopress.com/v/bjvmxiQS\n                    </div></figure>\n                    <!-- /wp:embed -->\n\n                    <!-- wp:spacer -->\n                    <div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:cover {\"overlayColor\":\"black\",\"minHeight\":316,\"minHeightUnit\":\"px\",\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"50px\",\"right\":\"50px\",\"bottom\":\"50px\",\"left\":\"50px\"}}}} -->\n                    <div class=\"wp-block-cover alignfull\" style=\"padding-top:50px;padding-right:50px;padding-bottom:50px;padding-left:50px;min-height:316px\"><span aria-hidden=\"true\" class=\"has-black-background-color has-background-dim-100 wp-block-cover__gradient-background has-background-dim\"></span><div class=\"wp-block-cover__inner-container\"><!-- wp:columns {\"verticalAlignment\":\"center\"} -->\n                    <div class=\"wp-block-columns are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"20px\",\"right\":\"0px\",\"bottom\":\"20px\",\"left\":\"0px\"}}}} -->\n                    <div class=\"wp-block-column is-vertically-aligned-center\" style=\"padding-top:20px;padding-right:0px;padding-bottom:20px;padding-left:0px\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0px\"}},\"layout\":{\"type\":\"flex\",\"allowOrientation\":false,\"justifyContent\":\"space-between\",\"flexWrap\":\"nowrap\"}} -->\n                    <div class=\"wp-block-group\"><!-- wp:image {\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n                    <figure class=\"wp-block-image size-full\"><img src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/laurel_left.png\" alt=\"\"/></figure>\n                    <!-- /wp:image -->\n\n                    <!-- wp:group -->\n                    <div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"center\",\"style\":{\"typography\":{\"lineHeight\":\"1\",\"fontSize\":\"18px\"}},\"textColor\":\"white\"} -->\n                    <p class=\"has-text-align-center has-white-color has-text-color\" style=\"font-size:18px;line-height:1\"><strong>&quot;Best Film&quot;<br></strong>Winner</p>\n                    <!-- /wp:paragraph --></div>\n                    <!-- /wp:group -->\n\n                    <!-- wp:image {\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n                    <figure class=\"wp-block-image size-full\"><img src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/laurel_right.png\" alt=\"\"/></figure>\n                    <!-- /wp:image --></div>\n                    <!-- /wp:group --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column {\"verticalAlignment\":\"center\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"20px\",\"right\":\"0px\",\"bottom\":\"20px\",\"left\":\"0px\"}}}} -->\n                    <div class=\"wp-block-column is-vertically-aligned-center\" style=\"padding-top:20px;padding-right:0px;padding-bottom:20px;padding-left:0px\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0px\"}},\"layout\":{\"type\":\"flex\",\"allowOrientation\":false,\"justifyContent\":\"space-between\",\"flexWrap\":\"nowrap\"}} -->\n                    <div class=\"wp-block-group\"><!-- wp:image {\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n                    <figure class=\"wp-block-image size-full\"><img src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/laurel_left.png\" alt=\"\"/></figure>\n                    <!-- /wp:image -->\n\n                    <!-- wp:group -->\n                    <div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"center\",\"style\":{\"typography\":{\"lineHeight\":\"1\",\"fontSize\":\"18px\"}},\"textColor\":\"white\"} -->\n                    <p class=\"has-text-align-center has-white-color has-text-color\" style=\"font-size:18px;line-height:1\"><strong>&quot;New Film Festival&quot;</strong><br>Winner</p>\n                    <!-- /wp:paragraph --></div>\n                    <!-- /wp:group -->\n\n                    <!-- wp:image {\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n                    <figure class=\"wp-block-image size-full\"><img src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/laurel_right.png\" alt=\"\"/></figure>\n                    <!-- /wp:image --></div>\n                    <!-- /wp:group --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column {\"verticalAlignment\":\"center\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"20px\",\"right\":\"0px\",\"bottom\":\"20px\",\"left\":\"0px\"}}}} -->\n                    <div class=\"wp-block-column is-vertically-aligned-center\" style=\"padding-top:20px;padding-right:0px;padding-bottom:20px;padding-left:0px\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0px\"}},\"layout\":{\"type\":\"flex\",\"allowOrientation\":false,\"justifyContent\":\"space-between\",\"flexWrap\":\"nowrap\"}} -->\n                    <div class=\"wp-block-group\"><!-- wp:image {\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n                    <figure class=\"wp-block-image size-full\"><img src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/laurel_left.png\" alt=\"\"/></figure>\n                    <!-- /wp:image -->\n\n                    <!-- wp:group -->\n                    <div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"center\",\"style\":{\"typography\":{\"lineHeight\":\"1\",\"fontSize\":\"18px\"}},\"textColor\":\"white\"} -->\n                    <p class=\"has-text-align-center has-white-color has-text-color\" style=\"font-size:18px;line-height:1\"><strong>&quot;Best Short&quot;</strong><br>Winner</p>\n                    <!-- /wp:paragraph --></div>\n                    <!-- /wp:group -->\n\n                    <!-- wp:image {\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n                    <figure class=\"wp-block-image size-full\"><img src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/laurel_right.png\" alt=\"\"/></figure>\n                    <!-- /wp:image --></div>\n                    <!-- /wp:group --></div>\n                    <!-- /wp:column --></div>\n                    <!-- /wp:columns --></div></div>\n                    <!-- /wp:cover -->", "About", "", "inherit", "closed", "closed", "", "43-revision-v1", "", "", "2024-10-08 09:25:10", "2024-10-08 07:25:10", "", "43", "http://portfolio-theo-valadoux.test/?p=52", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("53", "1", "2024-10-08 09:25:13", "2024-10-08 07:25:13", "", "Blog", "", "inherit", "closed", "closed", "", "45-revision-v1", "", "", "2024-10-08 09:25:13", "2024-10-08 07:25:13", "", "45", "http://portfolio-theo-valadoux.test/?p=53", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("54", "1", "2024-10-08 09:25:15", "2024-10-08 07:25:15", "\n                    <!-- wp:spacer {\"height\":\"156px\"} -->\n                    <div style=\"height:156px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\n                    <div class=\"wp-block-group\"><!-- wp:columns {\"verticalAlignment\":\"top\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"}}}} -->\n                    <div class=\"wp-block-columns are-vertically-aligned-top\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"50%\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"7%\"}}},\"layout\":{\"type\":\"default\"}} -->\n                    <div class=\"wp-block-column is-vertically-aligned-top\" style=\"padding-right:7%;flex-basis:50%\"><!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#0bb4aa\"}}} -->\n                    <p class=\"has-text-color\" style=\"color:#0bb4aa\">Let\'s Connect!</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:heading {\"fontSize\":\"large\"} -->\n                    <h2 class=\"wp-block-heading has-large-font-size\">Ready to start your next project?</h2>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:paragraph -->\n                    <p>This is some dummy copy. You’re not really supposed to read this dummy copy, it is just a place holder for people who <a href=\"#\">need some type</a> to visualize what the actual copy might look like if it were real content.<br></p>\n                    <!-- /wp:paragraph --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"50%\",\"layout\":{\"type\":\"default\"}} -->\n                    <div class=\"wp-block-column is-vertically-aligned-top\" style=\"flex-basis:50%\"><!-- wp:wpzoom-forms/form-block {\"formId\":\"21\"} /--></div>\n                    <!-- /wp:column --></div>\n                    <!-- /wp:columns -->\n\n                    <!-- wp:spacer {\"height\":\"135px\"} -->\n                    <div style=\"height:135px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer --></div>\n                    <!-- /wp:group -->\n\n                    <!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"blockGap\":\"0\"}},\"layout\":{\"type\":\"constrained\"}} -->\n                    <div class=\"wp-block-group alignfull\"><!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"},\"blockGap\":{\"top\":\"0\",\"left\":\"var:preset|spacing|x-small\"}}},\"backgroundColor\":\"light-background\"} -->\n                    <div class=\"wp-block-columns alignfull are-vertically-aligned-center has-light-background-background-color has-background\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"50%\",\"className\":\"map-grayscale\",\"layout\":{\"type\":\"default\"}} -->\n                    <div class=\"wp-block-column is-vertically-aligned-center map-grayscale\" style=\"flex-basis:50%\"><!-- wp:image {\"id\":7500,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n                    <figure class=\"wp-block-image size-large\"><img src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/map2.png\" alt=\"\" class=\"wp-image-7500\"/></figure>\n                    <!-- /wp:image --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"50%\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|small\",\"bottom\":\"var:preset|spacing|small\",\"right\":\"var:preset|spacing|small\",\"left\":\"2%\"}}},\"layout\":{\"type\":\"default\"}} -->\n                    <div class=\"wp-block-column is-vertically-aligned-center\" style=\"padding-top:var(--wp--preset--spacing--small);padding-right:var(--wp--preset--spacing--small);padding-bottom:var(--wp--preset--spacing--small);padding-left:2%;flex-basis:50%\"><!-- wp:heading {\"level\":3,\"fontSize\":\"large\"} -->\n                    <h3 class=\"wp-block-heading has-large-font-size\">Inspiro</h3>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:paragraph -->\n                    <p></p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:heading {\"level\":3} -->\n                    <h3 class=\"wp-block-heading\"><strong>Address</strong></h3>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:paragraph -->\n                    <p>1500 Broadway, New York, NY 10036, United States</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:heading {\"level\":3} -->\n                    <h3 class=\"wp-block-heading\"><strong>Email</strong></h3>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:paragraph -->\n                    <p>office@example.com</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:heading {\"level\":3} -->\n                    <h3 class=\"wp-block-heading\"><strong>Phone</strong></h3>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:paragraph -->\n                    <p>509-394-2555</p>\n                    <!-- /wp:paragraph --></div>\n                    <!-- /wp:column --></div>\n                    <!-- /wp:columns --></div>\n                    <!-- /wp:group -->\n\n                    <!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#f9f9f9\"}},\"layout\":{\"type\":\"constrained\"}} -->\n                    <div class=\"wp-block-group alignfull has-background\" style=\"background-color:#f9f9f9\"><!-- wp:group {\"layout\":{\"type\":\"default\"}} -->\n                    <div class=\"wp-block-group\"><!-- wp:spacer {\"height\":\"69px\"} -->\n                    <div style=\"height:69px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:columns -->\n                    <div class=\"wp-block-columns\"><!-- wp:column -->\n                    <div class=\"wp-block-column\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"color\":{\"text\":\"#0bb4aa\"}}} -->\n                    <p class=\"has-text-align-left has-text-color\" style=\"color:#0bb4aa\">WHERE ARE WE LOCATED</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:heading {\"textAlign\":\"left\",\"fontSize\":\"large\"} -->\n                    <h2 class=\"wp-block-heading has-text-align-left has-large-font-size\">Our Locations</h2>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:columns -->\n                    <div class=\"wp-block-columns\"><!-- wp:column -->\n                    <div class=\"wp-block-column\"><!-- wp:paragraph {\"style\":{\"typography\":{\"lineHeight\":\"2.5\"}}} -->\n                    <p style=\"line-height:2.5\">Amsterdam<br>Munich<br>Brussels<br>Hong Kong<br>Barcelona</p>\n                    <!-- /wp:paragraph --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column -->\n                    <div class=\"wp-block-column\"><!-- wp:paragraph {\"style\":{\"typography\":{\"lineHeight\":\"2.5\"}}} -->\n                    <p style=\"line-height:2.5\">New York<br>Paris<br>San Francisco<br>Sydney<br>Tokyo</p>\n                    <!-- /wp:paragraph --></div>\n                    <!-- /wp:column --></div>\n                    <!-- /wp:columns --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column -->\n                    <div class=\"wp-block-column\"><!-- wp:image {\"id\":5640,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n                    <figure class=\"wp-block-image size-large\"><img src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/map.png\" alt=\"\" class=\"wp-image-5640\"/></figure>\n                    <!-- /wp:image --></div>\n                    <!-- /wp:column --></div>\n                    <!-- /wp:columns -->\n\n                    <!-- wp:spacer {\"height\":\"52px\"} -->\n                    <div style=\"height:52px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer --></div>\n                    <!-- /wp:group --></div>\n                    <!-- /wp:group -->\n\n                    <!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\n                    <div class=\"wp-block-group\"><!-- wp:spacer {\"height\":\"33px\"} -->\n                    <div style=\"height:33px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:columns {\"verticalAlignment\":\"center\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|60\",\"left\":\"0\",\"bottom\":\"var:preset|spacing|60\"}}}} -->\n                    <div class=\"wp-block-columns are-vertically-aligned-center\" style=\"padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60);padding-left:0\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"66.66%\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\"}} -->\n                    <div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:66.66%\"><!-- wp:heading -->\n                    <h2 class=\"wp-block-heading\">Thinking about joining our team?</h2>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:paragraph -->\n                    <p>Check out our open positions, or drop us a line, say hi.</p>\n                    <!-- /wp:paragraph --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"33.33%\"} -->\n                    <div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:33.33%\"><!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"right\"}} -->\n                    <div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"border\":{\"radius\":\"0px\"},\"typography\":{\"textTransform\":\"uppercase\",\"fontStyle\":\"normal\",\"fontWeight\":\"600\",\"fontSize\":\"14px\",\"letterSpacing\":\"1px\"}},\"className\":\"is-style-fill\"} -->\n                    <div class=\"wp-block-button has-custom-font-size is-style-fill\" style=\"font-size:14px;font-style:normal;font-weight:600;letter-spacing:1px;text-transform:uppercase\"><a class=\"wp-block-button__link wp-element-button\" style=\"border-radius:0px\">View Job Openings</a></div>\n                    <!-- /wp:button --></div>\n                    <!-- /wp:buttons --></div>\n                    <!-- /wp:column --></div>\n                    <!-- /wp:columns -->\n\n                    <!-- wp:spacer {\"height\":\"45px\"} -->\n                    <div style=\"height:45px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer --></div>\n                    <!-- /wp:group -->\n                ", "Contact", "", "inherit", "closed", "closed", "", "44-revision-v1", "", "", "2024-10-08 09:25:15", "2024-10-08 07:25:15", "", "44", "http://portfolio-theo-valadoux.test/?p=54", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("55", "1", "2024-10-08 09:25:16", "2024-10-08 07:25:16", "\n                    <!-- wp:cover {\"url\":\"https://demo.wpzoom.com/inspiro-lite/files/2022/03/Pexels-Videos-1409899-1.mp4\",\"id\":6672,\"dimRatio\":20,\"backgroundType\":\"video\",\"minHeight\":100,\"minHeightUnit\":\"vh\",\"contentPosition\":\"center center\",\"isDark\":false,\"align\":\"full\",\"layout\":{\"type\":\"constrained\"}} -->\n                    <div class=\"wp-block-cover alignfull is-light\" style=\"min-height:100vh\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-20 has-background-dim\"></span><video class=\"wp-block-cover__video-background intrinsic-ignore\" autoplay muted loop playsinline src=\"https://demo.wpzoom.com/inspiro-lite/files/2022/03/Pexels-Videos-1409899-1.mp4\" data-object-fit=\"cover\"></video><div class=\"wp-block-cover__inner-container\"><!-- wp:paragraph {\"align\":\"center\",\"placeholder\":\"Write title…\",\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"900\",\"lineHeight\":\"1.2\"}},\"textColor\":\"white\",\"fontSize\":\"max-60\"} -->\n                    <p class=\"has-text-align-center has-white-color has-text-color has-max-60-font-size\" style=\"font-style:normal;font-weight:900;line-height:1.2\"><strong>Create. Amaze. Inspire.</strong></p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:paragraph {\"align\":\"center\",\"textColor\":\"white\",\"fontSize\":\"medium\"} -->\n                    <p class=\"has-text-align-center has-white-color has-text-color has-medium-font-size\">Inspiro is a Portfolio &amp; Photography WordPress Theme. This area supports self-hosted videos as well as videos from YouTube and Vimeo.</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:spacer {\"height\":\"55px\"} -->\n                    <div style=\"height:55px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n                    <div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"white\",\"style\":{\"border\":{\"radius\":\"0px\"}},\"className\":\"is-style-outline\"} -->\n                    <div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link has-white-color has-text-color wp-element-button\" href=\"#\" style=\"border-radius:0px\">Learn More</a></div>\n                    <!-- /wp:button --></div>\n                    <!-- /wp:buttons --></div></div>\n                    <!-- /wp:cover -->\n\n                    <!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\n                    <div class=\"wp-block-group\"><!-- wp:spacer {\"height\":\"57px\"} -->\n                    <div style=\"height:57px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:heading {\"textAlign\":\"center\",\"style\":{\"typography\":{\"letterSpacing\":\"1px\"}},\"fontSize\":\"medium\"} -->\n                    <h2 class=\"wp-block-heading has-text-align-center has-medium-font-size\" style=\"letter-spacing:1px\">WE ARE A CREATIVE AGENCY LOCATED IN LONDON</h2>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:paragraph {\"align\":\"center\"} -->\n                    <p class=\"has-text-align-center\">This is some dummy copy. You’re not really supposed to read this dummy copy, it is just a placeholder for people who need some type to visualize what the actual copy might look like if it were real content.</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\",\"orientation\":\"horizontal\"}} -->\n                    <div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"border\":{\"radius\":\"0px\"}},\"className\":\"is-style-outline\",\"fontSize\":\"small\"} -->\n                    <div class=\"wp-block-button has-custom-font-size is-style-outline has-small-font-size\"><a class=\"wp-block-button__link wp-element-button\" href=\"#\" style=\"border-radius:0px\">ABOUT US</a></div>\n                    <!-- /wp:button --></div>\n                    <!-- /wp:buttons -->\n\n                    <!-- wp:spacer {\"height\":\"57px\"} -->\n                    <div style=\"height:57px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer --></div>\n                    <!-- /wp:group -->\n\n                    <!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#f8f8f8\"}},\"className\":\"pattern_multiple_covers\",\"layout\":{\"type\":\"constrained\"}} -->\n                    <div class=\"wp-block-group alignfull pattern_multiple_covers has-background\" id=\"services\" style=\"background-color:#f8f8f8\"><!-- wp:spacer {\"height\":\"84px\"} -->\n                    <div style=\"height:84px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:paragraph {\"align\":\"left\",\"style\":{\"typography\":{\"letterSpacing\":\"1px\"}},\"textColor\":\"secondary\"} -->\n                    <p class=\"has-text-align-left has-secondary-color has-text-color\" style=\"letter-spacing:1px\">LET\'S WORK TOGETHER!</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:heading {\"textAlign\":\"left\"} -->\n                    <h2 class=\"wp-block-heading has-text-align-left\">Our Services</h2>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:paragraph {\"align\":\"left\"} -->\n                    <p class=\"has-text-align-left\">Inspiro is the perfect solution to create a beautiful website for your portfolio or your business. If you’re looking to create a captivating presence online, then you’ve found the right tool. The theme is easy to manage, with a drag-and-drop interface and fully customizable using the Theme Customizer.</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:spacer {\"height\":\"46px\"} -->\n                    <div style=\"height:46px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:columns -->\n                    <div class=\"wp-block-columns\"><!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"}}}} -->\n                    <div class=\"wp-block-column\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:cover {\"url\":\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/StockSnap_356BERTH29.jpg\",\"id\":7392,\"dimRatio\":70,\"overlayColor\":\"primary\",\"contentPosition\":\"bottom left\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|small\",\"right\":\"var:preset|spacing|x-small\",\"bottom\":\"var:preset|spacing|small\",\"left\":\"var:preset|spacing|x-small\"}}}} -->\n                    <div class=\"wp-block-cover has-custom-content-position is-position-bottom-left\" style=\"padding-top:var(--wp--preset--spacing--small);padding-right:var(--wp--preset--spacing--x-small);padding-bottom:var(--wp--preset--spacing--small);padding-left:var(--wp--preset--spacing--x-small)\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-primary-background-color has-background-dim-70 has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-7392\" alt=\"\" src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/StockSnap_356BERTH29.jpg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"margin\":{\"left\":\"0\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\"}}},\"textColor\":\"white\",\"fontSize\":\"medium\"} -->\n                    <h3 class=\"wp-block-heading has-white-color has-text-color has-medium-font-size\" style=\"margin-top:0;margin-right:0;margin-bottom:0;margin-left:0\">Video<br>Production</h3>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"left\":\"0\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|secondary\"}}}},\"textColor\":\"secondary\"} -->\n                    <p class=\"has-secondary-color has-text-color has-link-color\" style=\"margin-top:0;margin-right:0;margin-bottom:0;margin-left:0\"><a href=\"#\">Explore more →</a></p>\n                    <!-- /wp:paragraph --></div></div>\n                    <!-- /wp:cover --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"}}}} -->\n                    <div class=\"wp-block-column\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:cover {\"url\":\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/StockSnap_KV0WLH355C.jpg\",\"id\":7394,\"dimRatio\":70,\"overlayColor\":\"primary\",\"contentPosition\":\"bottom left\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|small\",\"right\":\"var:preset|spacing|x-small\",\"bottom\":\"var:preset|spacing|small\",\"left\":\"var:preset|spacing|x-small\"}}}} -->\n                    <div class=\"wp-block-cover has-custom-content-position is-position-bottom-left\" style=\"padding-top:var(--wp--preset--spacing--small);padding-right:var(--wp--preset--spacing--x-small);padding-bottom:var(--wp--preset--spacing--small);padding-left:var(--wp--preset--spacing--x-small)\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-primary-background-color has-background-dim-70 has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-7394\" alt=\"\" src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/StockSnap_KV0WLH355C.jpg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"margin\":{\"left\":\"0\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\"}}},\"textColor\":\"white\",\"fontSize\":\"medium\"} -->\n                    <h3 class=\"wp-block-heading has-white-color has-text-color has-medium-font-size\" style=\"margin-top:0;margin-right:0;margin-bottom:0;margin-left:0\">Professional<br>Editing</h3>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"left\":\"0\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|secondary\"}}}},\"textColor\":\"secondary\"} -->\n                    <p class=\"has-secondary-color has-text-color has-link-color\" style=\"margin-top:0;margin-right:0;margin-bottom:0;margin-left:0\"><a href=\"#\">Explore more →</a></p>\n                    <!-- /wp:paragraph --></div></div>\n                    <!-- /wp:cover --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"}}}} -->\n                    <div class=\"wp-block-column\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:cover {\"url\":\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/StockSnap_P9QYJ8AAL8.jpg\",\"id\":7497,\"dimRatio\":70,\"overlayColor\":\"primary\",\"contentPosition\":\"bottom left\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|small\",\"right\":\"var:preset|spacing|x-small\",\"bottom\":\"var:preset|spacing|small\",\"left\":\"var:preset|spacing|x-small\"}}}} -->\n                    <div class=\"wp-block-cover has-custom-content-position is-position-bottom-left\" style=\"padding-top:var(--wp--preset--spacing--small);padding-right:var(--wp--preset--spacing--x-small);padding-bottom:var(--wp--preset--spacing--small);padding-left:var(--wp--preset--spacing--x-small)\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-primary-background-color has-background-dim-70 has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-7497\" alt=\"\" src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/StockSnap_P9QYJ8AAL8.jpg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"level\":3,\"style\":{\"spacing\":{\"margin\":{\"left\":\"0\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\"}}},\"textColor\":\"white\",\"fontSize\":\"medium\"} -->\n                    <h3 class=\"wp-block-heading has-white-color has-text-color has-medium-font-size\" style=\"margin-top:0;margin-right:0;margin-bottom:0;margin-left:0\">Aerial<br>Video</h3>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"left\":\"0\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|secondary\"}}}},\"textColor\":\"secondary\"} -->\n                    <p class=\"has-secondary-color has-text-color has-link-color\" style=\"margin-top:0;margin-right:0;margin-bottom:0;margin-left:0\"><a href=\"#\">Explore more →</a></p>\n                    <!-- /wp:paragraph --></div></div>\n                    <!-- /wp:cover --></div>\n                    <!-- /wp:column --></div>\n                    <!-- /wp:columns -->\n\n                    <!-- wp:spacer {\"height\":\"103px\"} -->\n                    <div style=\"height:103px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer --></div>\n                    <!-- /wp:group -->\n\n                    <!-- wp:group {\"align\":\"full\",\"layout\":{\"type\":\"constrained\"}} -->\n                    <div class=\"wp-block-group alignfull\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|small\",\"bottom\":\"var:preset|spacing|small\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n                    <div class=\"wp-block-group\" style=\"padding-top:var(--wp--preset--spacing--small);padding-bottom:var(--wp--preset--spacing--small)\"><!-- wp:spacer {\"height\":\"30px\"} -->\n                    <div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|small\"}}}} -->\n                    <div class=\"wp-block-columns\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\n                    <div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:heading {\"style\":{\"typography\":{\"textTransform\":\"uppercase\"}},\"fontSize\":\"medium\"} -->\n                    <h2 class=\"wp-block-heading has-medium-font-size\" style=\"text-transform:uppercase\">About us</h2>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:paragraph -->\n                    <p>This is some dummy copy. You’re not really supposed to read this dummy copy, it is just a placeholder for people who need some type to visualize what the actual copy might look like if it were real content.</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"left\",\"orientation\":\"horizontal\"}} -->\n                    <div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"border\":{\"radius\":\"0px\"}},\"className\":\"is-style-outline\"} -->\n                    <div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\" href=\"#\" style=\"border-radius:0px\">ABOUT US</a></div>\n                    <!-- /wp:button --></div>\n                    <!-- /wp:buttons -->\n\n                    <!-- wp:paragraph -->\n                    <p></p>\n                    <!-- /wp:paragraph --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column -->\n                    <div class=\"wp-block-column\"><!-- wp:image {\"id\":26,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n                    <figure class=\"wp-block-image size-large\"><img src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/StockSnap_JKMGVEJMPU.jpg\" alt=\"\" class=\"wp-image-26\"/></figure>\n                    <!-- /wp:image --></div>\n                    <!-- /wp:column --></div>\n                    <!-- /wp:columns -->\n\n                    <!-- wp:spacer {\"height\":\"30px\"} -->\n                    <div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer --></div>\n                    <!-- /wp:group --></div>\n                    <!-- /wp:group -->\n\n                    <!-- wp:group {\"align\":\"full\",\"style\":{\"color\":{\"background\":\"#f8f8f8\"}},\"layout\":{\"type\":\"constrained\"}} -->\n                    <div class=\"wp-block-group alignfull has-background\" style=\"background-color:#f8f8f8\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|small\",\"bottom\":\"var:preset|spacing|small\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n                    <div class=\"wp-block-group\" style=\"padding-top:var(--wp--preset--spacing--small);padding-bottom:var(--wp--preset--spacing--small)\"><!-- wp:spacer {\"height\":\"30px\"} -->\n                    <div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:columns {\"verticalAlignment\":\"center\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|small\"}}}} -->\n                    <div class=\"wp-block-columns are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\n                    <div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:image {\"id\":27,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n                    <figure class=\"wp-block-image size-large\"><img src=\"http://portfolio-theo-valadoux.test/wp-content/themes/inspiro/assets/images/StockSnap_M6D1GS9PSL.jpg\" alt=\"\" class=\"wp-image-27\"/></figure>\n                    <!-- /wp:image --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column {\"verticalAlignment\":\"center\"} -->\n                    <div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:heading {\"style\":{\"typography\":{\"textTransform\":\"uppercase\"}},\"fontSize\":\"medium\"} -->\n                    <h2 class=\"wp-block-heading has-medium-font-size\" style=\"text-transform:uppercase\">Our Services</h2>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:paragraph -->\n                    <p>This is some dummy copy. You’re not really supposed to read this dummy copy, it is just a placeholder for people who need some type to visualize what the actual copy might look like if it were real content.</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:buttons -->\n                    <div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"border\":{\"radius\":\"0px\"}},\"className\":\"is-style-outline\"} -->\n                    <div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\" href=\"#\" style=\"border-radius:0px\">SERVICES</a></div>\n                    <!-- /wp:button --></div>\n                    <!-- /wp:buttons --></div>\n                    <!-- /wp:column --></div>\n                    <!-- /wp:columns -->\n\n                    <!-- wp:spacer {\"height\":\"30px\"} -->\n                    <div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer --></div>\n                    <!-- /wp:group --></div>\n                    <!-- /wp:group -->\n\n                    <!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0px\"}}},\"backgroundColor\":\"black\",\"className\":\"portfolio-dark\",\"layout\":{\"type\":\"constrained\"}} -->\n                    <div class=\"wp-block-group alignfull portfolio-dark has-black-background-color has-background\" id=\"portfolio\" style=\"margin-top:0px\"><!-- wp:spacer {\"height\":\"122px\"} -->\n                    <div style=\"height:122px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:paragraph {\"align\":\"left\",\"style\":{\"typography\":{\"letterSpacing\":\"1px\"},\"color\":{\"text\":\"#0bb4aa\"}}} -->\n                    <p class=\"has-text-align-left has-text-color\" style=\"color:#0bb4aa;letter-spacing:1px\">FROM THE PORTFOLIO</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:heading {\"textAlign\":\"left\",\"textColor\":\"white\",\"fontSize\":\"large\"} -->\n                    <h2 class=\"wp-block-heading has-text-align-left has-white-color has-text-color has-large-font-size\">Our Work</h2>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:spacer {\"height\":\"44px\"} -->\n                    <div style=\"height:44px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:wpzoom-blocks/portfolio {\"align\":\"full\",\"textColor\":\"white\",\"btnHoverTextColor\":\"#101010\",\"btnBgColor\":\"#0bb4aa\",\"btnHoverBgColor\":\"#ffffff\"} /-->\n\n                    <!-- wp:spacer {\"height\":\"50px\"} -->\n                    <div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer --></div>\n                    <!-- /wp:group -->\n\n                    <!-- wp:group {\"layout\":{\"type\":\"constrained\",\"contentSize\":\"1200px\",\"justifyContent\":\"center\"}} -->\n                    <div id=\"partners\" class=\"wp-block-group\"><!-- wp:spacer {\"height\":\"80px\"} -->\n                    <div style=\"height:80px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0px\",\"bottom\":\"var:preset|spacing|small\",\"right\":\"0\",\"left\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"contentSize\":\"\",\"justifyContent\":\"left\",\"wideSize\":\"\"}} -->\n                    <div class=\"wp-block-group\" style=\"padding-top:0px;padding-right:0;padding-bottom:var(--wp--preset--spacing--small);padding-left:0\"><!-- wp:columns -->\n                    <div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"60%\"} -->\n                    <div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:spacer {\"height\":\"20px\"} -->\n                    <div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:paragraph {\"textColor\":\"secondary\"} -->\n                    <p class=\"has-secondary-color has-text-color\">WE WORK WITH</p>\n                    <!-- /wp:paragraph -->\n\n                    <!-- wp:heading {\"textAlign\":\"left\"} -->\n                    <h2 class=\"wp-block-heading has-text-align-left\">Our Clients</h2>\n                    <!-- /wp:heading -->\n\n                    <!-- wp:spacer {\"height\":\"20px\"} -->\n                    <div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n                    <!-- /wp:spacer -->\n\n                    <!-- wp:paragraph {\"align\":\"left\",\"textColor\":\"tertiary\"} -->\n                    <p class=\"has-text-align-left has-tertiary-color has-text-color\">This is some dummy copy. You’re not really supposed to read this dummy copy, it is just a place holder for people who need some type to visualize.</p>\n                    <!-- /wp:paragraph --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column {\"width\":\"40%\"} -->\n                    <div class=\"wp-block-column\" style=\"flex-basis:40%\"></div>\n                    <!-- /wp:column --></div>\n                    <!-- /wp:columns --></div>\n                    <!-- /wp:group -->\n\n                    <!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\n                    <div class=\"wp-block-group\"><!-- wp:columns {\"verticalAlignment\":\"center\"} -->\n                    <div class=\"wp-block-columns are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"20%\"} -->\n                    <div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:20%\"><!-- wp:outermost/icon-block {\"iconName\":\"\",\"itemsJustification\":\"center\",\"width\":\"200px\"} -->\n                    <div class=\"wp-block-outermost-icon-block items-justified-center\"><div class=\"icon-container\" style=\"width:200px\"><svg width=\"147\" height=\"46\" viewBox=\"0 0 147 46\" fill=\"none\" xmlns=\"https://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M72.6763 7.40747C74.0641 6.01977 76.3141 6.01977 77.7019 7.40747C79.0897 8.79527 79.0897 11.0453 77.7019 12.4331L69.241 20.894C66.8118 17.6384 67.0757 13.0082 70.0327 10.0512L72.6763 7.40747Z\" fill=\"#ECECEC\"></path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M84.7713 26.4967C86.1593 27.8844 86.1593 30.1345 84.7713 31.5222C83.3843 32.91 81.1339 32.91 79.7461 31.5222L71.2852 23.0614C74.5408 20.6322 79.171 20.896 82.128 23.853L84.7713 26.4967Z\" fill=\"#ECECEC\"></path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M65.6835 38.5924C64.2958 39.9802 62.0457 39.9802 60.658 38.5924C59.2702 37.2046 59.2702 34.9546 60.658 33.5668L69.1188 25.106C71.548 28.3616 71.2842 32.9918 68.3272 35.9487L65.6835 38.5924Z\" fill=\"#ECECEC\"></path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M53.5877 19.503C52.1999 18.1152 52.1999 15.8652 53.5877 14.4774C54.9755 13.0896 57.2255 13.0896 58.6133 14.4774L67.0742 22.9383C63.8186 25.3675 59.1883 25.1036 56.2314 22.1467L53.5877 19.503Z\" fill=\"#ECECEC\"></path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M70.7852 37.5563C72.8315 35.2811 73.7826 32.3698 73.6383 29.5034L77.7017 33.5668C77.7118 33.5769 77.722 33.587 77.7322 33.5971V36.4981C77.7322 38.4607 76.1412 40.0517 74.1786 40.0517C72.5845 40.0517 71.2356 39.0021 70.7852 37.5563Z\" fill=\"#ECECEC\"></path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M54.6243 24.606C56.8994 26.6524 59.8107 27.6035 62.6771 27.4592L58.6138 31.5226C58.6036 31.5327 58.5935 31.5429 58.5835 31.553H55.6825C53.7199 31.5531 52.1289 29.962 52.1289 27.9994C52.1289 26.4054 53.1785 25.0564 54.6243 24.606Z\" fill=\"#ECECEC\"></path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M83.7362 21.3944C81.4613 19.348 78.55 18.3969 75.6836 18.5411L79.7469 14.4778C79.7571 14.4677 79.7671 14.4575 79.7772 14.4473H82.6783C84.6412 14.4473 86.2322 16.0384 86.2322 18.001C86.2322 19.5951 85.1822 20.944 83.7362 21.3944Z\" fill=\"#ECECEC\"></path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M67.572 8.44374C65.5256 10.7189 64.5746 13.6302 64.7188 16.4967L60.6555 12.4333C60.6453 12.4232 60.6352 12.4131 60.625 12.403V9.50194C60.625 7.53934 62.216 5.94824 64.1786 5.94824C65.7727 5.94824 67.1216 6.99794 67.572 8.44374Z\" fill=\"#ECECEC\"></path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M64.1781 3.05713C60.6187 3.05713 57.7332 5.94263 57.7332 9.50203V10.7555C55.5918 10.196 53.2186 10.7552 51.5405 12.4333C49.0236 14.9502 49.0236 19.0309 51.5405 21.5478L52.4268 22.4341C50.517 23.5527 49.2344 25.6262 49.2344 27.9993C49.2344 31.5587 52.1199 34.4442 55.6793 34.4442H56.9327C56.3732 36.5856 56.9324 38.9588 58.6105 40.6368C61.1274 43.1537 65.2081 43.1537 67.725 40.6368L70.3686 37.9932C72.7007 35.6611 73.7899 32.5567 73.6362 29.5033L77.6997 33.5667C80.2166 36.0836 84.2974 36.0836 86.8144 33.5667C89.3314 31.0498 89.3314 26.9691 86.8144 24.4523L85.9284 23.5661C87.8374 22.4475 89.1204 20.374 89.1204 18.0009C89.1204 14.4415 86.2344 11.556 82.6754 11.556H81.4219C81.9815 9.41453 81.4222 7.04133 79.7441 5.36323C77.2273 2.84633 73.1466 2.84633 70.6297 5.36323L67.986 8.00693C65.6539 10.339 64.5647 13.4433 64.7184 16.4967L60.655 12.4333C60.6448 12.4232 60.6347 12.4131 60.6245 12.403V9.50203C60.6245 7.53943 62.2155 5.94843 64.1781 5.94843C65.7722 5.94843 67.1211 6.99803 67.5715 8.44383C67.705 8.29543 67.8431 8.14973 67.9859 8.00693L69.7433 6.24953C68.6247 4.33973 66.5512 3.05713 64.1781 3.05713ZM79.7744 14.4473C79.7643 14.4574 79.7543 14.4676 79.7441 14.4777L75.6808 18.541C78.5473 18.3968 81.4585 19.3478 83.7334 21.3943C85.1794 20.9439 86.2294 19.5949 86.2294 18.0009C86.2294 16.0383 84.6384 14.4473 82.6754 14.4473H79.7744ZM58.5801 31.5529C58.5902 31.5427 58.6003 31.5325 58.6105 31.5224L62.6738 27.459C59.8074 27.6033 56.8962 26.6522 54.6211 24.6059C53.1753 25.0563 52.1256 26.4052 52.1256 27.9993C52.1256 29.9619 53.7167 31.5529 55.6793 31.5529H58.5801ZM54.5103 24.5049C54.4 24.403 54.2913 24.2985 54.1842 24.1914V24.1915C54.2913 24.2986 54.4 24.403 54.5103 24.5049ZM74.1766 42.9431C71.8034 42.9431 69.7299 41.6604 68.6113 39.7506L70.3686 37.9932C70.5115 37.8504 70.6496 37.7047 70.7831 37.5563C71.2335 39.0021 72.5824 40.0518 74.1766 40.0518C76.1392 40.0518 77.7302 38.4608 77.7302 36.4982V33.5972C78.563 34.4191 79.564 34.9683 80.6215 35.2446V36.4982C80.6215 40.0576 77.736 42.9431 74.1766 42.9431ZM77.6997 7.40763C76.3119 6.01993 74.0619 6.01993 72.6741 7.40763L70.0304 10.0513C67.0735 13.0083 66.8096 17.6385 69.2388 20.8941L77.6997 12.4332C79.0875 11.0454 79.0875 8.79543 77.6997 7.40763ZM84.7694 31.5223C86.1574 30.1345 86.1574 27.8845 84.7694 26.4967L82.126 23.853C79.1691 20.8961 74.5388 20.6322 71.2832 23.0614L79.7441 31.5223C81.1319 32.9101 83.3824 32.9101 84.7694 31.5223ZM65.6805 38.5924C64.2927 39.9802 62.0427 39.9802 60.6549 38.5924C59.2672 37.2046 59.2672 34.9546 60.6549 33.5668L69.1158 25.1059C71.545 28.3615 71.2811 32.9918 68.3242 35.9487L65.6805 38.5924ZM53.5849 14.4777C52.1972 15.8655 52.1972 18.1155 53.5849 19.5033L56.2286 22.147C59.1856 25.1039 63.8158 25.3678 67.0714 22.9386L58.6105 14.4777C57.2227 13.09 54.9727 13.09 53.5849 14.4777Z\" fill=\"#6C6C77\"></path><path d=\"M1.53125 16.0898H4.69185V25.911H10.1202V28.5716H1.53125V16.0898Z\" fill=\"#6C6C77\"></path><path d=\"M15.8598 28.8393C14.8003 28.8393 13.8717 28.6488 13.0741 28.2679C12.2765 27.875 11.6575 27.3393 11.217 26.6608C10.7885 25.9703 10.5742 25.1787 10.5742 24.2858C10.5742 23.393 10.7885 22.6073 11.217 21.9288C11.6575 21.2383 12.2765 20.7026 13.0741 20.3217C13.8717 19.9288 14.8003 19.7324 15.8598 19.7324C16.9193 19.7324 17.8478 19.9288 18.6454 20.3217C19.443 20.7026 20.0561 21.2383 20.4846 21.9288C20.9251 22.6073 21.1453 23.393 21.1453 24.2858C21.1453 25.1787 20.9251 25.9703 20.4846 26.6608C20.0561 27.3393 19.443 27.875 18.6454 28.2679C17.8478 28.6488 16.9193 28.8393 15.8598 28.8393ZM15.8598 26.3929C16.4907 26.3929 16.9907 26.2084 17.3597 25.8394C17.7407 25.4584 17.9311 24.9406 17.9311 24.2858C17.9311 23.6311 17.7407 23.1192 17.3597 22.7502C16.9907 22.3692 16.4907 22.1788 15.8598 22.1788C15.2288 22.1788 14.7229 22.3692 14.342 22.7502C13.9729 23.1192 13.7884 23.6311 13.7884 24.2858C13.7884 24.9406 13.9729 25.4584 14.342 25.8394C14.7229 26.2084 15.2288 26.3929 15.8598 26.3929Z\" fill=\"#6C6C77\"></path><path d=\"M27.049 32.6785C26.4776 32.6785 25.9002 32.6249 25.3169 32.5178C24.7455 32.4106 24.2513 32.2678 23.8347 32.0892V29.9107C24.7751 30.3154 25.8466 30.5178 27.049 30.5178C27.918 30.5178 28.543 30.3392 28.9239 29.9821C29.3168 29.625 29.5131 29.1012 29.5131 28.4107V27.8929C29.1679 28.1905 28.7393 28.4226 28.2274 28.5893C27.7274 28.756 27.1918 28.8393 26.6203 28.8393C25.7156 28.8393 24.9181 28.6488 24.2276 28.2679C23.5372 27.8869 22.9954 27.3512 22.6026 26.6608C22.2216 25.9703 22.0312 25.1787 22.0312 24.2858C22.0312 23.3811 22.2216 22.5835 22.6026 21.8931C22.9835 21.2026 23.5192 20.6728 24.2097 20.3038C24.9001 19.9229 25.6919 19.7324 26.5847 19.7324C27.8109 19.7324 28.8227 20.1074 29.6203 20.8574V20.0002H32.656V27.9822C32.656 29.4702 32.1976 30.625 31.281 31.4464C30.3763 32.2678 28.9656 32.6785 27.049 32.6785ZM27.406 26.4108C27.8941 26.4108 28.3287 26.2858 28.7096 26.0358C29.0906 25.7858 29.3583 25.4525 29.5131 25.0358V23.5359C29.3464 23.1192 29.0726 22.7918 28.6917 22.5537C28.3107 22.3038 27.8822 22.1788 27.406 22.1788C26.7632 22.1788 26.2454 22.3692 25.8526 22.7502C25.4597 23.1192 25.2633 23.6251 25.2633 24.268C25.2633 24.9227 25.4597 25.4465 25.8526 25.8394C26.2454 26.2203 26.7632 26.4108 27.406 26.4108Z\" fill=\"#6C6C77\"></path><path d=\"M38.7387 28.8393C37.6792 28.8393 36.7507 28.6488 35.9531 28.2679C35.1555 27.875 34.5364 27.3393 34.096 26.6608C33.6674 25.9703 33.4531 25.1787 33.4531 24.2858C33.4531 23.393 33.6674 22.6073 34.096 21.9288C34.5364 21.2383 35.1555 20.7026 35.9531 20.3217C36.7507 19.9288 37.6792 19.7324 38.7387 19.7324C39.7982 19.7324 40.7267 19.9288 41.5243 20.3217C42.3219 20.7026 42.935 21.2383 43.3636 21.9288C43.804 22.6073 44.0243 23.393 44.0243 24.2858C44.0243 25.1787 43.804 25.9703 43.3636 26.6608C42.935 27.3393 42.3219 27.875 41.5243 28.2679C40.7267 28.6488 39.7982 28.8393 38.7387 28.8393ZM38.7387 26.3929C39.3696 26.3929 39.8696 26.2084 40.2387 25.8394C40.6196 25.4584 40.8101 24.9406 40.8101 24.2858C40.8101 23.6311 40.6196 23.1192 40.2387 22.7502C39.8696 22.3692 39.3696 22.1788 38.7387 22.1788C38.1078 22.1788 37.6018 22.3692 37.2209 22.7502C36.8518 23.1192 36.6673 23.6311 36.6673 24.2858C36.6673 24.9406 36.8518 25.4584 37.2209 25.8394C37.6018 26.2084 38.1078 26.3929 38.7387 26.3929Z\" fill=\"#6C6C77\"></path><path d=\"M94.4336 16.0898H97.5946V28.5716H94.4336V16.0898Z\" fill=\"#6C6C77\"></path><path d=\"M99.1914 20.0002H102.227V20.8574C103.024 20.1074 104.036 19.7324 105.262 19.7324C106.155 19.7324 106.947 19.9229 107.637 20.3038C108.328 20.6728 108.863 21.2026 109.244 21.8931C109.625 22.5716 109.816 23.3633 109.816 24.268C109.816 25.1608 109.625 25.9584 109.244 26.6608C108.863 27.3512 108.328 27.8869 107.637 28.2679C106.959 28.6488 106.167 28.8393 105.262 28.8393C104.691 28.8393 104.143 28.75 103.62 28.5714C103.108 28.4048 102.679 28.1726 102.334 27.875V32.482H99.1914V20.0002ZM104.441 26.3929C105.084 26.3929 105.602 26.2025 105.994 25.8215C106.387 25.4406 106.584 24.9227 106.584 24.268C106.584 23.6132 106.387 23.1014 105.994 22.7323C105.602 22.3514 105.084 22.1609 104.441 22.1609C103.965 22.1609 103.536 22.2859 103.155 22.5359C102.774 22.774 102.501 23.1014 102.334 23.518V25.0358C102.501 25.4525 102.774 25.7858 103.155 26.0358C103.536 26.2739 103.965 26.3929 104.441 26.3929Z\" fill=\"#6C6C77\"></path><path d=\"M114.502 28.8393C113.812 28.8393 113.092 28.7679 112.342 28.625C111.592 28.4941 110.996 28.3036 110.556 28.0536V25.7501C111.044 26.0358 111.627 26.2739 112.306 26.4644C112.996 26.6429 113.627 26.7322 114.199 26.7322C114.615 26.7322 114.919 26.7024 115.109 26.6429C115.3 26.5834 115.395 26.4644 115.395 26.2858C115.395 26.1429 115.33 26.0298 115.199 25.9465C115.08 25.8513 114.853 25.756 114.52 25.6608C114.199 25.5537 113.824 25.4406 113.395 25.3215C112.669 25.1072 112.098 24.887 111.681 24.6608C111.264 24.4346 110.955 24.1489 110.752 23.8037C110.55 23.4585 110.449 23.024 110.449 22.5002C110.449 21.5716 110.812 20.8812 111.538 20.4288C112.276 19.9645 113.282 19.7324 114.556 19.7324C115.175 19.7324 115.824 19.7979 116.502 19.9288C117.193 20.0598 117.71 20.2324 118.056 20.4467V22.7145C117.699 22.4764 117.222 22.2799 116.627 22.1252C116.044 21.9704 115.496 21.8931 114.984 21.8931C114.58 21.8931 114.264 21.9347 114.038 22.018C113.812 22.0895 113.699 22.2204 113.699 22.4109C113.699 22.5895 113.812 22.7264 114.038 22.8216C114.264 22.9168 114.669 23.0359 115.252 23.1787C115.633 23.274 115.794 23.3156 115.734 23.3037C116.496 23.5061 117.085 23.7323 117.502 23.9823C117.919 24.2323 118.21 24.5299 118.377 24.8751C118.556 25.2084 118.645 25.637 118.645 26.1608C118.645 26.9822 118.288 27.6369 117.574 28.125C116.871 28.6012 115.847 28.8393 114.502 28.8393Z\" fill=\"#6C6C77\"></path><path d=\"M123.34 28.8396C122.162 28.8396 121.275 28.5122 120.68 27.8575C120.097 27.2027 119.805 26.3397 119.805 25.2683V20.0005H122.948V24.9111C122.948 25.8992 123.394 26.3932 124.287 26.3932C124.692 26.3932 125.061 26.298 125.394 26.1075C125.727 25.917 126.001 25.6373 126.215 25.2683V20.0005H129.358V28.5717H126.323V27.6432C125.954 28.036 125.507 28.3336 124.983 28.536C124.46 28.7384 123.912 28.8396 123.34 28.8396Z\" fill=\"#6C6C77\"></path><path d=\"M130.965 20.0004H133.876V20.929C134.233 20.5481 134.644 20.2564 135.108 20.054C135.572 19.8397 136.066 19.7326 136.59 19.7326C137.233 19.7326 137.745 19.8278 138.126 20.0183C138.519 20.2088 138.834 20.4945 139.072 20.8754C139.429 20.5183 139.864 20.2385 140.376 20.0362C140.888 19.8338 141.406 19.7326 141.929 19.7326C143.06 19.7326 143.864 20.0243 144.34 20.6076C144.816 21.179 145.054 22.0063 145.054 23.0896V28.5716H142.054V23.5361C142.054 23.0599 141.965 22.7147 141.786 22.5004C141.608 22.2861 141.31 22.179 140.894 22.179C140.358 22.179 139.923 22.3694 139.59 22.7504C139.602 22.9527 139.608 23.2623 139.608 23.6789V28.5716H136.608V23.4111C136.608 22.9706 136.531 22.6551 136.376 22.4647C136.221 22.2742 135.947 22.179 135.555 22.179C134.947 22.179 134.424 22.5182 133.983 23.1968V28.5716H130.965V20.0004Z\" fill=\"#6C6C77\"></path></svg></div></div>\n                    <!-- /wp:outermost/icon-block --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"20%\"} -->\n                    <div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:20%\"><!-- wp:outermost/icon-block {\"iconName\":\"\",\"itemsJustification\":\"center\",\"width\":\"105px\",\"align\":\"center\"} -->\n                    <div class=\"wp-block-outermost-icon-block aligncenter items-justified-center\"><div class=\"icon-container\" style=\"width:105px\"><svg width=\"70\" height=\"44\" viewBox=\"0 0 70 44\" fill=\"none\" xmlns=\"https://www.w3.org/2000/svg\"><g clip-path=\"url(#clip0_3236_3431)\"><path d=\"M65.5256 5.40859C65.5256 5.45989 65.5256 5.52402 65.5125 5.5625C65.4469 6.06271 65.4469 6.56292 65.4862 7.07596C65.5125 7.20422 65.5387 7.33248 65.6437 7.43509C65.8142 7.62747 66.0765 7.589 66.1815 7.35813C66.234 7.2427 66.234 7.12726 66.2077 7.01183C66.0765 6.52444 66.0503 6.01141 66.0372 5.51119C66.0372 5.48554 66.0372 5.44706 66.0372 5.40859C66.1815 5.39576 66.3127 5.38293 66.4307 5.38293C66.5226 5.37011 66.6013 5.35728 66.6669 5.3188C66.8636 5.2162 66.8636 4.99816 66.6537 4.89555C66.575 4.85707 66.4701 4.84424 66.3783 4.84424C66.0503 4.85707 65.7224 4.85707 65.3944 4.85707C65.2764 4.85707 65.1583 4.8699 65.0402 4.88272C64.9746 4.89555 64.8959 4.89555 64.8435 4.93403C64.7516 4.9725 64.6992 5.03663 64.6992 5.12641C64.7123 5.2162 64.7516 5.2675 64.8435 5.30598C64.8959 5.34446 64.9615 5.35728 65.0271 5.35728C65.1845 5.37011 65.3551 5.39576 65.5256 5.40859ZM69.133 5.99858C69.133 6.01141 69.1461 6.02423 69.1461 6.02423C69.1986 6.37053 69.2511 6.70401 69.2904 7.03748C69.3036 7.15291 69.3167 7.25552 69.3954 7.3453C69.5659 7.56334 69.8283 7.53769 69.9463 7.30683C69.9988 7.19139 70.0119 7.07596 69.9857 6.9477C69.907 6.56292 69.8676 6.17814 69.7889 5.80619C69.7364 5.57532 69.6709 5.35728 69.6053 5.15207C69.5659 5.02381 69.4741 4.93402 69.3167 4.9212C69.1593 4.89555 69.0412 4.9725 68.9756 5.08794C68.8969 5.19054 68.8313 5.29315 68.7788 5.40859C68.687 5.6138 68.6083 5.81902 68.5034 6.01141C68.4902 6.06271 68.4771 6.10119 68.4509 6.13966C68.4378 6.11401 68.4247 6.10119 68.4247 6.10119C68.2541 5.78054 68.0967 5.45989 67.9262 5.15207C67.8999 5.12641 67.8868 5.10076 67.8737 5.07511C67.795 4.95968 67.7032 4.89555 67.5589 4.89555C67.4277 4.90837 67.3227 4.98533 67.2572 5.10076C67.2309 5.15207 67.2309 5.19054 67.2178 5.24185C67.1653 5.65228 67.0997 6.06271 67.0473 6.47314C67.021 6.70401 67.0079 6.93487 67.0079 7.16574C66.9948 7.21704 67.0079 7.28117 67.0341 7.33248C67.0604 7.43508 67.1391 7.49922 67.244 7.51204C67.3752 7.52487 67.467 7.48639 67.5064 7.38378C67.5457 7.30683 67.5589 7.2427 67.572 7.17857C67.6245 6.9477 67.6638 6.72966 67.7032 6.51162C67.7294 6.38336 67.7425 6.28075 67.7819 6.13966C67.8081 6.19097 67.8343 6.22945 67.8606 6.26792C67.9786 6.42184 68.0967 6.57575 68.241 6.70401C68.3853 6.80661 68.5034 6.79379 68.6214 6.67835C68.6477 6.6527 68.6608 6.63988 68.687 6.61422C68.8051 6.43466 68.9494 6.2551 69.0674 6.07553C69.0937 6.04988 69.1068 6.02423 69.133 5.99858Z\" fill=\"#6C6C77\"></path><path d=\"M38.9086 5.66047C38.8174 5.90422 38.8 6.07983 38.8421 6.22579C38.8886 6.42427 39.0093 6.48925 39.1731 6.43877C40.7139 6.06624 44.0926 7.12364 45.3435 7.41835C45.6385 7.48023 45.8785 7.10788 45.6772 6.77404C45.3834 6.45074 42.0062 5.06657 40.7176 4.9911C40.2125 4.96319 39.3095 4.83655 38.9086 5.66047Z\" fill=\"#6C6C77\"></path><path d=\"M52.1116 1.17977C52.2758 1.27244 52.3676 1.36084 52.4129 1.45961C52.4804 1.58917 52.4448 1.67881 52.3314 1.72455C51.3129 2.21057 49.9576 4.30298 49.4105 5.02463C49.2779 5.19064 48.972 5.09417 48.9258 4.82117C48.9353 4.51249 50.1367 2.24176 50.8072 1.62329C51.0707 1.38182 51.506 0.908026 52.1116 1.17977Z\" fill=\"#6C6C77\"></path><path d=\"M44.0017 0.149796C44.199 0.00441888 44.404 -0.0465256 44.5087 0.0479512C46.0454 1.3329 46.8603 3.36773 47.3649 5.23057C47.3839 5.27397 47.3851 5.33625 47.3699 5.40122C47.3636 5.45675 47.3221 5.51541 47.2562 5.5608C47.1858 5.61091 47.1252 5.62617 47.0967 5.58299C46.4232 4.68732 42.5765 1.20242 44.0017 0.149796Z\" fill=\"#6C6C77\"></path><path d=\"M11.461 22.4276C11.8293 22.1595 12.2297 21.9363 12.6534 21.7631C13.0967 21.6392 13.5692 21.6597 13.9995 21.8217C14.4297 21.9837 14.7944 22.2782 15.0382 22.6608C15.2563 23.0424 15.3416 23.483 15.2814 23.9162C15.2212 24.3493 15.0187 24.7516 14.7043 25.0625C14.4606 25.3145 14.1839 25.534 13.8816 25.7154C12.5342 26.5665 11.1748 27.3709 9.81547 28.222C9.53732 28.435 9.24225 28.6261 8.93308 28.7933C8.46281 29.0226 7.92537 29.084 7.41368 28.9669C6.902 28.8499 6.44826 28.5616 6.13092 28.1521C5.89369 27.8621 5.69348 27.545 5.53471 27.2077C4.24691 24.5612 2.91142 21.9263 1.67131 19.2331C1.09895 18.0673 0.633913 16.7265 0.180798 15.4324C-0.0152406 15.0564 -0.0535225 14.6205 0.0741037 14.2173C0.20173 13.8141 0.485195 13.4755 0.864201 13.2735C1.24321 13.0715 1.68785 13.0221 2.10357 13.1357C2.51929 13.2493 2.87329 13.517 3.09027 13.8818C3.75722 14.7484 4.34761 15.6689 4.85504 16.6333C6.14284 18.965 7.37103 21.2967 8.61113 23.5585C8.68334 23.6835 8.76296 23.8041 8.84961 23.9199C9.783 23.5362 10.6609 23.0345 11.461 22.4276Z\" fill=\"#6C6C77\"></path><path d=\"M24.7776 21.6142C21.8324 24.9835 16.8958 24.1324 14.4156 19.7954C12.6508 16.7175 12.3408 11.6343 16.1804 8.42819C17.0003 7.75696 17.9807 7.29971 19.0302 7.09909C20.317 6.91872 21.6292 7.14068 22.7792 7.73326C23.9292 8.32584 24.8582 9.2587 25.4335 10.3985C27.5321 14.1293 27.234 18.886 24.7776 21.6142ZM23.5852 13.7562C23.2723 12.8394 22.6446 12.0567 21.8085 11.541C21.3354 11.2113 20.7605 11.051 20.1807 11.0871C19.6008 11.1232 19.0514 11.3535 18.6248 11.7392C16.9197 13.2199 16.5619 16.7292 17.802 18.8161C17.9601 19.1564 18.1922 19.4588 18.4823 19.7022C18.7724 19.9456 19.1134 20.1241 19.4814 20.2251C19.8494 20.3262 20.2355 20.3474 20.6128 20.2873C20.9901 20.2271 21.3493 20.0871 21.6655 19.877C22.5898 19.1763 23.2679 18.2115 23.6055 17.1167C23.9432 16.0218 23.9236 14.8513 23.5495 13.7679L23.5852 13.7562Z\" fill=\"#6C6C77\"></path><path d=\"M36.7949 15.2251C36.4934 15.2885 36.1819 15.2923 35.8788 15.2362C35.5758 15.1801 35.2872 15.0654 35.0302 14.8987C34.8053 14.7729 34.6117 14.6 34.4633 14.3923C34.315 14.1846 34.2156 13.9474 34.1723 13.6976C34.1289 13.4479 34.1428 13.1919 34.2127 12.948C34.2827 12.7041 34.4072 12.4784 34.5771 12.2871C34.8731 11.9027 35.2933 11.6275 35.7695 11.506C37.0128 11.1532 38.2927 10.9381 39.5852 10.8648C39.8692 10.8325 40.1569 10.856 40.4314 10.9339C40.706 11.0119 40.9618 11.1426 41.184 11.3186C41.4061 11.4945 41.5901 11.7121 41.7251 11.9585C41.86 12.2049 41.9433 12.4752 41.97 12.7535C42.3426 14.1205 42.3834 15.5538 42.0892 16.939C41.0161 21.4159 37.3196 22.9548 33.17 21.5208C32.0052 21.1374 30.9839 20.423 30.2367 19.4689C29.2401 18.3199 28.5335 16.9582 28.1738 15.4933C27.8824 14.1888 27.9143 12.8352 28.267 11.5453C28.6196 10.2554 29.2827 9.06664 30.2009 8.07834C31.0723 7.00417 32.2033 6.1588 33.492 5.61835C34.3063 5.1795 35.2592 5.05472 36.163 5.26859C36.368 5.32407 36.5541 5.43217 36.702 5.58168C36.8499 5.7312 36.9542 5.91667 37.0041 6.11888C37.054 6.32108 37.0476 6.53265 36.9857 6.73165C36.9237 6.93064 36.8085 7.10981 36.6519 7.25057C36.3541 7.51412 36.0306 7.74842 35.686 7.95009C34.6259 8.61016 33.7034 9.46071 32.9673 10.4567C32.4848 11.1012 32.1525 11.8413 31.9939 12.6248C31.8352 13.4083 31.8541 14.2163 32.0492 14.992C32.3196 16.0496 32.9197 16.9989 33.7662 17.7084C36.3895 20.0402 39.7998 17.79 39.2036 14.6072C38.3332 14.8171 37.57 15.0386 36.7949 15.2251Z\" fill=\"#6C6C77\"></path><path d=\"M52.8235 21.8007C48.9482 24.1325 44.5363 21.8007 43.5704 16.9041C42.8669 13.4065 44.2024 8.50979 48.8767 6.6444C49.8712 6.25605 50.9499 6.1197 52.0127 6.248C53.2896 6.47655 54.461 7.09118 55.3616 8.00525C56.2622 8.91931 56.8468 10.0867 57.0327 11.3429C57.8197 15.505 56.0311 19.947 52.8235 21.8007ZM54.171 13.9544C54.1698 12.9859 53.8194 12.0487 53.1813 11.3079C52.8402 10.8497 52.3471 10.5214 51.7861 10.3789C51.225 10.2365 50.6309 10.2887 50.1048 10.5268C48.0062 11.4128 46.5276 14.6306 47.0642 16.9974C47.1052 17.3688 47.2286 17.727 47.4259 18.0469C47.6232 18.3668 47.8896 18.6407 48.2065 18.8495C48.5233 19.0582 48.883 19.1968 49.2603 19.2555C49.6377 19.3141 50.0236 19.2915 50.391 19.1892C51.5003 18.8103 52.4608 18.1022 53.1384 17.1637C53.8161 16.2252 54.1771 15.1032 54.171 13.9544Z\" fill=\"#6C6C77\"></path><path d=\"M60.9503 22.78C60.8918 23.2067 60.6624 23.5932 60.3124 23.8545C59.9624 24.1157 59.5206 24.2304 59.0842 24.1732C58.6478 24.116 58.2525 23.8916 57.9853 23.5494C57.718 23.2073 57.6008 22.7753 57.6593 22.3486C57.7178 21.9219 57.9473 21.5354 58.2972 21.2741C58.6472 21.0128 59.089 20.8982 59.5254 20.9554C59.9618 21.0126 60.3571 21.2369 60.6244 21.5791C60.8916 21.9213 61.0089 22.3533 60.9503 22.78ZM59.9129 7.0524C60.1397 6.71375 60.4724 6.45586 60.8614 6.31719C61.2503 6.17852 61.6747 6.1665 62.0712 6.28293C62.4743 6.38154 62.8304 6.61255 63.0801 6.93728C63.3297 7.26202 63.4576 7.66075 63.4425 8.06671C63.3899 8.71788 63.2903 9.36461 63.1444 10.002C62.7509 12.1589 62.3693 14.3157 61.952 16.4493C61.7612 17.3004 61.5108 18.1165 61.2365 18.9792C61.1411 19.2489 60.9817 19.4926 60.7715 19.6904C60.6408 19.8392 60.4739 19.9533 60.2861 20.0222C60.0983 20.0912 59.8958 20.1127 59.6973 20.0848C59.4988 20.0569 59.3106 19.9805 59.1503 19.8627C58.99 19.7448 58.8627 19.5893 58.7802 19.4106C58.6384 19.09 58.5614 18.7455 58.5536 18.3963C58.5536 16.9506 58.5536 15.4933 58.649 14.0359C58.8111 11.9561 59.1299 9.89081 59.6029 7.85685C59.6586 7.58435 59.7635 7.32376 59.9129 7.08738V7.0524Z\" fill=\"#6C6C77\"></path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M6.42117 32.1487C6.28038 32.456 6.24177 32.7986 6.31057 33.1283C6.35634 33.5629 6.45687 33.9904 6.60987 34.401C6.80089 34.9038 7.01464 35.401 7.2782 36.0138C7.33881 36.1548 7.40215 36.302 7.46843 36.4569C7.82385 37.2871 8.26981 38.3481 8.86466 39.8836C9.03303 40.3198 9.18254 40.7596 9.3331 41.2024C9.39392 41.3813 9.45496 41.5608 9.51744 41.7407C9.7414 42.3803 10.1268 42.9549 10.6376 43.4103C10.8545 43.6606 11.1422 43.843 11.4648 43.9342C11.7937 44.0272 12.1435 44.0213 12.4689 43.9173C12.7943 43.8132 13.0801 43.6158 13.2892 43.3507C13.4942 43.0908 13.6161 42.7776 13.6398 42.4504C13.7728 41.813 13.7274 41.1521 13.5082 40.5376C13.1603 39.5173 12.764 38.4955 12.307 37.4961L12.3049 37.4917C11.5531 35.9281 10.7889 34.3753 9.9885 32.8219L9.98251 32.811C9.74821 32.4063 9.44372 32.0445 9.08272 31.7419C8.84836 31.4718 8.52509 31.2896 8.16809 31.2268C7.80348 31.1627 7.42744 31.2273 7.1071 31.4092C6.80406 31.5784 6.56384 31.8373 6.42117 32.1487Z\" fill=\"#6C6C77\"></path><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M17.9044 28.2986C16.7256 28.0001 15.4945 27.9566 14.2969 28.1712C13.3693 28.2605 12.457 28.4697 11.8235 28.8841C11.5013 29.095 11.2408 29.3658 11.0959 29.71C10.9502 30.0561 10.9316 30.4519 11.051 30.8929C11.269 31.7007 11.5521 32.4861 11.8342 33.269L11.8799 33.3958L11.881 33.3986C12.7304 35.673 13.5879 37.9397 14.4532 40.1986C14.5541 40.5546 14.6968 40.898 14.8784 41.2219L14.8818 41.2279C15.1217 41.6303 15.4294 41.9902 15.7919 42.2925C15.9732 42.4587 16.1974 42.5737 16.4405 42.6251C16.686 42.6769 16.9413 42.6619 17.1786 42.5815C17.416 42.5012 17.6262 42.3587 17.7864 42.1695C17.944 41.9834 18.0472 41.7592 18.0851 41.5206C18.2415 40.8724 18.1914 40.1929 17.9414 39.5733C17.8634 39.3648 17.8022 39.1517 17.7377 38.9274C17.7162 38.8526 17.6944 38.7765 17.6714 38.699C19.6521 37.942 21.7596 36.9241 22.5007 34.5561C22.7909 33.7378 22.8151 32.8517 22.5699 32.0193C22.3245 31.186 21.821 30.4474 21.1288 29.9052C20.1867 29.1462 19.0862 28.5978 17.9044 28.2986ZM14.6369 31.2031C14.6759 31.1921 14.7152 31.1819 14.7546 31.1724C16.0441 30.9742 17.3634 31.2383 18.4696 31.9159C18.9571 32.2474 19.1568 32.6157 19.1911 32.9701C19.2265 33.335 19.0908 33.7304 18.8182 34.1105C18.3031 34.8285 17.3631 35.4032 16.514 35.5103C15.895 34.1165 15.2664 32.6663 14.6369 31.2031Z\" fill=\"#6C6C77\"></path><path d=\"M25.7637 25.7473C27.1675 25.1134 28.9064 25.0039 30.2671 25.4496C30.6098 25.5472 30.9071 25.7583 31.1082 26.0468C31.308 26.3335 31.4002 26.679 31.3694 27.0244C31.3674 27.2486 31.3111 27.4692 31.2052 27.6682C31.0974 27.8708 30.9413 28.045 30.7501 28.1762C30.5589 28.3073 30.3382 28.3916 30.1067 28.4217C29.8751 28.4519 29.6396 28.4271 29.4199 28.3494L29.4032 28.3435L29.3875 28.3354C29.2751 28.2779 29.1557 28.2346 29.0322 28.2064L29.0244 28.2047C28.0672 27.9561 27.1643 28.368 26.8345 28.8741C26.6772 29.1154 26.6577 29.359 26.7887 29.5806C26.929 29.8179 27.2731 30.0842 27.9694 30.274C28.1609 30.3254 28.3572 30.375 28.5563 30.4254C29.1069 30.5648 29.6791 30.7096 30.2324 30.9103L30.2345 30.9111C32.7871 31.8607 33.7376 33.8274 33.4122 35.6772C33.0903 37.5065 31.5278 39.1713 29.1781 39.564C28.3231 39.7493 27.4333 39.7132 26.5968 39.4593C25.7582 39.2046 25.0023 38.7399 24.4042 38.1111L24.3886 38.0947C24.1998 37.8578 24.0728 37.5795 24.0165 37.2842C23.9647 37.0177 23.992 36.7423 24.095 36.4904C24.1974 36.24 24.3706 36.0233 24.5941 35.8654C24.8302 35.6864 25.1148 35.579 25.4127 35.5566C25.7096 35.5343 26.0067 35.5974 26.2674 35.738C26.5278 35.861 26.77 36.0179 26.9874 36.2045L26.9915 36.2079C27.3761 36.5518 27.8414 36.6414 28.2876 36.5584C28.7403 36.4742 29.166 36.2123 29.4398 35.8648C29.7118 35.5195 29.821 35.1093 29.6914 34.7111C29.561 34.31 29.1689 33.8606 28.3074 33.4849C28.0822 33.3914 27.8487 33.316 27.6058 33.2426C27.5403 33.2228 27.4737 33.2031 27.4063 33.1831C27.2267 33.1298 27.0419 33.0749 26.8607 33.0144C26.7359 32.9728 26.6121 32.9334 26.4895 32.8943C26.1544 32.7876 25.8277 32.6836 25.5133 32.5441C24.829 32.3163 24.2378 31.8789 23.8277 31.2966C23.4159 30.712 23.2087 30.0129 23.2369 29.3037C23.2391 27.5754 24.3524 26.3847 25.7637 25.7473Z\" fill=\"#6C6C77\"></path><path d=\"M43.5631 25.5634C43.2909 25.4334 42.9899 25.3717 42.6873 25.3838C42.3846 25.396 42.0898 25.4816 41.8295 25.6331C41.5708 25.7835 41.3542 25.9941 41.199 26.2462C41.0567 26.4585 40.9582 26.6959 40.9091 26.9452C40.86 27.1943 40.8612 27.4503 40.9125 27.6988C40.9632 28.0182 41.0194 28.3288 41.0749 28.6351C41.1668 29.142 41.2562 29.6375 41.3152 30.1427L41.3174 30.1555C41.4517 30.9478 41.522 31.7491 41.5283 32.5521L41.5289 32.5635C41.5748 33.4307 41.2726 34.281 40.6871 34.934L40.6778 34.9456C40.4873 35.1843 40.2326 35.3665 39.9421 35.4718C39.6517 35.5771 39.3371 35.6013 39.0334 35.5417C38.7297 35.4821 38.449 35.3411 38.2226 35.1344C37.9962 34.9277 37.8329 34.6627 37.7514 34.3706C37.5774 33.7549 37.4767 33.1216 37.4511 32.4834L37.7483 27.8571C37.7527 27.7967 37.7577 27.7347 37.7628 27.6721C37.7741 27.5316 37.7857 27.3885 37.7905 27.255C37.7975 27.0586 37.7915 26.8566 37.7447 26.6654C37.6968 26.47 37.6057 26.2841 37.4441 26.1258C37.2841 25.9691 37.0681 25.8535 36.7963 25.7748C36.3048 25.6357 35.8892 25.6401 35.5429 25.7838C35.1964 25.9275 34.959 26.1943 34.791 26.5025C34.6243 26.8081 34.5172 27.1699 34.4362 27.5323C34.3761 27.8012 34.3278 28.0835 34.2819 28.3522C34.266 28.4448 34.2505 28.5357 34.2348 28.624L34.2344 28.6266C33.9888 30.1002 33.9157 31.5964 34.0165 33.0862C34.0353 33.8913 34.207 34.686 34.523 35.4297C34.8795 36.3893 35.5252 37.2207 36.3749 37.8142C37.2264 38.4089 38.2425 38.7366 39.2887 38.7539C40.3349 38.7712 41.3618 38.4773 42.2334 37.9112C43.1036 37.3459 43.778 36.5357 44.1674 35.5878C44.7121 34.3803 44.9679 33.0671 44.9151 31.7483C44.8831 30.7855 44.8295 29.8153 44.7762 28.85C44.75 28.3765 44.7239 27.904 44.7005 27.4344C44.6887 26.9635 44.5299 26.5074 44.2453 26.1273C44.0692 25.887 43.8348 25.6932 43.5631 25.5634Z\" fill=\"#6C6C77\"></path><path d=\"M53.195 32.8172C53.1674 32.8515 53.1383 32.887 53.1079 32.9239C52.8865 31.6751 52.6813 30.4267 52.4758 29.1764C52.4021 28.7278 52.328 28.2773 52.2535 27.8281L52.2451 27.778L52.2179 27.7347C52.1666 27.6532 52.1615 27.5733 52.1615 27.4029V27.3832L52.1584 27.3637C52.1028 27.0118 51.94 26.6843 51.6913 26.4241C51.4433 26.1646 51.1212 25.984 50.7669 25.9056C50.4132 25.8203 50.0415 25.8391 49.6986 25.9597C49.3566 26.08 49.0585 26.2962 48.8415 26.5812C48.6611 26.7999 48.5132 27.0425 48.4024 27.3017C48.1509 27.8601 47.8972 28.4199 47.6428 28.9812L47.6384 28.9909C47.0033 30.3922 46.3639 31.8029 45.7431 33.2247L45.7412 33.2293C45.3601 34.1512 45.0455 35.1226 44.732 36.091C44.6694 36.2843 44.6068 36.4775 44.5437 36.6702C44.4305 36.9758 44.381 37.3004 44.398 37.6249C44.3774 37.9154 44.4485 38.2052 44.6019 38.4551C44.7583 38.7101 44.9926 38.9107 45.2717 39.0288C45.5675 39.1556 45.8982 39.1825 46.2115 39.1053C46.5241 39.0282 46.8017 38.8518 47.0006 38.6038C47.2546 38.2983 47.4731 37.9651 47.6513 37.6121C48.1772 36.5603 48.6798 35.4957 49.1801 34.4357C49.3737 34.0257 49.5618 33.6585 49.7758 33.2586C49.7905 33.3079 49.8055 33.356 49.821 33.4042C50.0453 34.3697 50.4239 35.2945 50.9428 36.1447C51.041 36.3248 51.1778 36.4822 51.3438 36.6061C51.5118 36.7315 51.7057 36.8195 51.912 36.8642C52.1183 36.9089 52.3321 36.9091 52.5385 36.8648C52.7446 36.8206 52.9391 36.7325 53.1072 36.6077L53.4399 36.3642L56.0222 34.2375L55.8695 35.189C55.6599 36.4969 55.4519 37.7939 55.2309 39.0912C55.0863 39.6662 55.0865 40.2668 55.2315 40.8416C55.2943 41.1651 55.4543 41.4629 55.6911 41.6971C55.9299 41.9332 56.2357 42.0936 56.5689 42.1576C56.9021 42.2215 57.2473 42.1861 57.5596 42.0558C57.8674 41.9275 58.1292 41.7129 58.3122 41.4394C58.738 40.9229 59.003 40.2976 59.0758 39.6379C59.1854 38.7063 59.3092 37.762 59.4331 36.818C59.5758 35.7299 59.7185 34.6421 59.839 33.5752L59.8394 33.5719C59.9554 32.404 60.0115 31.2313 60.0076 30.0579C60.033 29.6871 59.9386 29.3177 59.7374 29.002C59.5355 28.6852 59.2365 28.4389 58.8831 28.298C58.5155 28.1346 58.104 28.0909 57.7091 28.1735C57.3168 28.2555 56.9617 28.4577 56.6953 28.7506C56.219 29.1813 55.7722 29.6422 55.3577 30.1303L55.3549 30.1336C54.9024 30.6849 54.453 31.247 54.0065 31.8055C53.735 32.145 53.4643 32.4837 53.195 32.8172Z\" fill=\"#6C6C77\"></path></g><defs><clipPath id=\"clip0_3236_3431\"><rect width=\"70\" height=\"44\" fill=\"white\"></rect></clipPath></defs></svg></div></div>\n                    <!-- /wp:outermost/icon-block --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"20%\"} -->\n                    <div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:20%\"><!-- wp:outermost/icon-block {\"iconName\":\"\",\"itemsJustification\":\"center\",\"width\":\"175px\",\"align\":\"center\"} -->\n                    <div class=\"wp-block-outermost-icon-block aligncenter items-justified-center\"><div class=\"icon-container\" style=\"width:175px\"><svg width=\"140\" height=\"32\" viewBox=\"0 0 140 32\" fill=\"none\" xmlns=\"https://www.w3.org/2000/svg\"><g clip-path=\"url(#clip0_3236_3427)\"><path d=\"M136.315 6.13132L139.654 9.49344C139.771 9.58632 139.858 9.71168 139.902 9.85368C139.97 10.6812 139.344 10.7265 138.704 10.7727C138.427 10.7927 138.148 10.813 137.922 10.8968C136.798 11.2007 135.797 11.8426 135.052 12.7354C134.306 13.6282 133.854 14.7287 133.756 15.8874C133.684 16.0213 133.575 16.1314 133.442 16.2046C133.309 16.2779 133.158 16.311 133.006 16.3002C132.83 16.2846 132.665 16.2076 132.54 16.0826L131.444 14.979C131.452 15.0546 131.452 15.1294 131.452 15.1895V15.9174C131.452 15.9634 131.454 16.0078 131.448 16.052C131.441 16.1016 131.424 16.151 131.385 16.2026V16.2702C131.385 16.3046 131.389 16.3367 131.393 16.3693C131.401 16.4359 131.41 16.5046 131.385 16.6004C131.361 16.6898 131.358 16.794 131.355 16.887C131.354 16.9423 131.353 16.9937 131.347 17.0356C131.339 17.0938 131.339 17.1558 131.334 17.2178C131.33 17.2759 131.32 17.3339 131.294 17.3883C131.259 17.4645 131.247 17.5372 131.244 17.6111C131.242 17.6465 131.242 17.6821 131.242 17.7186L131.197 17.9512L129.494 26.0713L129.358 26.6791L129.306 27.5647L128.555 31.3996L128.435 32H67.6998L67.4071 31.7073L67.3546 31.9625H60.8555L57.2382 28.3227L57.5834 26.6791H55.5422L54.2739 25.3958C52.6999 26.542 50.7947 27.1428 48.848 27.107C46.7554 27.1893 44.7153 26.439 43.1745 25.0206L41.2007 23.0319L40.773 25.0281C40.7205 25.3133 40.6529 25.5835 40.5778 25.8462L40.5103 26.0938L40.3978 26.454C40.3885 26.4853 40.3759 26.5155 40.3602 26.5441C40.2485 26.875 40.1157 27.1983 39.9625 27.5122C39.9665 27.5243 39.9665 27.5375 39.9625 27.5497C39.9428 27.5913 39.9202 27.6314 39.8949 27.6698C39.7816 27.894 39.6564 28.1119 39.5197 28.3227C39.4943 28.361 39.4718 28.4012 39.4522 28.4428L39.3696 28.5328C39.1862 28.7959 38.9856 29.0466 38.7692 29.2833C38.7098 29.3426 38.6505 29.3984 38.5902 29.4531C38.5286 29.5091 38.466 29.5641 38.4014 29.621L38.2364 29.7786C38.1323 29.865 38.0258 29.9485 37.9171 30.0289C37.8274 30.0952 37.7362 30.1594 37.6435 30.2214C36.0969 31.1378 34.3128 31.5739 32.5178 31.4746C30.0413 31.4746 28.06 30.7542 26.8067 29.4934L23.2795 25.9437C21.8706 26.741 20.2754 27.1502 18.6566 27.1294C16.5703 27.194 14.5426 26.4336 13.0131 25.0131L11.0394 23.0244L10.4015 26.0938L10.2739 26.7017H3.63229L0 23.0394L0.187617 22.1538L4.18012 2.97934L4.30017 2.37898H10.9643L11.137 2.5441V2.37898H56.0375L56.2026 2.5441V2.37898H62.7017L66.3339 6.04126L66.1538 6.9193L65.9587 7.87992H67.8274L68.1201 8.17264C68.9423 7.69075 69.8762 7.43204 70.8293 7.42215C71.5301 7.40831 72.226 7.54142 72.8722 7.81286C73.5186 8.08432 74.1008 8.488 74.5816 8.99808L74.484 8.88552L76.2476 10.6642C77.3208 8.64544 79.7298 7.42215 83.0016 7.42215C85.5384 7.42215 87.4072 8.06752 88.54 9.23824L89.816 10.5216L90.244 8.45776L90.3712 7.85738H96.8776L98.7392 9.72608L99.0016 8.46528L99.1296 7.8649H111.933L112.278 8.21016C113.145 7.69845 114.138 7.43854 115.145 7.45966C115.75 7.43602 116.354 7.54692 116.912 7.78438C117.47 8.02184 117.968 8.38 118.371 8.83304C118.35 8.80944 118.33 8.78584 118.31 8.76264C118.274 8.7196 118.238 8.6776 118.2 8.63872L118.852 9.2908C119.42 8.70256 120.103 8.23672 120.858 7.92188C121.613 7.60702 122.424 7.44968 123.242 7.45966C123.676 7.43296 124.11 7.46992 124.53 7.56826L123.82 6.85178C123.723 6.74822 123.658 6.61937 123.631 6.48017C123.605 6.34097 123.618 6.19705 123.67 6.06518C123.722 5.93326 123.81 5.81874 123.924 5.73483C124.038 5.65092 124.174 5.60103 124.315 5.591H124.886C125.039 5.57634 125.192 5.55381 125.343 5.52344C126.141 5.35579 126.891 5.01299 127.54 4.51976C128.19 4.02658 128.721 3.39534 129.096 2.67167C129.129 2.6157 129.158 2.55812 129.186 2.49907V2.46156C129.444 1.90572 129.601 1.30865 129.651 0.697933C129.664 0.508162 129.75 0.330485 129.889 0.200949C130.028 0.0713663 130.211 -0.000455872 130.402 2.1775e-06H130.462C130.575 0.0108122 130.686 0.0475478 130.783 0.107369C130.881 0.167236 130.963 0.248586 131.025 0.345234C131.565 0.870568 134.566 3.92494 134.566 3.92494C134.817 4.1939 134.798 4.54308 134.779 4.89637C134.767 5.11482 134.755 5.33486 134.806 5.53846C134.943 5.56297 135.082 5.58152 135.219 5.59407C135.352 5.60602 135.485 5.61253 135.618 5.6135C135.773 5.61674 135.924 5.66832 136.049 5.76112C136.174 5.85388 136.267 5.98328 136.315 6.13132Z\" fill=\"#6C6C77\"></path><path d=\"M34.3474 8.60057H39.0904L36.4337 21.2009C35.946 23.5874 35.0153 24.9533 33.6045 25.9214C32.1774 26.7495 30.5388 27.1408 28.8916 27.0471C25.7546 27.0471 22.7452 25.7338 22.445 22.5442H27.218C27.3681 23.2947 28.0585 23.7225 29.1092 23.7225C30.5276 23.7225 31.1805 22.867 31.4732 21.5236L31.7583 20.1352H31.6533C31.2345 20.5956 30.7265 20.966 30.1601 21.224C29.5937 21.482 28.9809 21.6222 28.3587 21.6362C25.597 21.6362 23.4056 19.4373 23.4506 16.2178C23.5107 12.4654 25.9572 8.20281 30.0623 8.20281C30.8402 8.15041 31.6169 8.32185 32.3005 8.69689C32.9841 9.07185 33.5459 9.63481 33.9197 10.3191H34.0022L34.3474 8.60057ZM30.2724 18.1165C32.0961 18.1165 33.1092 16.0152 33.1392 14.2066C33.1392 12.9983 32.6664 11.76 31.2705 11.76C29.3643 11.76 28.3962 13.8838 28.3662 15.7074C28.3662 16.9382 28.839 18.1165 30.2349 18.1165M83.5185 18.5218C83.5185 19.3247 82.8273 19.6474 81.9193 19.6474C80.4185 19.6474 79.9159 18.897 79.9084 17.8463H75.188C75.1054 21.7638 78.6026 22.7318 81.7097 22.7318C85.6793 22.7318 88.2537 21.0133 88.3065 17.5837C88.3065 14.8444 85.9721 14.0114 83.6761 13.4786C81.9121 13.0734 81.1393 12.7807 81.1465 12.1127C81.1545 11.4448 81.9425 11.1746 82.7153 11.1746C83.6833 11.1746 84.3433 11.5198 84.4113 12.4054H88.9969C88.9441 9.13337 85.9945 8.17281 82.9929 8.17281C79.3456 8.17281 76.5013 9.83129 76.4562 12.9682C76.4562 15.4373 78.1223 16.3454 80.6361 16.9908C82.2497 17.4186 83.5329 17.5536 83.5185 18.5218ZM118.587 10.6343H118.505C118.301 9.89529 117.85 9.24833 117.227 8.80057C116.605 8.35289 115.848 8.13137 115.083 8.17281C113.042 8.17281 111.796 9.18593 110.618 10.7169H110.535L110.971 8.60057H106.197L103.338 22.2741H108.329L109.83 14.897C110.175 13.291 110.993 12.1653 112.231 12.1653C113.47 12.1653 113.635 13.1558 113.379 14.3642L111.728 22.2741H116.719L118.22 14.897C118.565 13.1859 119.383 12.1653 120.621 12.1653C121.859 12.1653 122.025 13.1034 121.77 14.3642L120.119 22.2741H125.109L126.895 14.1465C127.646 10.7169 126.498 8.14273 123.203 8.14273C122.287 8.13897 121.384 8.36505 120.578 8.80033C119.771 9.23561 119.087 9.86617 118.587 10.6343ZM0.914062 22.2741H6.06978L10.0548 3.09961H4.90656L0.914062 22.2741ZM16.4337 8.19529C19.9159 8.19529 23.2405 10.1014 23.188 14.4166C23.1429 19.1371 19.9309 22.6719 15.0229 22.6719C11.6457 22.6719 8.26869 20.7957 8.32869 16.503C8.41125 11.8951 11.5782 8.19529 16.4337 8.19529ZM15.1655 19.3247C17.3644 19.3247 18.1673 16.1352 18.1673 14.2591C18.1673 12.9158 17.7546 11.6024 16.3061 11.6024C14.1298 11.6024 13.3869 14.9795 13.3869 16.7206C13.3869 18.1165 13.7771 19.3247 15.1955 19.3247M11.7733 3.09961L11.0229 6.93451H54.3174L55.0679 3.09961H11.7733ZM46.5951 8.19529C50.0773 8.19529 53.4018 10.1014 53.3493 14.4166C53.3043 19.1371 50.0848 22.6719 45.1767 22.6719C41.7996 22.6719 38.4225 20.7957 38.4901 16.503C38.5951 11.8951 41.7621 8.19529 46.5951 8.19529ZM45.3493 19.3247C47.5482 19.3247 48.3512 16.1352 48.3512 14.2591C48.3512 12.9158 47.9309 11.6024 46.4825 11.6024C44.3137 11.6024 43.5632 14.9795 43.5632 16.7206C43.5632 18.1165 43.9534 19.3247 45.3793 19.3247M56.839 3.09961L56.0885 6.93451H61.0717L61.8221 3.09961H56.839ZM52.8465 22.2741H57.8371L60.6964 8.60057H55.6757L52.8465 22.2741ZM68.7714 22.7318C67.9772 22.7882 67.1829 22.6222 66.4776 22.2524C65.7724 21.8826 65.1841 21.3235 64.7789 20.6381H64.6964L63.1955 27.5574H58.1448L62.1973 8.60057H66.9403L66.5651 10.4242C67.0604 9.75057 67.702 9.19801 68.4416 8.80801C69.1812 8.41809 69.9996 8.20089 70.8353 8.17281C73.8371 8.17281 75.6007 10.7469 75.5482 14.094C75.4806 18.3041 73.2968 22.7318 68.7414 22.7318H68.7714ZM68.5763 12.0452C66.6477 12.0452 65.4619 14.5142 65.4319 16.413C65.4319 17.7338 65.8972 19.2046 67.4806 19.2046C69.5445 19.2046 70.3925 16.473 70.4149 14.6493C70.4149 13.411 70.0548 12.0452 68.5763 12.0452ZM97.4321 20.1203H97.5145L97.0793 22.2891H101.822L104.682 8.61553H99.6985L98.1073 16.2553C97.7849 17.8388 96.8089 18.6718 95.5785 18.6718C94.3473 18.6718 94.0769 17.5161 94.3249 16.3078L95.9385 8.61553H90.9553L89.1913 17.0583C88.4409 20.7356 90.1521 22.7169 93.0193 22.7169C93.9193 22.7081 94.8017 22.4621 95.5761 22.0035C96.3505 21.545 96.9913 20.8902 97.4321 20.1052V20.1203ZM124.201 27.625L124.951 23.79H65.7696L65.0191 27.625H124.201Z\" fill=\"white\"></path><path d=\"M129.569 12.3526C129.52 12.3488 129.472 12.3353 129.428 12.3128C129.383 12.2904 129.344 12.2595 129.312 12.2218C129.28 12.1841 129.256 12.1405 129.241 12.0934C129.225 12.0463 129.22 11.9967 129.224 11.9473C129.286 11.279 129.207 10.6049 128.991 9.9694C128.775 9.33388 128.427 8.75108 127.969 8.2594C127.513 7.76769 126.957 7.37807 126.339 7.11607C125.721 6.85408 125.054 6.72561 124.383 6.7391C124.284 6.7391 124.189 6.69957 124.118 6.6292C124.048 6.55883 124.008 6.46338 124.008 6.36386C124.008 6.26434 124.048 6.16891 124.118 6.09854C124.189 6.02817 124.284 5.98863 124.383 5.98863C124.563 6.00026 124.744 6.00026 124.924 5.98863C126.257 5.84662 127.498 5.24439 128.435 4.28557C129.373 3.32674 129.945 2.0713 130.057 0.735347C130.065 0.641121 130.107 0.553228 130.177 0.489226C130.246 0.425224 130.337 0.389835 130.432 0.390139C130.481 0.393927 130.529 0.407437 130.573 0.429886C130.617 0.452335 130.657 0.483281 130.689 0.520946C130.721 0.558611 130.745 0.602248 130.761 0.649349C130.776 0.69645 130.781 0.746079 130.777 0.795387C130.715 1.46312 130.794 2.13652 131.009 2.77154C131.225 3.40656 131.573 3.9889 132.029 4.4805C132.485 4.97209 133.04 5.36187 133.657 5.62434C134.274 5.88681 134.94 6.01606 135.61 6.00364C135.709 6.00364 135.805 6.04318 135.876 6.11355C135.946 6.18392 135.985 6.27936 135.985 6.37888C135.985 6.4784 135.946 6.57385 135.876 6.64421C135.805 6.71458 135.709 6.75411 135.61 6.75411C134.185 6.77766 132.817 7.32689 131.772 8.29644C130.726 9.26596 130.075 10.5875 129.945 12.0074C129.937 12.1016 129.894 12.1896 129.825 12.2536C129.755 12.3176 129.664 12.3529 129.569 12.3526Z\" fill=\"white\"></path></g><defs><clipPath id=\"clip0_3236_3427\"><rect width=\"140\" height=\"32\" fill=\"white\"></rect></clipPath></defs></svg></div></div>\n                    <!-- /wp:outermost/icon-block --></div>\n                    <!-- /wp:column -->\n\n                    <!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"20%\"} -->\n                    <div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:20%\"><!-- wp:outermost/icon-block {\"iconName\":\"\",\"itemsJustification\":\"center\",\"width\":\"180px\"} -->\n                    <div class=\"wp-block-outermost-icon-block items-justified-center\"><div class=\"icon-container\" style=\"width:180px\"><svg width=\"132\" height=\"35\" viewBox=\"0 0 132 35\" fill=\"none\" xmlns=\"https://www.w3.org/2000/svg\"><path d=\"M44.8293 25.2045C44.2345 25.2368 43.6462 25.0677 43.1593 24.7245C42.9559 24.5737 42.7922 24.3756 42.6824 24.1474C42.5726 23.9191 42.5201 23.6676 42.5293 23.4145V14.1445C42.5245 14.1053 42.5286 14.0654 42.5415 14.028C42.5543 13.9906 42.5755 13.9567 42.6035 13.9287C42.6315 13.9007 42.6654 13.8795 42.7028 13.8667C42.7402 13.8538 42.7801 13.8497 42.8193 13.8545H44.4993C44.6893 13.8545 44.7793 13.9545 44.7793 14.1445V22.6945C44.7793 23.0745 44.9493 23.2645 45.2993 23.2645C45.4477 23.2706 45.5961 23.2538 45.7393 23.2145C45.9393 23.2145 46.0493 23.2745 46.0593 23.4545L46.2093 24.7045C46.2165 24.741 46.2158 24.7785 46.2073 24.8147C46.1988 24.8508 46.1826 24.8848 46.1598 24.9141C46.1371 24.9435 46.1083 24.9677 46.0755 24.985C46.0426 25.0023 46.0064 25.0124 45.9693 25.0145C45.6013 25.1361 45.2168 25.2002 44.8293 25.2045Z\" fill=\"#6C6C77\"></path><path d=\"M54.2793 24.1347C53.4352 24.8322 52.3743 25.2137 51.2793 25.2137C50.1843 25.2137 49.1235 24.8322 48.2793 24.1347C47.5374 23.3857 47.1211 22.374 47.1211 21.3197C47.1211 20.2654 47.5374 19.2537 48.2793 18.5047C49.1251 17.8108 50.1853 17.4316 51.2793 17.4316C52.3733 17.4316 53.4335 17.8108 54.2793 18.5047C55.0042 19.2606 55.4089 20.2674 55.4089 21.3147C55.4089 22.362 55.0042 23.3688 54.2793 24.1247V24.1347ZM49.8593 22.8147C50.2511 23.1696 50.7607 23.3661 51.2893 23.3661C51.8179 23.3661 52.3276 23.1696 52.7193 22.8147C53.0739 22.4071 53.2691 21.885 53.2691 21.3447C53.2691 20.8045 53.0739 20.2824 52.7193 19.8747C52.3276 19.5199 51.8179 19.3233 51.2893 19.3233C50.7607 19.3233 50.2511 19.5199 49.8593 19.8747C49.5048 20.2824 49.3095 20.8045 49.3095 21.3447C49.3095 21.885 49.5048 22.4071 49.8593 22.8147Z\" fill=\"#6C6C77\"></path><path d=\"M64.6589 17.6846C64.8489 17.6846 64.9389 17.7846 64.9389 17.9746V25.1446C64.9564 25.6286 64.8658 26.1103 64.6738 26.5548C64.4818 26.9994 64.1932 27.3956 63.8289 27.7146C63.0203 28.4041 61.9805 28.7614 60.9189 28.7146C59.9601 28.7483 59.014 28.4865 58.2089 27.9646C57.8651 27.7389 57.5714 27.4448 57.3461 27.1008C57.1207 26.7567 56.9685 26.37 56.8989 25.9646C56.8989 25.7646 56.8989 25.6746 57.1689 25.6746H58.8489C58.9202 25.677 58.9894 25.7001 59.0479 25.7409C59.1065 25.7817 59.152 25.8385 59.1789 25.9046C59.2879 26.2083 59.5051 26.4612 59.7889 26.6146C60.1348 26.7931 60.5198 26.8825 60.9089 26.8746C61.1437 26.8875 61.3787 26.8534 61.6002 26.7744C61.8217 26.6955 62.0252 26.5731 62.1989 26.4146C62.3576 26.2488 62.481 26.0525 62.5618 25.8377C62.6426 25.6229 62.679 25.3939 62.6689 25.1646V24.5346C62.0674 24.977 61.3353 25.2058 60.5889 25.1846C60.0665 25.2036 59.5457 25.1169 59.0576 24.9296C58.5696 24.7422 58.1245 24.4583 57.7489 24.0946C57.028 23.3488 56.625 22.352 56.625 21.3146C56.625 20.2773 57.028 19.2805 57.7489 18.5346C58.1263 18.1742 58.572 17.893 59.0597 17.7075C59.5475 17.522 60.0674 17.436 60.5889 17.4546C61.3569 17.4343 62.1087 17.6779 62.7189 18.1446V17.9846C62.7143 17.9463 62.7183 17.9074 62.7306 17.8708C62.7429 17.8343 62.7632 17.8009 62.79 17.7731C62.8168 17.7453 62.8495 17.7239 62.8856 17.7103C62.9218 1